import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeExternalFunctionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/external_functions#database DataSnowflakeExternalFunctions#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the external functions from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/external_functions#schema DataSnowflakeExternalFunctions#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeExternalFunctionsExternalFunctions extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get language(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/external_functions snowflake_external_functions}
*/
export declare class DataSnowflakeExternalFunctions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/external_functions snowflake_external_functions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeExternalFunctionsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeExternalFunctionsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    externalFunctions(index: string): DataSnowflakeExternalFunctionsExternalFunctions;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
