import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakePipesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/pipes#database DataSnowflakePipes#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the pipes from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/pipes#schema DataSnowflakePipes#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakePipesPipes extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get integration(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/pipes snowflake_pipes}
*/
export declare class DataSnowflakePipes extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/pipes snowflake_pipes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakePipesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakePipesConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    pipes(index: string): DataSnowflakePipesPipes;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
