import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeStreamsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the streams from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/streams#database DataSnowflakeStreams#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the streams from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/streams#schema DataSnowflakeStreams#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeStreamsStreams extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
    get table(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/streams snowflake_streams}
*/
export declare class DataSnowflakeStreams extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/streams snowflake_streams} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeStreamsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeStreamsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    streams(index: string): DataSnowflakeStreamsStreams;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
