import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSystemGetAwsSnsIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Amazon Resource Name (ARN) of the SNS topic for your S3 bucket
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy#aws_sns_topic_arn DataSnowflakeSystemGetAwsSnsIamPolicy#aws_sns_topic_arn}
    */
    readonly awsSnsTopicArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy snowflake_system_get_aws_sns_iam_policy}
*/
export declare class DataSnowflakeSystemGetAwsSnsIamPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy snowflake_system_get_aws_sns_iam_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSystemGetAwsSnsIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeSystemGetAwsSnsIamPolicyConfig);
    private _awsSnsTopicArn?;
    get awsSnsTopicArn(): string;
    set awsSnsTopicArn(value: string);
    get awsSnsTopicArnInput(): string | undefined;
    get awsSnsTopicPolicyJson(): string;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
