import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#comment Database#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#data_retention_time_in_days Database#data_retention_time_in_days}
    */
    readonly dataRetentionTimeInDays?: number;
    /**
    * Specify a database to create a clone from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#from_database Database#from_database}
    */
    readonly fromDatabase?: string;
    /**
    * Specify a fully-qualified path to a database to create a replica from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#from_replica Database#from_replica}
    */
    readonly fromReplica?: string;
    /**
    * Specify a provider and a share in this map to create a database from a share.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#from_share Database#from_share}
    */
    readonly fromShare?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#name Database#name}
    */
    readonly name: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#tag Database#tag}
    */
    readonly tag?: DatabaseTag[] | cdktf.IResolvable;
}
export interface DatabaseTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#database Database#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#name Database#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#schema Database#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/database#value Database#value}
    */
    readonly value: string;
}
export declare function databaseTagToTerraform(struct?: DatabaseTag | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/database snowflake_database}
*/
export declare class Database extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/database snowflake_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionTimeInDays?;
    get dataRetentionTimeInDays(): number;
    set dataRetentionTimeInDays(value: number);
    resetDataRetentionTimeInDays(): void;
    get dataRetentionTimeInDaysInput(): number | undefined;
    private _fromDatabase?;
    get fromDatabase(): string;
    set fromDatabase(value: string);
    resetFromDatabase(): void;
    get fromDatabaseInput(): string | undefined;
    private _fromReplica?;
    get fromReplica(): string;
    set fromReplica(value: string);
    resetFromReplica(): void;
    get fromReplicaInput(): string | undefined;
    private _fromShare?;
    get fromShare(): {
        [key: string]: string;
    };
    set fromShare(value: {
        [key: string]: string;
    });
    resetFromShare(): void;
    get fromShareInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tag?;
    get tag(): DatabaseTag[] | cdktf.IResolvable;
    set tag(value: DatabaseTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | DatabaseTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
