import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to enable change tracking on the table. Default false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#change_tracking Table#change_tracking}
    */
    readonly changeTracking?: boolean | cdktf.IResolvable;
    /**
    * A list of one or more table columns/expressions to be used as clustering key(s) for the table
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#cluster_by Table#cluster_by}
    */
    readonly clusterBy?: string[];
    /**
    * Specifies a comment for the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#comment Table#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the retention period for the table so that Time Travel actions (SELECT, CLONE, UNDROP) can be performed on historical data in the table. Default value is 1, if you wish to inherit the parent schema setting then pass in the schema attribute to this argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#data_retention_days Table#data_retention_days}
    */
    readonly dataRetentionDays?: number;
    /**
    * The database in which to create the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#database Table#database}
    */
    readonly database: string;
    /**
    * Specifies the identifier for the table; must be unique for the database and schema in which the table is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#schema Table#schema}
    */
    readonly schema: string;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#column Table#column}
    */
    readonly column: TableColumn[] | cdktf.IResolvable;
    /**
    * primary_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#primary_key Table#primary_key}
    */
    readonly primaryKey?: TablePrimaryKey;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#tag Table#tag}
    */
    readonly tag?: TableTag[] | cdktf.IResolvable;
}
export interface TableColumnDefault {
    /**
    * The default constant value for the column
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#constant Table#constant}
    */
    readonly constant?: string;
    /**
    * The default expression value for the column
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#expression Table#expression}
    */
    readonly expression?: string;
    /**
    * The default sequence to use for the column
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#sequence Table#sequence}
    */
    readonly sequence?: string;
}
export declare function tableColumnDefaultToTerraform(struct?: TableColumnDefaultOutputReference | TableColumnDefault): any;
export declare class TableColumnDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): TableColumnDefault | undefined;
    set internalValue(value: TableColumnDefault | undefined);
    private _constant?;
    get constant(): string;
    set constant(value: string);
    resetConstant(): void;
    get constantInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    resetExpression(): void;
    get expressionInput(): string | undefined;
    private _sequence?;
    get sequence(): string;
    set sequence(value: string);
    resetSequence(): void;
    get sequenceInput(): string | undefined;
}
export interface TableColumnIdentity {
    /**
    * The number to start incrementing at.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#start_num Table#start_num}
    */
    readonly startNum?: number;
    /**
    * Step size to increment by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#step_num Table#step_num}
    */
    readonly stepNum?: number;
}
export declare function tableColumnIdentityToTerraform(struct?: TableColumnIdentityOutputReference | TableColumnIdentity): any;
export declare class TableColumnIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): TableColumnIdentity | undefined;
    set internalValue(value: TableColumnIdentity | undefined);
    private _startNum?;
    get startNum(): number;
    set startNum(value: number);
    resetStartNum(): void;
    get startNumInput(): number | undefined;
    private _stepNum?;
    get stepNum(): number;
    set stepNum(value: number);
    resetStepNum(): void;
    get stepNumInput(): number | undefined;
}
export interface TableColumn {
    /**
    * Column comment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#comment Table#comment}
    */
    readonly comment?: string;
    /**
    * Column name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
    */
    readonly name: string;
    /**
    * Whether this column can contain null values. **Note**: Depending on your Snowflake version, the default value will not suffice if this column is used in a primary key constraint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#nullable Table#nullable}
    */
    readonly nullable?: boolean | cdktf.IResolvable;
    /**
    * Column type, e.g. VARIANT
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#type Table#type}
    */
    readonly type: string;
    /**
    * default block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#default Table#default}
    */
    readonly default?: TableColumnDefault;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#identity Table#identity}
    */
    readonly identity?: TableColumnIdentity;
}
export declare function tableColumnToTerraform(struct?: TableColumn | cdktf.IResolvable): any;
export interface TablePrimaryKey {
    /**
    * Columns to use in primary key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#keys Table#keys}
    */
    readonly keys: string[];
    /**
    * Name of constraint
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
    */
    readonly name?: string;
}
export declare function tablePrimaryKeyToTerraform(struct?: TablePrimaryKeyOutputReference | TablePrimaryKey): any;
export declare class TablePrimaryKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): TablePrimaryKey | undefined;
    set internalValue(value: TablePrimaryKey | undefined);
    private _keys?;
    get keys(): string[];
    set keys(value: string[]);
    get keysInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface TableTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#database Table#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#schema Table#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#value Table#value}
    */
    readonly value: string;
}
export declare function tableTagToTerraform(struct?: TableTag | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/table snowflake_table}
*/
export declare class Table extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/table snowflake_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TableConfig
    */
    constructor(scope: Construct, id: string, config: TableConfig);
    private _changeTracking?;
    get changeTracking(): boolean | cdktf.IResolvable;
    set changeTracking(value: boolean | cdktf.IResolvable);
    resetChangeTracking(): void;
    get changeTrackingInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterBy?;
    get clusterBy(): string[];
    set clusterBy(value: string[]);
    resetClusterBy(): void;
    get clusterByInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionDays?;
    get dataRetentionDays(): number;
    set dataRetentionDays(value: number);
    resetDataRetentionDays(): void;
    get dataRetentionDaysInput(): number | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get owner(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _column?;
    get column(): TableColumn[] | cdktf.IResolvable;
    set column(value: TableColumn[] | cdktf.IResolvable);
    get columnInput(): cdktf.IResolvable | TableColumn[] | undefined;
    private _primaryKey;
    get primaryKey(): TablePrimaryKeyOutputReference;
    putPrimaryKey(value: TablePrimaryKey): void;
    resetPrimaryKey(): void;
    get primaryKeyInput(): TablePrimaryKey | undefined;
    private _tag?;
    get tag(): TableTag[] | cdktf.IResolvable;
    set tag(value: TableTag[] | cdktf.IResolvable);
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | TableTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
