/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.exception;

import io.ray.api.exception.RayException;
import io.ray.api.id.ActorId;

public class RayActorException
extends RayException {
    public ActorId actorId;

    public RayActorException() {
        super("The actor died unexpectedly before finishing this task.");
    }

    public RayActorException(ActorId actorId) {
        super(String.format("The actor %s died unexpectedly before finishing this task.", actorId));
        this.actorId = actorId;
    }

    public RayActorException(int pid, String ipAddress, ActorId actorId, Throwable cause) {
        super(String.format("(pid=%d, ip=%s) The actor %s died because of it's creation task failed", pid, ipAddress, actorId.toString()), cause);
        this.actorId = actorId;
    }

    public RayActorException(int pid, String ipAddress, Throwable cause) {
        super(String.format("(pid=%d, ip=%s) The actor died because of it's creation task failed", pid, ipAddress), cause);
    }
}

