# Machine Learning Models in NetworkML

## Overview

NetworkML performs role identification via supervised machine learning. Although our
internal analysis compared decision trees, random forests, and neural networks, the public
networkML codebase only includes a neural network (or "deep learning") model.

### Neural Network
Neural networks can be used for supervised machine learning to match patterns in network
traffic with the functional role of a device. For further information on neural networks,
see Francois Chollet's "Deep Learning with Python" published by Manning
Publications in 2018, especially pages 3-116. For more general information on machine
learning and information security or cybersecurity, see Clarence
Chio and David Freeman, "Machine Learning & Security," published by O'Reilly
in 2018. The neural network model in networkML uses the Python package scikit-learn. Using
TensorFlow or a similar neural network-specific machine learning package was not necessary
to achieve high levels of performance in our in-house testing.

### host_footprint model

Currently one model is defined, depending upon the Host() featurizer.

Note: The stored model was trained using all available host-level features. For a full description of the statistical features used to build a model in NetworkML, see the README in the featurizers directory.

#### Training and predicting

The model can be regenerated by:

~~~~
networkml --kfolds=5 --first_stage=algorithm --trained_model=networkml/trained_models/host_footprint.json --label_encoder=networkml/trained_models/host_footprint_le.json --scaler=networkml/trained_models/host_footprint_scaler.mod --operation train [--eval_data=/tmp/test_host.csv] /tmp/train_host.csv
~~~~

Where train_host.csv is the combined CSV output of the featurizer, used to train the model.

Optionally, if a --eval_data CSV is provided, this will be tested against the trained model.
This test CSV would typically be the result of a 20/80 split of the original featurizer data
(20% as test_host.csv, 80% as train_host.csv).


You can also evalulate an existing trained model without retraining:

~~~~
networkml --first_stage=algorithm --final_stage=algorithm --operation eval ~/tmp/test_host.csv
~~~~


A pcap prediction against an existing model in the default location can be done by:

~~~~
networkml --kfolds=5 --first_stage=parser -o /tmp/out--operation predict /tmp/test.pcap
~~~~

The output directory (e.g. /tmp/out) must already exist and be empty.

You can also do a prediction against featurizer output:

~~~~
networkml --kfolds=5 --first_stage=algorithm -o /tmp/out --operation predict /tmp/combined.csv
~~~

#### Using your own model

You can also use your own model. Specify --trained_model, --label_encoder, and --scaler for
training and predicting.
=======
