/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2;

import ee.ut.soras.ajavtV2.Main;
import ee.ut.soras.ajavtV2.WritableTimexForJSON;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.AjaObjekt;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.AjaPunkt;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.TimeMLDateTimePoint;
import ee.ut.soras.ajavtV2.util.TextUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;

public class JarelTootlus {
    public static final String[] orderOfTIMEX3Attributes = new String[]{"tid", "type", "functionInDocument", "temporalFunction", "value", "mod", "anchorTimeID", "beginPoint", "endPoint", "quant", "freq"};

    public static void joondaAlgseTekstiga(List<AjavtSona> sonad, String esialgneTekst) throws Exception {
        if (sonad != null && sonad.size() > 0) {
            int indexInText = 0;
            for (int i = 0; i < sonad.size(); ++i) {
                AjavtSona sona = sonad.get(i);
                int k = esialgneTekst.indexOf(sona.getAlgSona(), indexInText);
                if (k != -1) {
                    sona.setStartPosition(k);
                    sona.setEndPosition(k + sona.getAlgSona().length() - 1);
                    indexInText = k + sona.getAlgSona().length();
                    continue;
                }
                if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
                sona.setStartPosition(indexInText);
                sona.setEndPosition(indexInText);
            }
        }
    }

    public static void parandaTIDvaartused(List<AjavtSona> sonad, boolean allowOnlyPureTimeML) {
        HashMap<String, String> oldIDtoNewID = new HashMap<String, String>();
        int ID = 1;
        for (int i = 0; i < sonad.size(); ++i) {
            AjavtSona sona = sonad.get(i);
            if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
            List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
            List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
            for (int j = 0; j < ajavaljendiKandidaatides.size(); ++j) {
                HashMap<String, String> mapOfAttributesAndValues;
                FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(j);
                AjavaljendiKandidaat ajav = ajavaljendid.get(j);
                if (ajav.getSemantikaLahendus() == null) continue;
                if (koht.onFraasiAlgus() && (mapOfAttributesAndValues = ajav.getSemantikaLahendus().asHashMapOfAttributeValue("")).get("tid") != null && !mapOfAttributesAndValues.get("tid").equals("t0")) {
                    String oldID = mapOfAttributesAndValues.get("tid");
                    String newID = "t" + ID++;
                    oldIDtoNewID.put(oldID, newID);
                    ajav.getSemantikaLahendus().setTimex3Attribute("tid", newID);
                }
                if (!koht.onFraasiLopp() || ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                    HashMap<String, String> mapOfAttributesAndValues2 = ajaObjekt.asHashMapOfAttributeValue("");
                    if (mapOfAttributesAndValues2.get("tid") == null || mapOfAttributesAndValues2.get("tid").equals("t0")) continue;
                    String oldID = mapOfAttributesAndValues2.get("tid");
                    String newID = "t" + ID++;
                    oldIDtoNewID.put(oldID, newID);
                    ajaObjekt.setTimex3Attribute("tid", newID);
                }
            }
        }
        String[] linkingAttributes = new String[]{"beginPoint", "endPoint", "anchorTimeID"};
        for (int i = 0; i < sonad.size(); ++i) {
            AjavtSona sona = sonad.get(i);
            if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
            List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
            List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
            for (int j = 0; j < ajavaljendiKandidaatides.size(); ++j) {
                FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(j);
                AjavaljendiKandidaat ajav = ajavaljendid.get(j);
                if (ajav.getSemantikaLahendus() == null) continue;
                if (koht.onFraasiAlgus()) {
                    HashMap<String, String> mapOfAttributesAndValues = ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                    for (String attribute : linkingAttributes) {
                        if (mapOfAttributesAndValues.get(attribute) == null) continue;
                        String oldID = mapOfAttributesAndValues.get(attribute);
                        if (oldIDtoNewID.containsKey(oldID)) {
                            ajav.getSemantikaLahendus().setTimex3Attribute(attribute, (String)oldIDtoNewID.get(oldID));
                            continue;
                        }
                        if (oldID.equals("CREATION_TIME")) {
                            ajav.getSemantikaLahendus().setTimex3Attribute(attribute, "t0");
                            continue;
                        }
                        ajav.getSemantikaLahendus().setTimex3Attribute(attribute, "??");
                    }
                }
                if (!koht.onFraasiLopp() || ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                    HashMap<String, String> mapOfAttributesAndValues = ajaObjekt.asHashMapOfAttributeValue("");
                    for (String attribute : linkingAttributes) {
                        if (mapOfAttributesAndValues.get(attribute) == null) continue;
                        String oldID = mapOfAttributesAndValues.get(attribute);
                        if (oldIDtoNewID.containsKey(oldID)) {
                            ajaObjekt.setTimex3Attribute(attribute, (String)oldIDtoNewID.get(oldID));
                            continue;
                        }
                        if (oldID.equals("CREATION_TIME")) {
                            ajaObjekt.setTimex3Attribute(attribute, "t0");
                            continue;
                        }
                        ajav.getSemantikaLahendus().setTimex3Attribute(attribute, "??");
                    }
                }
            }
        }
    }

    public static String eraldamiseTulemusDebug(List<AjavtSona> sonad, String esialgneTekst, boolean allowOnlyPureTimeML, AjaPunkt creationTime) {
        StringBuffer sb = new StringBuffer(esialgneTekst);
        for (int i = sonad.size() - 1; i > -1; --i) {
            AjavtSona sona = sonad.get(i);
            StringBuilder newSuffix = new StringBuilder();
            StringBuilder newPrefix = new StringBuilder();
            if (sona.onVerb()) {
                newSuffix.append("_V_");
            }
            if (sona.getGrammatilineAeg() != AjavtSona.GRAMMATILINE_AEG.MAARAMATA) {
                newSuffix.append("{" + (Object)((Object)sona.getGrammatilineAeg()) + "}");
            }
            if (sona.isOnPotentsiaalneVahemikuAlgus()) {
                newSuffix.append("-st");
            }
            if (sona.isOnPotentsiaalneVahemikuLopp()) {
                newSuffix.append("-ni");
            }
            if (sona.onLauseLopp()) {
                newSuffix.append("-LL");
            }
            if (sona.onVoimalikTsiteeringuLoppVoiAlgus()) {
                newSuffix.append("-tsitaat");
            }
            if (sona.getArvSonaFraasis() != FraasisPaiknemiseKoht.PUUDUB) {
                String intValStr = null;
                intValStr = sona.getArvSonaTaisArvVaartus() != null ? String.valueOf(sona.getArvSonaTaisArvVaartus()) : String.valueOf(sona.getArvSonaMurdArvVaartus());
                if (sona.getArvSonaFraasis() == FraasisPaiknemiseKoht.ALGUSES || sona.getArvSonaFraasis() == FraasisPaiknemiseKoht.AINUSSONA) {
                    newPrefix.insert(0, "<NUMBER VAL=\"" + intValStr + "\">");
                }
                if (sona.getArvSonaFraasis() == FraasisPaiknemiseKoht.LOPUS || sona.getArvSonaFraasis() == FraasisPaiknemiseKoht.AINUSSONA) {
                    newSuffix.append("</NUMBER>");
                }
            }
            if (sona.onSeotudMoneAjavaljendiKandidaadiga()) {
                List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
                List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
                for (int j = 0; j < ajavaljendiKandidaatides.size(); ++j) {
                    FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(j);
                    AjavaljendiKandidaat ajav = ajavaljendid.get(j);
                    if (ajav.getSemantikaLahendus() == null) continue;
                    if (koht.onFraasiAlgus()) {
                        StringBuilder ajavAnnotationHeader = new StringBuilder();
                        ajavAnnotationHeader.append("<" + TextUtils.resizeString(ajav.toString(), 5, true).toUpperCase() + " ");
                        ajavAnnotationHeader.append("M_ID=\"");
                        ajavAnnotationHeader.append(ajav.getMustriID());
                        ajavAnnotationHeader.append("\" ");
                        if (ajav.getLahimVerb() != null) {
                            ajavAnnotationHeader.append("VERB=\"" + ajav.getLahimVerb().getAlgSona() + "\" ");
                        }
                        if (ajav.getAnkurdatudKandidaat() != null && ajav.getAnkurdatudKandidaat() != null) {
                            List<AjavtSona> fraas = ajav.getAnkurdatudKandidaat().getFraas();
                            ajavAnnotationHeader.append("ANKUR=\"");
                            for (AjavtSona ajavtSona : fraas) {
                                ajavAnnotationHeader.append(ajavtSona.getAlgSona());
                                ajavAnnotationHeader.append(" ");
                            }
                            ajavAnnotationHeader.append("\" ");
                        }
                        HashMap<String, String> mapOfAttributesAndValues = ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                        String orderedAttribsAndValues = JarelTootlus.orderAttributeValuePairs(mapOfAttributesAndValues);
                        ajavAnnotationHeader.append(orderedAttribsAndValues);
                        String mustriTahisedAsString = ajav.getMustriTahisedAsString();
                        if (mustriTahisedAsString != null && mustriTahisedAsString.length() > 0) {
                            ajavAnnotationHeader.append("TAHISED=\"");
                            ajavAnnotationHeader.append(mustriTahisedAsString);
                            ajavAnnotationHeader.append("\"");
                        }
                        ajavAnnotationHeader.append(">");
                        newPrefix.insert(0, " ");
                        newPrefix.insert(0, ajavAnnotationHeader);
                    }
                    if (!koht.onFraasiLopp()) continue;
                    newSuffix.append(" ");
                    newSuffix.append("</" + TextUtils.resizeString(ajav.toString(), 5, true).toUpperCase() + ">");
                    if (ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                    List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                    for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                        HashMap<String, String> mapOfAttributesAndValues = ajaObjekt.asHashMapOfAttributeValue("");
                        String orderedAttribsAndValues = JarelTootlus.orderAttributeValuePairs(mapOfAttributesAndValues);
                        newSuffix.append("<TIMEX ");
                        newSuffix.append(orderedAttribsAndValues);
                        newSuffix.append("/>");
                    }
                }
            }
            if (sona.getStartPosition() >= sb.length() || sona.getEndPosition() + 1 > sb.length() || -1 >= sona.getStartPosition() || -1 >= sona.getEndPosition()) continue;
            sb.insert(sona.getEndPosition() + 1, newSuffix);
            sb.insert(sona.getStartPosition(), newPrefix);
        }
        if (creationTime != null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            String orderedAttribsAndValues = JarelTootlus.orderAttributeValuePairs(mapOfAttributesAndValues);
            String ctTIMEX = "<TIMEX " + orderedAttribsAndValues + "/>\n";
            sb.insert(0, ctTIMEX);
        }
        return sb.toString();
    }

    public static String eraldamiseTulemusPretty(List<AjavtSona> sonad, String esialgneTekst, boolean allowOnlyPureTimeML, AjaPunkt creationTime) {
        StringBuffer sb = new StringBuffer(esialgneTekst);
        for (int i = sonad.size() - 1; i > -1; --i) {
            AjavtSona sona = sonad.get(i);
            if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
            String newPrefix = "";
            String newSuffix = "";
            List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
            List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
            for (int j = 0; j < ajavaljendiKandidaatides.size(); ++j) {
                HashMap<String, String> attribValuePairs;
                FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(j);
                AjavaljendiKandidaat ajav = ajavaljendid.get(j);
                if (koht.onFraasiAlgus() && ajav.getSemantikaLahendus() != null) {
                    HashMap<String, String> hashMap = attribValuePairs = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajav.getSemantikaLahendus()) : ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                    if (attribValuePairs != null) {
                        newPrefix = JarelTootlus.doTagHeader(null, attribValuePairs, allowOnlyPureTimeML, false) + newPrefix;
                    }
                }
                if (!koht.onFraasiLopp() || ajav.getSemantikaLahendus() == null) continue;
                HashMap<String, String> hashMap = attribValuePairs = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajav.getSemantikaLahendus()) : ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                if (attribValuePairs != null) {
                    newSuffix = newSuffix + JarelTootlus.doTagFooter(allowOnlyPureTimeML);
                }
                if (ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                for (AjaObjekt ajaObjekt : ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES()) {
                    HashMap<String, String> mapOfAttributesAndValues = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajaObjekt) : ajaObjekt.asHashMapOfAttributeValue("");
                    if (mapOfAttributesAndValues == null) continue;
                    newSuffix = newSuffix + JarelTootlus.doTagHeader(null, mapOfAttributesAndValues, allowOnlyPureTimeML, true);
                }
            }
            if (sona.getStartPosition() >= sb.length() || sona.getEndPosition() + 1 > sb.length() || -1 >= sona.getStartPosition() || -1 >= sona.getEndPosition()) continue;
            sb.insert(sona.getEndPosition() + 1, newSuffix);
            sb.insert(sona.getStartPosition(), newPrefix);
        }
        if (creationTime != null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            sb.insert(0, "\n");
            sb.insert(0, JarelTootlus.doTagHeader(null, mapOfAttributesAndValues, allowOnlyPureTimeML, true));
        }
        return sb.toString();
    }

    public static List<String> eraldamiseTulemusAinultValjendid(List<AjavtSona> sonad, String esialgneTekst, boolean allowOnlyPureTimeML, AjaPunkt creationTime) {
        LinkedList<String> list = new LinkedList<String>();
        if (creationTime != null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            list.add(JarelTootlus.doTagHeader(null, mapOfAttributesAndValues, allowOnlyPureTimeML, true));
        }
        for (int i = 0; i < sonad.size(); ++i) {
            AjavtSona sona = sonad.get(i);
            if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
            List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
            List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
            for (int j = 0; j < ajavaljendiKandidaatides.size(); ++j) {
                FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(j);
                AjavaljendiKandidaat ajav = ajavaljendid.get(j);
                if (koht != FraasisPaiknemiseKoht.AINUSSONA && koht != FraasisPaiknemiseKoht.ALGUSES || ajav.getSemantikaLahendus() == null) continue;
                StringBuilder sb = new StringBuilder();
                int algusPositsioon = -1;
                int loppPositsioon = -1;
                List<AjavtSona> ajavaljendiFraas = ajav.getFraas();
                for (int k = 0; k < ajavaljendiFraas.size(); ++k) {
                    AjavtSona sonaFraasis = ajavaljendiFraas.get(k);
                    if (k == 0) {
                        algusPositsioon = sonaFraasis.getStartPosition();
                    }
                    if (k != ajavaljendiFraas.size() - 1) continue;
                    loppPositsioon = sonaFraasis.getEndPosition();
                }
                if (algusPositsioon != -1 && loppPositsioon != -1) {
                    HashMap<String, String> mapOfAttributesAndValues;
                    String extraAttribs = "startPosition=\"" + String.valueOf(algusPositsioon) + "\"" + " endPosition=\"" + String.valueOf(loppPositsioon) + "\"";
                    HashMap<String, String> hashMap = mapOfAttributesAndValues = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajav.getSemantikaLahendus()) : ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                    if (mapOfAttributesAndValues != null) {
                        sb.append(JarelTootlus.doTagHeader(extraAttribs, mapOfAttributesAndValues, allowOnlyPureTimeML, false));
                        if (algusPositsioon < esialgneTekst.length() && loppPositsioon + 1 <= esialgneTekst.length()) {
                            String str = esialgneTekst.substring(algusPositsioon, loppPositsioon + 1);
                            sb.append(str);
                        }
                        sb.append(JarelTootlus.doTagFooter(allowOnlyPureTimeML));
                        list.add(sb.toString());
                    }
                }
                if (ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                    HashMap<String, String> mapOfAttributesAndValues = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajaObjekt) : ajaObjekt.asHashMapOfAttributeValue("");
                    if (mapOfAttributesAndValues == null) continue;
                    list.add(JarelTootlus.doTagHeader("", mapOfAttributesAndValues, allowOnlyPureTimeML, true));
                }
            }
        }
        return list;
    }

    public static List<HashMap<String, String>> eraldamiseTulemusAinultValjendidPaistabelitena(List<AjavtSona> sonad, String esialgneTekst, boolean allowOnlyPureTimeML, AjaPunkt creationTime) throws Exception {
        LinkedList<HashMap<String, String>> list = new LinkedList<HashMap<String, String>>();
        if (creationTime != null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            list.add(mapOfAttributesAndValues);
        }
        for (int i = 0; i < sonad.size(); ++i) {
            AjavtSona sona = sonad.get(i);
            if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
            List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
            List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
            for (int j = 0; j < ajavaljendiKandidaatides.size(); ++j) {
                HashMap<String, String> mapOfAttributesAndValues;
                FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(j);
                AjavaljendiKandidaat ajav = ajavaljendid.get(j);
                if (koht != FraasisPaiknemiseKoht.AINUSSONA && koht != FraasisPaiknemiseKoht.ALGUSES || ajav.getSemantikaLahendus() == null) continue;
                int algusPositsioonString = -1;
                int loppPositsioonString = -1;
                int algusPositsioonToken = -1;
                int loppPositsioonToken = -1;
                int algusPositsioon_token = -1;
                int loppPositsioon_token = -1;
                List<AjavtSona> ajavaljendiFraas = ajav.getFraas();
                StringBuilder tokenPhrase = new StringBuilder();
                for (int k = 0; k < ajavaljendiFraas.size(); ++k) {
                    AjavtSona sonaFraasis = ajavaljendiFraas.get(k);
                    tokenPhrase.append(sonaFraasis.getAlgSona());
                    if (k == 0) {
                        algusPositsioonString = sonaFraasis.getStartPosition();
                        algusPositsioonToken = sonaFraasis.getTokenPosition();
                        algusPositsioon_token = sonaFraasis.getInnerTokenPosition();
                    }
                    if (k == ajavaljendiFraas.size() - 1) {
                        loppPositsioonString = sonaFraasis.getEndPosition();
                        loppPositsioonToken = sonaFraasis.getTokenPosition();
                        loppPositsioon_token = sonaFraasis.getInnerTokenPosition();
                        continue;
                    }
                    tokenPhrase.append(" ");
                }
                if (algusPositsioonString != -1 && loppPositsioonString != -1) {
                    HashMap<String, String> hashMap = mapOfAttributesAndValues = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajav.getSemantikaLahendus()) : ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                    if (mapOfAttributesAndValues != null) {
                        mapOfAttributesAndValues.put("startPosition", String.valueOf(algusPositsioonString));
                        mapOfAttributesAndValues.put("endPosition", String.valueOf(loppPositsioonString));
                        if (algusPositsioonString < esialgneTekst.length() && loppPositsioonString + 1 <= esialgneTekst.length()) {
                            mapOfAttributesAndValues.put("text", esialgneTekst.substring(algusPositsioonString, loppPositsioonString + 1));
                        }
                        list.add(mapOfAttributesAndValues);
                    }
                } else if (algusPositsioonToken != -1 && loppPositsioonToken != -1) {
                    HashMap<String, String> hashMap = mapOfAttributesAndValues = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajav.getSemantikaLahendus()) : ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                    if (mapOfAttributesAndValues != null) {
                        int l;
                        StringBuilder tokensStr = new StringBuilder();
                        for (l = algusPositsioonToken; l <= loppPositsioonToken; ++l) {
                            tokensStr.append(l);
                            if (l == loppPositsioonToken) continue;
                            tokensStr.append(" ");
                        }
                        mapOfAttributesAndValues.put("tokens", tokensStr.toString());
                        tokensStr = new StringBuilder();
                        for (l = algusPositsioon_token; l <= loppPositsioon_token; ++l) {
                            tokensStr.append(l);
                            if (l == loppPositsioon_token) continue;
                            tokensStr.append(" ");
                        }
                        mapOfAttributesAndValues.put("_tokens", tokensStr.toString());
                        if (tokenPhrase.length() > 0) {
                            mapOfAttributesAndValues.put("text", tokenPhrase.toString());
                        }
                        list.add(mapOfAttributesAndValues);
                    }
                } else {
                    throw new Exception(" Unable to position temporal expression starting from word " + i + " " + sona.getAlgSona() + "");
                }
                if (ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                    HashMap<String, String> mapOfAttributesAndValues2 = allowOnlyPureTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajaObjekt) : ajaObjekt.asHashMapOfAttributeValue("");
                    if (mapOfAttributesAndValues2 == null) continue;
                    list.add(mapOfAttributesAndValues2);
                }
            }
        }
        return list;
    }

    public static List<String> konverteeriEraldamiseTulemusSonedeListiks(List<HashMap<String, String>> eraldamiseTulemusPaistabelitena, boolean allowOnlyPureTimeML, boolean useDebugTokens) {
        LinkedList<String> list = new LinkedList<String>();
        for (HashMap<String, String> timexAsAttribMap : eraldamiseTulemusPaistabelitena) {
            StringBuilder sb = new StringBuilder();
            String algusPositsioon = timexAsAttribMap.get("startPosition");
            String loppPositsioon = timexAsAttribMap.get("endPosition");
            String tokens = useDebugTokens ? timexAsAttribMap.get("_tokens") : timexAsAttribMap.get("tokens");
            String text = timexAsAttribMap.get("text");
            if (text != null) {
                String extraAttribs = "";
                if (algusPositsioon != null && loppPositsioon != null) {
                    extraAttribs = "startPosition=\"" + algusPositsioon + "\"" + " endPosition=\"" + loppPositsioon + "\"";
                } else if (tokens != null) {
                    extraAttribs = "tokens=\"" + tokens + "\"";
                }
                sb.append(JarelTootlus.doTagHeader(extraAttribs, timexAsAttribMap, allowOnlyPureTimeML, false));
                sb.append(text);
                sb.append(JarelTootlus.doTagFooter(allowOnlyPureTimeML));
                list.add(sb.toString());
                continue;
            }
            list.add(JarelTootlus.doTagHeader("", timexAsAttribMap, allowOnlyPureTimeML, true));
        }
        return list;
    }

    public static String eraldamiseTulemusPrettyT3OLP(List<AjavtSona> sonad, AjaPunkt creationTime, boolean usePurifiedTimeML) {
        StringBuilder valjund = new StringBuilder(sonad.size() * 20);
        if (creationTime != null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            valjund.append(JarelTootlus.doTagHeader("", mapOfAttributesAndValues, false, true));
            valjund.append("\n");
        }
        for (AjavtSona sona : sonad) {
            StringBuilder sonaStr = new StringBuilder(sona.getAlgSona());
            if (sona.onSeotudMoneAjavaljendiKandidaadiga()) {
                List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
                List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
                for (int i = 0; i < ajavaljendiKandidaatides.size(); ++i) {
                    FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(i);
                    AjavaljendiKandidaat ajav = ajavaljendid.get(i);
                    if ((koht == FraasisPaiknemiseKoht.AINUSSONA || koht == FraasisPaiknemiseKoht.ALGUSES) && ajav.getSemantikaLahendus() != null) {
                        StringBuilder ajavAnnotationHeader = new StringBuilder("");
                        HashMap<String, String> mapOfAttributesAndValues = ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                        ajavAnnotationHeader.append(JarelTootlus.doTagHeader(null, mapOfAttributesAndValues, usePurifiedTimeML, false));
                        sonaStr.insert(0, ajavAnnotationHeader + "");
                    }
                    if (koht != FraasisPaiknemiseKoht.AINUSSONA && koht != FraasisPaiknemiseKoht.LOPUS || ajav.getSemantikaLahendus() == null) continue;
                    sonaStr.append(JarelTootlus.doTagFooter(usePurifiedTimeML));
                    if (ajav.getSemantikaLahendus() == null || ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                    List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                    for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                        HashMap<String, String> mapOfAttributesAndValues = ajaObjekt.asHashMapOfAttributeValue("");
                        sonaStr.append(JarelTootlus.doTagHeader(null, mapOfAttributesAndValues, usePurifiedTimeML, true));
                    }
                }
            }
            valjund.append((CharSequence)sonaStr);
            if (sona.onLauseLopp()) {
                valjund.append("\n");
                continue;
            }
            valjund.append(" ");
        }
        return valjund.toString();
    }

    public static String eraldamiseTulemusT3OLPEraldiReal(String sisendT3OLP, List<AjavtSona> sonad, AjaPunkt creationTime, boolean usePurifiedTimeML, boolean skipIgnorePart) throws Exception {
        StringBuilder valjund = new StringBuilder(sonad.size() * 20);
        if (creationTime != null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            valjund.append(JarelTootlus.doTagHeader("", mapOfAttributesAndValues, false, true));
            valjund.append("\n");
        }
        HashMap tokenPosToAjavtSonaMap = new HashMap();
        for (AjavtSona sona : sonad) {
            if (sona.getTokenPosition() != -1) {
                int key = sona.getTokenPosition();
                if (!tokenPosToAjavtSonaMap.containsKey(key)) {
                    ArrayList listOfWords = new ArrayList(1);
                    tokenPosToAjavtSonaMap.put(key, listOfWords);
                }
                ((List)tokenPosToAjavtSonaMap.get(key)).add(sona);
                continue;
            }
            throw new Exception(" Unable to map AjavtSona to tokenposition for " + sona.getAlgSona());
        }
        String rida = null;
        int tokenPosition = 1;
        HashMap<String, Integer> timexTagStartPos = new HashMap<String, Integer>();
        HashMap<Integer, List<String>> implicitDurStartPos = new HashMap<Integer, List<String>>();
        BufferedReader input = new BufferedReader(new StringReader(sisendT3OLP));
        block1: while ((rida = input.readLine()) != null) {
            if (rida.length() > 0 && rida.equals("<ignoreeri>")) {
                if (!skipIgnorePart) {
                    valjund.append(rida);
                    valjund.append("\n");
                }
                ++tokenPosition;
                while ((rida = input.readLine()) != null) {
                    if (!skipIgnorePart) {
                        valjund.append(rida);
                        valjund.append("\n");
                    }
                    ++tokenPosition;
                    if (rida.length() <= 0 || !rida.equals("</ignoreeri>")) continue;
                    continue block1;
                }
                continue;
            }
            if (rida.length() <= 0) continue;
            StringBuilder sonaStr = new StringBuilder(rida);
            sonaStr.append("\n");
            if (tokenPosToAjavtSonaMap.containsKey(tokenPosition)) {
                List sonadPositsioonil = (List)tokenPosToAjavtSonaMap.get(tokenPosition);
                for (AjavtSona sona : sonadPositsioonil) {
                    if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
                    List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
                    List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
                    for (int i = 0; i < ajavaljendiKandidaatides.size(); ++i) {
                        FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(i);
                        AjavaljendiKandidaat ajav = ajavaljendid.get(i);
                        if ((koht == FraasisPaiknemiseKoht.AINUSSONA || koht == FraasisPaiknemiseKoht.ALGUSES) && ajav.getSemantikaLahendus() != null) {
                            StringBuilder ajavAnnotationHeader = new StringBuilder("");
                            HashMap<String, String> mapOfAttributesAndValues = ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                            String attribText = null;
                            if (ajav.hasTokenBreakPositions()) {
                                attribText = JarelTootlus.doTextAttributeForTimex(ajav);
                            }
                            if (attribText == null) {
                                attribText = "";
                            }
                            attribText = attribText + " mustriID=\"" + ajav.getMustriID() + "\" ";
                            ajavAnnotationHeader.append(JarelTootlus.doTagHeader(attribText, mapOfAttributesAndValues, usePurifiedTimeML, false));
                            sonaStr.insert(0, ajavAnnotationHeader + "\n");
                            timexTagStartPos.put(mapOfAttributesAndValues.get("tid"), valjund.length() - 1);
                        }
                        if (koht != FraasisPaiknemiseKoht.AINUSSONA && koht != FraasisPaiknemiseKoht.LOPUS || ajav.getSemantikaLahendus() == null) continue;
                        JarelTootlus.addImplicitTimexesIfNecessaryAndCloseTimex(skipIgnorePart, usePurifiedTimeML, ajav, sonaStr, valjund, timexTagStartPos, implicitDurStartPos);
                    }
                }
            }
            valjund.append((CharSequence)sonaStr);
            ++tokenPosition;
        }
        if (!implicitDurStartPos.isEmpty()) {
            ArrayList startPosList = new ArrayList(implicitDurStartPos.keySet());
            Collections.sort(startPosList);
            for (int i = startPosList.size() - 1; i > -1; --i) {
                Integer key = (Integer)startPosList.get(i);
                List startTags = (List)implicitDurStartPos.get(key);
                for (String tag : startTags) {
                    valjund.insert((int)key, tag);
                }
            }
        }
        return valjund.toString();
    }

    public static String eraldamiseTulemusVabaMorfiJSON(String sisendJSON, List<AjavtSona> sonad, AjaPunkt creationTime, boolean usePurifiedTimeML, boolean prettyPrint) throws Exception {
        StringWriter sw = new StringWriter();
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        if (prettyPrint) {
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        JsonGenerator jsonGenerator = jgf.createGenerator(sw);
        BufferedReader inputReader = new BufferedReader(new StringReader(sisendJSON));
        JsonParser parser = Json.createParser(inputReader);
        Stack<String> jsonKeyPath = new Stack<String>();
        JsonParser.Event lastEvent = null;
        String lastString = "";
        String tokenText = null;
        String newDCTvalue = null;
        String[] konehetkJSONist = Main.prooviLuuaJSONsisendiP6hjalRefAeg(sisendJSON);
        if (konehetkJSONist == null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            newDCTvalue = mapOfAttributesAndValues.get("value");
        }
        HashMap tokenPosToAjavtSonaMap = new HashMap();
        for (AjavtSona sona : sonad) {
            if (sona.getTokenPosition() != -1) {
                int key = sona.getTokenPosition();
                if (!tokenPosToAjavtSonaMap.containsKey(key)) {
                    ArrayList listOfWords = new ArrayList(1);
                    tokenPosToAjavtSonaMap.put(key, listOfWords);
                }
                ((List)tokenPosToAjavtSonaMap.get(key)).add(sona);
                continue;
            }
            throw new Exception(" Unable to map AjavtSona to tokenposition for " + sona.getAlgSona());
        }
        int currentTokenPosition = 1;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_ARRAY: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonKeyPath.push(lastString);
                        jsonGenerator.writeStartArray(lastString);
                    } else {
                        jsonGenerator.writeStartArray();
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case END_ARRAY: {
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("words")) {
                        // empty if block
                    }
                    lastEvent = event;
                    lastString = "";
                    jsonKeyPath.pop();
                    jsonGenerator.writeEnd();
                    break;
                }
                case START_OBJECT: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.writeStartObject(lastString);
                    } else {
                        jsonGenerator.writeStartObject();
                    }
                    if (jsonKeyPath.empty() && newDCTvalue != null) {
                        jsonGenerator.write("dct", newDCTvalue);
                    }
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("words")) {
                        // empty if block
                    }
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("analysis")) {
                        // empty if block
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case END_OBJECT: {
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("words")) {
                        if (tokenText == null) {
                            throw new Exception(" Unable to find text form for a word ...");
                        }
                        Integer positionKey = currentTokenPosition;
                        if (tokenPosToAjavtSonaMap.containsKey(positionKey)) {
                            List sonadPositsioonil = (List)tokenPosToAjavtSonaMap.get(positionKey);
                            ArrayList<WritableTimexForJSON> associatedTimexes = new ArrayList<WritableTimexForJSON>();
                            HashMap<String, Integer> addedTimexIDs = new HashMap<String, Integer>();
                            for (AjavtSona sona : sonadPositsioonil) {
                                if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
                                List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
                                List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
                                for (int i = 0; i < ajavaljendiKandidaatides.size(); ++i) {
                                    String TID;
                                    HashMap<String, String> mapOfAttributesAndValues;
                                    FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(i);
                                    AjavaljendiKandidaat ajav = ajavaljendid.get(i);
                                    if (ajav.getSemantikaLahendus() == null) continue;
                                    HashMap<String, String> hashMap = mapOfAttributesAndValues = usePurifiedTimeML ? JarelTootlus.getPurifiedTimeMLAnnotation(ajav.getSemantikaLahendus()) : ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                                    if (mapOfAttributesAndValues == null || !mapOfAttributesAndValues.containsKey("tid") || addedTimexIDs.containsKey(TID = mapOfAttributesAndValues.get("tid"))) continue;
                                    addedTimexIDs.put(TID, 1);
                                    associatedTimexes.add(new WritableTimexForJSON(ajav, mapOfAttributesAndValues, koht));
                                }
                            }
                            if (!associatedTimexes.isEmpty()) {
                                jsonGenerator.writeStartArray("timexes");
                                for (WritableTimexForJSON writableJSON : associatedTimexes) {
                                    writableJSON.writeAsJSONObject(jsonGenerator, usePurifiedTimeML);
                                }
                                jsonGenerator.writeEnd();
                            }
                        } else {
                            throw new Exception(" Unable to find AjavtSona associated with the word " + tokenText + " at position " + currentTokenPosition + "...");
                        }
                        ++currentTokenPosition;
                        tokenText = null;
                    }
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("analysis")) {
                        // empty if block
                    }
                    lastEvent = event;
                    lastString = "";
                    jsonGenerator.writeEnd();
                    break;
                }
                case VALUE_FALSE: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.write(lastString, false);
                    } else {
                        jsonGenerator.write(false);
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case VALUE_NULL: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.writeNull(lastString);
                    } else {
                        jsonGenerator.writeNull();
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case VALUE_TRUE: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.write(lastString, true);
                    } else {
                        jsonGenerator.write(true);
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case KEY_NAME: {
                    lastEvent = event;
                    lastString = parser.getString();
                    break;
                }
                case VALUE_STRING: {
                    if (newDCTvalue != null && lastEvent == JsonParser.Event.KEY_NAME && lastString.equalsIgnoreCase("dct")) {
                        lastEvent = event;
                        lastString = parser.getString();
                        break;
                    }
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.write(lastString, parser.getString());
                    } else {
                        jsonGenerator.write(parser.getString());
                    }
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("words") && lastString != null && lastString.equals("text")) {
                        tokenText = parser.getString();
                    }
                    lastEvent = event;
                    lastString = parser.getString();
                    break;
                }
                case VALUE_NUMBER: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        if (parser.isIntegralNumber()) {
                            jsonGenerator.write(lastString, parser.getLong());
                        } else {
                            jsonGenerator.write(lastString, parser.getBigDecimal());
                        }
                    } else if (parser.isIntegralNumber()) {
                        jsonGenerator.write(parser.getLong());
                    } else {
                        jsonGenerator.write(parser.getBigDecimal());
                    }
                    lastEvent = event;
                    lastString = "";
                }
            }
        }
        jsonGenerator.close();
        inputReader.close();
        return sw.toString();
    }

    public static void addImplicitTimexesIfNecessaryAndCloseTimex(boolean skipIgnorePart, boolean usePurifiedTimeML, AjavaljendiKandidaat ajav, StringBuilder sonaStr, StringBuilder valjund, HashMap<String, Integer> timexTagStartPos, HashMap<Integer, List<String>> implicitDurPos) throws Exception {
        block9: {
            block8: {
                if (!skipIgnorePart) break block8;
                sonaStr.append(JarelTootlus.doTagFooter(usePurifiedTimeML));
                sonaStr.append("\n");
                if (ajav.getSemantikaLahendus() == null || ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) break block9;
                List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                    HashMap<String, String> mapOfAttributesAndValues = ajaObjekt.asHashMapOfAttributeValue("");
                    String attribText = " mustriID=\"" + ajav.getMustriID() + "\" ";
                    sonaStr.append(JarelTootlus.doTagHeader(attribText, mapOfAttributesAndValues, usePurifiedTimeML, true));
                    sonaStr.append("\n");
                }
                break block9;
            }
            ArrayList<HashMap<String, String>> implicitDurations = null;
            if (ajav.getSemantikaLahendus() != null && ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() != null) {
                List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                    HashMap<String, String> mapOfAttributesAndValues = ajaObjekt.asHashMapOfAttributeValue("");
                    if (ajaObjekt.getType() != AjaObjekt.TYYP.DURATION) {
                        String attribText = " mustriID=\"" + ajav.getMustriID() + "\" ";
                        sonaStr.append(JarelTootlus.doTagHeader(attribText, mapOfAttributesAndValues, usePurifiedTimeML, true));
                        sonaStr.append("\n");
                        continue;
                    }
                    implicitDurations = new ArrayList<HashMap<String, String>>();
                    implicitDurations.add(mapOfAttributesAndValues);
                }
            }
            sonaStr.append(JarelTootlus.doTagFooter(usePurifiedTimeML));
            sonaStr.append("\n");
            if (implicitDurations != null) {
                for (HashMap hashMap : implicitDurations) {
                    String beginPoint = (String)hashMap.get("beginPoint");
                    if (beginPoint != null && timexTagStartPos.containsKey(beginPoint)) {
                        int startPos = timexTagStartPos.get(beginPoint);
                        Integer key = startPos + 1;
                        if (!implicitDurPos.containsKey(key)) {
                            implicitDurPos.put(key, new ArrayList());
                        }
                        String attribText = " mustriID=\"" + ajav.getMustriID() + "\" ";
                        implicitDurPos.get(key).add(JarelTootlus.doTagHeader(attribText, hashMap, usePurifiedTimeML, false) + "\n");
                        sonaStr.append(JarelTootlus.doTagFooter(usePurifiedTimeML));
                        sonaStr.append("\n");
                        continue;
                    }
                    throw new Exception(" Unable to locate beginPoint, specified in timex " + (String)hashMap.get("tid") + ".");
                }
            }
        }
    }

    public static String eraldamiseTulemusIgaSonaEraldiRealDebug(List<AjavtSona> sonad, AjaPunkt creationTime) {
        StringBuilder valjund = new StringBuilder(sonad.size() * 20);
        if (creationTime != null) {
            HashMap<String, String> mapOfAttributesAndValues = creationTime.asHashMapOfAttributeValue("");
            valjund.append(JarelTootlus.doTagHeader("", mapOfAttributesAndValues, false, true));
            valjund.append("\n");
        }
        for (AjavtSona sona : sonad) {
            StringBuilder sonaStr = new StringBuilder(sona.getAlgSona());
            if (sona.onVerb()) {
                sonaStr.append("_V_");
            }
            if (sona.getGrammatilineAeg() != AjavtSona.GRAMMATILINE_AEG.MAARAMATA) {
                sonaStr.append("{");
                sonaStr.append((Object)sona.getGrammatilineAeg());
                sonaStr.append("}");
            }
            if (sona.isOnPotentsiaalneVahemikuAlgus()) {
                sonaStr.append("-st");
            }
            if (sona.isOnPotentsiaalneVahemikuLopp()) {
                sonaStr.append("-ni");
            }
            if (sona.onLauseLopp()) {
                sonaStr.append("-LL");
            }
            if (sona.onVoimalikTsiteeringuLoppVoiAlgus()) {
                sonaStr.append("-tst");
            }
            if (sona.getArvSonaFraasis() != FraasisPaiknemiseKoht.PUUDUB) {
                String intValStr = null;
                intValStr = sona.getArvSonaTaisArvVaartus() != null ? String.valueOf(sona.getArvSonaTaisArvVaartus()) : String.valueOf(sona.getArvSonaMurdArvVaartus());
                if (sona.getArvSonaFraasis().onFraasiAlgus()) {
                    sonaStr.insert(0, "<NUMBER VAL=\"" + intValStr + "\">");
                }
                if (sona.getArvSonaFraasis().onFraasiLopp()) {
                    sonaStr.append("</NUMBER>");
                }
            }
            if (sona.onSeotudMoneAjavaljendiKandidaadiga()) {
                List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
                List<AjavaljendiKandidaat> ajavaljendid = sona.getAjavaljendiKandidaadid();
                for (int i = 0; i < ajavaljendiKandidaatides.size(); ++i) {
                    FraasisPaiknemiseKoht koht = ajavaljendiKandidaatides.get(i);
                    AjavaljendiKandidaat ajav = ajavaljendid.get(i);
                    if (koht == FraasisPaiknemiseKoht.AINUSSONA || koht == FraasisPaiknemiseKoht.ALGUSES) {
                        String mustriTahisedAsString;
                        StringBuilder ajavAnnotationHeader = new StringBuilder("<" + TextUtils.resizeString(ajav.toString(), 5, true).toUpperCase() + " ");
                        if (ajav.getLahimVerb() != null) {
                            ajavAnnotationHeader.append("VERB=\"" + ajav.getLahimVerb().getAlgSona() + "\" ");
                        }
                        if (ajav.getAnkurdatudKandidaat() != null && ajav.getAnkurdatudKandidaat() != null) {
                            List<AjavtSona> fraas = ajav.getAnkurdatudKandidaat().getFraas();
                            ajavAnnotationHeader.append("ANKUR=\"");
                            for (AjavtSona ajavtSona : fraas) {
                                ajavAnnotationHeader.append(ajavtSona.getAlgSona() + " ");
                            }
                            ajavAnnotationHeader.append("\" ");
                        }
                        if (ajav.getSemantikaLahendus() != null) {
                            HashMap<String, String> mapOfAttributesAndValues = ajav.getSemantikaLahendus().asHashMapOfAttributeValue("");
                            String orderedAttribsAndValues = JarelTootlus.orderAttributeValuePairs(mapOfAttributesAndValues);
                            ajavAnnotationHeader.append(orderedAttribsAndValues);
                        }
                        if ((mustriTahisedAsString = ajav.getMustriTahisedAsString()) != null && mustriTahisedAsString.length() > 0) {
                            ajavAnnotationHeader.append("TAHISED=\"");
                            ajavAnnotationHeader.append(mustriTahisedAsString);
                            ajavAnnotationHeader.append("\"");
                        }
                        ajavAnnotationHeader.append(">");
                        if (ajav.getSemantikaEhitusklotsid() != null) {
                            for (SemantikaDefinitsioon semDef : ajav.getSemantikaEhitusklotsid()) {
                                ajavAnnotationHeader.append("\n      " + semDef.toString());
                            }
                        }
                        sonaStr.insert(0, ajavAnnotationHeader + "\n");
                    }
                    if (koht != FraasisPaiknemiseKoht.AINUSSONA && koht != FraasisPaiknemiseKoht.LOPUS) continue;
                    sonaStr.append("\n</" + TextUtils.resizeString(ajav.toString(), 5, true).toUpperCase() + ">");
                    if (ajav.getSemantikaLahendus() == null || ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES() == null) continue;
                    List<AjaObjekt> relatedImplicitTIMEXES = ajav.getSemantikaLahendus().getRelatedImplicitTIMEXES();
                    for (AjaObjekt ajaObjekt : relatedImplicitTIMEXES) {
                        HashMap<String, String> mapOfAttributesAndValues = ajaObjekt.asHashMapOfAttributeValue("");
                        String orderedAttribsAndValues = JarelTootlus.orderAttributeValuePairs(mapOfAttributesAndValues);
                        sonaStr.append("\n");
                        sonaStr.append("<TIMEX ");
                        sonaStr.append(orderedAttribsAndValues);
                        sonaStr.append("/>");
                    }
                }
            }
            valjund.append((CharSequence)sonaStr);
            valjund.append("\n");
        }
        return valjund.toString();
    }

    public static String orderAttributeValuePairs(HashMap<String, String> attribValuePairs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < orderOfTIMEX3Attributes.length; ++i) {
            String attrib = orderOfTIMEX3Attributes[i];
            if (!attribValuePairs.containsKey(attrib) || attribValuePairs.get(attrib) == null) continue;
            sb.append(attrib);
            sb.append("=\"");
            sb.append(attribValuePairs.get(attrib));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public static HashMap<String, String> getPurifiedTimeMLAnnotation(AjaObjekt ajav) {
        String value;
        HashMap<String, String> attribValuePairs = ajav.asHashMapOfAttributeValue("");
        if (!attribValuePairs.containsKey("type") || !attribValuePairs.containsKey("value")) {
            return null;
        }
        if (attribValuePairs.containsKey("mod") && attribValuePairs.get("mod").equals("FIRST_HALF")) {
            attribValuePairs.put("mod", "START");
        }
        if (attribValuePairs.containsKey("mod") && attribValuePairs.get("mod").equals("SECOND_HALF")) {
            attribValuePairs.put("mod", "END");
        }
        if (attribValuePairs.containsKey("beginPoint") && !TextUtils.validTimeMLtid.matcher(attribValuePairs.get("beginPoint")).matches()) {
            attribValuePairs.remove("beginPoint");
        }
        if (attribValuePairs.containsKey("endPoint") && !TextUtils.validTimeMLtid.matcher(attribValuePairs.get("endPoint")).matches()) {
            attribValuePairs.remove("endPoint");
        }
        if (attribValuePairs.containsKey("anchorTimeID") && !TextUtils.validTimeMLtid.matcher(attribValuePairs.get("anchorTimeID")).matches()) {
            attribValuePairs.remove("anchorTimeID");
        }
        if (attribValuePairs.containsKey("freq")) {
            if (attribValuePairs.get("freq").matches("T?[0-9]+(Y|M|D|H)")) {
                attribValuePairs.put("freq", "P" + attribValuePairs.get("freq"));
            } else {
                attribValuePairs.remove("freq");
            }
        }
        if ((value = attribValuePairs.get("value")).matches(".*-W.*-WD.*")) {
            attribValuePairs.put("value", value.replaceAll("-WD", "-X"));
        }
        if (value.matches(".*-W.*-WET.*")) {
            attribValuePairs.put("value", value.replaceAll("-WE", "-X"));
        }
        if (value.matches(".*TXX.*")) {
            return null;
        }
        return attribValuePairs;
    }

    public static String doTextAttributeForTimex(AjavaljendiKandidaat ajav) {
        StringBuilder additionStr = new StringBuilder();
        List<AjavtSona> fraas = ajav.getFraas();
        additionStr.append("text=");
        additionStr.append("\"");
        for (int j = 0; j < fraas.size(); ++j) {
            AjavtSona ajavtSona = fraas.get(j);
            additionStr.append(ajavtSona.getAlgSona());
            if (j >= fraas.size() - 1) continue;
            additionStr.append(" ");
        }
        additionStr.append("\"");
        return additionStr.toString();
    }

    public static AjaPunkt formatAsCreationTime(String[] konehetk) {
        AjaPunkt creationTime = new AjaPunkt(AjaObjekt.TYYP.POINT, new TimeMLDateTimePoint(konehetk));
        if (creationTime.getDateTimePoint() != null) {
            creationTime.getDateTimePoint().copyInputFieldsToOpenedFields();
        }
        creationTime.setTimex3Attribute("temporalFunction", null);
        creationTime.setTimex3Attribute("tid", "t0");
        creationTime.setTimex3Attribute("functionInDocument", "CREATION_TIME");
        return creationTime;
    }

    public static String doTagHeader(String extraAttribs, HashMap<String, String> attribValuePairs, boolean usePurifiedTimeML, boolean doEmptyTag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<TIMEX");
        if (usePurifiedTimeML) {
            sb.append("3");
        }
        sb.append(" ");
        if (extraAttribs != null) {
            sb.append(extraAttribs);
            sb.append(" ");
        }
        sb.append(JarelTootlus.orderAttributeValuePairs(attribValuePairs));
        if (doEmptyTag) {
            sb.append("/");
        }
        sb.append(">");
        return sb.toString();
    }

    public static String doTagFooter(boolean usePurifiedTimeML) {
        StringBuilder sb = new StringBuilder();
        sb.append("</TIMEX");
        if (usePurifiedTimeML) {
            sb.append("3");
        }
        sb.append(">");
        return sb.toString();
    }
}

