/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus;

import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.SemLeidmiseAbimeetodid;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.base.BaseLocal;

public class TimeMLDateTimePoint {
    public final boolean SET_TYPE_OPERATION = true;
    public final boolean ADD_TYPE_OPERATION = false;
    public static final VALUE_FIELD[] valueFieldsInOrder = new VALUE_FIELD[]{VALUE_FIELD.YEAR, VALUE_FIELD.MONTH_OR_WEEK, VALUE_FIELD.DAY, VALUE_FIELD.HOUR_OR_POD, VALUE_FIELD.MINUTE};
    private HashMap<VALUE_FIELD, String> maskedFields = new HashMap();
    private HashMap<VALUE_FIELD, String> openedFields = new HashMap();
    private HashMap<VALUE_FIELD, String> inputFields = new HashMap();
    private HashMap<Granulaarsus, String> modifiedGrans = new HashMap();
    private LocalTime underlyingTime = null;
    private LocalDate underlyingDate = null;
    private String partOfDay = null;
    private boolean dateModified = false;
    private boolean functionOtherThanSetUsed = false;

    public TimeMLDateTimePoint(LocalDateTime lct) {
        this.underlyingTime = lct.toLocalTime();
        this.underlyingDate = lct.toLocalDate();
        this.inputFields.put(VALUE_FIELD.YEAR, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, this.underlyingDate.getYear()));
        this.inputFields.put(VALUE_FIELD.MONTH_OR_WEEK, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()));
        this.inputFields.put(VALUE_FIELD.DAY, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()));
        this.inputFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
        this.inputFields.put(VALUE_FIELD.MINUTE, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, this.underlyingTime.getMinuteOfHour()));
    }

    public TimeMLDateTimePoint(String[] granularities) {
        this(granularities[0], granularities[1], granularities[2], granularities[3], granularities[4]);
    }

    public TimeMLDateTimePoint(String year, String month, String day, String hour, String minute) {
        this.underlyingDate = new LocalDate();
        this.underlyingTime = new LocalTime();
        Pattern maskPattern = Pattern.compile("X+");
        if (maskPattern.matcher(year).matches()) {
            this.maskedFields.put(VALUE_FIELD.YEAR, year);
            this.inputFields.put(VALUE_FIELD.YEAR, year);
        } else if (TimeMLDateTimePoint.parseInteger(year) > -1) {
            this.inputFields.put(VALUE_FIELD.YEAR, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, year));
            this.underlyingDate = this.underlyingDate.withYear(TimeMLDateTimePoint.parseInteger(year));
        }
        if (maskPattern.matcher(month).matches()) {
            this.maskedFields.put(VALUE_FIELD.MONTH_OR_WEEK, month);
            this.inputFields.put(VALUE_FIELD.MONTH_OR_WEEK, month);
        } else if (TimeMLDateTimePoint.parseInteger(month) > -1) {
            this.inputFields.put(VALUE_FIELD.MONTH_OR_WEEK, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, month));
            this.underlyingDate = this.underlyingDate.withMonthOfYear(TimeMLDateTimePoint.parseInteger(month));
        }
        if (maskPattern.matcher(day).matches()) {
            this.maskedFields.put(VALUE_FIELD.DAY, day);
            this.inputFields.put(VALUE_FIELD.DAY, day);
        } else if (TimeMLDateTimePoint.parseInteger(day) > -1) {
            this.inputFields.put(VALUE_FIELD.DAY, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, day));
            this.underlyingDate = this.underlyingDate.withDayOfMonth(TimeMLDateTimePoint.parseInteger(day));
        }
        if (maskPattern.matcher(hour).matches()) {
            this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, hour);
            this.inputFields.put(VALUE_FIELD.HOUR_OR_POD, hour);
        } else if (TimeMLDateTimePoint.parseInteger(hour) > -1) {
            this.inputFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, hour));
            this.underlyingTime = this.underlyingTime.withHourOfDay(TimeMLDateTimePoint.parseInteger(hour));
        }
        if (maskPattern.matcher(minute).matches()) {
            this.maskedFields.put(VALUE_FIELD.MINUTE, minute);
            this.inputFields.put(VALUE_FIELD.MINUTE, minute);
        } else if (TimeMLDateTimePoint.parseInteger(minute) > -1) {
            this.inputFields.put(VALUE_FIELD.MINUTE, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, minute));
            this.underlyingTime = this.underlyingTime.withMinuteOfHour(TimeMLDateTimePoint.parseInteger(minute));
        }
    }

    public TimeMLDateTimePoint(TimeMLDateTimePoint refDateTime) {
        if (refDateTime.underlyingTime != null) {
            this.underlyingTime = new LocalTime(refDateTime.underlyingTime);
        }
        if (refDateTime.underlyingDate != null) {
            this.underlyingDate = new LocalDate(refDateTime.underlyingDate);
        }
        this.inputFields = new HashMap<VALUE_FIELD, String>(refDateTime.inputFields);
        this.maskedFields = new HashMap<VALUE_FIELD, String>(refDateTime.maskedFields);
        this.openedFields = new HashMap<VALUE_FIELD, String>(refDateTime.openedFields);
        this.modifiedGrans = new HashMap<Granulaarsus, String>(refDateTime.modifiedGrans);
        this.dateModified = refDateTime.dateModified;
        this.functionOtherThanSetUsed = refDateTime.functionOtherThanSetUsed;
    }

    public void setField(Granulaarsus field, int value) {
        if (field == Granulaarsus.AM_PM) {
            try {
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.halfdayOfDay(), value);
                this.updateTimeRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.HOUR_OF_HALF_DAY) {
            try {
                if (value == 12) {
                    value = 0;
                }
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.hourOfHalfday(), value);
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.minuteOfHour(), 0);
                this.updateTimeRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.MINUTE) {
            try {
                this.underlyingTime = this.underlyingTime.withField(DateTimeFieldType.minuteOfHour(), value);
                this.updateTimeRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.DAY_OF_WEEK) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.dayOfWeek(), value);
                this.dateModified = true;
                this.updateDateRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.WEEK_OF_YEAR) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.weekOfWeekyear(), value);
                this.dateModified = true;
                this.updateDateRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.DAY_OF_MONTH) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.dayOfMonth(), value);
                this.dateModified = true;
                this.updateDateRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.MONTH) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.monthOfYear(), value);
                this.dateModified = true;
                this.updateDateRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.YEAR) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.year(), value);
                this.dateModified = true;
                this.updateDateRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.YEAR_OF_CENTURY) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.yearOfCentury(), value);
                this.dateModified = true;
                this.updateDateRepresentation(field, null, false, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.CENTURY_OF_ERA) {
            try {
                this.underlyingDate = this.underlyingDate.withField(DateTimeFieldType.centuryOfEra(), value);
                this.dateModified = true;
                this.updateDateRepresentation(field, null, false, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setField(Granulaarsus field, String label) {
        if (field == Granulaarsus.TIME) {
            this.updateTimeRepresentation(field, label, false, true);
        }
        if (field == Granulaarsus.DAY_OF_WEEK) {
            this.openedFields.put(VALUE_FIELD.DAY, label);
            this.updateDateRepresentation(field, label, true, true);
            this.dateModified = true;
        }
        if (field == Granulaarsus.MONTH) {
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, label);
            this.updateDateRepresentation(field, label, true, true);
            this.dateModified = true;
        }
    }

    public void addToField(Granulaarsus field, int value) {
        if (field == Granulaarsus.MINUTE || field == Granulaarsus.HOUR_OF_HALF_DAY || field == Granulaarsus.HOUR_OF_DAY) {
            LocalDateTime ajaFookus = this.getAsLocalDateTime();
            if (field == Granulaarsus.MINUTE) {
                ajaFookus = ajaFookus.plusMinutes(value);
                this.underlyingTime = ajaFookus.toLocalTime();
                this.underlyingDate = ajaFookus.toLocalDate();
                if (this.dateModified) {
                    this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
                }
                this.updateTimeRepresentation(field, null, false, false);
                this.functionOtherThanSetUsed = true;
            }
            if (field == Granulaarsus.HOUR_OF_DAY || field == Granulaarsus.HOUR_OF_HALF_DAY) {
                ajaFookus = ajaFookus.plusHours(value);
                this.underlyingTime = ajaFookus.toLocalTime();
                this.underlyingDate = ajaFookus.toLocalDate();
                if (this.dateModified) {
                    this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
                }
                this.updateTimeRepresentation(field, null, false, false);
                this.functionOtherThanSetUsed = true;
            }
        }
        if (field == Granulaarsus.DAY_OF_MONTH) {
            this.underlyingDate = this.underlyingDate.plusDays(value);
            this.updateDateRepresentation(field, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.DAY_OF_WEEK) {
            this.underlyingDate = this.underlyingDate.plusDays(value);
            this.updateDateRepresentation(field, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.WEEK_OF_YEAR) {
            this.underlyingDate = this.underlyingDate.plusWeeks(value);
            this.updateDateRepresentation(field, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.MONTH) {
            this.underlyingDate = this.underlyingDate.plusMonths(value);
            this.updateDateRepresentation(field, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.YEAR) {
            this.underlyingDate = this.underlyingDate.plusYears(value);
            this.updateDateRepresentation(field, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.YEAR_OF_CENTURY) {
            this.underlyingDate = this.underlyingDate.plusYears(value);
            this.updateDateRepresentation(field, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.CENTURY_OF_ERA) {
            this.underlyingDate = this.underlyingDate.plusYears(value * 100);
            this.updateDateRepresentation(field, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
    }

    public void addToField(Granulaarsus field, Period period, int direction) {
        if (field.compareByCoarseRank(Granulaarsus.WEEK_OF_YEAR) == -1) {
            LocalDateTime ajaFookus = this.getAsLocalDateTime();
            try {
                ajaFookus = direction > 0 ? ajaFookus.plus(period) : ajaFookus.minus(period);
                this.functionOtherThanSetUsed = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            this.underlyingTime = ajaFookus.toLocalTime();
            this.underlyingDate = ajaFookus.toLocalDate();
            if (field.compareByCoarseRank(Granulaarsus.DAY_OF_MONTH) == 0) {
                this.dateModified = true;
                this.updateTimeRepresentation(Granulaarsus.HOUR_OF_DAY, null, false, false);
            } else {
                this.updateTimeRepresentation(Granulaarsus.MINUTE, null, false, false);
            }
            if (this.dateModified) {
                this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            }
        } else {
            try {
                this.underlyingDate = direction > 0 ? this.underlyingDate.plus(period) : this.underlyingDate.minus(period);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (field == Granulaarsus.MONTH || field == Granulaarsus.WEEK_OF_YEAR) {
                this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            }
            if (field == Granulaarsus.YEAR) {
                this.updateDateRepresentation(Granulaarsus.MONTH, null, false, false);
            }
            if (field == Granulaarsus.CENTURY_OF_ERA) {
                this.updateDateRepresentation(Granulaarsus.YEAR, null, false, false);
            }
        }
    }

    public void seekField(Granulaarsus field, int direction, int soughtValue, boolean excludingCurrent) {
        LocalDate nihutatudFookus;
        int count;
        LocalDate ajaFookus;
        int dir;
        if (field == Granulaarsus.DAY_OF_MONTH && direction != 0 && soughtValue == 0) {
            LocalDate nihutatudFookus2;
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            this.underlyingDate = ajaFookus = (nihutatudFookus2 = ajaFookus.plusDays(1 * dir));
            this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.DAY_OF_WEEK && soughtValue >= 1 && soughtValue <= 7 && direction != 0) {
            int algneNadalapaev;
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            int n = algneNadalapaev = excludingCurrent ? ajaFookus.getDayOfWeek() : -1;
            if (!excludingCurrent) {
                ajaFookus = ajaFookus.plusDays(dir * -1);
            }
            count = 0;
            while (true) {
                ajaFookus = nihutatudFookus = ajaFookus.plusDays(1 * dir);
                int uusNadalapaev = ajaFookus.getDayOfWeek();
                if (algneNadalapaev != -1) {
                    if (algneNadalapaev == uusNadalapaev) continue;
                    algneNadalapaev = -1;
                }
                if (uusNadalapaev != soughtValue) continue;
                algneNadalapaev = uusNadalapaev;
                if (++count == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus;
            this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.WEEK_OF_YEAR && soughtValue == 0 && direction != 0) {
            int algneNadal;
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            int n = algneNadal = excludingCurrent ? ajaFookus.getWeekOfWeekyear() : -1;
            if (!excludingCurrent) {
                ajaFookus = ajaFookus.plusDays(dir * -1);
            }
            count = 0;
            while (true) {
                ajaFookus = nihutatudFookus = ajaFookus.plusDays(1 * dir);
                int uusNadal = nihutatudFookus.getWeekOfWeekyear();
                if (algneNadal != -1) {
                    if (algneNadal == uusNadal) continue;
                    algneNadal = -1;
                }
                if (soughtValue != 0) continue;
                algneNadal = uusNadal;
                if (++count == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus;
            this.updateDateRepresentation(Granulaarsus.WEEK_OF_YEAR, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.MONTH && (soughtValue == 0 || 1 <= soughtValue && soughtValue <= 12) && direction != 0) {
            int algneKuu;
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            int n = algneKuu = excludingCurrent ? ajaFookus.getMonthOfYear() : -1;
            if (!excludingCurrent) {
                ajaFookus = ajaFookus.plusMonths(dir * -1);
            }
            count = 0;
            while (true) {
                ajaFookus = nihutatudFookus = ajaFookus.plusMonths(1 * dir);
                int uusKuu = nihutatudFookus.getMonthOfYear();
                if (algneKuu != -1) {
                    if (algneKuu == uusKuu) continue;
                    algneKuu = -1;
                }
                if (soughtValue != 0 && (soughtValue == 0 || uusKuu != soughtValue)) continue;
                algneKuu = uusKuu;
                if (++count == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus;
            this.updateDateRepresentation(Granulaarsus.MONTH, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.YEAR && soughtValue == 0 && direction != 0) {
            int algneAasta;
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            int n = algneAasta = excludingCurrent ? ajaFookus.getYear() : -1;
            if (!excludingCurrent) {
                ajaFookus = ajaFookus.plusMonths(dir * -1);
            }
            count = 0;
            while (true) {
                ajaFookus = nihutatudFookus = ajaFookus.plusMonths(1 * dir);
                int uusAasta = nihutatudFookus.getYear();
                if (algneAasta != -1) {
                    if (algneAasta == uusAasta) continue;
                    algneAasta = -1;
                }
                if (soughtValue != 0) continue;
                algneAasta = uusAasta;
                if (++count == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus;
            this.updateDateRepresentation(Granulaarsus.YEAR, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.YEAR_OF_CENTURY && direction != 0) {
            int minValue = SemLeidmiseAbimeetodid.getLocalDateTimeFieldExtremum(this.underlyingDate, DateTimeFieldType.yearOfCentury(), false);
            int maxValue = SemLeidmiseAbimeetodid.getLocalDateTimeFieldExtremum(this.underlyingDate, DateTimeFieldType.yearOfCentury(), true);
            if (minValue <= soughtValue && soughtValue <= maxValue) {
                int algneAasta;
                int dir2 = direction > 0 ? 1 : -1;
                LocalDate ajaFookus2 = new LocalDate(this.underlyingDate);
                int n = algneAasta = excludingCurrent ? ajaFookus2.getYearOfCentury() : -1;
                if (!excludingCurrent) {
                    ajaFookus2 = ajaFookus2.plusYears(dir2 * -1);
                }
                int count2 = 0;
                int cycleCount = 0;
                while (true) {
                    LocalDate nihutatudFookus3 = ajaFookus2.plusYears(1 * dir2);
                    ++cycleCount;
                    ajaFookus2 = nihutatudFookus3;
                    int uusAasta = nihutatudFookus3.getYearOfCentury();
                    if (algneAasta != -1) {
                        if (algneAasta == uusAasta) continue;
                        algneAasta = -1;
                    }
                    if (uusAasta != soughtValue) continue;
                    algneAasta = uusAasta;
                    if (++count2 == Math.abs(direction)) break;
                }
                this.underlyingDate = ajaFookus2;
                this.updateDateRepresentation(Granulaarsus.YEAR, null, false, false);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            }
        }
        if (field == Granulaarsus.CENTURY_OF_ERA && soughtValue == 0 && direction != 0) {
            int algneSajand;
            dir = direction > 0 ? 1 : -1;
            LocalDate ajaFookus3 = new LocalDate(this.underlyingDate);
            int n = algneSajand = excludingCurrent ? ajaFookus3.getCenturyOfEra() : Integer.MIN_VALUE;
            if (!excludingCurrent) {
                ajaFookus3 = ajaFookus3.plusYears(dir * -10);
            }
            int count3 = 0;
            while (true) {
                LocalDate nihutatudFookus4;
                ajaFookus3 = nihutatudFookus4 = ajaFookus3.plusYears(10 * dir);
                int uusSajand = nihutatudFookus4.getCenturyOfEra();
                if (algneSajand != Integer.MIN_VALUE) {
                    if (algneSajand == uusSajand) continue;
                    algneSajand = Integer.MIN_VALUE;
                }
                if (soughtValue != 0) continue;
                algneSajand = uusSajand;
                if (++count3 == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus3;
            this.updateDateRepresentation(Granulaarsus.CENTURY_OF_ERA, null, false, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
    }

    public void seekField(Granulaarsus field, int direction, String soughtValue, boolean excludingCurrent) {
        LocalDate nihutatudFookus;
        int count;
        String algneMargend;
        BaseLocal ajaFookus;
        int dir;
        if (field == Granulaarsus.TIME && soughtValue != null && soughtValue.matches("(NI|MO|AF|EV)") && direction != 0) {
            dir = direction > 0 ? 1 : -1;
            ajaFookus = this.getAsLocalDateTime();
            String string = algneMargend = excludingCurrent ? SemLeidmiseAbimeetodid.getPartOfDay(((LocalDateTime)ajaFookus).toLocalTime()) : null;
            if (!excludingCurrent) {
                ajaFookus = ((LocalDateTime)ajaFookus).plusHours(dir * -1);
            }
            count = 0;
            while (true) {
                LocalDateTime uusFookus = ((LocalDateTime)ajaFookus).plusHours(1 * dir);
                ajaFookus = uusFookus;
                String newPartOfDay = SemLeidmiseAbimeetodid.getPartOfDay(uusFookus.toLocalTime());
                if (algneMargend != null) {
                    if (algneMargend.equals(newPartOfDay)) continue;
                    algneMargend = null;
                }
                if (newPartOfDay == null || !newPartOfDay.equals(soughtValue)) continue;
                algneMargend = newPartOfDay;
                if (++count == Math.abs(direction)) break;
            }
            this.partOfDay = soughtValue;
            this.updateTimeRepresentation(Granulaarsus.TIME, soughtValue, true, false);
            this.underlyingTime = ((LocalDateTime)ajaFookus).toLocalTime();
            this.underlyingDate = ((LocalDateTime)ajaFookus).toLocalDate();
            this.functionOtherThanSetUsed = true;
        }
        if (field == Granulaarsus.DAY_OF_WEEK && soughtValue != null && soughtValue.matches("(WD|WE)") && direction != 0) {
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            String string = algneMargend = excludingCurrent ? SemLeidmiseAbimeetodid.getWordDayOrWeekend((LocalDate)ajaFookus) : null;
            if (!excludingCurrent) {
                ajaFookus = ((LocalDate)ajaFookus).plusDays(dir * -1);
            }
            count = 0;
            while (true) {
                nihutatudFookus = ((LocalDate)ajaFookus).plusDays(1 * dir);
                ajaFookus = nihutatudFookus;
                String toopaevVoiNadalalopp = SemLeidmiseAbimeetodid.getWordDayOrWeekend((LocalDate)ajaFookus);
                if (algneMargend != null) {
                    if (algneMargend.equals(toopaevVoiNadalalopp)) continue;
                    algneMargend = null;
                }
                if (!toopaevVoiNadalalopp.equals(soughtValue)) continue;
                algneMargend = toopaevVoiNadalalopp;
                if (++count == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus;
            this.openedFields.put(VALUE_FIELD.DAY, soughtValue);
            this.updateDateRepresentation(Granulaarsus.DAY_OF_WEEK, soughtValue, true, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.MONTH && soughtValue != null && soughtValue.matches("(SP|SU|FA|WI)") && direction != 0) {
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            String string = algneMargend = excludingCurrent ? SemLeidmiseAbimeetodid.getSeason((LocalDate)ajaFookus) : null;
            if (!excludingCurrent) {
                ajaFookus = ((LocalDate)ajaFookus).plusMonths(dir * -1);
            }
            count = 0;
            while (true) {
                nihutatudFookus = ((LocalDate)ajaFookus).plusMonths(1 * dir);
                ajaFookus = nihutatudFookus;
                String aastaaeg = SemLeidmiseAbimeetodid.getSeason((LocalDate)ajaFookus);
                if (algneMargend != null) {
                    if (algneMargend.equals(aastaaeg)) continue;
                    algneMargend = null;
                }
                if (!aastaaeg.equals(soughtValue)) continue;
                algneMargend = aastaaeg;
                if (++count == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus;
            if (this.underlyingDate.getMonthOfYear() == 12) {
                this.underlyingDate = this.underlyingDate.plusMonths(1);
            }
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, soughtValue);
            this.updateDateRepresentation(Granulaarsus.MONTH, soughtValue, true, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
        if (field == Granulaarsus.MONTH && soughtValue != null && soughtValue.matches("Q(1|2|3|4)") && direction != 0) {
            dir = direction > 0 ? 1 : -1;
            ajaFookus = new LocalDate(this.underlyingDate);
            String string = algneMargend = excludingCurrent ? SemLeidmiseAbimeetodid.getQuarterOfYear((LocalDate)ajaFookus) : null;
            if (!excludingCurrent) {
                ajaFookus = ((LocalDate)ajaFookus).plusMonths(dir * -1);
            }
            count = 0;
            while (true) {
                nihutatudFookus = ((LocalDate)ajaFookus).plusMonths(1 * dir);
                ajaFookus = nihutatudFookus;
                String kvartal = SemLeidmiseAbimeetodid.getQuarterOfYear((LocalDate)ajaFookus);
                if (algneMargend != null) {
                    if (algneMargend.equals(kvartal)) continue;
                    algneMargend = null;
                }
                if (!kvartal.equals(soughtValue)) continue;
                algneMargend = kvartal;
                if (++count == Math.abs(direction)) break;
            }
            this.underlyingDate = ajaFookus;
            String newQuarterVal = SemLeidmiseAbimeetodid.getQuarterOfYear(this.underlyingDate);
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, newQuarterVal);
            this.updateDateRepresentation(Granulaarsus.MONTH, newQuarterVal, true, false);
            this.functionOtherThanSetUsed = true;
            this.dateModified = true;
        }
    }

    public void applyBalwinWindow(Granulaarsus field, String soughtValue) {
        block4: {
            if (soughtValue != null) {
                LocalDateTime ajaFookus = this.getAsLocalDateTime();
                try {
                    int soughtValueAsInt = Integer.parseInt(soughtValue);
                    LocalDateTime uusFookus = SemLeidmiseAbimeetodid.applyBaldwinWindow(field, ajaFookus, soughtValueAsInt);
                    this.underlyingTime = uusFookus.toLocalTime();
                    this.underlyingDate = uusFookus.toLocalDate();
                    if (field == Granulaarsus.DAY_OF_WEEK) {
                        field = Granulaarsus.DAY_OF_MONTH;
                    }
                    this.updateDateRepresentation(field, null, false, false);
                    this.functionOtherThanSetUsed = true;
                    this.dateModified = true;
                }
                catch (NumberFormatException e) {
                    LocalDateTime uusFookus = SemLeidmiseAbimeetodid.applyBaldwinWindow(field, ajaFookus, soughtValue);
                    if (uusFookus == null || field != Granulaarsus.MONTH) break block4;
                    this.underlyingTime = uusFookus.toLocalTime();
                    this.underlyingDate = uusFookus.toLocalDate();
                    this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, soughtValue);
                    this.updateDateRepresentation(Granulaarsus.MONTH, soughtValue, true, false);
                    this.functionOtherThanSetUsed = true;
                    this.dateModified = true;
                }
            }
        }
    }

    public void findNthSubpartOfGranularity(Granulaarsus superField, Granulaarsus subField, int soughtValueOfSubField, int n) {
        LocalDateTime ajaFookus = this.getAsLocalDateTime();
        LocalDateTime uusFookus = SemLeidmiseAbimeetodid.findNthSubpartOfGranularity(superField, subField, soughtValueOfSubField, n, ajaFookus);
        if (uusFookus != null && superField == Granulaarsus.MONTH) {
            this.underlyingTime = uusFookus.toLocalTime();
            this.underlyingDate = uusFookus.toLocalDate();
            if (subField == Granulaarsus.DAY_OF_WEEK) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    this.manageMaskedFields(Granulaarsus.MONTH, null, false, true);
                }
                this.updateDateRepresentation(Granulaarsus.DAY_OF_MONTH, null, false, false);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            } else if (subField == Granulaarsus.WEEK_OF_YEAR) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    this.manageMaskedFields(Granulaarsus.MONTH, null, false, true);
                }
                this.updateDateRepresentation(Granulaarsus.WEEK_OF_YEAR, null, false, false);
                this.functionOtherThanSetUsed = true;
                this.dateModified = true;
            }
        }
    }

    private void updateDateRepresentation(Granulaarsus changedGranularity, String label, boolean skipOverwritingChangedOne, boolean setOrAddOperation) {
        this.modifiedGrans.put(changedGranularity, "1");
        if (label == null && this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && (changedGranularity == Granulaarsus.WEEK_OF_YEAR || changedGranularity == Granulaarsus.DAY_OF_WEEK) && !this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
            this.openedFields.put(VALUE_FIELD.MONTH_OR_WEEK, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()));
            this.openedFields.put(VALUE_FIELD.DAY, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()));
        }
        for (int i = 0; i < 3; ++i) {
            VALUE_FIELD field = valueFieldsInOrder[i];
            if (!field.matchesGranularity(changedGranularity)) continue;
            int j = i;
            while (j > -1) {
                VALUE_FIELD upperOrSameField = valueFieldsInOrder[j];
                if (j == i && skipOverwritingChangedOne) {
                    --j;
                    continue;
                }
                if (upperOrSameField == VALUE_FIELD.YEAR) {
                    String yearStr = String.valueOf(this.underlyingDate.getYear());
                    if (yearStr.startsWith("-")) {
                        yearStr = yearStr.substring(1);
                    }
                    yearStr = TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, yearStr);
                    if (this.underlyingDate.era().get() == 0) {
                        yearStr = "BC" + yearStr;
                    }
                    this.openedFields.put(upperOrSameField, yearStr);
                }
                if (upperOrSameField == VALUE_FIELD.MONTH_OR_WEEK) {
                    if (this.isModified(Granulaarsus.WEEK_OF_YEAR) && !this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && changedGranularity == Granulaarsus.DAY_OF_WEEK && label != null) {
                        this.openedFields.put(upperOrSameField, "W" + TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getWeekOfWeekyear()));
                        if (this.maskedFields.containsKey((Object)upperOrSameField)) {
                            this.maskedFields.put(upperOrSameField, "WXX");
                        }
                    } else {
                        this.openedFields.put(upperOrSameField, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()));
                        if (this.maskedFields.containsKey((Object)upperOrSameField)) {
                            this.maskedFields.put(upperOrSameField, "XX");
                        }
                    }
                }
                if (upperOrSameField == VALUE_FIELD.DAY) {
                    if (this.isModified(Granulaarsus.WEEK_OF_YEAR) && !this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) && this.isModified(Granulaarsus.WEEK_OF_YEAR) && this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                        this.openedFields.put(upperOrSameField, String.valueOf(this.underlyingDate.getDayOfWeek()));
                    } else {
                        this.openedFields.put(upperOrSameField, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()));
                    }
                }
                --j;
            }
            break;
        }
        if (this.isModified(Granulaarsus.CENTURY_OF_ERA) && !this.isModified(Granulaarsus.YEAR) && !this.isModified(Granulaarsus.YEAR_OF_CENTURY) && this.openedFields.containsKey((Object)VALUE_FIELD.YEAR) && this.openedFields.get((Object)VALUE_FIELD.YEAR).matches("(BC)?\\d{2,4}")) {
            String newYearVal = String.valueOf(this.underlyingDate.getCenturyOfEra());
            if (newYearVal.length() == 1) {
                newYearVal = "0" + newYearVal;
            }
            if (this.underlyingDate.era().get() == 0) {
                newYearVal = "BC" + newYearVal;
            }
            this.openedFields.put(VALUE_FIELD.YEAR, newYearVal);
        }
        this.manageMaskedFields(changedGranularity, label, skipOverwritingChangedOne, setOrAddOperation);
    }

    private void updateTimeRepresentation(Granulaarsus field, String setLabel, boolean skipOverwritingChangedOne, boolean setOrAddOperation) {
        if (field == Granulaarsus.TIME && setLabel != null) {
            this.partOfDay = setLabel;
        }
        this.modifiedGrans.put(field, "1");
        if (setLabel == null) {
            if (!skipOverwritingChangedOne) {
                if (field == Granulaarsus.AM_PM) {
                    this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
                }
                if (field == Granulaarsus.HOUR_OF_HALF_DAY) {
                    if (this.isModified(Granulaarsus.AM_PM)) {
                        this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
                        this.openedFields.remove((Object)VALUE_FIELD.MINUTE);
                    } else {
                        this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()));
                    }
                }
                if (field == Granulaarsus.MINUTE) {
                    this.openedFields.put(VALUE_FIELD.MINUTE, TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, this.underlyingTime.getMinuteOfHour()));
                }
            }
        } else if (field == Granulaarsus.TIME) {
            if (!this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD)) {
                this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, setLabel);
                this.openedFields.remove((Object)VALUE_FIELD.MINUTE);
            } else if (this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+")) {
                this.openedFields.put(VALUE_FIELD.HOUR_OR_POD, setLabel);
                this.openedFields.remove((Object)VALUE_FIELD.MINUTE);
            }
        }
        if (this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && this.partOfDay != null && !this.isModified(Granulaarsus.AM_PM)) {
            int hourOfHalfDay = this.underlyingTime.get(DateTimeFieldType.hourOfHalfday());
            if (this.partOfDay.equals("NI")) {
                if (hourOfHalfDay >= 8 && hourOfHalfDay < 12) {
                    this.setField(Granulaarsus.AM_PM, 1);
                } else {
                    this.setField(Granulaarsus.AM_PM, 0);
                }
                return;
            }
            if (this.partOfDay.equals("MO")) {
                if (hourOfHalfDay == 0) {
                    this.setField(Granulaarsus.AM_PM, 1);
                } else {
                    this.setField(Granulaarsus.AM_PM, 0);
                }
            }
            if (this.partOfDay.equals("AF")) {
                this.setField(Granulaarsus.AM_PM, 1);
            }
            if (this.partOfDay.equals("DT")) {
                if (hourOfHalfDay == 0) {
                    this.setField(Granulaarsus.AM_PM, 1);
                } else if (9 <= hourOfHalfDay && hourOfHalfDay < 12) {
                    this.setField(Granulaarsus.AM_PM, 0);
                } else if (hourOfHalfDay <= 7) {
                    this.setField(Granulaarsus.AM_PM, 1);
                }
            }
            if (this.partOfDay.equals("EV")) {
                if (hourOfHalfDay == 0) {
                    this.setField(Granulaarsus.AM_PM, 0);
                } else {
                    this.setField(Granulaarsus.AM_PM, 1);
                }
            }
        }
        this.manageMaskedFields(field, setLabel, skipOverwritingChangedOne, setOrAddOperation);
    }

    public void closeGranularitiesBelow(Granulaarsus minGran, int digits) {
        if (minGran.compareByCoarseRank(Granulaarsus.TIME) == 1) {
            this.partOfDay = null;
        }
        boolean skipRemovingLowerGranularities = false;
        if (digits > 0 && minGran == Granulaarsus.YEAR && this.openedFields.containsKey((Object)VALUE_FIELD.YEAR) && this.openedFields.get((Object)VALUE_FIELD.YEAR).matches("(BC)?\\d{4}")) {
            if (digits > 3) {
                this.maskedFields.put(VALUE_FIELD.YEAR, "XXXX");
                skipRemovingLowerGranularities = true;
            } else {
                String year = this.openedFields.get((Object)VALUE_FIELD.YEAR);
                this.openedFields.put(VALUE_FIELD.YEAR, year.substring(0, year.length() - digits));
            }
        }
        if (!skipRemovingLowerGranularities) {
            for (Granulaarsus granulaarsus : Granulaarsus.fieldsInSafeOrder) {
                if (minGran.compareByCoarseRank(granulaarsus) != 1) continue;
                for (int i = 0; i < valueFieldsInOrder.length; ++i) {
                    VALUE_FIELD field = valueFieldsInOrder[i];
                    if (!field.matchesGranularity(granulaarsus)) continue;
                    this.openedFields.remove((Object)field);
                }
            }
        }
    }

    private void manageMaskedFields(Granulaarsus changedGranularity, String label, boolean skipOverwritingChangedOne, boolean setOrAddOperation) {
        int j;
        boolean fieldFound;
        VALUE_FIELD removeMaskFromFieldsEqualOrLowerThan = null;
        VALUE_FIELD addMaskToFieldsEqualOrGreaterThan = null;
        if (setOrAddOperation) {
            if (changedGranularity == Granulaarsus.YEAR || changedGranularity == Granulaarsus.YEAR_OF_CENTURY || changedGranularity == Granulaarsus.CENTURY_OF_ERA) {
                this.maskedFields.remove((Object)VALUE_FIELD.YEAR);
                removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.YEAR;
            }
            if (changedGranularity == Granulaarsus.MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR) || label != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                } else if (!(this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_MONTH))) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.YEAR;
                }
            }
            if (changedGranularity == Granulaarsus.WEEK_OF_YEAR) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                } else if (!this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.DAY_OF_MONTH)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.MONTH_OR_WEEK;
                }
            }
            if (changedGranularity == Granulaarsus.DAY_OF_WEEK) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY) || label != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.DAY);
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = label != null ? VALUE_FIELD.MONTH_OR_WEEK : VALUE_FIELD.DAY;
                }
            }
            if (changedGranularity == Granulaarsus.DAY_OF_MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.DAY);
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.DAY;
                }
            }
            if (changedGranularity == Granulaarsus.AM_PM && label == null && !skipOverwritingChangedOne) {
                this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.MINUTE;
            }
            if (changedGranularity == Granulaarsus.TIME && label != null) {
                this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.DAY;
                }
            }
            if ((changedGranularity == Granulaarsus.HOUR_OF_HALF_DAY || changedGranularity == Granulaarsus.HOUR_OF_DAY) && label == null) {
                if (this.isModified(Granulaarsus.AM_PM)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                } else {
                    this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
                }
                removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.DAY;
                }
            }
            if (changedGranularity == Granulaarsus.MINUTE) {
                this.maskedFields.remove((Object)VALUE_FIELD.MINUTE);
                if (!this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) || this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+")) {
                    this.openedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                    this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
                }
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.DAY;
                }
            }
        } else {
            if (changedGranularity == Granulaarsus.YEAR || changedGranularity == Granulaarsus.YEAR_OF_CENTURY || changedGranularity == Granulaarsus.CENTURY_OF_ERA) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.YEAR;
                } else if (!this.isModified(Granulaarsus.MONTH) && !this.isModified(Granulaarsus.WEEK_OF_YEAR)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.MONTH_OR_WEEK;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.YEAR)) {
                    if (changedGranularity == Granulaarsus.YEAR) {
                        this.maskedFields.put(VALUE_FIELD.YEAR, "XXXX");
                    }
                    if (changedGranularity == Granulaarsus.YEAR_OF_CENTURY) {
                        this.maskedFields.put(VALUE_FIELD.YEAR, "XXXX");
                    }
                    if (changedGranularity == Granulaarsus.CENTURY_OF_ERA) {
                        this.maskedFields.put(VALUE_FIELD.YEAR, "XX");
                    }
                }
            }
            if (changedGranularity == Granulaarsus.MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || label != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                } else if (!(this.isModified(Granulaarsus.WEEK_OF_YEAR) || this.isModified(Granulaarsus.DAY_OF_WEEK) || this.isModified(Granulaarsus.DAY_OF_MONTH))) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.YEAR;
                }
            }
            if (changedGranularity == Granulaarsus.WEEK_OF_YEAR) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY) || label != null) {
                    this.maskedFields.remove((Object)VALUE_FIELD.MONTH_OR_WEEK);
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                } else if (!this.isModified(Granulaarsus.DAY_OF_WEEK) && !this.isModified(Granulaarsus.DAY_OF_MONTH)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.DAY;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.MONTH_OR_WEEK;
                }
            }
            if (changedGranularity == Granulaarsus.DAY_OF_WEEK) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = label != null ? VALUE_FIELD.MONTH_OR_WEEK : VALUE_FIELD.DAY;
                }
            }
            if (changedGranularity == Granulaarsus.DAY_OF_MONTH) {
                if (!this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                } else if (!this.isModified(Granulaarsus.HOUR_OF_HALF_DAY) && !this.isModified(Granulaarsus.TIME)) {
                    removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.HOUR_OR_POD;
                }
                if (this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) || this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.DAY;
                }
            }
            if ((changedGranularity == Granulaarsus.HOUR_OF_HALF_DAY || changedGranularity == Granulaarsus.HOUR_OF_DAY) && label == null) {
                if (this.isModified(Granulaarsus.AM_PM)) {
                    this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                } else {
                    this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
                }
                removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.DAY;
                }
            }
            if (changedGranularity == Granulaarsus.TIME && label != null) {
                this.maskedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                removeMaskFromFieldsEqualOrLowerThan = VALUE_FIELD.MINUTE;
                if (this.dateModified && this.maskedFields.containsKey((Object)VALUE_FIELD.DAY)) {
                    addMaskToFieldsEqualOrGreaterThan = VALUE_FIELD.DAY;
                }
            }
            if (changedGranularity == Granulaarsus.MINUTE && (!this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) || this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+"))) {
                this.openedFields.remove((Object)VALUE_FIELD.HOUR_OR_POD);
                this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, "XX");
            }
        }
        if (removeMaskFromFieldsEqualOrLowerThan != null) {
            fieldFound = false;
            for (j = 0; j < valueFieldsInOrder.length; ++j) {
                VALUE_FIELD lowerOrSameField = valueFieldsInOrder[j];
                if (lowerOrSameField == removeMaskFromFieldsEqualOrLowerThan) {
                    fieldFound = true;
                }
                if (!fieldFound) continue;
                this.maskedFields.remove((Object)lowerOrSameField);
            }
        }
        if (addMaskToFieldsEqualOrGreaterThan != null) {
            fieldFound = false;
            for (j = valueFieldsInOrder.length - 1; j > -1; --j) {
                VALUE_FIELD greaterOrSameField = valueFieldsInOrder[j];
                if (greaterOrSameField == addMaskToFieldsEqualOrGreaterThan) {
                    fieldFound = true;
                }
                if (!fieldFound) continue;
                if (greaterOrSameField == VALUE_FIELD.YEAR) {
                    this.maskedFields.put(greaterOrSameField, "XXXX");
                }
                if (greaterOrSameField == VALUE_FIELD.MONTH_OR_WEEK) {
                    if (this.hasWeekBasedFormatInOutput()) {
                        this.maskedFields.put(greaterOrSameField, "WXX");
                    } else {
                        this.maskedFields.put(greaterOrSameField, "XX");
                    }
                }
                if (greaterOrSameField == VALUE_FIELD.DAY) {
                    this.maskedFields.put(greaterOrSameField, "XX");
                }
                if (greaterOrSameField == VALUE_FIELD.HOUR_OR_POD) {
                    this.maskedFields.put(greaterOrSameField, "XX");
                }
                if (greaterOrSameField != VALUE_FIELD.MINUTE) continue;
                this.maskedFields.put(greaterOrSameField, "XX");
            }
        }
    }

    public void setMaskedFields(String year, String month, String day, String hour, String minute) {
        Pattern maskPattern = Pattern.compile("X+");
        if (year != null && maskPattern.matcher(year).matches()) {
            this.maskedFields.put(VALUE_FIELD.YEAR, year);
        }
        if (month != null && maskPattern.matcher(month).matches()) {
            this.maskedFields.put(VALUE_FIELD.MONTH_OR_WEEK, month);
        }
        if (day != null && maskPattern.matcher(day).matches()) {
            this.maskedFields.put(VALUE_FIELD.DAY, day);
        }
        if (hour != null && maskPattern.matcher(hour).matches()) {
            this.maskedFields.put(VALUE_FIELD.HOUR_OR_POD, hour);
        }
        if (minute != null && maskPattern.matcher(minute).matches()) {
            this.maskedFields.put(VALUE_FIELD.MINUTE, minute);
        }
    }

    public TimeMLDateTimePoint clone() {
        TimeMLDateTimePoint newDtp = new TimeMLDateTimePoint(this);
        return newDtp;
    }

    public boolean isModified(Granulaarsus g) {
        return this.modifiedGrans.containsKey((Object)g);
    }

    public boolean hasFunctionOtherThanSetUsed() {
        return this.functionOtherThanSetUsed;
    }

    public boolean hasModifiedFields() {
        return !this.openedFields.isEmpty();
    }

    public boolean hadModifiedDateFields() {
        return this.dateModified;
    }

    public boolean hasModifiedTimeFields() {
        return this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) || this.maskedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD);
    }

    public boolean hasLabelsInOutput() {
        return this.openedFields.containsKey((Object)VALUE_FIELD.HOUR_OR_POD) && this.openedFields.get((Object)VALUE_FIELD.HOUR_OR_POD).matches("[A-Z]+") || this.openedFields.containsKey((Object)VALUE_FIELD.DAY) && this.openedFields.get((Object)VALUE_FIELD.DAY).matches("[A-Z]+") || this.openedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) && this.openedFields.get((Object)VALUE_FIELD.MONTH_OR_WEEK).matches("[A-Z]+[0-9]*");
    }

    public boolean hasWeekBasedFormatInOutput() {
        return this.openedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) && this.openedFields.get((Object)VALUE_FIELD.MONTH_OR_WEEK).matches("W\\d+") || this.maskedFields.containsKey((Object)VALUE_FIELD.MONTH_OR_WEEK) && this.maskedFields.get((Object)VALUE_FIELD.MONTH_OR_WEEK).matches("WX+");
    }

    public String toValueString() throws Exception {
        VALUE_FIELD field;
        int i;
        HashMap<VALUE_FIELD, String> displayableFields = this.openedFields;
        if (this.openedFields.size() == 0) {
            displayableFields = this.inputFields;
        }
        if (displayableFields.size() == 0 && this.maskedFields.size() == 0) {
            throw new Exception("No calendaric fields have been set for " + this.getClass().getCanonicalName() + " object.");
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < valueFieldsInOrder.length; ++i) {
            field = valueFieldsInOrder[i];
            if (this.maskedFields.containsKey((Object)field)) {
                if (i > 0 && i < 3) {
                    sb.append("-");
                }
                if (i == 3) {
                    sb.append("T");
                }
                if (i == 4) {
                    sb.append(":");
                }
                sb.append(this.maskedFields.get((Object)field));
                continue;
            }
            if (!displayableFields.containsKey((Object)field)) break;
            if (i > 0 && i < 3) {
                sb.append("-");
            }
            if (i == 3) {
                sb.append("T");
            }
            if (i == 4) {
                sb.append(":");
            }
            sb.append(displayableFields.get((Object)field));
        }
        if (sb.length() == 0) {
            for (i = 3; i < valueFieldsInOrder.length; ++i) {
                field = valueFieldsInOrder[i];
                if (this.maskedFields.containsKey((Object)field)) {
                    if (i == 3) {
                        sb.append("T");
                    }
                    if (i == 4) {
                        sb.append(":");
                    }
                    sb.append(this.maskedFields.get((Object)field));
                    continue;
                }
                if (!displayableFields.containsKey((Object)field)) break;
                if (i == 3) {
                    sb.append("T");
                }
                if (i == 4) {
                    sb.append(":");
                }
                sb.append(displayableFields.get((Object)field));
            }
        }
        return sb.toString();
    }

    public static String normalizeByAddingZeroes(VALUE_FIELD field, int value) {
        return TimeMLDateTimePoint.normalizeByAddingZeroes(field, String.valueOf(value));
    }

    public static String normalizeByAddingZeroes(VALUE_FIELD field, String value) {
        if (value.matches("\\d+")) {
            if (field == VALUE_FIELD.YEAR) {
                while (value.length() < 4) {
                    value = "0" + value;
                }
            }
            if (value.length() == 1) {
                if (field == VALUE_FIELD.MONTH_OR_WEEK) {
                    return "0" + value;
                }
                if (field == VALUE_FIELD.DAY) {
                    return "0" + value;
                }
                if (field == VALUE_FIELD.HOUR_OR_POD) {
                    return "0" + value;
                }
                if (field == VALUE_FIELD.MINUTE) {
                    return "0" + value;
                }
            }
        }
        return value;
    }

    public static String getFieldShapeInXXXes(VALUE_FIELD field) {
        if (field == VALUE_FIELD.YEAR) {
            return "XXXX";
        }
        return "XX";
    }

    public Granulaarsus getLowestChangedGranularity() {
        Granulaarsus lowest = null;
        for (Granulaarsus gran : Granulaarsus.fieldsInSafeOrder) {
            if (!this.isModified(gran)) continue;
            lowest = gran;
        }
        if (lowest == Granulaarsus.CENTURY_OF_ERA) {
            lowest = Granulaarsus.YEAR;
        }
        if (lowest == Granulaarsus.DAY_OF_WEEK) {
            lowest = Granulaarsus.DAY_OF_MONTH;
        }
        if (lowest == Granulaarsus.WEEK_OF_YEAR) {
            lowest = Granulaarsus.DAY_OF_MONTH;
        }
        if (lowest == Granulaarsus.HOUR_OF_HALF_DAY) {
            lowest = Granulaarsus.HOUR_OF_DAY;
        }
        if (lowest == Granulaarsus.AM_PM) {
            lowest = Granulaarsus.HOUR_OF_DAY;
        }
        if (lowest == null && this.isModified(Granulaarsus.TIME)) {
            lowest = Granulaarsus.HOUR_OF_DAY;
        }
        if (lowest == null && this.isModified(Granulaarsus.YEAR_OF_CENTURY)) {
            lowest = Granulaarsus.YEAR;
        }
        return lowest;
    }

    public void copyInputFieldsToOpenedFields() {
        if (this.inputFields.size() == 5) {
            for (VALUE_FIELD vf : this.inputFields.keySet()) {
                this.openedFields.put(vf, this.inputFields.get((Object)vf));
            }
        }
    }

    public LocalDateTime getAsLocalDateTime() {
        return new LocalDateTime(this.underlyingDate.getYear(), this.underlyingDate.getMonthOfYear(), this.underlyingDate.getDayOfMonth(), this.underlyingTime.getHourOfDay(), this.underlyingTime.getMinuteOfHour());
    }

    public String[] getUnderlyingDateTimeAsGranularitiesArray() {
        return new String[]{TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.YEAR, this.underlyingDate.getYear()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MONTH_OR_WEEK, this.underlyingDate.getMonthOfYear()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.DAY, this.underlyingDate.getDayOfMonth()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.HOUR_OR_POD, this.underlyingTime.getHourOfDay()), TimeMLDateTimePoint.normalizeByAddingZeroes(VALUE_FIELD.MINUTE, this.underlyingTime.getMinuteOfHour())};
    }

    private static int parseInteger(String str) {
        int i = -1;
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    public static enum VALUE_FIELD {
        YEAR,
        MONTH_OR_WEEK,
        DAY,
        HOUR_OR_POD,
        MINUTE;


        public boolean matchesGranularity(Granulaarsus g) {
            if (this.equals((Object)MINUTE)) {
                return g.equals((Object)Granulaarsus.MINUTE);
            }
            if (this.equals((Object)HOUR_OR_POD)) {
                return g.equals((Object)Granulaarsus.HOUR_OF_DAY) || g.equals((Object)Granulaarsus.HOUR_OF_HALF_DAY);
            }
            if (this.equals((Object)DAY)) {
                return g.equals((Object)Granulaarsus.DAY_OF_MONTH) || g.equals((Object)Granulaarsus.DAY_OF_WEEK);
            }
            if (this.equals((Object)MONTH_OR_WEEK)) {
                return g.equals((Object)Granulaarsus.MONTH) || g.equals((Object)Granulaarsus.WEEK_OF_YEAR);
            }
            if (this.equals((Object)YEAR)) {
                return g.equals((Object)Granulaarsus.YEAR) || g.equals((Object)Granulaarsus.YEAR_OF_CENTURY) || g.equals((Object)Granulaarsus.CENTURY_OF_ERA);
            }
            return false;
        }
    }
}

