import binascii
import logging

from .cookie import Cookie

from .signals import (the_signature_validation_has_failed,
					  the_signature_validation_was_successful,
					  the_signature_validation_throws_error)

class Base(Cookie):

	@property
	def verificated(self):
		#: This property is set to True only when the credentials 
		#: have been successfully verified. It is always set to False 
		#: before request processing begins.
		if not hasattr(self, 'client_key'):
			self.client_key = bytes()
		return self.client_key

	@verificated.setter
	def verificated(self, value:bool = False):
		self.client_key = bool(value)

	@property
	def client(self):
		#: ed25519 public key sent by the user's device, this  user's signature key 
		#: is stored unencrypted and is static (it doesn't rotate over time).

		#: Client signature key is unique, generated by the user device at the moment 
		#: of key agreement and is used to sign and verify authentication tokens.
		if not hasattr(self, 'client_key'):
			self.client_key = bytes()
		return self.client_key

	@client.setter
	def client(self, value:bytes):
		self.client_key = value

	@property
	def user(self):
		#: The user ID received from the `USER object' passed by Flask-Login.
		if hasattr(self, 'user_id'):
			return self.user_id

	@user.setter
	def user(self, value:int):
		self.user_id = value

	@property
	def email(self):
		#: The user email received from the `USER object' passed by Flask-Login.
		if hasattr(self, 'mail'):
			return self.mail

	@email.setter
	def email(self, value:int):
		self.mail = value