"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwesomeList = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
/**
 * Awesome List project.
 *
 * @stability stable
 * @pjid awesome-list
 */
class AwesomeList extends projen_1.JsiiProject {
    /**
     * @stability stable
     */
    constructor(options) {
        var _b, _c;
        super({
            ...options,
            readme: {
                filename: 'readme.md',
                contents: readmeContents(),
            },
            defaultReleaseBranch: 'main',
            releaseBranches: ['main'],
            gitpod: true,
            releaseToNpm: false,
        });
        new projen_1.SampleFile(this, 'code-of-conduct.md', {
            contents: this.codeOfConduct().replace('CONTACTEMAIL', (_b = options.contactEmail) !== null && _b !== void 0 ? _b : 'noreply@example.com'),
        });
        new projen_1.SampleFile(this, 'contributing.md', {
            contents: this.contributing(),
        });
        this._awesomeLint();
        (_c = this.gitpod) === null || _c === void 0 ? void 0 : _c.addCustomTask({
            name: 'Setup',
            command: 'npx projen Setup',
        });
    }
    _awesomeLint() {
        this.addDevDeps('awesome-lint');
        const awesomeLintTask = this.addTask('awesome-lint');
        awesomeLintTask.exec('npx awesome-lint');
        this.buildTask.reset(awesomeLintTask.toShellCommand());
    }
    codeOfConduct() {
        const contents = `# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at CONTACTEMAIL. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
    `;
        return contents;
    }
    contributing() {
        const contents = `# Contribution Guidelines

Please note that this project is released with a
[Contributor Code of Conduct](code-of-conduct.md). By participating in this
project you agree to abide by its terms.

## Adding an awesome list

Please ensure your pull request adheres to the [list guidelines](pull_request_template.md).

## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one. If you're not sure how to do that,
[here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md)
on the different ways you can update your PR so that we can merge it.
    `;
        return contents;
    }
}
exports.AwesomeList = AwesomeList;
_a = JSII_RTTI_SYMBOL_1;
AwesomeList[_a] = { fqn: "p6-projen-project-awesome-list.AwesomeList", version: "0.1.60" };
function readmeContents() {
    const contents = `# Awesome Projen [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

  > Curated list of awesome [PROJECT](REPOSITORY) SHORTDESC.

  LONGDESC

  ## Contents

  ## Contributing

  Contributions welcome! Read the [contribution guidelines](contributing.md) first.`;
    return contents;
}
//# sourceMappingURL=data:application/json;base64,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