# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetListUserGrantsResult',
    'AwaitableGetListUserGrantsResult',
    'get_list_user_grants',
    'get_list_user_grants_output',
]

@pulumi.output_type
class GetListUserGrantsResult:
    """
    A collection of values returned by getListUserGrants.
    """
    def __init__(__self__, depth_level=None, depth_level_greater_than_or_equal_to=None, depth_level_less_than=None, filters=None, grant_key=None, grant_name=None, grants=None, id=None, privilege_category=None, privilege_type=None, user_assessment_id=None, user_key=None):
        if depth_level and not isinstance(depth_level, int):
            raise TypeError("Expected argument 'depth_level' to be a int")
        pulumi.set(__self__, "depth_level", depth_level)
        if depth_level_greater_than_or_equal_to and not isinstance(depth_level_greater_than_or_equal_to, int):
            raise TypeError("Expected argument 'depth_level_greater_than_or_equal_to' to be a int")
        pulumi.set(__self__, "depth_level_greater_than_or_equal_to", depth_level_greater_than_or_equal_to)
        if depth_level_less_than and not isinstance(depth_level_less_than, int):
            raise TypeError("Expected argument 'depth_level_less_than' to be a int")
        pulumi.set(__self__, "depth_level_less_than", depth_level_less_than)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if grant_key and not isinstance(grant_key, str):
            raise TypeError("Expected argument 'grant_key' to be a str")
        pulumi.set(__self__, "grant_key", grant_key)
        if grant_name and not isinstance(grant_name, str):
            raise TypeError("Expected argument 'grant_name' to be a str")
        pulumi.set(__self__, "grant_name", grant_name)
        if grants and not isinstance(grants, list):
            raise TypeError("Expected argument 'grants' to be a list")
        pulumi.set(__self__, "grants", grants)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if privilege_category and not isinstance(privilege_category, str):
            raise TypeError("Expected argument 'privilege_category' to be a str")
        pulumi.set(__self__, "privilege_category", privilege_category)
        if privilege_type and not isinstance(privilege_type, str):
            raise TypeError("Expected argument 'privilege_type' to be a str")
        pulumi.set(__self__, "privilege_type", privilege_type)
        if user_assessment_id and not isinstance(user_assessment_id, str):
            raise TypeError("Expected argument 'user_assessment_id' to be a str")
        pulumi.set(__self__, "user_assessment_id", user_assessment_id)
        if user_key and not isinstance(user_key, str):
            raise TypeError("Expected argument 'user_key' to be a str")
        pulumi.set(__self__, "user_key", user_key)

    @property
    @pulumi.getter(name="depthLevel")
    def depth_level(self) -> Optional[int]:
        """
        The grant depth level of the indirect grant. An indirectly granted role/privilege is granted to the user through another role. The depth level indicates how deep a privilege is within the grant hierarchy.
        """
        return pulumi.get(self, "depth_level")

    @property
    @pulumi.getter(name="depthLevelGreaterThanOrEqualTo")
    def depth_level_greater_than_or_equal_to(self) -> Optional[int]:
        return pulumi.get(self, "depth_level_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="depthLevelLessThan")
    def depth_level_less_than(self) -> Optional[int]:
        return pulumi.get(self, "depth_level_less_than")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetListUserGrantsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="grantKey")
    def grant_key(self) -> Optional[str]:
        return pulumi.get(self, "grant_key")

    @property
    @pulumi.getter(name="grantName")
    def grant_name(self) -> Optional[str]:
        """
        The name of a user grant.
        """
        return pulumi.get(self, "grant_name")

    @property
    @pulumi.getter
    def grants(self) -> Sequence['outputs.GetListUserGrantsGrantResult']:
        """
        The list of grants.
        """
        return pulumi.get(self, "grants")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privilegeCategory")
    def privilege_category(self) -> Optional[str]:
        """
        The privilege category.
        """
        return pulumi.get(self, "privilege_category")

    @property
    @pulumi.getter(name="privilegeType")
    def privilege_type(self) -> Optional[str]:
        """
        The type of a user grant.
        """
        return pulumi.get(self, "privilege_type")

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> str:
        return pulumi.get(self, "user_assessment_id")

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> str:
        return pulumi.get(self, "user_key")


class AwaitableGetListUserGrantsResult(GetListUserGrantsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListUserGrantsResult(
            depth_level=self.depth_level,
            depth_level_greater_than_or_equal_to=self.depth_level_greater_than_or_equal_to,
            depth_level_less_than=self.depth_level_less_than,
            filters=self.filters,
            grant_key=self.grant_key,
            grant_name=self.grant_name,
            grants=self.grants,
            id=self.id,
            privilege_category=self.privilege_category,
            privilege_type=self.privilege_type,
            user_assessment_id=self.user_assessment_id,
            user_key=self.user_key)


def get_list_user_grants(depth_level: Optional[int] = None,
                         depth_level_greater_than_or_equal_to: Optional[int] = None,
                         depth_level_less_than: Optional[int] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetListUserGrantsFilterArgs']]] = None,
                         grant_key: Optional[str] = None,
                         grant_name: Optional[str] = None,
                         privilege_category: Optional[str] = None,
                         privilege_type: Optional[str] = None,
                         user_assessment_id: Optional[str] = None,
                         user_key: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListUserGrantsResult:
    """
    This data source provides the list of List User Grants in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of grants for a particular user in the specified user assessment. A user grant contains details such as the
    privilege name, type, category, and depth level. The depth level indicates how deep in the hierarchy of roles granted to
    roles a privilege grant is. The userKey in this operation is a system-generated identifier. Perform the operation ListUsers
    to get the userKey for a particular user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_list_user_grants = oci.DataSafe.get_list_user_grants(user_assessment_id=oci_data_safe_user_assessment["test_user_assessment"]["id"],
        user_key=var["list_user_grant_user_key"],
        depth_level=var["list_user_grant_depth_level"],
        depth_level_greater_than_or_equal_to=var["list_user_grant_depth_level_greater_than_or_equal_to"],
        depth_level_less_than=var["list_user_grant_depth_level_less_than"],
        grant_key=var["list_user_grant_grant_key"],
        grant_name=var["list_user_grant_grant_name"],
        privilege_category=var["list_user_grant_privilege_category"],
        privilege_type=var["list_user_grant_privilege_type"])
    ```


    :param int depth_level: A filter to return only items that match the specified user grant depth level.
    :param int depth_level_greater_than_or_equal_to: A filter to return only items that are at a level greater than or equal to the specified user grant depth level.
    :param int depth_level_less_than: A filter to return only items that are at a level less than the specified user grant depth level.
    :param str grant_key: A filter to return only items that match the specified user grant key.
    :param str grant_name: A filter to return only items that match the specified user grant name.
    :param str privilege_category: A filter to return only items that match the specified user privilege category.
    :param str privilege_type: A filter to return only items that match the specified privilege grant type.
    :param str user_assessment_id: The OCID of the user assessment.
    :param str user_key: The unique user key. This is a system-generated identifier. ListUsers gets the user key for a user.
    """
    __args__ = dict()
    __args__['depthLevel'] = depth_level
    __args__['depthLevelGreaterThanOrEqualTo'] = depth_level_greater_than_or_equal_to
    __args__['depthLevelLessThan'] = depth_level_less_than
    __args__['filters'] = filters
    __args__['grantKey'] = grant_key
    __args__['grantName'] = grant_name
    __args__['privilegeCategory'] = privilege_category
    __args__['privilegeType'] = privilege_type
    __args__['userAssessmentId'] = user_assessment_id
    __args__['userKey'] = user_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getListUserGrants:getListUserGrants', __args__, opts=opts, typ=GetListUserGrantsResult).value

    return AwaitableGetListUserGrantsResult(
        depth_level=pulumi.get(__ret__, 'depth_level'),
        depth_level_greater_than_or_equal_to=pulumi.get(__ret__, 'depth_level_greater_than_or_equal_to'),
        depth_level_less_than=pulumi.get(__ret__, 'depth_level_less_than'),
        filters=pulumi.get(__ret__, 'filters'),
        grant_key=pulumi.get(__ret__, 'grant_key'),
        grant_name=pulumi.get(__ret__, 'grant_name'),
        grants=pulumi.get(__ret__, 'grants'),
        id=pulumi.get(__ret__, 'id'),
        privilege_category=pulumi.get(__ret__, 'privilege_category'),
        privilege_type=pulumi.get(__ret__, 'privilege_type'),
        user_assessment_id=pulumi.get(__ret__, 'user_assessment_id'),
        user_key=pulumi.get(__ret__, 'user_key'))


@_utilities.lift_output_func(get_list_user_grants)
def get_list_user_grants_output(depth_level: Optional[pulumi.Input[Optional[int]]] = None,
                                depth_level_greater_than_or_equal_to: Optional[pulumi.Input[Optional[int]]] = None,
                                depth_level_less_than: Optional[pulumi.Input[Optional[int]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetListUserGrantsFilterArgs']]]]] = None,
                                grant_key: Optional[pulumi.Input[Optional[str]]] = None,
                                grant_name: Optional[pulumi.Input[Optional[str]]] = None,
                                privilege_category: Optional[pulumi.Input[Optional[str]]] = None,
                                privilege_type: Optional[pulumi.Input[Optional[str]]] = None,
                                user_assessment_id: Optional[pulumi.Input[str]] = None,
                                user_key: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetListUserGrantsResult]:
    """
    This data source provides the list of List User Grants in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of grants for a particular user in the specified user assessment. A user grant contains details such as the
    privilege name, type, category, and depth level. The depth level indicates how deep in the hierarchy of roles granted to
    roles a privilege grant is. The userKey in this operation is a system-generated identifier. Perform the operation ListUsers
    to get the userKey for a particular user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_list_user_grants = oci.DataSafe.get_list_user_grants(user_assessment_id=oci_data_safe_user_assessment["test_user_assessment"]["id"],
        user_key=var["list_user_grant_user_key"],
        depth_level=var["list_user_grant_depth_level"],
        depth_level_greater_than_or_equal_to=var["list_user_grant_depth_level_greater_than_or_equal_to"],
        depth_level_less_than=var["list_user_grant_depth_level_less_than"],
        grant_key=var["list_user_grant_grant_key"],
        grant_name=var["list_user_grant_grant_name"],
        privilege_category=var["list_user_grant_privilege_category"],
        privilege_type=var["list_user_grant_privilege_type"])
    ```


    :param int depth_level: A filter to return only items that match the specified user grant depth level.
    :param int depth_level_greater_than_or_equal_to: A filter to return only items that are at a level greater than or equal to the specified user grant depth level.
    :param int depth_level_less_than: A filter to return only items that are at a level less than the specified user grant depth level.
    :param str grant_key: A filter to return only items that match the specified user grant key.
    :param str grant_name: A filter to return only items that match the specified user grant name.
    :param str privilege_category: A filter to return only items that match the specified user privilege category.
    :param str privilege_type: A filter to return only items that match the specified privilege grant type.
    :param str user_assessment_id: The OCID of the user assessment.
    :param str user_key: The unique user key. This is a system-generated identifier. ListUsers gets the user key for a user.
    """
    ...
