# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBuildPipelineStageResult',
    'AwaitableGetBuildPipelineStageResult',
    'get_build_pipeline_stage',
    'get_build_pipeline_stage_output',
]

@pulumi.output_type
class GetBuildPipelineStageResult:
    """
    A collection of values returned by getBuildPipelineStage.
    """
    def __init__(__self__, build_pipeline_id=None, build_pipeline_stage_id=None, build_pipeline_stage_predecessor_collections=None, build_pipeline_stage_type=None, build_runner_shape_configs=None, build_source_collections=None, build_spec_file=None, compartment_id=None, defined_tags=None, deliver_artifact_collections=None, deploy_pipeline_id=None, description=None, display_name=None, freeform_tags=None, id=None, image=None, is_pass_all_parameters_enabled=None, lifecycle_details=None, primary_build_source=None, private_access_configs=None, project_id=None, stage_execution_timeout_in_seconds=None, state=None, system_tags=None, time_created=None, time_updated=None, wait_criterias=None):
        if build_pipeline_id and not isinstance(build_pipeline_id, str):
            raise TypeError("Expected argument 'build_pipeline_id' to be a str")
        pulumi.set(__self__, "build_pipeline_id", build_pipeline_id)
        if build_pipeline_stage_id and not isinstance(build_pipeline_stage_id, str):
            raise TypeError("Expected argument 'build_pipeline_stage_id' to be a str")
        pulumi.set(__self__, "build_pipeline_stage_id", build_pipeline_stage_id)
        if build_pipeline_stage_predecessor_collections and not isinstance(build_pipeline_stage_predecessor_collections, list):
            raise TypeError("Expected argument 'build_pipeline_stage_predecessor_collections' to be a list")
        pulumi.set(__self__, "build_pipeline_stage_predecessor_collections", build_pipeline_stage_predecessor_collections)
        if build_pipeline_stage_type and not isinstance(build_pipeline_stage_type, str):
            raise TypeError("Expected argument 'build_pipeline_stage_type' to be a str")
        pulumi.set(__self__, "build_pipeline_stage_type", build_pipeline_stage_type)
        if build_runner_shape_configs and not isinstance(build_runner_shape_configs, list):
            raise TypeError("Expected argument 'build_runner_shape_configs' to be a list")
        pulumi.set(__self__, "build_runner_shape_configs", build_runner_shape_configs)
        if build_source_collections and not isinstance(build_source_collections, list):
            raise TypeError("Expected argument 'build_source_collections' to be a list")
        pulumi.set(__self__, "build_source_collections", build_source_collections)
        if build_spec_file and not isinstance(build_spec_file, str):
            raise TypeError("Expected argument 'build_spec_file' to be a str")
        pulumi.set(__self__, "build_spec_file", build_spec_file)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deliver_artifact_collections and not isinstance(deliver_artifact_collections, list):
            raise TypeError("Expected argument 'deliver_artifact_collections' to be a list")
        pulumi.set(__self__, "deliver_artifact_collections", deliver_artifact_collections)
        if deploy_pipeline_id and not isinstance(deploy_pipeline_id, str):
            raise TypeError("Expected argument 'deploy_pipeline_id' to be a str")
        pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image and not isinstance(image, str):
            raise TypeError("Expected argument 'image' to be a str")
        pulumi.set(__self__, "image", image)
        if is_pass_all_parameters_enabled and not isinstance(is_pass_all_parameters_enabled, bool):
            raise TypeError("Expected argument 'is_pass_all_parameters_enabled' to be a bool")
        pulumi.set(__self__, "is_pass_all_parameters_enabled", is_pass_all_parameters_enabled)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if primary_build_source and not isinstance(primary_build_source, str):
            raise TypeError("Expected argument 'primary_build_source' to be a str")
        pulumi.set(__self__, "primary_build_source", primary_build_source)
        if private_access_configs and not isinstance(private_access_configs, list):
            raise TypeError("Expected argument 'private_access_configs' to be a list")
        pulumi.set(__self__, "private_access_configs", private_access_configs)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if stage_execution_timeout_in_seconds and not isinstance(stage_execution_timeout_in_seconds, int):
            raise TypeError("Expected argument 'stage_execution_timeout_in_seconds' to be a int")
        pulumi.set(__self__, "stage_execution_timeout_in_seconds", stage_execution_timeout_in_seconds)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if wait_criterias and not isinstance(wait_criterias, list):
            raise TypeError("Expected argument 'wait_criterias' to be a list")
        pulumi.set(__self__, "wait_criterias", wait_criterias)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> str:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @property
    @pulumi.getter(name="buildPipelineStageId")
    def build_pipeline_stage_id(self) -> str:
        return pulumi.get(self, "build_pipeline_stage_id")

    @property
    @pulumi.getter(name="buildPipelineStagePredecessorCollections")
    def build_pipeline_stage_predecessor_collections(self) -> Sequence['outputs.GetBuildPipelineStageBuildPipelineStagePredecessorCollectionResult']:
        """
        The collection containing the predecessors of a stage.
        """
        return pulumi.get(self, "build_pipeline_stage_predecessor_collections")

    @property
    @pulumi.getter(name="buildPipelineStageType")
    def build_pipeline_stage_type(self) -> str:
        """
        Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        """
        return pulumi.get(self, "build_pipeline_stage_type")

    @property
    @pulumi.getter(name="buildRunnerShapeConfigs")
    def build_runner_shape_configs(self) -> Sequence['outputs.GetBuildPipelineStageBuildRunnerShapeConfigResult']:
        """
        The information about build runner.
        """
        return pulumi.get(self, "build_runner_shape_configs")

    @property
    @pulumi.getter(name="buildSourceCollections")
    def build_source_collections(self) -> Sequence['outputs.GetBuildPipelineStageBuildSourceCollectionResult']:
        """
        Collection of build sources.
        """
        return pulumi.get(self, "build_source_collections")

    @property
    @pulumi.getter(name="buildSpecFile")
    def build_spec_file(self) -> str:
        """
        The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        """
        return pulumi.get(self, "build_spec_file")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment where the pipeline is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deliverArtifactCollections")
    def deliver_artifact_collections(self) -> Sequence['outputs.GetBuildPipelineStageDeliverArtifactCollectionResult']:
        """
        Specifies an array of artifacts that need to be pushed to the artifactory stores.
        """
        return pulumi.get(self, "deliver_artifact_collections")

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> str:
        """
        A target deployment pipeline OCID that will run in this stage.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional description about the build stage.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Image name for the build environment.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="isPassAllParametersEnabled")
    def is_pass_all_parameters_enabled(self) -> bool:
        """
        A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        """
        return pulumi.get(self, "is_pass_all_parameters_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="primaryBuildSource")
    def primary_build_source(self) -> str:
        """
        Name of the build source where the build_spec.yml file is located. If not specified, then the first entry in the build source collection is chosen as primary build source.
        """
        return pulumi.get(self, "primary_build_source")

    @property
    @pulumi.getter(name="privateAccessConfigs")
    def private_access_configs(self) -> Sequence['outputs.GetBuildPipelineStagePrivateAccessConfigResult']:
        """
        Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        """
        return pulumi.get(self, "private_access_configs")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="stageExecutionTimeoutInSeconds")
    def stage_execution_timeout_in_seconds(self) -> int:
        """
        Timeout for the build stage execution. Specify value in seconds.
        """
        return pulumi.get(self, "stage_execution_timeout_in_seconds")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the stage.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="waitCriterias")
    def wait_criterias(self) -> Sequence['outputs.GetBuildPipelineStageWaitCriteriaResult']:
        """
        Specifies wait criteria for the Wait stage.
        """
        return pulumi.get(self, "wait_criterias")


class AwaitableGetBuildPipelineStageResult(GetBuildPipelineStageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBuildPipelineStageResult(
            build_pipeline_id=self.build_pipeline_id,
            build_pipeline_stage_id=self.build_pipeline_stage_id,
            build_pipeline_stage_predecessor_collections=self.build_pipeline_stage_predecessor_collections,
            build_pipeline_stage_type=self.build_pipeline_stage_type,
            build_runner_shape_configs=self.build_runner_shape_configs,
            build_source_collections=self.build_source_collections,
            build_spec_file=self.build_spec_file,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            deliver_artifact_collections=self.deliver_artifact_collections,
            deploy_pipeline_id=self.deploy_pipeline_id,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image=self.image,
            is_pass_all_parameters_enabled=self.is_pass_all_parameters_enabled,
            lifecycle_details=self.lifecycle_details,
            primary_build_source=self.primary_build_source,
            private_access_configs=self.private_access_configs,
            project_id=self.project_id,
            stage_execution_timeout_in_seconds=self.stage_execution_timeout_in_seconds,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            wait_criterias=self.wait_criterias)


def get_build_pipeline_stage(build_pipeline_stage_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBuildPipelineStageResult:
    """
    This data source provides details about a specific Build Pipeline Stage resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a stage based on the stage ID provided in the request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_build_pipeline_stage = oci.DevOps.get_build_pipeline_stage(build_pipeline_stage_id=oci_devops_build_pipeline_stage["test_build_pipeline_stage"]["id"])
    ```


    :param str build_pipeline_stage_id: Unique stage identifier.
    """
    __args__ = dict()
    __args__['buildPipelineStageId'] = build_pipeline_stage_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getBuildPipelineStage:getBuildPipelineStage', __args__, opts=opts, typ=GetBuildPipelineStageResult).value

    return AwaitableGetBuildPipelineStageResult(
        build_pipeline_id=pulumi.get(__ret__, 'build_pipeline_id'),
        build_pipeline_stage_id=pulumi.get(__ret__, 'build_pipeline_stage_id'),
        build_pipeline_stage_predecessor_collections=pulumi.get(__ret__, 'build_pipeline_stage_predecessor_collections'),
        build_pipeline_stage_type=pulumi.get(__ret__, 'build_pipeline_stage_type'),
        build_runner_shape_configs=pulumi.get(__ret__, 'build_runner_shape_configs'),
        build_source_collections=pulumi.get(__ret__, 'build_source_collections'),
        build_spec_file=pulumi.get(__ret__, 'build_spec_file'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deliver_artifact_collections=pulumi.get(__ret__, 'deliver_artifact_collections'),
        deploy_pipeline_id=pulumi.get(__ret__, 'deploy_pipeline_id'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image=pulumi.get(__ret__, 'image'),
        is_pass_all_parameters_enabled=pulumi.get(__ret__, 'is_pass_all_parameters_enabled'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        primary_build_source=pulumi.get(__ret__, 'primary_build_source'),
        private_access_configs=pulumi.get(__ret__, 'private_access_configs'),
        project_id=pulumi.get(__ret__, 'project_id'),
        stage_execution_timeout_in_seconds=pulumi.get(__ret__, 'stage_execution_timeout_in_seconds'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        wait_criterias=pulumi.get(__ret__, 'wait_criterias'))


@_utilities.lift_output_func(get_build_pipeline_stage)
def get_build_pipeline_stage_output(build_pipeline_stage_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBuildPipelineStageResult]:
    """
    This data source provides details about a specific Build Pipeline Stage resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a stage based on the stage ID provided in the request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_build_pipeline_stage = oci.DevOps.get_build_pipeline_stage(build_pipeline_stage_id=oci_devops_build_pipeline_stage["test_build_pipeline_stage"]["id"])
    ```


    :param str build_pipeline_stage_id: Unique stage identifier.
    """
    ...
