# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLogAnalyticsObjectCollectionRulesResult',
    'AwaitableGetLogAnalyticsObjectCollectionRulesResult',
    'get_log_analytics_object_collection_rules',
    'get_log_analytics_object_collection_rules_output',
]

@pulumi.output_type
class GetLogAnalyticsObjectCollectionRulesResult:
    """
    A collection of values returned by getLogAnalyticsObjectCollectionRules.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, log_analytics_object_collection_rule_collections=None, name=None, namespace=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_analytics_object_collection_rule_collections and not isinstance(log_analytics_object_collection_rule_collections, list):
            raise TypeError("Expected argument 'log_analytics_object_collection_rule_collections' to be a list")
        pulumi.set(__self__, "log_analytics_object_collection_rule_collections", log_analytics_object_collection_rule_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLogAnalyticsObjectCollectionRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logAnalyticsObjectCollectionRuleCollections")
    def log_analytics_object_collection_rule_collections(self) -> Sequence['outputs.GetLogAnalyticsObjectCollectionRulesLogAnalyticsObjectCollectionRuleCollectionResult']:
        """
        The list of log_analytics_object_collection_rule_collection.
        """
        return pulumi.get(self, "log_analytics_object_collection_rule_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A unique name to the rule. The name must be unique, within the tenancy, and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the rule.
        """
        return pulumi.get(self, "state")


class AwaitableGetLogAnalyticsObjectCollectionRulesResult(GetLogAnalyticsObjectCollectionRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsObjectCollectionRulesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            log_analytics_object_collection_rule_collections=self.log_analytics_object_collection_rule_collections,
            name=self.name,
            namespace=self.namespace,
            state=self.state)


def get_log_analytics_object_collection_rules(compartment_id: Optional[str] = None,
                                              filters: Optional[Sequence[pulumi.InputType['GetLogAnalyticsObjectCollectionRulesFilterArgs']]] = None,
                                              name: Optional[str] = None,
                                              namespace: Optional[str] = None,
                                              state: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsObjectCollectionRulesResult:
    """
    This data source provides the list of Log Analytics Object Collection Rules in Oracle Cloud Infrastructure Log Analytics service.

    Gets list of configuration details of Object Storage based collection rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_object_collection_rules = oci.LogAnalytics.get_log_analytics_object_collection_rules(compartment_id=var["compartment_id"],
        namespace=var["log_analytics_object_collection_rule_namespace"],
        name=var["log_analytics_object_collection_rule_name"],
        state=var["log_analytics_object_collection_rule_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str name: A filter to return rules only matching with this name.
    :param str namespace: The Logging Analytics namespace used for the request.
    :param str state: Lifecycle state filter.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsObjectCollectionRules:getLogAnalyticsObjectCollectionRules', __args__, opts=opts, typ=GetLogAnalyticsObjectCollectionRulesResult).value

    return AwaitableGetLogAnalyticsObjectCollectionRulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        log_analytics_object_collection_rule_collections=pulumi.get(__ret__, 'log_analytics_object_collection_rule_collections'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_log_analytics_object_collection_rules)
def get_log_analytics_object_collection_rules_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetLogAnalyticsObjectCollectionRulesFilterArgs']]]]] = None,
                                                     name: Optional[pulumi.Input[Optional[str]]] = None,
                                                     namespace: Optional[pulumi.Input[str]] = None,
                                                     state: Optional[pulumi.Input[Optional[str]]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogAnalyticsObjectCollectionRulesResult]:
    """
    This data source provides the list of Log Analytics Object Collection Rules in Oracle Cloud Infrastructure Log Analytics service.

    Gets list of configuration details of Object Storage based collection rules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_object_collection_rules = oci.LogAnalytics.get_log_analytics_object_collection_rules(compartment_id=var["compartment_id"],
        namespace=var["log_analytics_object_collection_rule_namespace"],
        name=var["log_analytics_object_collection_rule_name"],
        state=var["log_analytics_object_collection_rule_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str name: A filter to return rules only matching with this name.
    :param str namespace: The Logging Analytics namespace used for the request.
    :param str state: Lifecycle state filter.
    """
    ...
