# coding: utf-8

"""
    OurSky

    Fully merged Converged Node Platform API documentation

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictStr

from typing import List, Optional

from ourskyai_node_platform_api.models.empty_success import EmptySuccess
from ourskyai_node_platform_api.models.v1_get_component_status_response import V1GetComponentStatusResponse
from ourskyai_node_platform_api.models.v1_get_storage_status_response import V1GetStorageStatusResponse
from ourskyai_node_platform_api.models.v1_mount_go_to_coordinates_request import V1MountGoToCoordinatesRequest
from ourskyai_node_platform_api.models.v1_network_interface import V1NetworkInterface
from ourskyai_node_platform_api.models.v1_post_alpaca_connection_event_request import V1PostAlpacaConnectionEventRequest
from ourskyai_node_platform_api.models.v1_update_network_interface_request import V1UpdateNetworkInterfaceRequest

from ourskyai_node_platform_api.api_client import ApiClient
from ourskyai_node_platform_api.api_response import ApiResponse
from ourskyai_node_platform_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def v1_get_component_status(self, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> V1GetComponentStatusResponse:  # noqa: E501
        """v1_get_component_status  # noqa: E501

        Get Component Status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_get_component_status(lineage_id, async_req=True)
        >>> result = thread.get()

        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: V1GetComponentStatusResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the v1_get_component_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.v1_get_component_status_with_http_info(lineage_id, **kwargs)  # noqa: E501

    @validate_arguments
    def v1_get_component_status_with_http_info(self, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """v1_get_component_status  # noqa: E501

        Get Component Status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_get_component_status_with_http_info(lineage_id, async_req=True)
        >>> result = thread.get()

        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(V1GetComponentStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lineage_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_get_component_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('lineage_id') is not None:  # noqa: E501
            _query_params.append(('lineageId', _params['lineage_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Roles', 'BearerToken']  # noqa: E501

        _response_types_map = {
            '200': "V1GetComponentStatusResponse",
        }

        return self.api_client.call_api(
            '/v1/status/components', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def v1_get_network_configuration(self, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> List[V1NetworkInterface]:  # noqa: E501
        """v1_get_network_configuration  # noqa: E501

        Gets the list of interfaces and their configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_get_network_configuration(lineage_id, async_req=True)
        >>> result = thread.get()

        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[V1NetworkInterface]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the v1_get_network_configuration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.v1_get_network_configuration_with_http_info(lineage_id, **kwargs)  # noqa: E501

    @validate_arguments
    def v1_get_network_configuration_with_http_info(self, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """v1_get_network_configuration  # noqa: E501

        Gets the list of interfaces and their configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_get_network_configuration_with_http_info(lineage_id, async_req=True)
        >>> result = thread.get()

        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[V1NetworkInterface], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lineage_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_get_network_configuration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('lineage_id') is not None:  # noqa: E501
            _query_params.append(('lineageId', _params['lineage_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Roles', 'BearerToken']  # noqa: E501

        _response_types_map = {
            '200': "List[V1NetworkInterface]",
        }

        return self.api_client.call_api(
            '/v1/network-settings', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def v1_get_storage_status(self, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> V1GetStorageStatusResponse:  # noqa: E501
        """v1_get_storage_status  # noqa: E501

        Get Storage Status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_get_storage_status(lineage_id, async_req=True)
        >>> result = thread.get()

        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: V1GetStorageStatusResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the v1_get_storage_status_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.v1_get_storage_status_with_http_info(lineage_id, **kwargs)  # noqa: E501

    @validate_arguments
    def v1_get_storage_status_with_http_info(self, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """v1_get_storage_status  # noqa: E501

        Get Storage Status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_get_storage_status_with_http_info(lineage_id, async_req=True)
        >>> result = thread.get()

        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(V1GetStorageStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'lineage_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_get_storage_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('lineage_id') is not None:  # noqa: E501
            _query_params.append(('lineageId', _params['lineage_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Roles', 'BearerToken']  # noqa: E501

        _response_types_map = {
            '200': "V1GetStorageStatusResponse",
        }

        return self.api_client.call_api(
            '/v1/status/storage', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def v1_mount_go_to_coordinates(self, v1_mount_go_to_coordinates_request : V1MountGoToCoordinatesRequest, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> EmptySuccess:  # noqa: E501
        """v1_mount_go_to_coordinates  # noqa: E501

        Instruct the connected mount to move to coordinates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_mount_go_to_coordinates(v1_mount_go_to_coordinates_request, lineage_id, async_req=True)
        >>> result = thread.get()

        :param v1_mount_go_to_coordinates_request: (required)
        :type v1_mount_go_to_coordinates_request: V1MountGoToCoordinatesRequest
        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EmptySuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the v1_mount_go_to_coordinates_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.v1_mount_go_to_coordinates_with_http_info(v1_mount_go_to_coordinates_request, lineage_id, **kwargs)  # noqa: E501

    @validate_arguments
    def v1_mount_go_to_coordinates_with_http_info(self, v1_mount_go_to_coordinates_request : V1MountGoToCoordinatesRequest, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """v1_mount_go_to_coordinates  # noqa: E501

        Instruct the connected mount to move to coordinates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_mount_go_to_coordinates_with_http_info(v1_mount_go_to_coordinates_request, lineage_id, async_req=True)
        >>> result = thread.get()

        :param v1_mount_go_to_coordinates_request: (required)
        :type v1_mount_go_to_coordinates_request: V1MountGoToCoordinatesRequest
        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EmptySuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'v1_mount_go_to_coordinates_request',
            'lineage_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_mount_go_to_coordinates" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('lineage_id') is not None:  # noqa: E501
            _query_params.append(('lineageId', _params['lineage_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['v1_mount_go_to_coordinates_request'] is not None:
            _body_params = _params['v1_mount_go_to_coordinates_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Roles', 'BearerToken']  # noqa: E501

        _response_types_map = {
            '200': "EmptySuccess",
        }

        return self.api_client.call_api(
            '/v1/mount/go-to-coordinates', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def v1_post_alpaca_connection_event(self, v1_post_alpaca_connection_event_request : V1PostAlpacaConnectionEventRequest, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> EmptySuccess:  # noqa: E501
        """v1_post_alpaca_connection_event  # noqa: E501

        Post an Alpaca connection event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_post_alpaca_connection_event(v1_post_alpaca_connection_event_request, lineage_id, async_req=True)
        >>> result = thread.get()

        :param v1_post_alpaca_connection_event_request: (required)
        :type v1_post_alpaca_connection_event_request: V1PostAlpacaConnectionEventRequest
        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EmptySuccess
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the v1_post_alpaca_connection_event_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.v1_post_alpaca_connection_event_with_http_info(v1_post_alpaca_connection_event_request, lineage_id, **kwargs)  # noqa: E501

    @validate_arguments
    def v1_post_alpaca_connection_event_with_http_info(self, v1_post_alpaca_connection_event_request : V1PostAlpacaConnectionEventRequest, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """v1_post_alpaca_connection_event  # noqa: E501

        Post an Alpaca connection event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_post_alpaca_connection_event_with_http_info(v1_post_alpaca_connection_event_request, lineage_id, async_req=True)
        >>> result = thread.get()

        :param v1_post_alpaca_connection_event_request: (required)
        :type v1_post_alpaca_connection_event_request: V1PostAlpacaConnectionEventRequest
        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EmptySuccess, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'v1_post_alpaca_connection_event_request',
            'lineage_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_post_alpaca_connection_event" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('lineage_id') is not None:  # noqa: E501
            _query_params.append(('lineageId', _params['lineage_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['v1_post_alpaca_connection_event_request'] is not None:
            _body_params = _params['v1_post_alpaca_connection_event_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Roles', 'BearerToken']  # noqa: E501

        _response_types_map = {
            '200': "EmptySuccess",
        }

        return self.api_client.call_api(
            '/v1/events/alpacaConnectionEvent', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def v1_update_network_configuration(self, v1_update_network_interface_request : V1UpdateNetworkInterfaceRequest, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> List[V1NetworkInterface]:  # noqa: E501
        """v1_update_network_configuration  # noqa: E501

        Update the network configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_update_network_configuration(v1_update_network_interface_request, lineage_id, async_req=True)
        >>> result = thread.get()

        :param v1_update_network_interface_request: (required)
        :type v1_update_network_interface_request: V1UpdateNetworkInterfaceRequest
        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[V1NetworkInterface]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the v1_update_network_configuration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.v1_update_network_configuration_with_http_info(v1_update_network_interface_request, lineage_id, **kwargs)  # noqa: E501

    @validate_arguments
    def v1_update_network_configuration_with_http_info(self, v1_update_network_interface_request : V1UpdateNetworkInterfaceRequest, lineage_id : Annotated[Optional[StrictStr], Field(description="Optional lineage ID for tracking purposes")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """v1_update_network_configuration  # noqa: E501

        Update the network configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.v1_update_network_configuration_with_http_info(v1_update_network_interface_request, lineage_id, async_req=True)
        >>> result = thread.get()

        :param v1_update_network_interface_request: (required)
        :type v1_update_network_interface_request: V1UpdateNetworkInterfaceRequest
        :param lineage_id: Optional lineage ID for tracking purposes
        :type lineage_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[V1NetworkInterface], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'v1_update_network_interface_request',
            'lineage_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_update_network_configuration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('lineage_id') is not None:  # noqa: E501
            _query_params.append(('lineageId', _params['lineage_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['v1_update_network_interface_request'] is not None:
            _body_params = _params['v1_update_network_interface_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Roles', 'BearerToken']  # noqa: E501

        _response_types_map = {
            '200': "List[V1NetworkInterface]",
        }

        return self.api_client.call_api(
            '/v1/network-settings', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
