# coding: utf-8

"""
    OurSky

    Fully merged Converged Node Platform API documentation

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class CameraStatus(BaseModel):
    """
    CameraStatus
    """
    id: StrictStr = Field(...)
    connected: StrictBool = Field(...)
    name: StrictStr = Field(...)
    pixel_size_microns: Union[StrictFloat, StrictInt] = Field(..., alias="pixelSizeMicrons")
    sensor_width: Union[StrictFloat, StrictInt] = Field(..., alias="sensorWidth")
    sensor_height: Union[StrictFloat, StrictInt] = Field(..., alias="sensorHeight")
    has_gps: StrictBool = Field(..., alias="hasGps")
    temperature: Union[StrictFloat, StrictInt] = Field(...)
    __properties = ["id", "connected", "name", "pixelSizeMicrons", "sensorWidth", "sensorHeight", "hasGps", "temperature"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CameraStatus:
        """Create an instance of CameraStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CameraStatus:
        """Create an instance of CameraStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CameraStatus.parse_obj(obj)

        _obj = CameraStatus.parse_obj({
            "id": obj.get("id"),
            "connected": obj.get("connected"),
            "name": obj.get("name"),
            "pixel_size_microns": obj.get("pixelSizeMicrons"),
            "sensor_width": obj.get("sensorWidth"),
            "sensor_height": obj.get("sensorHeight"),
            "has_gps": obj.get("hasGps"),
            "temperature": obj.get("temperature")
        })
        return _obj


