# coding: utf-8

"""
    OurSky

    Fully merged Converged Node Platform API documentation

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from ourskyai_node_platform_api.models.focuser_position import FocuserPosition

class FocuserStatus(BaseModel):
    """
    FocuserStatus
    """
    connected: StrictBool = Field(...)
    moving: StrictBool = Field(...)
    position: Optional[FocuserPosition] = None
    __properties = ["connected", "moving", "position"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FocuserStatus:
        """Create an instance of FocuserStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FocuserStatus:
        """Create an instance of FocuserStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FocuserStatus.parse_obj(obj)

        _obj = FocuserStatus.parse_obj({
            "connected": obj.get("connected"),
            "moving": obj.get("moving"),
            "position": FocuserPosition.from_dict(obj.get("position")) if obj.get("position") is not None else None
        })
        return _obj


