# coding: utf-8

"""
    OurSky

    Fully merged Converged Node Platform API documentation

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt

class MountStatus(BaseModel):
    """
    MountStatus
    """
    connected: StrictBool = Field(...)
    latitude: Union[StrictFloat, StrictInt] = Field(...)
    longitude: Union[StrictFloat, StrictInt] = Field(...)
    height: Union[StrictFloat, StrictInt] = Field(...)
    slewing: StrictBool = Field(...)
    tracking: StrictBool = Field(...)
    geometry: StrictInt = Field(...)
    ra: Union[StrictFloat, StrictInt] = Field(...)
    dec: Union[StrictFloat, StrictInt] = Field(...)
    altitude: Union[StrictFloat, StrictInt] = Field(...)
    azimuth: Union[StrictFloat, StrictInt] = Field(...)
    __properties = ["connected", "latitude", "longitude", "height", "slewing", "tracking", "geometry", "ra", "dec", "altitude", "azimuth"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MountStatus:
        """Create an instance of MountStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MountStatus:
        """Create an instance of MountStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MountStatus.parse_obj(obj)

        _obj = MountStatus.parse_obj({
            "connected": obj.get("connected"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "height": obj.get("height"),
            "slewing": obj.get("slewing"),
            "tracking": obj.get("tracking"),
            "geometry": obj.get("geometry"),
            "ra": obj.get("ra"),
            "dec": obj.get("dec"),
            "altitude": obj.get("altitude"),
            "azimuth": obj.get("azimuth")
        })
        return _obj


