# coding: utf-8

"""
    OurSky

    Fully merged Converged Node Platform API documentation

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from ourskyai_node_platform_api.models.camera_status import CameraStatus
from ourskyai_node_platform_api.models.focuser_status import FocuserStatus
from ourskyai_node_platform_api.models.mount_status import MountStatus
from ourskyai_node_platform_api.models.optical_tube_status import OpticalTubeStatus
from ourskyai_node_platform_api.models.relays_status import RelaysStatus
from ourskyai_node_platform_api.models.roof_status import RoofStatus
from ourskyai_node_platform_api.models.v1_filter_wheel_status import V1FilterWheelStatus
from ourskyai_node_platform_api.models.v1_safety_status import V1SafetyStatus
from ourskyai_node_platform_api.models.weather_station_status import WeatherStationStatus

class V1GetComponentStatusResponse(BaseModel):
    """
    Component Status Response  # noqa: E501
    """
    camera_statuses: conlist(CameraStatus) = Field(..., alias="cameraStatuses")
    mount_status: MountStatus = Field(..., alias="mountStatus")
    focuser_status: FocuserStatus = Field(..., alias="focuserStatus")
    optical_tube_status: OpticalTubeStatus = Field(..., alias="opticalTubeStatus")
    weather_station_status: WeatherStationStatus = Field(..., alias="weatherStationStatus")
    relays_status: RelaysStatus = Field(..., alias="relaysStatus")
    roof_status: RoofStatus = Field(..., alias="roofStatus")
    safety_status: V1SafetyStatus = Field(..., alias="safetyStatus")
    filter_wheel_status: V1FilterWheelStatus = Field(..., alias="filterWheelStatus")
    __properties = ["cameraStatuses", "mountStatus", "focuserStatus", "opticalTubeStatus", "weatherStationStatus", "relaysStatus", "roofStatus", "safetyStatus", "filterWheelStatus"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> V1GetComponentStatusResponse:
        """Create an instance of V1GetComponentStatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in camera_statuses (list)
        _items = []
        if self.camera_statuses:
            for _item in self.camera_statuses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cameraStatuses'] = _items
        # override the default output from pydantic by calling `to_dict()` of mount_status
        if self.mount_status:
            _dict['mountStatus'] = self.mount_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of focuser_status
        if self.focuser_status:
            _dict['focuserStatus'] = self.focuser_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of optical_tube_status
        if self.optical_tube_status:
            _dict['opticalTubeStatus'] = self.optical_tube_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of weather_station_status
        if self.weather_station_status:
            _dict['weatherStationStatus'] = self.weather_station_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relays_status
        if self.relays_status:
            _dict['relaysStatus'] = self.relays_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of roof_status
        if self.roof_status:
            _dict['roofStatus'] = self.roof_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of safety_status
        if self.safety_status:
            _dict['safetyStatus'] = self.safety_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filter_wheel_status
        if self.filter_wheel_status:
            _dict['filterWheelStatus'] = self.filter_wheel_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> V1GetComponentStatusResponse:
        """Create an instance of V1GetComponentStatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return V1GetComponentStatusResponse.parse_obj(obj)

        _obj = V1GetComponentStatusResponse.parse_obj({
            "camera_statuses": [CameraStatus.from_dict(_item) for _item in obj.get("cameraStatuses")] if obj.get("cameraStatuses") is not None else None,
            "mount_status": MountStatus.from_dict(obj.get("mountStatus")) if obj.get("mountStatus") is not None else None,
            "focuser_status": FocuserStatus.from_dict(obj.get("focuserStatus")) if obj.get("focuserStatus") is not None else None,
            "optical_tube_status": OpticalTubeStatus.from_dict(obj.get("opticalTubeStatus")) if obj.get("opticalTubeStatus") is not None else None,
            "weather_station_status": WeatherStationStatus.from_dict(obj.get("weatherStationStatus")) if obj.get("weatherStationStatus") is not None else None,
            "relays_status": RelaysStatus.from_dict(obj.get("relaysStatus")) if obj.get("relaysStatus") is not None else None,
            "roof_status": RoofStatus.from_dict(obj.get("roofStatus")) if obj.get("roofStatus") is not None else None,
            "safety_status": V1SafetyStatus.from_dict(obj.get("safetyStatus")) if obj.get("safetyStatus") is not None else None,
            "filter_wheel_status": V1FilterWheelStatus.from_dict(obj.get("filterWheelStatus")) if obj.get("filterWheelStatus") is not None else None
        })
        return _obj


