# coding: utf-8

"""
    OurSky

    Fully merged Converged Node Platform API documentation

    The version of the OpenAPI document: 1.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist
from ourskyai_node_platform_api.models.v1_interface_info import V1InterfaceInfo

class V1UpdateNetworkInterfaceRequest(BaseModel):
    """
    V1UpdateNetworkInterfaceRequest
    """
    interface: StrictStr = Field(..., description="Interface name")
    info: conlist(V1InterfaceInfo) = Field(...)
    __properties = ["interface", "info"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> V1UpdateNetworkInterfaceRequest:
        """Create an instance of V1UpdateNetworkInterfaceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in info (list)
        _items = []
        if self.info:
            for _item in self.info:
                if _item:
                    _items.append(_item.to_dict())
            _dict['info'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> V1UpdateNetworkInterfaceRequest:
        """Create an instance of V1UpdateNetworkInterfaceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return V1UpdateNetworkInterfaceRequest.parse_obj(obj)

        _obj = V1UpdateNetworkInterfaceRequest.parse_obj({
            "interface": obj.get("interface"),
            "info": [V1InterfaceInfo.from_dict(_item) for _item in obj.get("info")] if obj.get("info") is not None else None
        })
        return _obj


