from src.mb_cruise_migration.db.cruise_connection import CruiseConnection
from src.mb_cruise_migration.logging.migration_log import MigrationLog
from src.mb_cruise_migration.logging.migration_report import MigrationReport
from src.mb_cruise_migration.migration_properties import MigrationProperties


class Cleaner(object):
    def __init__(self, config_file):
        MigrationProperties(config_file)
        MigrationLog()
        MigrationReport()
        self.cruise = CruiseConnection()

    def delete_multibeam_data_from_cruise(self):
        self.__delete_file_shapes()
        self.__delete_file_access_paths()
        self.__delete_file_parameters()
        self.__delete_files()
        self.__delete_dataset_shapes()
        self.__delete_dataset_surveys()
        self.__delete_dataset_projects()
        self.__delete_dataset_sources()
        self.__delete_dataset_scientists()
        self.__delete_dataset_platforms()
        self.__delete_dataset_instruments()
        self.__delete_dataset_parameters()
        self.__delete_datasets()
        self.__delete_unreferenced_shapes()
        self.__delete_unreferenced_access_paths()

    def __delete_file_shapes(self):
        command = "DELETE FROM CRUISE.FILE_SHAPES WHERE FILE_ID IN (SELECT FILE_ID FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')))"
        self.cruise.execute(command)

    def __delete_file_access_paths(self):
        command = "DELETE FROM CRUISE.FILE_ACCESS_PATHS WHERE FILE_ID IN (SELECT FILE_ID FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')))"
        self.cruise.execute(command)

    def __delete_file_parameters(self):
        command = "DELETE FROM CRUISE.FILE_PARAMETERS WHERE FILE_ID IN (SELECT FILE_ID FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')))"
        self.cruise.execute(command)

    def __delete_files(self):
        command = "DELETE FROM CRUISE.FILES all_files WHERE all_files.DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_shapes(self):
        command = "DELETE FROM CRUISE.DATASET_SHAPES WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_surveys(self):
        command = "DELETE FROM CRUISE.DATASET_SURVEYS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_projects(self):
        command = "DELETE FROM CRUISE.DATASET_PROJECTS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_sources(self):
        command = "DELETE FROM CRUISE.SOURCES WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_scientists(self):
        command = "DELETE FROM CRUISE.SCIENTISTS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_platforms(self):
        command = "DELETE FROM CRUISE.DATASET_PLATFORMS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_instruments(self):
        command = "DELETE FROM CRUISE.DATASET_INSTRUMENTS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_dataset_parameters(self):
        command = "DELETE FROM CRUISE.DATASET_PARAMETERS WHERE DATASET_ID IN (SELECT DATASET_ID FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC'))"
        self.cruise.execute(command)

    def __delete_datasets(self):
        command = "DELETE FROM CRUISE.DATASETS WHERE DATASET_TYPE_ID IN (SELECT TYPE_ID FROM CRUISE.DATASET_TYPES WHERE TYPE_NAME = 'MB RAW' OR TYPE_NAME = 'MB PROCESSED' OR TYPE_NAME = 'MB PRODUCT' OR TYPE_NAME = 'MB RAW NONPUBLIC' OR TYPE_NAME = 'MB PROCESSED NONPUBLIC' OR TYPE_NAME = 'MB PRODUCT NONPUBLIC' OR TYPE_NAME = 'ANCILLARY' OR TYPE_NAME = 'DOCUMENT' OR TYPE_NAME = 'METADATA' OR TYPE_NAME = 'ANCILLARY NONPUBLIC' OR TYPE_NAME = 'DOCUMENT NONPUBLIC' OR TYPE_NAME = 'METADATA NONPUBLIC')"
        self.cruise.execute(command)

    def __delete_unreferenced_shapes(self):
        command = "DELETE FROM (SELECT * FROM CRUISE.SHAPES WHERE SHAPE_ID NOT IN (SELECT DISTINCT SHAPE_ID FROM CRUISE.FILE_SHAPES) AND SHAPE_ID NOT IN (SELECT DISTINCT SHAPE_ID FROM CRUISE.DATASET_SHAPES) AND SHAPE_ID NOT IN (SELECT DISTINCT SHAPE_ID FROM CRUISE.SURVEY_SHAPES))"
        self.cruise.execute(command)

    def __delete_unreferenced_access_paths(self):
        command = "DELETE FROM (SELECT * FROM CRUISE.ACCESS_PATHS WHERE PATH_ID NOT IN (SELECT DISTINCT PATH_ID FROM CRUISE.FILE_ACCESS_PATHS))"
        self.cruise.execute(command)
