# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkAclArgs', 'NetworkAcl']

@pulumi.input_type
class NetworkAclArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[builtins.bool],
                 description: pulumi.Input[builtins.str],
                 priority: pulumi.Input[builtins.int],
                 rule: pulumi.Input['NetworkAclRuleArgs']):
        """
        The set of arguments for constructing a NetworkAcl resource.
        :param pulumi.Input[builtins.bool] active: Whether the Network ACL is active
        :param pulumi.Input[builtins.str] description: The description of the Network ACL
        :param pulumi.Input[builtins.int] priority: The priority of the Network ACL. Must be unique between 1 and 10.
        :param pulumi.Input['NetworkAclRuleArgs'] rule: The rule of the Network ACL
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Input[builtins.bool]:
        """
        Whether the Network ACL is active
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the Network ACL
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        The priority of the Network ACL. Must be unique between 1 and 10.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def rule(self) -> pulumi.Input['NetworkAclRuleArgs']:
        """
        The rule of the Network ACL
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: pulumi.Input['NetworkAclRuleArgs']):
        pulumi.set(self, "rule", value)


@pulumi.input_type
class _NetworkAclState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 rule: Optional[pulumi.Input['NetworkAclRuleArgs']] = None):
        """
        Input properties used for looking up and filtering NetworkAcl resources.
        :param pulumi.Input[builtins.bool] active: Whether the Network ACL is active
        :param pulumi.Input[builtins.str] description: The description of the Network ACL
        :param pulumi.Input[builtins.int] priority: The priority of the Network ACL. Must be unique between 1 and 10.
        :param pulumi.Input['NetworkAclRuleArgs'] rule: The rule of the Network ACL
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Network ACL is active
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Network ACL
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of the Network ACL. Must be unique between 1 and 10.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input['NetworkAclRuleArgs']]:
        """
        The rule of the Network ACL
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input['NetworkAclRuleArgs']]):
        pulumi.set(self, "rule", value)


@pulumi.type_token("auth0:index/networkAcl:NetworkAcl")
class NetworkAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 rule: Optional[pulumi.Input[Union['NetworkAclRuleArgs', 'NetworkAclRuleArgsDict']]] = None,
                 __props__=None):
        """
        With this resource, you can create and manage NetworkACLs for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # Example of auth0_network_acl with match criteria
        my_network_acl_match = auth0.NetworkAcl("my_network_acl_match",
            description="Example with match network ACL",
            active=True,
            priority=1,
            rule={
                "action": {
                    "allow": True,
                },
                "scope": "management",
                "match": {
                    "geo_country_codes": [
                        "US",
                        "CA",
                    ],
                    "geo_subdivision_codes": [
                        "US-NY",
                        "CA-ON",
                    ],
                },
            })
        # Example of auth0_network_acl with not-match criteria
        my_network_acl_not_match = auth0.NetworkAcl("my_network_acl_not_match",
            description="Example with not match network ACL",
            active=True,
            priority=3,
            rule={
                "action": {
                    "log": True,
                },
                "scope": "authentication",
                "not_match": {
                    "asns": [9876],
                    "ipv4_cidrs": [
                        "192.168.1.0/24",
                        "10.0.0.0/8",
                    ],
                    "ipv6_cidrs": ["2001:db8::/32"],
                },
            })
        ```

        ## Import

        This resource can be imported using the network acl ID.

        Example:

        ```sh
        $ pulumi import auth0:index/networkAcl:NetworkAcl my_network_acl "167f9a50-4444-3333-1111-ndfdaf953ab4"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Whether the Network ACL is active
        :param pulumi.Input[builtins.str] description: The description of the Network ACL
        :param pulumi.Input[builtins.int] priority: The priority of the Network ACL. Must be unique between 1 and 10.
        :param pulumi.Input[Union['NetworkAclRuleArgs', 'NetworkAclRuleArgsDict']] rule: The rule of the Network ACL
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can create and manage NetworkACLs for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        # Example of auth0_network_acl with match criteria
        my_network_acl_match = auth0.NetworkAcl("my_network_acl_match",
            description="Example with match network ACL",
            active=True,
            priority=1,
            rule={
                "action": {
                    "allow": True,
                },
                "scope": "management",
                "match": {
                    "geo_country_codes": [
                        "US",
                        "CA",
                    ],
                    "geo_subdivision_codes": [
                        "US-NY",
                        "CA-ON",
                    ],
                },
            })
        # Example of auth0_network_acl with not-match criteria
        my_network_acl_not_match = auth0.NetworkAcl("my_network_acl_not_match",
            description="Example with not match network ACL",
            active=True,
            priority=3,
            rule={
                "action": {
                    "log": True,
                },
                "scope": "authentication",
                "not_match": {
                    "asns": [9876],
                    "ipv4_cidrs": [
                        "192.168.1.0/24",
                        "10.0.0.0/8",
                    ],
                    "ipv6_cidrs": ["2001:db8::/32"],
                },
            })
        ```

        ## Import

        This resource can be imported using the network acl ID.

        Example:

        ```sh
        $ pulumi import auth0:index/networkAcl:NetworkAcl my_network_acl "167f9a50-4444-3333-1111-ndfdaf953ab4"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 rule: Optional[pulumi.Input[Union['NetworkAclRuleArgs', 'NetworkAclRuleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkAclArgs.__new__(NetworkAclArgs)

            if active is None and not opts.urn:
                raise TypeError("Missing required property 'active'")
            __props__.__dict__["active"] = active
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            if rule is None and not opts.urn:
                raise TypeError("Missing required property 'rule'")
            __props__.__dict__["rule"] = rule
        super(NetworkAcl, __self__).__init__(
            'auth0:index/networkAcl:NetworkAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            rule: Optional[pulumi.Input[Union['NetworkAclRuleArgs', 'NetworkAclRuleArgsDict']]] = None) -> 'NetworkAcl':
        """
        Get an existing NetworkAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Whether the Network ACL is active
        :param pulumi.Input[builtins.str] description: The description of the Network ACL
        :param pulumi.Input[builtins.int] priority: The priority of the Network ACL. Must be unique between 1 and 10.
        :param pulumi.Input[Union['NetworkAclRuleArgs', 'NetworkAclRuleArgsDict']] rule: The rule of the Network ACL
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkAclState.__new__(_NetworkAclState)

        __props__.__dict__["active"] = active
        __props__.__dict__["description"] = description
        __props__.__dict__["priority"] = priority
        __props__.__dict__["rule"] = rule
        return NetworkAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the Network ACL is active
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the Network ACL
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        The priority of the Network ACL. Must be unique between 1 and 10.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rule(self) -> pulumi.Output['outputs.NetworkAclRule']:
        """
        The rule of the Network ACL
        """
        return pulumi.get(self, "rule")

