# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCameraPermissionsResult',
    'AwaitableGetCameraPermissionsResult',
    'get_camera_permissions',
    'get_camera_permissions_output',
]

@pulumi.output_type
class GetCameraPermissionsResult:
    """
    A collection of values returned by getCameraPermissions.
    """
    def __init__(__self__, id=None, item=None, organization_id=None, permission_scope_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if permission_scope_id and not isinstance(permission_scope_id, str):
            raise TypeError("Expected argument 'permission_scope_id' to be a str")
        pulumi.set(__self__, "permission_scope_id", permission_scope_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetCameraPermissionsItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="permissionScopeId")
    def permission_scope_id(self) -> str:
        """
        permissionScopeId path parameter. Permission scope ID
        """
        return pulumi.get(self, "permission_scope_id")


class AwaitableGetCameraPermissionsResult(GetCameraPermissionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCameraPermissionsResult(
            id=self.id,
            item=self.item,
            organization_id=self.organization_id,
            permission_scope_id=self.permission_scope_id)


def get_camera_permissions(organization_id: Optional[str] = None,
                           permission_scope_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCameraPermissionsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_camera_permissions(organization_id="string",
        permission_scope_id="string")
    pulumi.export("merakiOrganizationsCameraPermissionsExample", example.item)
    ```


    :param str organization_id: organizationId path parameter. Organization ID
    :param str permission_scope_id: permissionScopeId path parameter. Permission scope ID
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['permissionScopeId'] = permission_scope_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getCameraPermissions:getCameraPermissions', __args__, opts=opts, typ=GetCameraPermissionsResult).value

    return AwaitableGetCameraPermissionsResult(
        id=pulumi.get(__ret__, 'id'),
        item=pulumi.get(__ret__, 'item'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        permission_scope_id=pulumi.get(__ret__, 'permission_scope_id'))
def get_camera_permissions_output(organization_id: Optional[pulumi.Input[str]] = None,
                                  permission_scope_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCameraPermissionsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_camera_permissions(organization_id="string",
        permission_scope_id="string")
    pulumi.export("merakiOrganizationsCameraPermissionsExample", example.item)
    ```


    :param str organization_id: organizationId path parameter. Organization ID
    :param str permission_scope_id: permissionScopeId path parameter. Permission scope ID
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['permissionScopeId'] = permission_scope_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:organizations/getCameraPermissions:getCameraPermissions', __args__, opts=opts, typ=GetCameraPermissionsResult)
    return __ret__.apply(lambda __response__: GetCameraPermissionsResult(
        id=pulumi.get(__response__, 'id'),
        item=pulumi.get(__response__, 'item'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        permission_scope_id=pulumi.get(__response__, 'permission_scope_id')))
