import os
from logging.config import dictConfig

from python_agent.packages import urllib3
from python_agent.packages.urllib3.exceptions import InsecureRequestWarning

urllib3.disable_warnings(InsecureRequestWarning)
__legacy_mode__ = os.environ.get("SL_LEGACY_MODE", "false").lower() == "true"

__version__ = "2.2.1"
__package_name__ = "sealights-python-agent"

####################  PyNext Mode  ####################
if not __legacy_mode__:
    is_debug = os.environ.get("SL_DEBUG", "false").lower() == "true"
    current_level = "DEBUG" if is_debug else "INFO"
    save_log_file = os.environ.get("SL_SAVE_LOG_FILE", "false").lower() == "true"
    LOG_CONF = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'standard': {
                'format': '%(asctime)s SEALIGHTS %(levelname)s: %(message)s [%(filename)s:%(lineno)d]'
            },
            'standard-debug': {
                'format': '%(asctime)s SEALIGHTS %(levelname)s: %(message)s [%(filename)s:%(lineno)d] [pid:%(process)d|%(thread)d]'
            }
        },
        'handlers': {
            'cli': {
                'class': 'logging.StreamHandler',
                'level': current_level,
                'formatter': 'standard',
                'stream': 'ext://sys.stdout',
            },
            'cli-debug': {
                'class': 'logging.StreamHandler',
                'level': current_level,
                'formatter': 'standard-debug',
                'stream': 'ext://sys.stdout',
            }
        }
    }
    handlers = []
    if is_debug:
        handlers.append('cli-debug')
    else:
        handlers.append('cli')
    if save_log_file:
        LOG_CONF['handlers'].update({
            'sealights-file': {
                'class': 'logging.handlers.RotatingFileHandler',
                'level': current_level,
                'formatter': 'standard-debug',
                'filename': 'sealights-python-agent.log',
                'mode': 'a',
                'maxBytes': 10485760,
                'backupCount': 10,
            }
        })
        handlers.append('sealights-file')
    LOG_CONF["loggers"] = {
        'python_agent': {
            'handlers': handlers,
            'level': current_level,
            'propagate': True
        },
    }
####################  End PyNext Mode  ###############

####################  Legacy Mode  ####################
else:
    print("------- Sealights Agent Is Running In Legacy Mode --------")
    LOG_CONF = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'sealights-standard': {
                'format': '%(asctime)s SEALIGHTS %(levelname)s: [%(process)d|%(thread)d] %(name)s %(message)s'
            },
            'standard': {
                'format': '%(asctime)s SEALIGHTS %(levelname)s: %(message)s'
            }
        },
        'handlers': {
            'cli': {
                'class': 'logging.StreamHandler',
                'level': 'DEBUG',
                'formatter': 'standard',
                'stream': 'ext://sys.stdout',
            }
        },
        'loggers': {
            '__main__': {
                'handlers': ['cli'],
                'level': 'DEBUG',
                'propagate': True
            },
            'python_agent.build_scanner.executors': {
                'handlers': ['cli'],
                'level': 'DEBUG',
                'propagate': True
            },
            'python_agent.test_listener.executors': {
                'handlers': ['cli'],
                'level': 'DEBUG',
                'propagate': True
            },
            'python_agent.common.token': {
                'handlers': ['cli'],
                'level': 'DEBUG',
                'propagate': True
            },
            'python_agent.admin': {
                'handlers': ['cli'],
                'level': 'DEBUG',
                'propagate': True
            },
            'python_agent.common.configuration_manager': {
                'handlers': ['cli'],
                'level': 'DEBUG',
                'propagate': True
            },
            'python_agent.common.environment_variables_resolver': {
                'handlers': ['cli'],
                'level': 'DEBUG',
                'propagate': True
            },
            'python_agent.packages.urllib3.connectionpool': {
                'handlers': [],
                'level': 'WARN',
                'propagate': False
            },
            'pip': {
                'handlers': [],
                'level': 'WARN',
                'propagate': False
            },
            'python_agent.serverless': {
                'handlers': ['cli'],
                'level': 'INFO',
                'propagate': True
            },
        }
    }
    if os.environ.get("SL_DEBUG"):
        LOG_CONF["handlers"].update({
            'sealights-console': {
                'class': 'logging.StreamHandler',
                'level': 'DEBUG',
                'formatter': 'sealights-standard',
                'stream': 'ext://sys.stdout',
            },
            'sealights-file': {
                'class': 'logging.handlers.RotatingFileHandler',
                'level': 'DEBUG',
                'formatter': 'sealights-standard',
                'filename': 'sealights-python-agent.log',
                'mode': 'a',
                'maxBytes': 10485760,
                'backupCount': 10,
            }
        })
        LOG_CONF["loggers"].update({
            'python_agent': {
                'handlers': ['sealights-console', 'sealights-file'],
                'level': 'DEBUG',
                'propagate': False
            }
        })
####################  End Legacy Mode  ####################

dictConfig(LOG_CONF)
