# dfp-sync 
`dfp-sync` is a set of command-line utilities for syncing google doubleclick data to a hadoop-based filesystem (either locally or on Amazon S3). It currently includes commands for the following tasks:

- `dfp-sync service`: Sync Doubleclick API Service Data.
- `dfp-sync transfer-file`: Sync Doubleclick Transfer Files.
- `dfp-sync cloud-auth`: Fetches cloud-auth credentials as json file browser-based oauth flow

Here is the help screen for `dfp-sync`

```
usage: dfp-sync [-h] [--aws-key AWS_KEY] [--aws-secret AWS_SECRET]
                {service,transfer-file,cloud-auth} ...

positional arguments:
  {service,transfer-file,cloud-auth}
                        Commands
    service             Sync Doubleclick API Service Data.
    transfer-file       Sync Doubleclick Transfer Files in Google Cloud
                        Storage.
    cloud-auth          Get you gcloud authentication parameters as json. Must
                        have google cloud SDK installed. You'll need this file
                        to run $ dfp-sync transfer-file

optional arguments:
  -h, --help            show this help message and exit
  --aws-key AWS_KEY
  --aws-secret AWS_SECRET
```

## Services
```
usage: dfp-sync service [-h] [-c CONFIG] [-n CHUNK_SIZE] [-f {avro,json.gz}]
                        [-w WHERE] [-l LOG_EVERY] [-j N_JOBS] [-s S3_BUCKET]
                        {AdUnit,ActivityGroup,Activity,AdExclusionRule,AdRule,AudienceSegment,BaseRate,Company,Contact,ContentBundle,ContentMetadataKeyHierarchy,Content,Creative,CreativeSet,CreativeTemplate,CreativeWrapper,CustomField,Label,LineItemCreativeAssociation,LineItemTemplate,Network,Order,Placement,PremiumRate,Product,ProposalLineItem,Proposal,RateCard,SharedAdUnit,SuggestedAdUnit,Team,User,UserTeamAssociation,All}

Services to Sync:
  AdUnit,
  ActivityGroup,
  Activity,
  AdExclusionRule,
  AdRule,
  AudienceSegment,
  BaseRate,
  Company,
  Contact,
  ContentBundle,
  ContentMetadataKeyHierarchy,
  Content,
  Creative,
  CreativeSet,
  CreativeTemplate,
  CreativeWrapper,
  CustomField,
  Label,
  LineItemCreativeAssociation,
  LineItemTemplate,
  Network,
  Order,
  Placement,
  PremiumRate,
  Product,
  ProposalLineItem,
  Proposal,
  RateCard,
  SharedAdUnit,
  SuggestedAdUnit,
  Team,
  User,
  UserTeamAssociation,
  All

optional arguments:
  -h, --help            show this help message and exit
  -c CONFIG, --config CONFIG
                        The path to your googleads.yaml file.
  -n CHUNK_SIZE, --chunk-size CHUNK_SIZE
                        The number of records to dump per file
  -f {avro,json.gz}, --format {avro,json.gz}
                        The format to export files in.
  -w WHERE, --where WHERE
                        Optional PQL filter statement to apply to a service.
                        Ignored when service_name == "All"
  -l LOG_EVERY, --log-every LOG_EVERY
                        How often to log process (in number of records).
  -j N_JOBS, --n-jobs N_JOBS
                        The number of services to concurrently access.
  -s S3_BUCKET, --s3-bucket S3_BUCKET
                        The S3 Bucket where the files should be stored.
```

## Transfer Files

```
usage: dfp-sync transfer-file [-h] [-c CONFIG] [-g GCS_BUCKET] [-s S3_BUCKET]
                              [-p PATH] [--event-type {click,impression,all}]
                              [--event-name {NetworkBackillImpressions,NetworkBackfillClicks,NetworkImpressions,NetworkClicks,all}]
                              [-l] [--limit LIMIT] [-i INTERVAL] [-f]
                              [--year YEAR] [--month MONTH] [--day DAY]
                              [--hour HOUR] [--backfill BACKFILL]

optional arguments:
  -h, --help            show this help message and exit
  -c CONFIG, --config CONFIG
                        The path to your google cloud conifg generated by $
                        gcloud auth login
  -g GCS_BUCKET, --gcs-bucket GCS_BUCKET
                        The GCS Bucket where the files are stored.
  -s S3_BUCKET, --s3-bucket S3_BUCKET
                        The S3 Bucket where the files should be stored.
  -p PATH, --path PATH  The formatting string used to create the filepaths on
                        S3. Defaults to event_type={event_type}/year={year}/mo
                        nth={month}/day={day}/{gcs_file}. You can use the
                        following variables: event_name, event_type,
                        network_id, year, month, day, hour, gcs_file, backfill
  --event-type {click,impression,all}
                        Filter transfer files by with event type
  --event-name {NetworkBackillImpressions,NetworkBackfillClicks,NetworkImpressions,NetworkClicks,all}
                        Filter transfer files by event name
  -l, --listen          Poll GCS bucket for new transfer files.
  --limit LIMIT         Limit the number of recent files to check at once.
  -i INTERVAL, --interval INTERVAL
                        Interval to wait in between polling periods.
  -f, --force           Overwrite existing files.
  --year YEAR           Filter transfer files by year.
  --month MONTH         Filter transfer files by month
  --day DAY             Filter transfer files by day
  --hour HOUR           Filter transfer files by hour.
  --backfill BACKFILL   Filter transfer files by whther or not they represent
                        backfilled events.
```


## Data Transfer File Schema:

filepath: `{event_name}_{network_id}_{date}_{hour}.gz`

* Time
- Displays the network's **local event time** in 24-hour format. Format: YYYY-MM-DD-HH:MI:SS
This field corresponds to the impression. For click events, it corresponds to the underlying impression. For Rich Media, Video, conversions, and Active View, it corresponds to the actual event.
* [UserId](https://support.google.com/dfp_premium/answer/1733128?hl=en)
  - Encrypted DoubleClick cookie ID. For iOS mobile apps an encrypted version of Apple's Identifier for Advertising (IDFA), for Android apps an encrypted version of the Android Advertising Id (AdId) will be used. If a user's browser does not accept cookies, this field will be blank.* AdvertiserId
* [OrderId](https://developers.google.com/doubleclick-publishers/docs/reference/v201505/OrderService.Order)
  - An Order represents a grouping of individual LineItem objects, each of which fulfill an ad request from a particular advertiser.
* [LineItemId](https://developers.google.com/doubleclick-publishers/docs/reference/v201505/LineItemService.LineItem)
  - A LineItem is an advertiser's commitment to purchase a specific number of ad impressions, clicks, or time.
* [CreativeId](https://developers.google.com/doubleclick-publishers/docs/reference/v201511/CreativeService.Creative)
  - A Creative represents the media for the ad being served.
* CreativeVersion
* [AdUnitId](https://developers.google.com/doubleclick-publishers/docs/reference/v201511/InventoryService.AdUnit)
* [CustomTargeting](https://support.google.com/dfp_premium/answer/1733128?hl=en)
  - Includes both targeted and non-targeted pairs. (Known as 'Key-values' in the user interface.) Key-value pairs are specified by the publisher and separated by semicolons (;). Key-values reporting differs slightly between Query Tool reports and data that's delivered through Data Transfer. Query Tool reports only include custom criteria where both the key and the value are defined in DFP, while Data Transfer reports include custom criteria where only the key is defined.For example, if the key "articleID" is defined, but the value "123456" is not, this custom criterion would be included in Data Transfer reports, but not in Query Tool reports.
    * Domain
    * CountryId
    * Country

Time,
UserId,
AdvertiserId,
OrderId,
LineItemId,
CreativeId,
CreativeVersion,
AdUnitId,
CustomTargeting,
Domain,
CountryId,
Country,
TimeUsec,
CreativeSize,
RegionId,
Region,
MetroId,
Metro,
CityId,
PostalCodeId,
PostalCode,
BrowserId,
Browser,
OSId,
OS,
OSVersion,
BandWidth,
TimeUsec2,
KeyPart,
AudienceSegmentIds,
Product,
RequestedAdUnitSizes,
MobileDevice,
MobileCapability,
MobileCarrier,
GfpContentId,
VideoPosition,
VideoFallbackPosition,
PodPosition,
IsCompanion,
PublisherProvidedID,
TargetedCustomCriteria,
DeviceCategory,
IsInterstitial,
ActiveViewEligibleImpression
