"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Discovery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_applicationdiscovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Discovery extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [discovery](https://docs.aws.amazon.com/service-authorization/latest/reference/list_applicationdiscovery.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'discovery';
        this.accessLevelList = {
            Write: [
                'AssociateConfigurationItemsToApplication',
                'BatchDeleteImportData',
                'CreateApplication',
                'DeleteApplications',
                'DisassociateConfigurationItemsFromApplication',
                'ExportConfigurations',
                'StartContinuousExport',
                'StartDataCollectionByAgentIds',
                'StartExportTask',
                'StartImportTask',
                'StopContinuousExport',
                'StopDataCollectionByAgentIds',
                'UpdateApplication'
            ],
            Tagging: [
                'CreateTags',
                'DeleteTags'
            ],
            Read: [
                'DescribeAgents',
                'DescribeConfigurations',
                'DescribeContinuousExports',
                'DescribeExportConfigurations',
                'DescribeExportTasks',
                'DescribeTags',
                'GetDiscoverySummary'
            ],
            List: [
                'DescribeImportTasks',
                'ListConfigurations',
                'ListServerNeighbors'
            ]
        };
    }
    /**
     * Associates one or more configuration items with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html
     */
    toAssociateConfigurationItemsToApplication() {
        return this.to('AssociateConfigurationItemsToApplication');
    }
    /**
     * Deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html
     */
    toBatchDeleteImportData() {
        return this.to('BatchDeleteImportData');
    }
    /**
     * Creates an application with the given name and description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html
     */
    toCreateTags() {
        return this.to('CreateTags');
    }
    /**
     * Deletes a list of applications and their associations with configuration items.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html
     */
    toDeleteApplications() {
        return this.to('DeleteApplications');
    }
    /**
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags() {
        return this.to('DeleteTags');
    }
    /**
     * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html
     */
    toDescribeAgents() {
        return this.to('DescribeAgents');
    }
    /**
     * Retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html
     */
    toDescribeConfigurations() {
        return this.to('DescribeConfigurations');
    }
    /**
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html
     */
    toDescribeContinuousExports() {
        return this.to('DescribeContinuousExports');
    }
    /**
     * Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html
     */
    toDescribeExportConfigurations() {
        return this.to('DescribeExportConfigurations');
    }
    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html
     */
    toDescribeExportTasks() {
        return this.to('DescribeExportTasks');
    }
    /**
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html
     */
    toDescribeImportTasks() {
        return this.to('DescribeImportTasks');
    }
    /**
     * Retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html
     */
    toDescribeTags() {
        return this.to('DescribeTags');
    }
    /**
     * Disassociates one or more configuration items from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html
     */
    toDisassociateConfigurationItemsFromApplication() {
        return this.to('DisassociateConfigurationItemsFromApplication');
    }
    /**
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html
     */
    toExportConfigurations() {
        return this.to('ExportConfigurations');
    }
    /**
     * Retrieves a short summary of discovered assets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html
     */
    toGetDiscoverySummary() {
        return this.to('GetDiscoverySummary');
    }
    /**
     * Retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html
     */
    toListConfigurations() {
        return this.to('ListConfigurations');
    }
    /**
     * Retrieves a list of servers which are one network hop away from a specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html
     */
    toListServerNeighbors() {
        return this.to('ListServerNeighbors');
    }
    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html
     */
    toStartContinuousExport() {
        return this.to('StartContinuousExport');
    }
    /**
     * Instructs the specified agents or Connectors to start collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html
     */
    toStartDataCollectionByAgentIds() {
        return this.to('StartDataCollectionByAgentIds');
    }
    /**
     * Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html
     */
    toStartExportTask() {
        return this.to('StartExportTask');
    }
    /**
     * Starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html
     */
    toStartImportTask() {
        return this.to('StartImportTask');
    }
    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html
     */
    toStopContinuousExport() {
        return this.to('StopContinuousExport');
    }
    /**
     * Instructs the specified agents or Connectors to stop collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html
     */
    toStopDataCollectionByAgentIds() {
        return this.to('StopDataCollectionByAgentIds');
    }
    /**
     * Updates metadata about an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
}
exports.Discovery = Discovery;
_a = JSII_RTTI_SYMBOL_1;
Discovery[_a] = { fqn: "cdk-iam-floyd.Discovery", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwbGljYXRpb25kaXNjb3ZlcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhcHBsaWNhdGlvbmRpc2NvdmVyeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0QztBQUc1Qzs7OztHQUlHO0FBQ0gsTUFBYSxTQUFVLFNBQVEsd0JBQWU7SUEwVDVDOzs7T0FHRztJQUNILFlBQVksS0FBZ0M7UUFDMUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBOVRSLGtCQUFhLEdBQUcsV0FBVyxDQUFDO1FBcVJ6QixvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsMENBQTBDO2dCQUMxQyx1QkFBdUI7Z0JBQ3ZCLG1CQUFtQjtnQkFDbkIsb0JBQW9CO2dCQUNwQiwrQ0FBK0M7Z0JBQy9DLHNCQUFzQjtnQkFDdEIsdUJBQXVCO2dCQUN2QiwrQkFBK0I7Z0JBQy9CLGlCQUFpQjtnQkFDakIsaUJBQWlCO2dCQUNqQixzQkFBc0I7Z0JBQ3RCLDhCQUE4QjtnQkFDOUIsbUJBQW1CO2FBQ3BCO1lBQ0QsT0FBTyxFQUFFO2dCQUNQLFlBQVk7Z0JBQ1osWUFBWTthQUNiO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLGdCQUFnQjtnQkFDaEIsd0JBQXdCO2dCQUN4QiwyQkFBMkI7Z0JBQzNCLDhCQUE4QjtnQkFDOUIscUJBQXFCO2dCQUNyQixjQUFjO2dCQUNkLHFCQUFxQjthQUN0QjtZQUNELElBQUksRUFBRTtnQkFDSixxQkFBcUI7Z0JBQ3JCLG9CQUFvQjtnQkFDcEIscUJBQXFCO2FBQ3RCO1NBQ0YsQ0FBQztJQVFGLENBQUM7SUE3VEQ7Ozs7OztPQU1HO0lBQ0ksMENBQTBDO1FBQy9DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQ0FBMEMsQ0FBQyxDQUFDO0lBQzdELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDhCQUE4QjtRQUNuQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwrQ0FBK0M7UUFDcEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtDQUErQyxDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwrQkFBK0I7UUFDcEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDhCQUE4QjtRQUNuQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7O0FBcFJILDhCQWlVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnLi4vc2hhcmVkJztcbmltcG9ydCB7IGF3c19pYW0gYXMgaWFtIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtkaXNjb3ZlcnldKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2FwcGxpY2F0aW9uZGlzY292ZXJ5Lmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgRGlzY292ZXJ5IGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnZGlzY292ZXJ5JztcblxuICAvKipcbiAgICogQXNzb2NpYXRlcyBvbmUgb3IgbW9yZSBjb25maWd1cmF0aW9uIGl0ZW1zIHdpdGggYW4gYXBwbGljYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9Bc3NvY2lhdGVDb25maWd1cmF0aW9uSXRlbXNUb0FwcGxpY2F0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Fzc29jaWF0ZUNvbmZpZ3VyYXRpb25JdGVtc1RvQXBwbGljYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Fzc29jaWF0ZUNvbmZpZ3VyYXRpb25JdGVtc1RvQXBwbGljYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIG9uZSBvciBtb3JlIE1pZ3JhdGlvbiBIdWIgaW1wb3J0IHRhc2tzLCBlYWNoIGlkZW50aWZpZWQgYnkgdGhlaXIgaW1wb3J0IElELiBFYWNoIGltcG9ydCB0YXNrIGhhcyBhIG51bWJlciBvZiByZWNvcmRzLCB3aGljaCBjYW4gaWRlbnRpZnkgc2VydmVycyBvciBhcHBsaWNhdGlvbnMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9CYXRjaERlbGV0ZUltcG9ydERhdGEuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQmF0Y2hEZWxldGVJbXBvcnREYXRhKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdCYXRjaERlbGV0ZUltcG9ydERhdGEnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGFuIGFwcGxpY2F0aW9uIHdpdGggdGhlIGdpdmVuIG5hbWUgYW5kIGRlc2NyaXB0aW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlQXBwbGljYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlQXBwbGljYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUFwcGxpY2F0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBvbmUgb3IgbW9yZSB0YWdzIGZvciBjb25maWd1cmF0aW9uIGl0ZW1zLiBUYWdzIGFyZSBtZXRhZGF0YSB0aGF0IGhlbHAgeW91IGNhdGVnb3JpemUgSVQgYXNzZXRzLiBUaGlzIEFQSSBhY2NlcHRzIGEgbGlzdCBvZiBtdWx0aXBsZSBjb25maWd1cmF0aW9uIGl0ZW1zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVUYWdzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVRhZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVRhZ3MnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIGEgbGlzdCBvZiBhcHBsaWNhdGlvbnMgYW5kIHRoZWlyIGFzc29jaWF0aW9ucyB3aXRoIGNvbmZpZ3VyYXRpb24gaXRlbXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVBcHBsaWNhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlQXBwbGljYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVBcHBsaWNhdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIHRoZSBhc3NvY2lhdGlvbiBiZXR3ZWVuIGNvbmZpZ3VyYXRpb24gaXRlbXMgYW5kIG9uZSBvciBtb3JlIHRhZ3MuIFRoaXMgQVBJIGFjY2VwdHMgYSBsaXN0IG9mIG11bHRpcGxlIGNvbmZpZ3VyYXRpb24gaXRlbXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwbGljYXRpb24tZGlzY292ZXJ5L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZVRhZ3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlVGFncygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlVGFncycpO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIGFnZW50cyBvciB0aGUgQ29ubmVjdG9yIGJ5IElEIG9yIGxpc3RzIGFsbCBhZ2VudHMvQ29ubmVjdG9ycyBhc3NvY2lhdGVkIHdpdGggeW91ciB1c2VyIGFjY291bnQgaWYgeW91IGRpZCBub3Qgc3BlY2lmeSBhbiBJRC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVBZ2VudHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVBZ2VudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQWdlbnRzJyk7XG4gIH1cblxuICAvKipcbiAgICogUmV0cmlldmVzIGF0dHJpYnV0ZXMgZm9yIGEgbGlzdCBvZiBjb25maWd1cmF0aW9uIGl0ZW0gSURzLiBBbGwgb2YgdGhlIHN1cHBsaWVkIElEcyBtdXN0IGJlIGZvciB0aGUgc2FtZSBhc3NldCB0eXBlIChzZXJ2ZXIsIGFwcGxpY2F0aW9uLCBwcm9jZXNzLCBvciBjb25uZWN0aW9uKS4gT3V0cHV0IGZpZWxkcyBhcmUgc3BlY2lmaWMgdG8gdGhlIGFzc2V0IHR5cGUgc2VsZWN0ZWQuIEZvciBleGFtcGxlLCB0aGUgb3V0cHV0IGZvciBhIHNlcnZlciBjb25maWd1cmF0aW9uIGl0ZW0gaW5jbHVkZXMgYSBsaXN0IG9mIGF0dHJpYnV0ZXMgYWJvdXQgdGhlIHNlcnZlciwgc3VjaCBhcyBob3N0IG5hbWUsIG9wZXJhdGluZyBzeXN0ZW0sIGFuZCBudW1iZXIgb2YgbmV0d29yayBjYXJkcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVDb25maWd1cmF0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUNvbmZpZ3VyYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUNvbmZpZ3VyYXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgZXhwb3J0cyBhcyBzcGVjaWZpZWQgYnkgSUQuIEFsbCBjb250aW51b3VzIGV4cG9ydHMgYXNzb2NpYXRlZCB3aXRoIHlvdXIgdXNlciBhY2NvdW50IGNhbiBiZSBsaXN0ZWQgaWYgeW91IGNhbGwgRGVzY3JpYmVDb250aW51b3VzRXhwb3J0cyBhcyBpcyB3aXRob3V0IHBhc3NpbmcgYW55IHBhcmFtZXRlcnMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwbGljYXRpb24tZGlzY292ZXJ5L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQ29udGludW91c0V4cG9ydHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVDb250aW51b3VzRXhwb3J0cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVDb250aW51b3VzRXhwb3J0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlcyB0aGUgc3RhdHVzIG9mIGEgZ2l2ZW4gZXhwb3J0IHByb2Nlc3MuIFlvdSBjYW4gcmV0cmlldmUgc3RhdHVzIGZyb20gYSBtYXhpbXVtIG9mIDEwMCBwcm9jZXNzZXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwbGljYXRpb24tZGlzY292ZXJ5L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlRXhwb3J0Q29uZmlndXJhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVFeHBvcnRDb25maWd1cmF0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVFeHBvcnRDb25maWd1cmF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlIHN0YXR1cyBvZiBvbmUgb3IgbW9yZSBleHBvcnQgdGFza3MuIFlvdSBjYW4gcmV0cmlldmUgdGhlIHN0YXR1cyBvZiB1cCB0byAxMDAgZXhwb3J0IHRhc2tzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZXNjcmliZUV4cG9ydFRhc2tzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlRXhwb3J0VGFza3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlRXhwb3J0VGFza3MnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGFuIGFycmF5IG9mIGltcG9ydCB0YXNrcyBmb3IgeW91ciBhY2NvdW50LCBpbmNsdWRpbmcgc3RhdHVzIGluZm9ybWF0aW9uLCB0aW1lcywgSURzLCB0aGUgQW1hem9uIFMzIE9iamVjdCBVUkwgZm9yIHRoZSBpbXBvcnQgZmlsZSwgYW5kIG1vcmUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwbGljYXRpb24tZGlzY292ZXJ5L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlSW1wb3J0VGFza3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVJbXBvcnRUYXNrcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVJbXBvcnRUYXNrcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlcyBhIGxpc3Qgb2YgY29uZmlndXJhdGlvbiBpdGVtcyB0aGF0IGFyZSB0YWdnZWQgd2l0aCBhIHNwZWNpZmljIHRhZy4gT3IgcmV0cmlldmVzIGEgbGlzdCBvZiBhbGwgdGFncyBhc3NpZ25lZCB0byBhIHNwZWNpZmljIGNvbmZpZ3VyYXRpb24gaXRlbS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVzY3JpYmVUYWdzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlVGFncygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVUYWdzJyk7XG4gIH1cblxuICAvKipcbiAgICogRGlzYXNzb2NpYXRlcyBvbmUgb3IgbW9yZSBjb25maWd1cmF0aW9uIGl0ZW1zIGZyb20gYW4gYXBwbGljYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EaXNhc3NvY2lhdGVDb25maWd1cmF0aW9uSXRlbXNGcm9tQXBwbGljYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGlzYXNzb2NpYXRlQ29uZmlndXJhdGlvbkl0ZW1zRnJvbUFwcGxpY2F0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEaXNhc3NvY2lhdGVDb25maWd1cmF0aW9uSXRlbXNGcm9tQXBwbGljYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBFeHBvcnRzIGFsbCBkaXNjb3ZlcmVkIGNvbmZpZ3VyYXRpb24gZGF0YSB0byBhbiBBbWF6b24gUzMgYnVja2V0IG9yIGFuIGFwcGxpY2F0aW9uIHRoYXQgZW5hYmxlcyB5b3UgdG8gdmlldyBhbmQgZXZhbHVhdGUgdGhlIGRhdGEuIERhdGEgaW5jbHVkZXMgdGFncyBhbmQgdGFnIGFzc29jaWF0aW9ucywgcHJvY2Vzc2VzLCBjb25uZWN0aW9ucywgc2VydmVycywgYW5kIHN5c3RlbSBwZXJmb3JtYW5jZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwbGljYXRpb24tZGlzY292ZXJ5L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0V4cG9ydENvbmZpZ3VyYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0V4cG9ydENvbmZpZ3VyYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdFeHBvcnRDb25maWd1cmF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlcyBhIHNob3J0IHN1bW1hcnkgb2YgZGlzY292ZXJlZCBhc3NldHMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwbGljYXRpb24tZGlzY292ZXJ5L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldERpc2NvdmVyeVN1bW1hcnkuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RGlzY292ZXJ5U3VtbWFyeSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RGlzY292ZXJ5U3VtbWFyeScpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlcyBhIGxpc3Qgb2YgY29uZmlndXJhdGlvbiBpdGVtcyBhY2NvcmRpbmcgdG8gY3JpdGVyaWEgeW91IHNwZWNpZnkgaW4gYSBmaWx0ZXIuIFRoZSBmaWx0ZXIgY3JpdGVyaWEgaWRlbnRpZnkgcmVsYXRpb25zaGlwIHJlcXVpcmVtZW50cy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdENvbmZpZ3VyYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RDb25maWd1cmF0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdENvbmZpZ3VyYXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogUmV0cmlldmVzIGEgbGlzdCBvZiBzZXJ2ZXJzIHdoaWNoIGFyZSBvbmUgbmV0d29yayBob3AgYXdheSBmcm9tIGEgc3BlY2lmaWVkIHNlcnZlci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFNlcnZlck5laWdoYm9ycy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U2VydmVyTmVpZ2hib3JzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0U2VydmVyTmVpZ2hib3JzJyk7XG4gIH1cblxuICAvKipcbiAgICogU3RhcnQgdGhlIGNvbnRpbnVvdXMgZmxvdyBvZiBhZ2VudCdzIGRpc2NvdmVyZWQgZGF0YSBpbnRvIEFtYXpvbiBBdGhlbmEuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdGFydENvbnRpbnVvdXNFeHBvcnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RhcnRDb250aW51b3VzRXhwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydENvbnRpbnVvdXNFeHBvcnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbnN0cnVjdHMgdGhlIHNwZWNpZmllZCBhZ2VudHMgb3IgQ29ubmVjdG9ycyB0byBzdGFydCBjb2xsZWN0aW5nIGRhdGEuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdGFydERhdGFDb2xsZWN0aW9uQnlBZ2VudElkcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydERhdGFDb2xsZWN0aW9uQnlBZ2VudElkcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnU3RhcnREYXRhQ29sbGVjdGlvbkJ5QWdlbnRJZHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBFeHBvcnQgdGhlIGNvbmZpZ3VyYXRpb24gZGF0YSBhYm91dCBkaXNjb3ZlcmVkIGNvbmZpZ3VyYXRpb24gaXRlbXMgYW5kIHJlbGF0aW9uc2hpcHMgdG8gYW4gUzMgYnVja2V0IGluIGEgc3BlY2lmaWVkIGZvcm1hdC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBwbGljYXRpb24tZGlzY292ZXJ5L2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1N0YXJ0RXhwb3J0VGFzay5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydEV4cG9ydFRhc2soKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0YXJ0RXhwb3J0VGFzaycpO1xuICB9XG5cbiAgLyoqXG4gICAqIFN0YXJ0cyBhbiBpbXBvcnQgdGFzay4gVGhlIE1pZ3JhdGlvbiBIdWIgaW1wb3J0IGZlYXR1cmUgYWxsb3dzIHlvdSB0byBpbXBvcnQgZGV0YWlscyBvZiB5b3VyIG9uLXByZW1pc2VzIGVudmlyb25tZW50IGRpcmVjdGx5IGludG8gQVdTIHdpdGhvdXQgaGF2aW5nIHRvIHVzZSB0aGUgQXBwbGljYXRpb24gRGlzY292ZXJ5IFNlcnZpY2UgKEFEUykgdG9vbHMgc3VjaCBhcyB0aGUgRGlzY292ZXJ5IENvbm5lY3RvciBvciBEaXNjb3ZlcnkgQWdlbnQuIFRoaXMgZ2l2ZXMgeW91IHRoZSBvcHRpb24gdG8gcGVyZm9ybSBtaWdyYXRpb24gYXNzZXNzbWVudCBhbmQgcGxhbm5pbmcgZGlyZWN0bHkgZnJvbSB5b3VyIGltcG9ydGVkIGRhdGEgaW5jbHVkaW5nIHRoZSBhYmlsaXR5IHRvIGdyb3VwIHlvdXIgZGV2aWNlcyBhcyBhcHBsaWNhdGlvbnMgYW5kIHRyYWNrIHRoZWlyIG1pZ3JhdGlvbiBzdGF0dXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdGFydEltcG9ydFRhc2suaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RhcnRJbXBvcnRUYXNrKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydEltcG9ydFRhc2snKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBTdG9wIHRoZSBjb250aW51b3VzIGZsb3cgb2YgYWdlbnQncyBkaXNjb3ZlcmVkIGRhdGEgaW50byBBbWF6b24gQXRoZW5hLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfU3RvcENvbnRpbnVvdXNFeHBvcnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RvcENvbnRpbnVvdXNFeHBvcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0b3BDb250aW51b3VzRXhwb3J0Jyk7XG4gIH1cblxuICAvKipcbiAgICogSW5zdHJ1Y3RzIHRoZSBzcGVjaWZpZWQgYWdlbnRzIG9yIENvbm5lY3RvcnMgdG8gc3RvcCBjb2xsZWN0aW5nIGRhdGEuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2FwcGxpY2F0aW9uLWRpc2NvdmVyeS9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9TdG9wRGF0YUNvbGxlY3Rpb25CeUFnZW50SWRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0b3BEYXRhQ29sbGVjdGlvbkJ5QWdlbnRJZHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1N0b3BEYXRhQ29sbGVjdGlvbkJ5QWdlbnRJZHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIG1ldGFkYXRhIGFib3V0IGFuIGFwcGxpY2F0aW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcHBsaWNhdGlvbi1kaXNjb3ZlcnkvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlQXBwbGljYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQXBwbGljYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUFwcGxpY2F0aW9uJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgV3JpdGU6IFtcbiAgICAgICdBc3NvY2lhdGVDb25maWd1cmF0aW9uSXRlbXNUb0FwcGxpY2F0aW9uJyxcbiAgICAgICdCYXRjaERlbGV0ZUltcG9ydERhdGEnLFxuICAgICAgJ0NyZWF0ZUFwcGxpY2F0aW9uJyxcbiAgICAgICdEZWxldGVBcHBsaWNhdGlvbnMnLFxuICAgICAgJ0Rpc2Fzc29jaWF0ZUNvbmZpZ3VyYXRpb25JdGVtc0Zyb21BcHBsaWNhdGlvbicsXG4gICAgICAnRXhwb3J0Q29uZmlndXJhdGlvbnMnLFxuICAgICAgJ1N0YXJ0Q29udGludW91c0V4cG9ydCcsXG4gICAgICAnU3RhcnREYXRhQ29sbGVjdGlvbkJ5QWdlbnRJZHMnLFxuICAgICAgJ1N0YXJ0RXhwb3J0VGFzaycsXG4gICAgICAnU3RhcnRJbXBvcnRUYXNrJyxcbiAgICAgICdTdG9wQ29udGludW91c0V4cG9ydCcsXG4gICAgICAnU3RvcERhdGFDb2xsZWN0aW9uQnlBZ2VudElkcycsXG4gICAgICAnVXBkYXRlQXBwbGljYXRpb24nXG4gICAgXSxcbiAgICBUYWdnaW5nOiBbXG4gICAgICAnQ3JlYXRlVGFncycsXG4gICAgICAnRGVsZXRlVGFncydcbiAgICBdLFxuICAgIFJlYWQ6IFtcbiAgICAgICdEZXNjcmliZUFnZW50cycsXG4gICAgICAnRGVzY3JpYmVDb25maWd1cmF0aW9ucycsXG4gICAgICAnRGVzY3JpYmVDb250aW51b3VzRXhwb3J0cycsXG4gICAgICAnRGVzY3JpYmVFeHBvcnRDb25maWd1cmF0aW9ucycsXG4gICAgICAnRGVzY3JpYmVFeHBvcnRUYXNrcycsXG4gICAgICAnRGVzY3JpYmVUYWdzJyxcbiAgICAgICdHZXREaXNjb3ZlcnlTdW1tYXJ5J1xuICAgIF0sXG4gICAgTGlzdDogW1xuICAgICAgJ0Rlc2NyaWJlSW1wb3J0VGFza3MnLFxuICAgICAgJ0xpc3RDb25maWd1cmF0aW9ucycsXG4gICAgICAnTGlzdFNlcnZlck5laWdoYm9ycydcbiAgICBdXG4gIH07XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZGlzY292ZXJ5XShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hcHBsaWNhdGlvbmRpc2NvdmVyeS5odG1sKS5cbiAgICpcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByb3BzPzogaWFtLlBvbGljeVN0YXRlbWVudFByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICB9XG59XG4iXX0=