"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wisdom = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [wisdom](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectwisdom.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Wisdom extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [wisdom](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnectwisdom.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'wisdom';
        this.accessLevelList = {
            Write: [
                'CreateAssistant',
                'CreateAssistantAssociation',
                'CreateContent',
                'CreateKnowledgeBase',
                'CreateSession',
                'DeleteAssistant',
                'DeleteAssistantAssociation',
                'DeleteContent',
                'DeleteKnowledgeBase',
                'NotifyRecommendationsReceived',
                'RemoveKnowledgeBaseTemplateUri',
                'StartContentUpload',
                'UpdateContent',
                'UpdateKnowledgeBaseTemplateUri'
            ],
            Read: [
                'GetAssistant',
                'GetAssistantAssociation',
                'GetContent',
                'GetContentSummary',
                'GetKnowledgeBase',
                'GetRecommendations',
                'GetSession',
                'ListTagsForResource',
                'QueryAssistant',
                'SearchContent',
                'SearchSessions'
            ],
            List: [
                'ListAssistantAssociations',
                'ListAssistants',
                'ListContents',
                'ListKnowledgeBases'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create an assistant
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAssistant.html
     */
    toCreateAssistant() {
        return this.to('CreateAssistant');
    }
    /**
     * Grants permission to create an association between an assistant and another resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateAssistantAssociation.html
     */
    toCreateAssistantAssociation() {
        return this.to('CreateAssistantAssociation');
    }
    /**
     * Grants permission to create content
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html
     */
    toCreateContent() {
        return this.to('CreateContent');
    }
    /**
     * Grants permission to create a knowledge base
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateKnowledgeBase.html
     */
    toCreateKnowledgeBase() {
        return this.to('CreateKnowledgeBase');
    }
    /**
     * Grants permission to create a session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateSession.html
     */
    toCreateSession() {
        return this.to('CreateSession');
    }
    /**
     * Grants permission to delete an assistant
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAssistant.html
     */
    toDeleteAssistant() {
        return this.to('DeleteAssistant');
    }
    /**
     * Grants permission to delete an assistant association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteAssistantAssociation.html
     */
    toDeleteAssistantAssociation() {
        return this.to('DeleteAssistantAssociation');
    }
    /**
     * Grants permission to delete content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteContent.html
     */
    toDeleteContent() {
        return this.to('DeleteContent');
    }
    /**
     * Grants permission to delete a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html
     */
    toDeleteKnowledgeBase() {
        return this.to('DeleteKnowledgeBase');
    }
    /**
     * Grants permission to retrieve information about an assistant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAssistant.html
     */
    toGetAssistant() {
        return this.to('GetAssistant');
    }
    /**
     * Grants permission to retrieve information about an assistant association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetAssistantAssociation.html
     */
    toGetAssistantAssociation() {
        return this.to('GetAssistantAssociation');
    }
    /**
     * Grants permission to retrieve content, including a pre-signed URL to download the content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html
     */
    toGetContent() {
        return this.to('GetContent');
    }
    /**
     * Grants permission to retrieve summary information about the content
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContentSummary.html
     */
    toGetContentSummary() {
        return this.to('GetContentSummary');
    }
    /**
     * Grants permission to retrieve information about the knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetKnowledgeBase.html
     */
    toGetKnowledgeBase() {
        return this.to('GetKnowledgeBase');
    }
    /**
     * Grants permission to retrieve recommendations for the specified session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html
     */
    toGetRecommendations() {
        return this.to('GetRecommendations');
    }
    /**
     * Grants permission to retrieve information for a specified session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetSession.html
     */
    toGetSession() {
        return this.to('GetSession');
    }
    /**
     * Grants permission to list information about assistant associations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAssistantAssociations.html
     */
    toListAssistantAssociations() {
        return this.to('ListAssistantAssociations');
    }
    /**
     * Grants permission to list information about assistants
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListAssistants.html
     */
    toListAssistants() {
        return this.to('ListAssistants');
    }
    /**
     * Grants permission to list the content with a knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListContents.html
     */
    toListContents() {
        return this.to('ListContents');
    }
    /**
     * Grants permission to list information about knowledge bases
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListKnowledgeBases.html
     */
    toListKnowledgeBases() {
        return this.to('ListKnowledgeBases');
    }
    /**
     * Grants permission to list the tags for the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to remove the specified recommendations from the specified assistant's queue of newly available recommendations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html
     */
    toNotifyRecommendationsReceived() {
        return this.to('NotifyRecommendationsReceived');
    }
    /**
     * Grants permission to perform a manual search against the specified assistant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html
     */
    toQueryAssistant() {
        return this.to('QueryAssistant');
    }
    /**
     * Grants permission to remove a URI template from a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_RemoveKnowledgeBaseTemplateUri.html
     */
    toRemoveKnowledgeBaseTemplateUri() {
        return this.to('RemoveKnowledgeBaseTemplateUri');
    }
    /**
     * Grants permission to search for content referencing a specified knowledge base. Can be used to get a specific content resource by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html
     */
    toSearchContent() {
        return this.to('SearchContent');
    }
    /**
     * Grants permission to search for sessions referencing a specified assistant. Can be used to et a specific session resource by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchSessions.html
     */
    toSearchSessions() {
        return this.to('SearchSessions');
    }
    /**
     * Grants permission to get a URL to upload content to a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html
     */
    toStartContentUpload() {
        return this.to('StartContentUpload');
    }
    /**
     * Grants permission to add the specified tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update information about the content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html
     */
    toUpdateContent() {
        return this.to('UpdateContent');
    }
    /**
     * Grants permission to update the template URI of a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateKnowledgeBaseTemplateUri.html
     */
    toUpdateKnowledgeBaseTemplateUri() {
        return this.to('UpdateKnowledgeBaseTemplateUri');
    }
    /**
     * Adds a resource of type Assistant to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AssistantData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAssistant(assistantId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:wisdom:${region || '*'}:${account || '*'}:assistant/${assistantId}`);
    }
    /**
     * Adds a resource of type AssistantAssociation to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_AssistantAssociationData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param assistantAssociationId - Identifier for the assistantAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAssistantAssociation(assistantId, assistantAssociationId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:wisdom:${region || '*'}:${account || '*'}:association/${assistantId}/${assistantAssociationId}`);
    }
    /**
     * Adds a resource of type Content to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_ContentData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param contentId - Identifier for the contentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContent(knowledgeBaseId, contentId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:wisdom:${region || '*'}:${account || '*'}:content/${knowledgeBaseId}/${contentId}`);
    }
    /**
     * Adds a resource of type KnowledgeBase to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_KnowledgeBaseData.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKnowledgeBase(knowledgeBaseId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:wisdom:${region || '*'}:${account || '*'}:knowledge-base/${knowledgeBaseId}`);
    }
    /**
     * Adds a resource of type Session to the statement
     *
     * https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SessionData.html
     *
     * @param assistantId - Identifier for the assistantId.
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(assistantId, sessionId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:wisdom:${region || '*'}:${account || '*'}:session/${assistantId}/${sessionId}`);
    }
}
exports.Wisdom = Wisdom;
_a = JSII_RTTI_SYMBOL_1;
Wisdom[_a] = { fqn: "cdk-iam-floyd.Wisdom", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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