"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotfleetwise = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iotfleetwise](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iotfleetwise extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iotfleetwise](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'iotfleetwise';
        this.accessLevelList = {
            Write: [
                'AssociateVehicle',
                'CreateCampaign',
                'CreateDecoderManifest',
                'CreateFleet',
                'CreateModelManifest',
                'CreateSignalCatalog',
                'CreateVehicle',
                'DeleteCampaign',
                'DeleteDecoderManifest',
                'DeleteFleet',
                'DeleteModelManifest',
                'DeleteSignalCatalog',
                'DeleteVehicle',
                'DisassociateVehicle',
                'ImportDecoderManifest',
                'ImportSignalCatalog',
                'RegisterAccount',
                'UpdateCampaign',
                'UpdateDecoderManifest',
                'UpdateFleet',
                'UpdateModelManifest',
                'UpdateSignalCatalog',
                'UpdateVehicle'
            ],
            Read: [
                'GetCampaign',
                'GetDecoderManifest',
                'GetFleet',
                'GetModelManifest',
                'GetRegisterAccountStatus',
                'GetSignalCatalog',
                'GetVehicle',
                'GetVehicleStatus',
                'ListCampaigns',
                'ListDecoderManifests',
                'ListFleets',
                'ListFleetsForVehicle',
                'ListModelManifests',
                'ListSignalCatalogNodes',
                'ListSignalCatalogs',
                'ListVehicles',
                'ListVehiclesInFleet'
            ],
            List: [
                'ListDecoderManifestNetworkInterfaces',
                'ListDecoderManifestSignals',
                'ListModelManifestNodes'
            ]
        };
    }
    /**
     * Grants permission to associate the given vehicle to a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_AssociateVehicle.html
     */
    toAssociateVehicle() {
        return this.to('AssociateVehicle');
    }
    /**
     * Grants permission to create a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateCampaign.html
     */
    toCreateCampaign() {
        return this.to('CreateCampaign');
    }
    /**
     * Grants permission to create a decoder manifest for an existing model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateDecoderManifest.html
     */
    toCreateDecoderManifest() {
        return this.to('CreateDecoderManifest');
    }
    /**
     * Grants permission to create a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateFleet.html
     */
    toCreateFleet() {
        return this.to('CreateFleet');
    }
    /**
     * Grants permission to create a model manifest definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateModelManifest.html
     */
    toCreateModelManifest() {
        return this.to('CreateModelManifest');
    }
    /**
     * Grants permission to create a signal catalog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateSignalCatalog.html
     */
    toCreateSignalCatalog() {
        return this.to('CreateSignalCatalog');
    }
    /**
     * Grants permission to create a vehicle
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:CreateThing
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_CreateVehicle.html
     */
    toCreateVehicle() {
        return this.to('CreateVehicle');
    }
    /**
     * Grants permission to delete a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteCampaign.html
     */
    toDeleteCampaign() {
        return this.to('DeleteCampaign');
    }
    /**
     * Grants permission to delete the given decoder manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteDecoderManifest.html
     */
    toDeleteDecoderManifest() {
        return this.to('DeleteDecoderManifest');
    }
    /**
     * Grants permission to delete a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteFleet.html
     */
    toDeleteFleet() {
        return this.to('DeleteFleet');
    }
    /**
     * Grants permission to delete the given model manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteModelManifest.html
     */
    toDeleteModelManifest() {
        return this.to('DeleteModelManifest');
    }
    /**
     * Grants permission to delete a specific signal catalog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteSignalCatalog.html
     */
    toDeleteSignalCatalog() {
        return this.to('DeleteSignalCatalog');
    }
    /**
     * Grants permission to delete a vehicle
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DeleteVehicle.html
     */
    toDeleteVehicle() {
        return this.to('DeleteVehicle');
    }
    /**
     * Grants permission to disassociate a vehicle from an existing fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_DisassociateVehicle.html
     */
    toDisassociateVehicle() {
        return this.to('DisassociateVehicle');
    }
    /**
     * Grants permission to get summary information for a given campaign
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetCampaign.html
     */
    toGetCampaign() {
        return this.to('GetCampaign');
    }
    /**
     * Grants permission to get summary information for a given decoder manifest definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetDecoderManifest.html
     */
    toGetDecoderManifest() {
        return this.to('GetDecoderManifest');
    }
    /**
     * Grants permission to get summary information for a fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetFleet.html
     */
    toGetFleet() {
        return this.to('GetFleet');
    }
    /**
     * Grants permission to get summary information for a given model manifest definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetModelManifest.html
     */
    toGetModelManifest() {
        return this.to('GetModelManifest');
    }
    /**
     * Grants permission to get the account registration status with IoT FleetWise
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetRegisterAccountStatus.html
     */
    toGetRegisterAccountStatus() {
        return this.to('GetRegisterAccountStatus');
    }
    /**
     * Grants permission to get summary information for a specific signal catalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetSignalCatalog.html
     */
    toGetSignalCatalog() {
        return this.to('GetSignalCatalog');
    }
    /**
     * Grants permission to get summary information for a vehicle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetVehicle.html
     */
    toGetVehicle() {
        return this.to('GetVehicle');
    }
    /**
     * Grants permission to get the status of the campaigns running on a specific vehicle
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_GetVehicleStatus.html
     */
    toGetVehicleStatus() {
        return this.to('GetVehicleStatus');
    }
    /**
     * Grants permission to import an existing decoder manifest
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ImportDecoderManifest.html
     */
    toImportDecoderManifest() {
        return this.to('ImportDecoderManifest');
    }
    /**
     * Grants permission to create a signal catalog by importing existing definitions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ImportSignalCatalog.html
     */
    toImportSignalCatalog() {
        return this.to('ImportSignalCatalog');
    }
    /**
     * Grants permission to list campaigns
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListCampaigns.html
     */
    toListCampaigns() {
        return this.to('ListCampaigns');
    }
    /**
     * Grants permission to list network interfaces associated to the existing decoder manifest
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifestNetworkInterfaces.html
     */
    toListDecoderManifestNetworkInterfaces() {
        return this.to('ListDecoderManifestNetworkInterfaces');
    }
    /**
     * Grants permission to list decoder manifest signals
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifestSignals.html
     */
    toListDecoderManifestSignals() {
        return this.to('ListDecoderManifestSignals');
    }
    /**
     * Grants permission to list all decoder manifests, with an optional filter on model manifest
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListDecoderManifests.html
     */
    toListDecoderManifests() {
        return this.to('ListDecoderManifests');
    }
    /**
     * Grants permission to list all fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListFleets.html
     */
    toListFleets() {
        return this.to('ListFleets');
    }
    /**
     * Grants permission to list all the fleets that the given vehicle is associated with
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListFleetsForVehicle.html
     */
    toListFleetsForVehicle() {
        return this.to('ListFleetsForVehicle');
    }
    /**
     * Grants permission to list all nodes for the given model manifest
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListModelManifestNodes.html
     */
    toListModelManifestNodes() {
        return this.to('ListModelManifestNodes');
    }
    /**
     * Grants permission to list all model manifests, with an optional filter on signal catalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListModelManifests.html
     */
    toListModelManifests() {
        return this.to('ListModelManifests');
    }
    /**
     * Grants permission to list all nodes for a given signal catalog
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_.html
     */
    toListSignalCatalogNodes() {
        return this.to('ListSignalCatalogNodes');
    }
    /**
     * Grants permission to list all signal catalogs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListSignalCatalogs.html
     */
    toListSignalCatalogs() {
        return this.to('ListSignalCatalogs');
    }
    /**
     * Grants permission to list all vehicles, with an optional filter on model manifest
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListVehicles.html
     */
    toListVehicles() {
        return this.to('ListVehicles');
    }
    /**
     * Grants permission to list vehicles in the given fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_ListVehiclesInFleet.html
     */
    toListVehiclesInFleet() {
        return this.to('ListVehiclesInFleet');
    }
    /**
     * Grants permission to register an AWS account to IoT FleetWise
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_RegisterAccount.html
     */
    toRegisterAccount() {
        return this.to('RegisterAccount');
    }
    /**
     * Grants permission to update the given campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateCampaign.html
     */
    toUpdateCampaign() {
        return this.to('UpdateCampaign');
    }
    /**
     * Grants permission to update a decoder manifest defnition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateDecoderManifest.html
     */
    toUpdateDecoderManifest() {
        return this.to('UpdateDecoderManifest');
    }
    /**
     * Grants permission to update the fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateFleet.html
     */
    toUpdateFleet() {
        return this.to('UpdateFleet');
    }
    /**
     * Grants permission to update the given model manifest definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateModelManifest.html
     */
    toUpdateModelManifest() {
        return this.to('UpdateModelManifest');
    }
    /**
     * Grants permission to update a specific signal catalog definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateSignalCatalog.html
     */
    toUpdateSignalCatalog() {
        return this.to('UpdateSignalCatalog');
    }
    /**
     * Grants permission to update the vehicle
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUpdateToModelManifestArn()
     * - .ifUpdateToDecoderManifestArn()
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/apireference/API_UpdateVehicle.html
     */
    toUpdateVehicle() {
        return this.to('UpdateVehicle');
    }
    /**
     * Adds a resource of type campaign to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param campaignName - Identifier for the campaignName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onCampaign(campaignName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotfleetwise:${region || '*'}:${account || '*'}:campaign/${campaignName}`);
    }
    /**
     * Adds a resource of type decodermanifest to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDecodermanifest(name, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotfleetwise:${region || '*'}:${account || '*'}:decoder-manifest/${name}`);
    }
    /**
     * Adds a resource of type fleet to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onFleet(fleetId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotfleetwise:${region || '*'}:${account || '*'}:fleet/${fleetId}`);
    }
    /**
     * Adds a resource of type modelmanifest to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onModelmanifest(name, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotfleetwise:${region || '*'}:${account || '*'}:model-manifest/${name}`);
    }
    /**
     * Adds a resource of type signalcatalog to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSignalcatalog(name, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotfleetwise:${region || '*'}:${account || '*'}:signal-catalog/${name}`);
    }
    /**
     * Adds a resource of type vehicle to the statement
     *
     * https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/iot-vehicle-wise.html
     *
     * @param vehicleId - Identifier for the vehicleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onVehicle(vehicleId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:iotfleetwise:${region || '*'}:${account || '*'}:vehicle/${vehicleId}`);
    }
    /**
     * Filters access by a list of IoT FleetWise Decoder Manifest ARNs
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html
     *
     * Applies to actions:
     * - .toUpdateVehicle()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUpdateToDecoderManifestArn(value, operator) {
        return this.if(`UpdateToDecoderManifestArn`, value, operator || 'StringLike');
    }
    /**
     * Filters access by a list of IoT FleetWise Model Manifest ARNs
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleetwise.html
     *
     * Applies to actions:
     * - .toUpdateVehicle()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUpdateToModelManifestArn(value, operator) {
        return this.if(`UpdateToModelManifestArn`, value, operator || 'StringLike');
    }
}
exports.Iotfleetwise = Iotfleetwise;
_a = JSII_RTTI_SYMBOL_1;
Iotfleetwise[_a] = { fqn: "cdk-iam-floyd.Iotfleetwise", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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