import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [grafana](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedgrafana.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Grafana extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to upgrade a workspace with a license
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - aws-marketplace:ViewSubscriptions
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toAssociateLicense(): this;
    /**
     * Grants permission to create a workspace
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - organizations:DescribeOrganization
     * - sso:CreateManagedApplicationInstance
     * - sso:DescribeRegisteredRegions
     * - sso:GetSharedSsoConfiguration
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toCreateWorkspace(): this;
    /**
     * Grants permission to delete a workspace
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toDeleteWorkspace(): this;
    /**
     * Grants permission to describe a workspace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toDescribeWorkspace(): this;
    /**
     * Grants permission to describe authetication providers on a workspace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toDescribeWorkspaceAuthentication(): this;
    /**
     * Grants permission to remove a license from a workspace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toDisassociateLicense(): this;
    /**
     * Grants permission to list the permissions on a wokspace
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toListPermissions(): this;
    /**
     * Grants permission to list workspaces
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toListWorkspaces(): this;
    /**
     * Grants permission to modify the permissions on a workspace
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toUpdatePermissions(): this;
    /**
     * Grants permission to modify a workspace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toUpdateWorkspace(): this;
    /**
     * Grants permission to modify authetication providers on a workspace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/AMG-and-IAM.html
     */
    toUpdateWorkspaceAuthentication(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type workspace to the statement
     *
     * https://docs.aws.amazon.com/grafana/latest/userguide/security-iam.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWorkspace(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [grafana](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedgrafana.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
