"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Swf = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [swf](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpleworkflowservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Swf extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [swf](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpleworkflowservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'swf';
        this.accessLevelList = {
            Write: [
                'CancelTimer',
                'CancelWorkflowExecution',
                'CompleteWorkflowExecution',
                'ContinueAsNewWorkflowExecution',
                'DeprecateActivityType',
                'DeprecateDomain',
                'DeprecateWorkflowType',
                'FailWorkflowExecution',
                'PollForActivityTask',
                'PollForDecisionTask',
                'RecordActivityTaskHeartbeat',
                'RecordMarker',
                'RegisterActivityType',
                'RegisterDomain',
                'RegisterWorkflowType',
                'RequestCancelActivityTask',
                'RequestCancelExternalWorkflowExecution',
                'RequestCancelWorkflowExecution',
                'RespondActivityTaskCanceled',
                'RespondActivityTaskCompleted',
                'RespondActivityTaskFailed',
                'RespondDecisionTaskCompleted',
                'ScheduleActivityTask',
                'SignalExternalWorkflowExecution',
                'SignalWorkflowExecution',
                'StartChildWorkflowExecution',
                'StartTimer',
                'StartWorkflowExecution',
                'TerminateWorkflowExecution',
                'UndeprecateActivityType',
                'UndeprecateDomain',
                'UndeprecateWorkflowType'
            ],
            Read: [
                'CountClosedWorkflowExecutions',
                'CountOpenWorkflowExecutions',
                'CountPendingActivityTasks',
                'CountPendingDecisionTasks',
                'DescribeActivityType',
                'DescribeDomain',
                'DescribeWorkflowExecution',
                'DescribeWorkflowType',
                'GetWorkflowExecutionHistory'
            ],
            List: [
                'ListActivityTypes',
                'ListClosedWorkflowExecutions',
                'ListDomains',
                'ListOpenWorkflowExecutions',
                'ListTagsForResource',
                'ListWorkflowTypes'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Description for CancelTimer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toCancelTimer() {
        return this.to('CancelTimer');
    }
    /**
     * Description for CancelWorkflowExecution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toCancelWorkflowExecution() {
        return this.to('CancelWorkflowExecution');
    }
    /**
     * Description for CompleteWorkflowExecution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toCompleteWorkflowExecution() {
        return this.to('CompleteWorkflowExecution');
    }
    /**
     * Description for ContinueAsNewWorkflowExecution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toContinueAsNewWorkflowExecution() {
        return this.to('ContinueAsNewWorkflowExecution');
    }
    /**
     * Returns the number of closed workflow executions within the given domain that meet the specified filtering criteria
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTagFilterTag()
     * - .ifTypeFilterName()
     * - .ifTypeFilterVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_CountClosedWorkflowExecutions.html
     */
    toCountClosedWorkflowExecutions() {
        return this.to('CountClosedWorkflowExecutions');
    }
    /**
     * Returns the number of open workflow executions within the given domain that meet the specified filtering criteria
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTagFilterTag()
     * - .ifTypeFilterName()
     * - .ifTypeFilterVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_CountOpenWorkflowExecutions.html
     */
    toCountOpenWorkflowExecutions() {
        return this.to('CountOpenWorkflowExecutions');
    }
    /**
     * Returns the estimated number of activity tasks in the specified task list
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTaskListName()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_CountPendingActivityTasks.html
     */
    toCountPendingActivityTasks() {
        return this.to('CountPendingActivityTasks');
    }
    /**
     * Returns the estimated number of decision tasks in the specified task list
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTaskListName()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_CountPendingDecisionTasks.html
     */
    toCountPendingDecisionTasks() {
        return this.to('CountPendingDecisionTasks');
    }
    /**
     * Deprecates the specified activity type
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifActivityTypeName()
     * - .ifActivityTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_DeprecateActivityType.html
     */
    toDeprecateActivityType() {
        return this.to('DeprecateActivityType');
    }
    /**
     * Deprecates the specified domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_DeprecateDomain.html
     */
    toDeprecateDomain() {
        return this.to('DeprecateDomain');
    }
    /**
     * Deprecates the specified workflow type
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifWorkflowTypeName()
     * - .ifWorkflowTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_DeprecateWorkflowType.html
     */
    toDeprecateWorkflowType() {
        return this.to('DeprecateWorkflowType');
    }
    /**
     * Returns information about the specified activity type
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifActivityTypeName()
     * - .ifActivityTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_DescribeActivityType.html
     */
    toDescribeActivityType() {
        return this.to('DescribeActivityType');
    }
    /**
     * Returns information about the specified domain, including description and status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_DescribeDomain.html
     */
    toDescribeDomain() {
        return this.to('DescribeDomain');
    }
    /**
     * Returns information about the specified workflow execution including its type and some statistics
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_DescribeWorkflowExecution.html
     */
    toDescribeWorkflowExecution() {
        return this.to('DescribeWorkflowExecution');
    }
    /**
     * Returns information about the specified workflow type
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifWorkflowTypeName()
     * - .ifWorkflowTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_DescribeWorkflowType.html
     */
    toDescribeWorkflowType() {
        return this.to('DescribeWorkflowType');
    }
    /**
     * Description for FailWorkflowExecution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toFailWorkflowExecution() {
        return this.to('FailWorkflowExecution');
    }
    /**
     * Returns the history of the specified workflow execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_GetWorkflowExecutionHistory.html
     */
    toGetWorkflowExecutionHistory() {
        return this.to('GetWorkflowExecutionHistory');
    }
    /**
     * Returns information about all activities registered in the specified domain that match the specified name and registration status
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_ListActivityTypes.html
     */
    toListActivityTypes() {
        return this.to('ListActivityTypes');
    }
    /**
     * Returns a list of closed workflow executions in the specified domain that meet the filtering criteria
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifTagFilterTag()
     * - .ifTypeFilterName()
     * - .ifTypeFilterVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_ListClosedWorkflowExecutions.html
     */
    toListClosedWorkflowExecutions() {
        return this.to('ListClosedWorkflowExecutions');
    }
    /**
     * Returns the list of domains registered in the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_ListDomains.html
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Returns a list of open workflow executions in the specified domain that meet the filtering criteria
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifTagFilterTag()
     * - .ifTypeFilterName()
     * - .ifTypeFilterVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_ListOpenWorkflowExecutions.html
     */
    toListOpenWorkflowExecutions() {
        return this.to('ListOpenWorkflowExecutions');
    }
    /**
     * This action lists tags for an AWS SWF resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Returns information about workflow types in the specified domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_ListWorkflowTypes.html
     */
    toListWorkflowTypes() {
        return this.to('ListWorkflowTypes');
    }
    /**
     * Used by workers to get an ActivityTask from the specified activity taskList
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTaskListName()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_PollForActivityTask.html
     */
    toPollForActivityTask() {
        return this.to('PollForActivityTask');
    }
    /**
     * Used by deciders to get a DecisionTask from the specified decision taskList
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTaskListName()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_PollForDecisionTask.html
     */
    toPollForDecisionTask() {
        return this.to('PollForDecisionTask');
    }
    /**
     * Used by activity workers to report to the service that the ActivityTask represented by the specified taskToken is still making progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RecordActivityTaskHeartbeat.html
     */
    toRecordActivityTaskHeartbeat() {
        return this.to('RecordActivityTaskHeartbeat');
    }
    /**
     * Description for RecordMarker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toRecordMarker() {
        return this.to('RecordMarker');
    }
    /**
     * Registers a new activity type along with its configuration settings in the specified domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDefaultTaskListName()
     * - .ifName()
     * - .ifVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RegisterActivityType.html
     */
    toRegisterActivityType() {
        return this.to('RegisterActivityType');
    }
    /**
     * Registers a new domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RegisterDomain.html
     */
    toRegisterDomain() {
        return this.to('RegisterDomain');
    }
    /**
     * Registers a new workflow type and its configuration settings in the specified domain
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDefaultTaskListName()
     * - .ifName()
     * - .ifVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RegisterWorkflowType.html
     */
    toRegisterWorkflowType() {
        return this.to('RegisterWorkflowType');
    }
    /**
     * Description for RequestCancelActivityTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toRequestCancelActivityTask() {
        return this.to('RequestCancelActivityTask');
    }
    /**
     * Description for RequestCancelExternalWorkflowExecution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toRequestCancelExternalWorkflowExecution() {
        return this.to('RequestCancelExternalWorkflowExecution');
    }
    /**
     * Records a WorkflowExecutionCancelRequested event in the currently running workflow execution identified by the given domain, workflowId, and runId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RequestCancelWorkflowExecution.html
     */
    toRequestCancelWorkflowExecution() {
        return this.to('RequestCancelWorkflowExecution');
    }
    /**
     * Used by workers to tell the service that the ActivityTask identified by the taskToken was successfully canceled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RespondActivityTaskCanceled.html
     */
    toRespondActivityTaskCanceled() {
        return this.to('RespondActivityTaskCanceled');
    }
    /**
     * Used by workers to tell the service that the ActivityTask identified by the taskToken completed successfully with a result (if provided)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifActivityTypeName()
     * - .ifActivityTypeVersion()
     * - .ifTagListMember0()
     * - .ifTagListMember1()
     * - .ifTagListMember2()
     * - .ifTagListMember3()
     * - .ifTagListMember4()
     * - .ifTaskListName()
     * - .ifWorkflowTypeName()
     * - .ifWorkflowTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RespondActivityTaskCompleted.html
     */
    toRespondActivityTaskCompleted() {
        return this.to('RespondActivityTaskCompleted');
    }
    /**
     * Used by workers to tell the service that the ActivityTask identified by the taskToken has failed with reason (if specified)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RespondActivityTaskFailed.html
     */
    toRespondActivityTaskFailed() {
        return this.to('RespondActivityTaskFailed');
    }
    /**
     * Used by deciders to tell the service that the DecisionTask identified by the taskToken has successfully completed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_RespondDecisionTaskCompleted.html
     */
    toRespondDecisionTaskCompleted() {
        return this.to('RespondDecisionTaskCompleted');
    }
    /**
     * Description for ScheduleActivityTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toScheduleActivityTask() {
        return this.to('ScheduleActivityTask');
    }
    /**
     * Description for SignalExternalWorkflowExecution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toSignalExternalWorkflowExecution() {
        return this.to('SignalExternalWorkflowExecution');
    }
    /**
     * Records a WorkflowExecutionSignaled event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_SignalWorkflowExecution.html
     */
    toSignalWorkflowExecution() {
        return this.to('SignalWorkflowExecution');
    }
    /**
     * Description for StartChildWorkflowExecution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toStartChildWorkflowExecution() {
        return this.to('StartChildWorkflowExecution');
    }
    /**
     * Description for StartTimer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_Decision.html
     */
    toStartTimer() {
        return this.to('StartTimer');
    }
    /**
     * Starts an execution of the workflow type in the specified domain using the provided workflowId and input data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTagListMember0()
     * - .ifTagListMember1()
     * - .ifTagListMember2()
     * - .ifTagListMember3()
     * - .ifTagListMember4()
     * - .ifTaskListName()
     * - .ifWorkflowTypeName()
     * - .ifWorkflowTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_StartWorkflowExecution.html
     */
    toStartWorkflowExecution() {
        return this.to('StartWorkflowExecution');
    }
    /**
     * This action tags an AWS SWF resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Records a WorkflowExecutionTerminated event and forces closure of the workflow execution identified by the given domain, runId, and workflowId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_TerminateWorkflowExecution.html
     */
    toTerminateWorkflowExecution() {
        return this.to('TerminateWorkflowExecution');
    }
    /**
     * Undeprecates a previously deprecated activity type
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifActivityTypeName()
     * - .ifActivityTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_UndeprecateActivityType.html
     */
    toUndeprecateActivityType() {
        return this.to('UndeprecateActivityType');
    }
    /**
     * Undeprecates a previously deprecated domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_UndeprecateDomain.html
     */
    toUndeprecateDomain() {
        return this.to('UndeprecateDomain');
    }
    /**
     * Undeprecates a previously deprecated workflow type
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifWorkflowTypeName()
     * - .ifWorkflowTypeVersion()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_UndeprecateWorkflowType.html
     */
    toUndeprecateWorkflowType() {
        return this.to('UndeprecateWorkflowType');
    }
    /**
     * This action removes a tag from an AWS SWF resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/amazonswf/latest/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-domains.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomain(domainName, account, partition) {
        return this.on(`arn:${partition || 'aws'}:swf::${account || '*'}:/domain/${domainName}`);
    }
    /**
     * Constrains the policy statement to only an activity type of the specified name
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toDeprecateActivityType()
     * - .toDescribeActivityType()
     * - .toRespondActivityTaskCompleted()
     * - .toUndeprecateActivityType()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActivityTypeName(value, operator) {
        return this.if(`activityType.name`, value, operator || 'StringLike');
    }
    /**
     * Contstrains the policy statement to only an activity type of the specified version
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toDeprecateActivityType()
     * - .toDescribeActivityType()
     * - .toRespondActivityTaskCompleted()
     * - .toUndeprecateActivityType()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActivityTypeVersion(value, operator) {
        return this.if(`activityType.version`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that specify a matching defaultTaskList name
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRegisterActivityType()
     * - .toRegisterWorkflowType()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDefaultTaskListName(value, operator) {
        return this.if(`defaultTaskList.name`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only activities or workflows with the specified name
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRegisterActivityType()
     * - .toRegisterWorkflowType()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifName(value, operator) {
        return this.if(`name`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that specify a matching tagFilter.tag value
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toCountClosedWorkflowExecutions()
     * - .toCountOpenWorkflowExecutions()
     * - .toListClosedWorkflowExecutions()
     * - .toListOpenWorkflowExecutions()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTagFilterTag(value, operator) {
        return this.if(`tagFilter.tag`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that contain the specified tag
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTagListMember0(value, operator) {
        return this.if(`tagList.member.0`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that contain the specified tag
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTagListMember1(value, operator) {
        return this.if(`tagList.member.1`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that contain the specified tag
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTagListMember2(value, operator) {
        return this.if(`tagList.member.2`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that contain the specified tag
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTagListMember3(value, operator) {
        return this.if(`tagList.member.3`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that contain the specified tag
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTagListMember4(value, operator) {
        return this.if(`tagList.member.4`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that specify a tasklist with the specified name
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toCountPendingActivityTasks()
     * - .toCountPendingDecisionTasks()
     * - .toPollForActivityTask()
     * - .toPollForDecisionTask()
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTaskListName(value, operator) {
        return this.if(`taskList.name`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that specify a type filter with the specified name
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toCountClosedWorkflowExecutions()
     * - .toCountOpenWorkflowExecutions()
     * - .toListClosedWorkflowExecutions()
     * - .toListOpenWorkflowExecutions()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTypeFilterName(value, operator) {
        return this.if(`typeFilter.name`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that specify a type filter with the specified version
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toCountClosedWorkflowExecutions()
     * - .toCountOpenWorkflowExecutions()
     * - .toListClosedWorkflowExecutions()
     * - .toListOpenWorkflowExecutions()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTypeFilterVersion(value, operator) {
        return this.if(`typeFilter.version`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only activities or workflows with the specified version
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toRegisterActivityType()
     * - .toRegisterWorkflowType()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVersion(value, operator) {
        return this.if(`version`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that specify a workflow type of the specified name
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toDeprecateWorkflowType()
     * - .toDescribeWorkflowType()
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     * - .toUndeprecateWorkflowType()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkflowTypeName(value, operator) {
        return this.if(`workflowType.name`, value, operator || 'StringLike');
    }
    /**
     * Constrains the policy statement to only requests that specify a workflow type of the specified version
     *
     * https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html##swf-dev-iam.api
     *
     * Applies to actions:
     * - .toDeprecateWorkflowType()
     * - .toDescribeWorkflowType()
     * - .toRespondActivityTaskCompleted()
     * - .toStartWorkflowExecution()
     * - .toUndeprecateWorkflowType()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkflowTypeVersion(value, operator) {
        return this.if(`workflowType.version`, value, operator || 'StringLike');
    }
}
exports.Swf = Swf;
_a = JSII_RTTI_SYMBOL_1;
Swf[_a] = { fqn: "cdk-iam-floyd.Swf", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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