import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [workspaces-web](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspacesweb.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class WorkspacesWeb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate browser settings to web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateBrowserSettings.html
     */
    toAssociateBrowserSettings(): this;
    /**
     * Grants permission to associate network settings to web portals
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:CreateNetworkInterfacePermission
     * - ec2:CreateTags
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteNetworkInterfacePermission
     * - ec2:ModifyNetworkInterfaceAttribute
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateNetworkSettings.html
     */
    toAssociateNetworkSettings(): this;
    /**
     * Grants permission to associate trust stores with web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateTrustStore.html
     */
    toAssociateTrustStore(): this;
    /**
     * Grants permission to associate user settings with web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_AssociateUserSettings.html
     */
    toAssociateUserSettings(): this;
    /**
     * Grants permission to create browser settings
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateBrowserSettings.html
     */
    toCreateBrowserSettings(): this;
    /**
     * Grants permission to create identity providers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateIdentityProvider.html
     */
    toCreateIdentityProvider(): this;
    /**
     * Grants permission to create network settings
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateNetworkSettings.html
     */
    toCreateNetworkSettings(): this;
    /**
     * Grants permission to create web portals
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - kms:CreateGrant
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreatePortal.html
     */
    toCreatePortal(): this;
    /**
     * Grants permission to create trust stores
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateTrustStore.html
     */
    toCreateTrustStore(): this;
    /**
     * Grants permission to create user settings
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateUserSettings.html
     */
    toCreateUserSettings(): this;
    /**
     * Grants permission to delete browser settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteBrowserSettings.html
     */
    toDeleteBrowserSettings(): this;
    /**
     * Grants permission to delete identity providers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteIdentityProvider.html
     */
    toDeleteIdentityProvider(): this;
    /**
     * Grants permission to delete network settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteNetworkSettings.html
     */
    toDeleteNetworkSettings(): this;
    /**
     * Grants permission to delete web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeletePortal.html
     */
    toDeletePortal(): this;
    /**
     * Grants permission to delete trust stores
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteTrustStore.html
     */
    toDeleteTrustStore(): this;
    /**
     * Grants permission to delete user settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DeleteUserSettings.html
     */
    toDeleteUserSettings(): this;
    /**
     * Grants permission to disassociate browser settings from web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateBrowserSettings.html
     */
    toDisassociateBrowserSettings(): this;
    /**
     * Grants permission to disassociate network settings from web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateNetworkSettings.html
     */
    toDisassociateNetworkSettings(): this;
    /**
     * Grants permission to disassociate trust stores from web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateTrustStore.html
     */
    toDisassociateTrustStore(): this;
    /**
     * Grants permission to disassociate user settings from web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_DisassociateUserSettings.html
     */
    toDisassociateUserSettings(): this;
    /**
     * Grants permission to get details on browser settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetBrowserSettings.html
     */
    toGetBrowserSettings(): this;
    /**
     * Grants permission to get details on identity providers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetIdentityProvider.html
     */
    toGetIdentityProvider(): this;
    /**
     * Grants permission to get details on network settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetNetworkSettings.html
     */
    toGetNetworkSettings(): this;
    /**
     * Grants permission to get details on web portals
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetPortal.html
     */
    toGetPortal(): this;
    /**
     * Grants permission to get service provider metadata information for web portals
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetPortalServiceProviderMetadata.html
     */
    toGetPortalServiceProviderMetadata(): this;
    /**
     * Grants permission to get details on trust stores
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetTrustStore.html
     */
    toGetTrustStore(): this;
    /**
     * Grants permission to get certificates from trust stores
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetTrustStoreCertificate.html
     */
    toGetTrustStoreCertificate(): this;
    /**
     * Grants permission to get details on user settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_GetUserSettings.html
     */
    toGetUserSettings(): this;
    /**
     * Grants permission to list browser settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListBrowserSettings.html
     */
    toListBrowserSettings(): this;
    /**
     * Grants permission to list identity providers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListIdentityProviders.html
     */
    toListIdentityProviders(): this;
    /**
     * Grants permission to list network settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListNetworkSettings.html
     */
    toListNetworkSettings(): this;
    /**
     * Grants permission to list web portals
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListPortals.html
     */
    toListPortals(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list certificates in a trust store
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListTrustStoreCertificates.html
     */
    toListTrustStoreCertificates(): this;
    /**
     * Grants permission to list trust stores
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListTrustStores.html
     */
    toListTrustStores(): this;
    /**
     * Grants permission to list user settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_ListUserSettings.html
     */
    toListUserSettings(): this;
    /**
     * Grants permission to add one or more tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update browser settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateBrowserSettings.html
     */
    toUpdateBrowserSettings(): this;
    /**
     * Grants permission to update identity provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateIdentityProvider.html
     */
    toUpdateIdentityProvider(): this;
    /**
     * Grants permission to update network settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateNetworkSettings.html
     */
    toUpdateNetworkSettings(): this;
    /**
     * Grants permission to update web portals
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdatePortal.html
     */
    toUpdatePortal(): this;
    /**
     * Grants permission to update trust stores
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateTrustStore.html
     */
    toUpdateTrustStore(): this;
    /**
     * Grants permission to update user settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_UpdateUserSettings.html
     */
    toUpdateUserSettings(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type browserSettings to the statement
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateBrowserSettings.html
     *
     * @param browserSettingsId - Identifier for the browserSettingsId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBrowserSettings(browserSettingsId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type networkSettings to the statement
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateNetworkSettings.html
     *
     * @param networkSettingsId - Identifier for the networkSettingsId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkSettings(networkSettingsId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type portal to the statement
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreatePortal.html
     *
     * @param portalId - Identifier for the portalId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPortal(portalId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type trustStore to the statement
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateTrustStore.html
     *
     * @param trustStoreId - Identifier for the trustStoreId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrustStore(trustStoreId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type userSettings to the statement
     *
     * https://docs.aws.amazon.com/workspaces-web/latest/APIReference/API_CreateUserSettings.html
     *
     * @param userSettingsId - Identifier for the userSettingsId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUserSettings(userSettingsId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [workspaces-web](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspacesweb.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
