"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// This file is used in the CDK variant of the package: cdk-iam-floyd
// @ts-ignore only available running bin/mkcdk
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _4_resources_1 = require("./4-resources");
/**
 * Adds "effect" functionality to the Policy Statement
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    /**
     * Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        // @ts-ignore only available after swapping 1-base
        statement.Effect = this.effect;
        return statement;
    }
    /**
     * Allow the actions in this statement
     */
    allow() {
        // @ts-ignore only available after swapping 1-base
        this.effect = aws_cdk_lib_1.aws_iam.Effect.ALLOW;
        return this;
    }
    /**
     * Deny the actions in this statement
     */
    deny() {
        // @ts-ignore only available after swapping 1-base
        this.effect = aws_cdk_lib_1.aws_iam.Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithEffect[_a] = { fqn: "cdk-iam-floyd.PolicyStatementWithEffect", version: "0.331.0" };
//# sourceMappingURL=data:application/json;base64,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