"""
Common Data Share
"""

import typing

# 数据来源：https://github.com/modood/Administrative-divisions-of-China
CHINA_ADMINISTRATIVE_DIVISION: dict[str, dict[str, list[str]]] = {
    "北京市": {
        "市辖区": [
            "东城区", "西城区", "朝阳区", "丰台区", "石景山区", "海淀区", "门头沟区", "房山区", "通州区", "顺义区", "昌平区", "大兴区", "怀柔区", "平谷区", "密云区",
            "延庆区"
        ]
    },
    "天津市": {
        "市辖区": [
            "和平区", "河东区", "河西区", "南开区", "河北区", "红桥区", "东丽区", "西青区", "津南区", "北辰区", "武清区", "宝坻区", "滨海新区", "宁河区", "静海区",
            "蓟州区"
        ]
    },
    "河北省": {
        "石家庄市": [
            "长安区", "桥西区", "新华区", "井陉矿区", "裕华区", "藁城区", "鹿泉区", "栾城区", "井陉县", "正定县", "行唐县", "灵寿县", "高邑县", "深泽县", "赞皇县",
            "无极县", "平山县", "元氏县", "赵县", "石家庄高新技术产业开发区", "石家庄循环化工园区", "辛集市", "晋州市", "新乐市"
        ],
        "唐山市": [
            "路南区", "路北区", "古冶区", "开平区", "丰南区", "丰润区", "曹妃甸区", "滦南县", "乐亭县", "迁西县", "玉田县", "河北唐山芦台经济开发区", "唐山市汉沽管理区",
            "唐山高新技术产业开发区", "河北唐山海港经济开发区", "遵化市", "迁安市", "滦州市"
        ],
        "秦皇岛市": ["海港区", "山海关区", "北戴河区", "抚宁区", "青龙满族自治县", "昌黎县", "卢龙县", "秦皇岛市经济技术开发区", "北戴河新区"],
        "邯郸市": [
            "邯山区", "丛台区", "复兴区", "峰峰矿区", "肥乡区", "永年区", "临漳县", "成安县", "大名县", "涉县", "磁县", "邱县", "鸡泽县", "广平县", "馆陶县", "魏县",
            "曲周县", "邯郸经济技术开发区", "邯郸冀南新区", "武安市"
        ],
        "邢台市": [
            "襄都区", "信都区", "任泽区", "南和区", "临城县", "内丘县", "柏乡县", "隆尧县", "宁晋县", "巨鹿县", "新河县", "广宗县", "平乡县", "威县", "清河县",
            "临西县", "河北邢台经济开发区", "南宫市", "沙河市"
        ],
        "保定市": [
            "竞秀区", "莲池区", "满城区", "清苑区", "徐水区", "涞水县", "阜平县", "定兴县", "唐县", "高阳县", "容城县", "涞源县", "望都县", "安新县", "易县",
            "曲阳县", "蠡县", "顺平县", "博野县", "雄县", "保定高新技术产业开发区", "保定白沟新城", "涿州市", "定州市", "安国市", "高碑店市"
        ],
        "张家口市": [
            "桥东区", "桥西区", "宣化区", "下花园区", "万全区", "崇礼区", "张北县", "康保县", "沽源县", "尚义县", "蔚县", "阳原县", "怀安县", "怀来县", "涿鹿县",
            "赤城县", "张家口经济开发区", "张家口市察北管理区", "张家口市塞北管理区"
        ],
        "承德市":
            ["双桥区", "双滦区", "鹰手营子矿区", "承德县", "兴隆县", "滦平县", "隆化县", "丰宁满族自治县", "宽城满族自治县", "围场满族蒙古族自治县", "承德高新技术产业开发区",
             "平泉市"],
        "沧州市": [
            "新华区", "运河区", "沧县", "青县", "东光县", "海兴县", "盐山县", "肃宁县", "南皮县", "吴桥县", "献县", "孟村回族自治县", "河北沧州经济开发区",
            "沧州高新技术产业开发区", "沧州渤海新区", "泊头市", "任丘市", "黄骅市", "河间市"
        ],
        "廊坊市": ["安次区", "广阳区", "固安县", "永清县", "香河县", "大城县", "文安县", "大厂回族自治县", "廊坊经济技术开发区", "霸州市", "三河市"],
        "衡水市": ["桃城区", "冀州区", "枣强县", "武邑县", "武强县", "饶阳县", "安平县", "故城县", "景县", "阜城县", "河北衡水高新技术产业开发区", "衡水滨湖新区", "深州市"]
    },
    "山西省": {
        "太原市": ["小店区", "迎泽区", "杏花岭区", "尖草坪区", "万柏林区", "晋源区", "清徐县", "阳曲县", "娄烦县", "山西转型综合改革示范区", "古交市"],
        "大同市": ["新荣区", "平城区", "云冈区", "云州区", "阳高县", "天镇县", "广灵县", "灵丘县", "浑源县", "左云县", "山西大同经济开发区"],
        "阳泉市": ["城区", "矿区", "郊区", "平定县", "盂县"],
        "长治市": ["潞州区", "上党区", "屯留区", "潞城区", "襄垣县", "平顺县", "黎城县", "壶关县", "长子县", "武乡县", "沁县", "沁源县", "山西长治高新技术产业园区"],
        "晋城市": ["城区", "沁水县", "阳城县", "陵川县", "泽州县", "高平市"],
        "朔州市": ["朔城区", "平鲁区", "山阴县", "应县", "右玉县", "山西朔州经济开发区", "怀仁市"],
        "晋中市": ["榆次区", "太谷区", "榆社县", "左权县", "和顺县", "昔阳县", "寿阳县", "祁县", "平遥县", "灵石县", "介休市"],
        "运城市": ["盐湖区", "临猗县", "万荣县", "闻喜县", "稷山县", "新绛县", "绛县", "垣曲县", "夏县", "平陆县", "芮城县", "永济市", "河津市"],
        "忻州市":
            ["忻府区", "定襄县", "五台县", "代县", "繁峙县", "宁武县", "静乐县", "神池县", "五寨县", "岢岚县", "河曲县", "保德县", "偏关县", "五台山风景名胜区",
             "原平市"],
        "临汾市": [
            "尧都区", "曲沃县", "翼城县", "襄汾县", "洪洞县", "古县", "安泽县", "浮山县", "吉县", "乡宁县", "大宁县", "隰县", "永和县", "蒲县", "汾西县", "侯马市",
            "霍州市"
        ],
        "吕梁市": ["离石区", "文水县", "交城县", "兴县", "临县", "柳林县", "石楼县", "岚县", "方山县", "中阳县", "交口县", "孝义市", "汾阳市"]
    },
    "内蒙古自治区": {
        "呼和浩特市": ["新城区", "回民区", "玉泉区", "赛罕区", "土默特左旗", "托克托县", "和林格尔县", "清水河县", "武川县", "呼和浩特经济技术开发区"],
        "包头市": ["东河区", "昆都仑区", "青山区", "石拐区", "白云鄂博矿区", "九原区", "土默特右旗", "固阳县", "达尔罕茂明安联合旗", "包头稀土高新技术产业开发区"],
        "乌海市": ["海勃湾区", "海南区", "乌达区"],
        "赤峰市": ["红山区", "元宝山区", "松山区", "阿鲁科尔沁旗", "巴林左旗", "巴林右旗", "林西县", "克什克腾旗", "翁牛特旗", "喀喇沁旗", "宁城县", "敖汉旗"],
        "通辽市": ["科尔沁区", "科尔沁左翼中旗", "科尔沁左翼后旗", "开鲁县", "库伦旗", "奈曼旗", "扎鲁特旗", "通辽经济技术开发区", "霍林郭勒市"],
        "鄂尔多斯市": ["东胜区", "康巴什区", "达拉特旗", "准格尔旗", "鄂托克前旗", "鄂托克旗", "杭锦旗", "乌审旗", "伊金霍洛旗"],
        "呼伦贝尔市": [
            "海拉尔区", "扎赉诺尔区", "阿荣旗", "莫力达瓦达斡尔族自治旗", "鄂伦春自治旗", "鄂温克族自治旗", "陈巴尔虎旗", "新巴尔虎左旗", "新巴尔虎右旗", "满洲里市", "牙克石市",
            "扎兰屯市", "额尔古纳市", "根河市"
        ],
        "巴彦淖尔市": ["临河区", "五原县", "磴口县", "乌拉特前旗", "乌拉特中旗", "乌拉特后旗", "杭锦后旗"],
        "乌兰察布市": ["集宁区", "卓资县", "化德县", "商都县", "兴和县", "凉城县", "察哈尔右翼前旗", "察哈尔右翼中旗", "察哈尔右翼后旗", "四子王旗", "丰镇市"],
        "兴安盟": ["乌兰浩特市", "阿尔山市", "科尔沁右翼前旗", "科尔沁右翼中旗", "扎赉特旗", "突泉县"],
        "锡林郭勒盟":
            ["二连浩特市", "锡林浩特市", "阿巴嘎旗", "苏尼特左旗", "苏尼特右旗", "东乌珠穆沁旗", "西乌珠穆沁旗", "太仆寺旗", "镶黄旗", "正镶白旗", "正蓝旗", "多伦县",
             "乌拉盖管委会"],
        "阿拉善盟": ["阿拉善左旗", "阿拉善右旗", "额济纳旗", "内蒙古阿拉善经济开发区"]
    },
    "辽宁省": {
        "沈阳市": ["和平区", "沈河区", "大东区", "皇姑区", "铁西区", "苏家屯区", "浑南区", "沈北新区", "于洪区", "辽中区", "康平县", "法库县", "新民市"],
        "大连市": ["中山区", "西岗区", "沙河口区", "甘井子区", "旅顺口区", "金州区", "普兰店区", "长海县", "瓦房店市", "庄河市"],
        "鞍山市": ["铁东区", "铁西区", "立山区", "千山区", "台安县", "岫岩满族自治县", "海城市"],
        "抚顺市": ["新抚区", "东洲区", "望花区", "顺城区", "抚顺县", "新宾满族自治县", "清原满族自治县"],
        "本溪市": ["平山区", "溪湖区", "明山区", "南芬区", "本溪满族自治县", "桓仁满族自治县"],
        "丹东市": ["元宝区", "振兴区", "振安区", "宽甸满族自治县", "东港市", "凤城市"],
        "锦州市": ["古塔区", "凌河区", "太和区", "黑山县", "义县", "凌海市", "北镇市"],
        "营口市": ["站前区", "西市区", "鲅鱼圈区", "老边区", "盖州市", "大石桥市"],
        "阜新市": ["海州区", "新邱区", "太平区", "清河门区", "细河区", "阜新蒙古族自治县", "彰武县"],
        "辽阳市": ["白塔区", "文圣区", "宏伟区", "弓长岭区", "太子河区", "辽阳县", "灯塔市"],
        "盘锦市": ["双台子区", "兴隆台区", "大洼区", "盘山县"],
        "铁岭市": ["银州区", "清河区", "铁岭县", "西丰县", "昌图县", "调兵山市", "开原市"],
        "朝阳市": ["双塔区", "龙城区", "朝阳县", "建平县", "喀喇沁左翼蒙古族自治县", "北票市", "凌源市"],
        "葫芦岛市": ["连山区", "龙港区", "南票区", "绥中县", "建昌县", "兴城市"]
    },
    "吉林省": {
        "长春市": [
            "南关区", "宽城区", "朝阳区", "二道区", "绿园区", "双阳区", "九台区", "农安县", "长春经济技术开发区", "长春净月高新技术产业开发区", "长春高新技术产业开发区",
            "长春汽车经济技术开发区", "榆树市", "德惠市", "公主岭市"
        ],
        "吉林市": ["昌邑区", "龙潭区", "船营区", "丰满区", "永吉县", "吉林经济开发区", "吉林高新技术产业开发区", "吉林中国新加坡食品区", "蛟河市", "桦甸市", "舒兰市", "磐石市"],
        "四平市": ["铁西区", "铁东区", "梨树县", "伊通满族自治县", "双辽市"],
        "辽源市": ["龙山区", "西安区", "东丰县", "东辽县"],
        "通化市": ["东昌区", "二道江区", "通化县", "辉南县", "柳河县", "梅河口市", "集安市"],
        "白山市": ["浑江区", "江源区", "抚松县", "靖宇县", "长白朝鲜族自治县", "临江市"],
        "松原市": ["宁江区", "前郭尔罗斯蒙古族自治县", "长岭县", "乾安县", "吉林松原经济开发区", "扶余市"],
        "白城市": ["洮北区", "镇赉县", "通榆县", "吉林白城经济开发区", "洮南市", "大安市"],
        "延边朝鲜族自治州": ["延吉市", "图们市", "敦化市", "珲春市", "龙井市", "和龙市", "汪清县", "安图县"]
    },
    "黑龙江省": {
        "哈尔滨市": [
            "道里区", "南岗区", "道外区", "平房区", "松北区", "香坊区", "呼兰区", "阿城区", "双城区", "依兰县", "方正县", "宾县", "巴彦县", "木兰县", "通河县",
            "延寿县", "尚志市", "五常市"
        ],
        "齐齐哈尔市": [
            "龙沙区", "建华区", "铁锋区", "昂昂溪区", "富拉尔基区", "碾子山区", "梅里斯达斡尔族区", "龙江县", "依安县", "泰来县", "甘南县", "富裕县", "克山县", "克东县",
            "拜泉县", "讷河市"
        ],
        "鸡西市": ["鸡冠区", "恒山区", "滴道区", "梨树区", "城子河区", "麻山区", "鸡东县", "虎林市", "密山市"],
        "鹤岗市": ["向阳区", "工农区", "南山区", "兴安区", "东山区", "兴山区", "萝北县", "绥滨县"],
        "双鸭山市": ["尖山区", "岭东区", "四方台区", "宝山区", "集贤县", "友谊县", "宝清县", "饶河县"],
        "大庆市": ["萨尔图区", "龙凤区", "让胡路区", "红岗区", "大同区", "肇州县", "肇源县", "林甸县", "杜尔伯特蒙古族自治县", "大庆高新技术产业开发区"],
        "伊春市": ["伊美区", "乌翠区", "友好区", "嘉荫县", "汤旺县", "丰林县", "大箐山县", "南岔县", "金林区", "铁力市"],
        "佳木斯市": ["向阳区", "前进区", "东风区", "郊区", "桦南县", "桦川县", "汤原县", "同江市", "富锦市", "抚远市"],
        "七台河市": ["新兴区", "桃山区", "茄子河区", "勃利县"],
        "牡丹江市": ["东安区", "阳明区", "爱民区", "西安区", "林口县", "牡丹江经济技术开发区", "绥芬河市", "海林市", "宁安市", "穆棱市", "东宁市"],
        "黑河市": ["爱辉区", "逊克县", "孙吴县", "北安市", "五大连池市", "嫩江市"],
        "绥化市": ["北林区", "望奎县", "兰西县", "青冈县", "庆安县", "明水县", "绥棱县", "安达市", "肇东市", "海伦市"],
        "大兴安岭地区": ["漠河市", "呼玛县", "塔河县", "加格达奇区", "松岭区", "新林区", "呼中区"]
    },
    "上海市": {
        "市辖区": [
            "黄浦区", "徐汇区", "长宁区", "静安区", "普陀区", "虹口区", "杨浦区", "闵行区", "宝山区", "嘉定区", "浦东新区", "金山区", "松江区", "青浦区", "奉贤区",
            "崇明区"
        ]
    },
    "江苏省": {
        "南京市": ["玄武区", "秦淮区", "建邺区", "鼓楼区", "浦口区", "栖霞区", "雨花台区", "江宁区", "六合区", "溧水区", "高淳区"],
        "无锡市": ["锡山区", "惠山区", "滨湖区", "梁溪区", "新吴区", "江阴市", "宜兴市"],
        "徐州市": ["鼓楼区", "云龙区", "贾汪区", "泉山区", "铜山区", "丰县", "沛县", "睢宁县", "徐州经济技术开发区", "新沂市", "邳州市"],
        "常州市": ["天宁区", "钟楼区", "新北区", "武进区", "金坛区", "溧阳市"],
        "苏州市": ["虎丘区", "吴中区", "相城区", "姑苏区", "吴江区", "苏州工业园区", "常熟市", "张家港市", "昆山市", "太仓市"],
        "南通市": ["崇川区", "港闸区", "通州区", "如东县", "南通经济技术开发区", "启东市", "如皋市", "海门市", "海安市"],
        "连云港市": ["连云区", "海州区", "赣榆区", "东海县", "灌云县", "灌南县", "连云港经济技术开发区", "连云港高新技术产业开发区"],
        "淮安市": ["淮安区", "淮阴区", "清江浦区", "洪泽区", "涟水县", "盱眙县", "金湖县", "淮安经济技术开发区"],
        "盐城市": ["亭湖区", "盐都区", "大丰区", "响水县", "滨海县", "阜宁县", "射阳县", "建湖县", "盐城经济技术开发区", "东台市"],
        "扬州市": ["广陵区", "邗江区", "江都区", "宝应县", "扬州经济技术开发区", "仪征市", "高邮市"],
        "镇江市": ["京口区", "润州区", "丹徒区", "镇江新区", "丹阳市", "扬中市", "句容市"],
        "泰州市": ["海陵区", "高港区", "姜堰区", "泰州医药高新技术产业开发区", "兴化市", "靖江市", "泰兴市"],
        "宿迁市": ["宿城区", "宿豫区", "沭阳县", "泗阳县", "泗洪县", "宿迁经济技术开发区"]
    },
    "浙江省": {
        "杭州市": ["上城区", "下城区", "江干区", "拱墅区", "西湖区", "滨江区", "萧山区", "余杭区", "富阳区", "临安区", "桐庐县", "淳安县", "建德市"],
        "宁波市": ["海曙区", "江北区", "北仑区", "镇海区", "鄞州区", "奉化区", "象山县", "宁海县", "余姚市", "慈溪市"],
        "温州市": ["鹿城区", "龙湾区", "瓯海区", "洞头区", "永嘉县", "平阳县", "苍南县", "文成县", "泰顺县", "温州经济技术开发区", "瑞安市", "乐清市", "龙港市"],
        "嘉兴市": ["南湖区", "秀洲区", "嘉善县", "海盐县", "海宁市", "平湖市", "桐乡市"],
        "湖州市": ["吴兴区", "南浔区", "德清县", "长兴县", "安吉县"],
        "绍兴市": ["越城区", "柯桥区", "上虞区", "新昌县", "诸暨市", "嵊州市"],
        "金华市": ["婺城区", "金东区", "武义县", "浦江县", "磐安县", "兰溪市", "义乌市", "东阳市", "永康市"],
        "衢州市": ["柯城区", "衢江区", "常山县", "开化县", "龙游县", "江山市"],
        "舟山市": ["定海区", "普陀区", "岱山县", "嵊泗县"],
        "台州市": ["椒江区", "黄岩区", "路桥区", "三门县", "天台县", "仙居县", "温岭市", "临海市", "玉环市"],
        "丽水市": ["莲都区", "青田县", "缙云县", "遂昌县", "松阳县", "云和县", "庆元县", "景宁畲族自治县", "龙泉市"]
    },
    "安徽省": {
        "合肥市":
            ["瑶海区", "庐阳区", "蜀山区", "包河区", "长丰县", "肥东县", "肥西县", "庐江县", "合肥高新技术产业开发区", "合肥经济技术开发区", "合肥新站高新技术产业开发区",
             "巢湖市"],
        "芜湖市": ["镜湖区", "弋江区", "鸠江区", "三山区", "芜湖县", "繁昌县", "南陵县", "芜湖经济技术开发区", "安徽芜湖长江大桥经济开发区", "无为市"],
        "蚌埠市": ["龙子湖区", "蚌山区", "禹会区", "淮上区", "怀远县", "五河县", "固镇县", "蚌埠市高新技术开发区", "蚌埠市经济开发区"],
        "淮南市": ["大通区", "田家庵区", "谢家集区", "八公山区", "潘集区", "凤台县", "寿县"],
        "马鞍山市": ["花山区", "雨山区", "博望区", "当涂县", "含山县", "和县"],
        "淮北市": ["杜集区", "相山区", "烈山区", "濉溪县"],
        "铜陵市": ["铜官区", "义安区", "郊区", "枞阳县"],
        "安庆市": ["迎江区", "大观区", "宜秀区", "怀宁县", "太湖县", "宿松县", "望江县", "岳西县", "安徽安庆经济开发区", "桐城市", "潜山市"],
        "黄山市": ["屯溪区", "黄山区", "徽州区", "歙县", "休宁县", "黟县", "祁门县"],
        "滁州市": ["琅琊区", "南谯区", "来安县", "全椒县", "定远县", "凤阳县", "苏滁现代产业园", "滁州经济技术开发区", "天长市", "明光市"],
        "阜阳市": ["颍州区", "颍东区", "颍泉区", "临泉县", "太和县", "阜南县", "颍上县", "阜阳合肥现代产业园区", "阜阳经济技术开发区", "界首市"],
        "宿州市": ["埇桥区", "砀山县", "萧县", "灵璧县", "泗县", "宿州马鞍山现代产业园区", "宿州经济技术开发区"],
        "六安市": ["金安区", "裕安区", "叶集区", "霍邱县", "舒城县", "金寨县", "霍山县"],
        "亳州市": ["谯城区", "涡阳县", "蒙城县", "利辛县"],
        "池州市": ["贵池区", "东至县", "石台县", "青阳县"],
        "宣城市": ["宣州区", "郎溪县", "泾县", "绩溪县", "旌德县", "宣城市经济开发区", "宁国市", "广德市"]
    },
    "福建省": {
        "福州市": ["鼓楼区", "台江区", "仓山区", "马尾区", "晋安区", "长乐区", "闽侯县", "连江县", "罗源县", "闽清县", "永泰县", "平潭县", "福清市"],
        "厦门市": ["思明区", "海沧区", "湖里区", "集美区", "同安区", "翔安区"],
        "莆田市": ["城厢区", "涵江区", "荔城区", "秀屿区", "仙游县"],
        "三明市": ["梅列区", "三元区", "明溪县", "清流县", "宁化县", "大田县", "尤溪县", "沙县", "将乐县", "泰宁县", "建宁县", "永安市"],
        "泉州市": ["鲤城区", "丰泽区", "洛江区", "泉港区", "惠安县", "安溪县", "永春县", "德化县", "金门县", "石狮市", "晋江市", "南安市"],
        "漳州市": ["芗城区", "龙文区", "云霄县", "漳浦县", "诏安县", "长泰县", "东山县", "南靖县", "平和县", "华安县", "龙海市"],
        "南平市": ["延平区", "建阳区", "顺昌县", "浦城县", "光泽县", "松溪县", "政和县", "邵武市", "武夷山市", "建瓯市"],
        "龙岩市": ["新罗区", "永定区", "长汀县", "上杭县", "武平县", "连城县", "漳平市"],
        "宁德市": ["蕉城区", "霞浦县", "古田县", "屏南县", "寿宁县", "周宁县", "柘荣县", "福安市", "福鼎市"]
    },
    "江西省": {
        "南昌市": ["东湖区", "西湖区", "青云谱区", "青山湖区", "新建区", "红谷滩区", "南昌县", "安义县", "进贤县"],
        "景德镇市": ["昌江区", "珠山区", "浮梁县", "乐平市"],
        "萍乡市": ["安源区", "湘东区", "莲花县", "上栗县", "芦溪县"],
        "九江市": ["濂溪区", "浔阳区", "柴桑区", "武宁县", "修水县", "永修县", "德安县", "都昌县", "湖口县", "彭泽县", "瑞昌市", "共青城市", "庐山市"],
        "新余市": ["渝水区", "分宜县"],
        "鹰潭市": ["月湖区", "余江区", "贵溪市"],
        "赣州市": [
            "章贡区", "南康区", "赣县区", "信丰县", "大余县", "上犹县", "崇义县", "安远县", "定南县", "全南县", "宁都县", "于都县", "兴国县", "会昌县", "寻乌县",
            "石城县", "瑞金市", "龙南市"
        ],
        "吉安市": ["吉州区", "青原区", "吉安县", "吉水县", "峡江县", "新干县", "永丰县", "泰和县", "遂川县", "万安县", "安福县", "永新县", "井冈山市"],
        "宜春市": ["袁州区", "奉新县", "万载县", "上高县", "宜丰县", "靖安县", "铜鼓县", "丰城市", "樟树市", "高安市"],
        "抚州市": ["临川区", "东乡区", "南城县", "黎川县", "南丰县", "崇仁县", "乐安县", "宜黄县", "金溪县", "资溪县", "广昌县"],
        "上饶市": ["信州区", "广丰区", "广信区", "玉山县", "铅山县", "横峰县", "弋阳县", "余干县", "鄱阳县", "万年县", "婺源县", "德兴市"]
    },
    "山东省": {
        "济南市": ["历下区", "市中区", "槐荫区", "天桥区", "历城区", "长清区", "章丘区", "济阳区", "莱芜区", "钢城区", "平阴县", "商河县", "济南高新技术产业开发区"],
        "青岛市": ["市南区", "市北区", "黄岛区", "崂山区", "李沧区", "城阳区", "即墨区", "青岛高新技术产业开发区", "胶州市", "平度市", "莱西市"],
        "淄博市": ["淄川区", "张店区", "博山区", "临淄区", "周村区", "桓台县", "高青县", "沂源县"],
        "枣庄市": ["市中区", "薛城区", "峄城区", "台儿庄区", "山亭区", "滕州市"],
        "东营市": ["东营区", "河口区", "垦利区", "利津县", "广饶县", "东营经济技术开发区", "东营港经济开发区"],
        "烟台市":
            ["芝罘区", "福山区", "牟平区", "莱山区", "蓬莱区", "烟台高新技术产业开发区", "烟台经济技术开发区", "龙口市", "莱阳市", "莱州市", "招远市", "栖霞市", "海阳市"],
        "潍坊市": ["潍城区", "寒亭区", "坊子区", "奎文区", "临朐县", "昌乐县", "潍坊滨海经济技术开发区", "青州市", "诸城市", "寿光市", "安丘市", "高密市", "昌邑市"],
        "济宁市": ["任城区", "兖州区", "微山县", "鱼台县", "金乡县", "嘉祥县", "汶上县", "泗水县", "梁山县", "济宁高新技术产业开发区", "曲阜市", "邹城市"],
        "泰安市": ["泰山区", "岱岳区", "宁阳县", "东平县", "新泰市", "肥城市"],
        "威海市": ["环翠区", "文登区", "威海火炬高技术产业开发区", "威海经济技术开发区", "威海临港经济技术开发区", "荣成市", "乳山市"],
        "日照市": ["东港区", "岚山区", "五莲县", "莒县", "日照经济技术开发区"],
        "临沂市": ["兰山区", "罗庄区", "河东区", "沂南县", "郯城县", "沂水县", "兰陵县", "费县", "平邑县", "莒南县", "蒙阴县", "临沭县", "临沂高新技术产业开发区"],
        "德州市": ["德城区", "陵城区", "宁津县", "庆云县", "临邑县", "齐河县", "平原县", "夏津县", "武城县", "德州经济技术开发区", "德州运河经济开发区", "乐陵市", "禹城市"],
        "聊城市": ["东昌府区", "茌平区", "阳谷县", "莘县", "东阿县", "冠县", "高唐县", "临清市"],
        "滨州市": ["滨城区", "沾化区", "惠民县", "阳信县", "无棣县", "博兴县", "邹平市"],
        "菏泽市": ["牡丹区", "定陶区", "曹县", "单县", "成武县", "巨野县", "郓城县", "鄄城县", "东明县", "菏泽经济技术开发区", "菏泽高新技术开发区"]
    },
    "河南省": {
        "郑州市": [
            "中原区", "二七区", "管城回族区", "金水区", "上街区", "惠济区", "中牟县", "郑州经济技术开发区", "郑州高新技术产业开发区", "郑州航空港经济综合实验区", "巩义市", "荥阳市",
            "新密市", "新郑市", "登封市"
        ],
        "开封市": ["龙亭区", "顺河回族区", "鼓楼区", "禹王台区", "祥符区", "杞县", "通许县", "尉氏县", "兰考县"],
        "洛阳市": [
            "老城区", "西工区", "瀍河回族区", "涧西区", "吉利区", "洛龙区", "孟津县", "新安县", "栾川县", "嵩县", "汝阳县", "宜阳县", "洛宁县", "伊川县",
            "洛阳高新技术产业开发区", "偃师市"
        ],
        "平顶山市": ["新华区", "卫东区", "石龙区", "湛河区", "宝丰县", "叶县", "鲁山县", "郏县", "平顶山高新技术产业开发区", "平顶山市城乡一体化示范区", "舞钢市", "汝州市"],
        "安阳市": ["文峰区", "北关区", "殷都区", "龙安区", "安阳县", "汤阴县", "滑县", "内黄县", "安阳高新技术产业开发区", "林州市"],
        "鹤壁市": ["鹤山区", "山城区", "淇滨区", "浚县", "淇县", "鹤壁经济技术开发区"],
        "新乡市": [
            "红旗区", "卫滨区", "凤泉区", "牧野区", "新乡县", "获嘉县", "原阳县", "延津县", "封丘县", "新乡高新技术产业开发区", "新乡经济技术开发区", "新乡市平原城乡一体化示范区",
            "卫辉市", "辉县市", "长垣市"
        ],
        "焦作市": ["解放区", "中站区", "马村区", "山阳区", "修武县", "博爱县", "武陟县", "温县", "焦作城乡一体化示范区", "沁阳市", "孟州市"],
        "濮阳市": ["华龙区", "清丰县", "南乐县", "范县", "台前县", "濮阳县", "河南濮阳工业园区", "濮阳经济技术开发区"],
        "许昌市": ["魏都区", "建安区", "鄢陵县", "襄城县", "许昌经济技术开发区", "禹州市", "长葛市"],
        "漯河市": ["源汇区", "郾城区", "召陵区", "舞阳县", "临颍县", "漯河经济技术开发区"],
        "三门峡市": ["湖滨区", "陕州区", "渑池县", "卢氏县", "河南三门峡经济开发区", "义马市", "灵宝市"],
        "南阳市": [
            "宛城区", "卧龙区", "南召县", "方城县", "西峡县", "镇平县", "内乡县", "淅川县", "社旗县", "唐河县", "新野县", "桐柏县", "南阳高新技术产业开发区",
            "南阳市城乡一体化示范区", "邓州市"
        ],
        "商丘市": ["梁园区", "睢阳区", "民权县", "睢县", "宁陵县", "柘城县", "虞城县", "夏邑县", "豫东综合物流产业聚集区", "河南商丘经济开发区", "永城市"],
        "信阳市": ["浉河区", "平桥区", "罗山县", "光山县", "新县", "商城县", "固始县", "潢川县", "淮滨县", "息县", "信阳高新技术产业开发区"],
        "周口市": ["川汇区", "淮阳区", "扶沟县", "西华县", "商水县", "沈丘县", "郸城县", "太康县", "鹿邑县", "河南周口经济开发区", "项城市"],
        "驻马店市": ["驿城区", "西平县", "上蔡县", "平舆县", "正阳县", "确山县", "泌阳县", "汝南县", "遂平县", "新蔡县", "河南驻马店经济开发区"],
        "省直辖县级行政区划": ["济源市"]
    },
    "湖北省": {
        "武汉市": ["江岸区", "江汉区", "硚口区", "汉阳区", "武昌区", "青山区", "洪山区", "东西湖区", "汉南区", "蔡甸区", "江夏区", "黄陂区", "新洲区"],
        "黄石市": ["黄石港区", "西塞山区", "下陆区", "铁山区", "阳新县", "大冶市"],
        "十堰市": ["茅箭区", "张湾区", "郧阳区", "郧西县", "竹山县", "竹溪县", "房县", "丹江口市"],
        "宜昌市": ["西陵区", "伍家岗区", "点军区", "猇亭区", "夷陵区", "远安县", "兴山县", "秭归县", "长阳土家族自治县", "五峰土家族自治县", "宜都市", "当阳市", "枝江市"],
        "襄阳市": ["襄城区", "樊城区", "襄州区", "南漳县", "谷城县", "保康县", "老河口市", "枣阳市", "宜城市"],
        "鄂州市": ["梁子湖区", "华容区", "鄂城区"],
        "荆门市": ["东宝区", "掇刀区", "沙洋县", "钟祥市", "京山市"],
        "孝感市": ["孝南区", "孝昌县", "大悟县", "云梦县", "应城市", "安陆市", "汉川市"],
        "荆州市": ["沙市区", "荆州区", "公安县", "监利县", "江陵县", "荆州经济技术开发区", "石首市", "洪湖市", "松滋市"],
        "黄冈市": ["黄州区", "团风县", "红安县", "罗田县", "英山县", "浠水县", "蕲春县", "黄梅县", "龙感湖管理区", "麻城市", "武穴市"],
        "咸宁市": ["咸安区", "嘉鱼县", "通城县", "崇阳县", "通山县", "赤壁市"],
        "随州市": ["曾都区", "随县", "广水市"],
        "恩施土家族苗族自治州": ["恩施市", "利川市", "建始县", "巴东县", "宣恩县", "咸丰县", "来凤县", "鹤峰县"],
        "省直辖县级行政区划": ["仙桃市", "潜江市", "天门市", "神农架林区"]
    },
    "湖南省": {
        "长沙市": ["芙蓉区", "天心区", "岳麓区", "开福区", "雨花区", "望城区", "长沙县", "浏阳市", "宁乡市"],
        "株洲市": ["荷塘区", "芦淞区", "石峰区", "天元区", "渌口区", "攸县", "茶陵县", "炎陵县", "云龙示范区", "醴陵市"],
        "湘潭市": ["雨湖区", "岳塘区", "湘潭县", "湖南湘潭高新技术产业园区", "湘潭昭山示范区", "湘潭九华示范区", "湘乡市", "韶山市"],
        "衡阳市": [
            "珠晖区", "雁峰区", "石鼓区", "蒸湘区", "南岳区", "衡阳县", "衡南县", "衡山县", "衡东县", "祁东县", "衡阳综合保税区", "湖南衡阳高新技术产业园区",
            "湖南衡阳松木经济开发区", "耒阳市", "常宁市"
        ],
        "邵阳市": ["双清区", "大祥区", "北塔区", "新邵县", "邵阳县", "隆回县", "洞口县", "绥宁县", "新宁县", "城步苗族自治县", "武冈市", "邵东市"],
        "岳阳市": ["岳阳楼区", "云溪区", "君山区", "岳阳县", "华容县", "湘阴县", "平江县", "岳阳市屈原管理区", "汨罗市", "临湘市"],
        "常德市": ["武陵区", "鼎城区", "安乡县", "汉寿县", "澧县", "临澧县", "桃源县", "石门县", "常德市西洞庭管理区", "津市市"],
        "张家界市": ["永定区", "武陵源区", "慈利县", "桑植县"],
        "益阳市": ["资阳区", "赫山区", "南县", "桃江县", "安化县", "益阳市大通湖管理区", "湖南益阳高新技术产业园区", "沅江市"],
        "郴州市": ["北湖区", "苏仙区", "桂阳县", "宜章县", "永兴县", "嘉禾县", "临武县", "汝城县", "桂东县", "安仁县", "资兴市"],
        "永州市": [
            "零陵区", "冷水滩区", "祁阳县", "东安县", "双牌县", "道县", "江永县", "宁远县", "蓝山县", "新田县", "江华瑶族自治县", "永州经济技术开发区", "永州市金洞管理区",
            "永州市回龙圩管理区"
        ],
        "怀化市": [
            "鹤城区", "中方县", "沅陵县", "辰溪县", "溆浦县", "会同县", "麻阳苗族自治县", "新晃侗族自治县", "芷江侗族自治县", "靖州苗族侗族自治县", "通道侗族自治县",
            "怀化市洪江管理区", "洪江市"
        ],
        "娄底市": ["娄星区", "双峰县", "新化县", "冷水江市", "涟源市"],
        "湘西土家族苗族自治州": ["吉首市", "泸溪县", "凤凰县", "花垣县", "保靖县", "古丈县", "永顺县", "龙山县"]
    },
    "广东省": {
        "广州市": ["荔湾区", "越秀区", "海珠区", "天河区", "白云区", "黄埔区", "番禺区", "花都区", "南沙区", "从化区", "增城区"],
        "韶关市": ["武江区", "浈江区", "曲江区", "始兴县", "仁化县", "翁源县", "乳源瑶族自治县", "新丰县", "乐昌市", "南雄市"],
        "深圳市": ["罗湖区", "福田区", "南山区", "宝安区", "龙岗区", "盐田区", "龙华区", "坪山区", "光明区"],
        "珠海市": ["香洲区", "斗门区", "金湾区"],
        "汕头市": ["龙湖区", "金平区", "濠江区", "潮阳区", "潮南区", "澄海区", "南澳县"],
        "佛山市": ["禅城区", "南海区", "顺德区", "三水区", "高明区"],
        "江门市": ["蓬江区", "江海区", "新会区", "台山市", "开平市", "鹤山市", "恩平市"],
        "湛江市": ["赤坎区", "霞山区", "坡头区", "麻章区", "遂溪县", "徐闻县", "廉江市", "雷州市", "吴川市"],
        "茂名市": ["茂南区", "电白区", "高州市", "化州市", "信宜市"],
        "肇庆市": ["端州区", "鼎湖区", "高要区", "广宁县", "怀集县", "封开县", "德庆县", "四会市"],
        "惠州市": ["惠城区", "惠阳区", "博罗县", "惠东县", "龙门县"],
        "梅州市": ["梅江区", "梅县区", "大埔县", "丰顺县", "五华县", "平远县", "蕉岭县", "兴宁市"],
        "汕尾市": ["城区", "海丰县", "陆河县", "陆丰市"],
        "河源市": ["源城区", "紫金县", "龙川县", "连平县", "和平县", "东源县"],
        "阳江市": ["江城区", "阳东区", "阳西县", "阳春市"],
        "清远市": ["清城区", "清新区", "佛冈县", "阳山县", "连山壮族瑶族自治县", "连南瑶族自治县", "英德市", "连州市"],
        "东莞市": [
            "东城街道", "南城街道", "万江街道", "莞城街道", "石碣镇", "石龙镇", "茶山镇", "石排镇", "企石镇", "横沥镇", "桥头镇", "谢岗镇", "东坑镇", "常平镇", "寮步镇",
            "樟木头镇", "大朗镇", "黄江镇", "清溪镇", "塘厦镇", "凤岗镇", "大岭山镇", "长安镇", "虎门镇", "厚街镇", "沙田镇", "道滘镇", "洪梅镇", "麻涌镇", "望牛墩镇",
            "中堂镇", "高埗镇", "松山湖", "东莞港", "东莞生态园"
        ],
        "中山市": [
            "石岐街道", "东区街道", "中山港街道", "西区街道", "南区街道", "五桂山街道", "小榄镇", "黄圃镇", "民众镇", "东凤镇", "东升镇", "古镇镇", "沙溪镇", "坦洲镇",
            "港口镇", "三角镇", "横栏镇", "南头镇", "阜沙镇", "南朗镇", "三乡镇", "板芙镇", "大涌镇", "神湾镇"
        ],
        "潮州市": ["湘桥区", "潮安区", "饶平县"],
        "揭阳市": ["榕城区", "揭东区", "揭西县", "惠来县", "普宁市"],
        "云浮市": ["云城区", "云安区", "新兴县", "郁南县", "罗定市"]
    },
    "广西壮族自治区": {
        "南宁市": ["兴宁区", "青秀区", "江南区", "西乡塘区", "良庆区", "邕宁区", "武鸣区", "隆安县", "马山县", "上林县", "宾阳县", "横县"],
        "柳州市": ["城中区", "鱼峰区", "柳南区", "柳北区", "柳江区", "柳城县", "鹿寨县", "融安县", "融水苗族自治县", "三江侗族自治县"],
        "桂林市": [
            "秀峰区", "叠彩区", "象山区", "七星区", "雁山区", "临桂区", "阳朔县", "灵川县", "全州县", "兴安县", "永福县", "灌阳县", "龙胜各族自治县", "资源县", "平乐县",
            "恭城瑶族自治县", "荔浦市"
        ],
        "梧州市": ["万秀区", "长洲区", "龙圩区", "苍梧县", "藤县", "蒙山县", "岑溪市"],
        "北海市": ["海城区", "银海区", "铁山港区", "合浦县"],
        "防城港市": ["港口区", "防城区", "上思县", "东兴市"],
        "钦州市": ["钦南区", "钦北区", "灵山县", "浦北县"],
        "贵港市": ["港北区", "港南区", "覃塘区", "平南县", "桂平市"],
        "玉林市": ["玉州区", "福绵区", "容县", "陆川县", "博白县", "兴业县", "北流市"],
        "百色市": ["右江区", "田阳区", "田东县", "德保县", "那坡县", "凌云县", "乐业县", "田林县", "西林县", "隆林各族自治县", "靖西市", "平果市"],
        "贺州市": ["八步区", "平桂区", "昭平县", "钟山县", "富川瑶族自治县"],
        "河池市": ["金城江区", "宜州区", "南丹县", "天峨县", "凤山县", "东兰县", "罗城仫佬族自治县", "环江毛南族自治县", "巴马瑶族自治县", "都安瑶族自治县", "大化瑶族自治县"],
        "来宾市": ["兴宾区", "忻城县", "象州县", "武宣县", "金秀瑶族自治县", "合山市"],
        "崇左市": ["江州区", "扶绥县", "宁明县", "龙州县", "大新县", "天等县", "凭祥市"]
    },
    "海南省": {
        "海口市": ["秀英区", "龙华区", "琼山区", "美兰区"],
        "三亚市": ["海棠区", "吉阳区", "天涯区", "崖州区"],
        "三沙市": ["西沙群岛", "南沙群岛", "中沙群岛的岛礁及其海域"],
        "儋州市": [
            "那大镇", "和庆镇", "南丰镇", "大成镇", "雅星镇", "兰洋镇", "光村镇", "木棠镇", "海头镇", "峨蔓镇", "王五镇", "白马井镇", "中和镇", "排浦镇", "东成镇",
            "新州镇", "洋浦经济开发区", "华南热作学院"
        ],
        "省直辖县级行政区划": [
            "五指山市", "琼海市", "文昌市", "万宁市", "东方市", "定安县", "屯昌县", "澄迈县", "临高县", "白沙黎族自治县", "昌江黎族自治县", "乐东黎族自治县", "陵水黎族自治县",
            "保亭黎族苗族自治县", "琼中黎族苗族自治县"
        ]
    },
    "重庆市": {
        "市辖区": [
            "万州区", "涪陵区", "渝中区", "大渡口区", "江北区", "沙坪坝区", "九龙坡区", "南岸区", "北碚区", "綦江区", "大足区", "渝北区", "巴南区", "黔江区", "长寿区",
            "江津区", "合川区", "永川区", "南川区", "璧山区", "铜梁区", "潼南区", "荣昌区", "开州区", "梁平区", "武隆区"
        ],
        "县":
            ["城口县", "丰都县", "垫江县", "忠县", "云阳县", "奉节县", "巫山县", "巫溪县", "石柱土家族自治县", "秀山土家族苗族自治县", "酉阳土家族苗族自治县",
             "彭水苗族土家族自治县"]
    },
    "四川省": {
        "成都市": [
            "锦江区", "青羊区", "金牛区", "武侯区", "成华区", "龙泉驿区", "青白江区", "新都区", "温江区", "双流区", "郫都区", "新津区", "金堂县", "大邑县", "蒲江县",
            "都江堰市", "彭州市", "邛崃市", "崇州市", "简阳市"
        ],
        "自贡市": ["自流井区", "贡井区", "大安区", "沿滩区", "荣县", "富顺县"],
        "攀枝花市": ["东区", "西区", "仁和区", "米易县", "盐边县"],
        "泸州市": ["江阳区", "纳溪区", "龙马潭区", "泸县", "合江县", "叙永县", "古蔺县"],
        "德阳市": ["旌阳区", "罗江区", "中江县", "广汉市", "什邡市", "绵竹市"],
        "绵阳市": ["涪城区", "游仙区", "安州区", "三台县", "盐亭县", "梓潼县", "北川羌族自治县", "平武县", "江油市"],
        "广元市": ["利州区", "昭化区", "朝天区", "旺苍县", "青川县", "剑阁县", "苍溪县"],
        "遂宁市": ["船山区", "安居区", "蓬溪县", "大英县", "射洪市"],
        "内江市": ["市中区", "东兴区", "威远县", "资中县", "内江经济开发区", "隆昌市"],
        "乐山市": ["市中区", "沙湾区", "五通桥区", "金口河区", "犍为县", "井研县", "夹江县", "沐川县", "峨边彝族自治县", "马边彝族自治县", "峨眉山市"],
        "南充市": ["顺庆区", "高坪区", "嘉陵区", "南部县", "营山县", "蓬安县", "仪陇县", "西充县", "阆中市"],
        "眉山市": ["东坡区", "彭山区", "仁寿县", "洪雅县", "丹棱县", "青神县"],
        "宜宾市": ["翠屏区", "南溪区", "叙州区", "江安县", "长宁县", "高县", "珙县", "筠连县", "兴文县", "屏山县"],
        "广安市": ["广安区", "前锋区", "岳池县", "武胜县", "邻水县", "华蓥市"],
        "达州市": ["通川区", "达川区", "宣汉县", "开江县", "大竹县", "渠县", "达州经济开发区", "万源市"],
        "雅安市": ["雨城区", "名山区", "荥经县", "汉源县", "石棉县", "天全县", "芦山县", "宝兴县"],
        "巴中市": ["巴州区", "恩阳区", "通江县", "南江县", "平昌县", "巴中经济开发区"],
        "资阳市": ["雁江区", "安岳县", "乐至县"],
        "阿坝藏族羌族自治州": ["马尔康市", "汶川县", "理县", "茂县", "松潘县", "九寨沟县", "金川县", "小金县", "黑水县", "壤塘县", "阿坝县", "若尔盖县", "红原县"],
        "甘孜藏族自治州": [
            "康定市", "泸定县", "丹巴县", "九龙县", "雅江县", "道孚县", "炉霍县", "甘孜县", "新龙县", "德格县", "白玉县", "石渠县", "色达县", "理塘县", "巴塘县",
            "乡城县", "稻城县", "得荣县"
        ],
        "凉山彝族自治州": [
            "西昌市", "木里藏族自治县", "盐源县", "德昌县", "会理县", "会东县", "宁南县", "普格县", "布拖县", "金阳县", "昭觉县", "喜德县", "冕宁县", "越西县", "甘洛县",
            "美姑县", "雷波县"
        ]
    },
    "贵州省": {
        "贵阳市": ["南明区", "云岩区", "花溪区", "乌当区", "白云区", "观山湖区", "开阳县", "息烽县", "修文县", "清镇市"],
        "六盘水市": ["钟山区", "六枝特区", "水城县", "盘州市"],
        "遵义市": [
            "红花岗区", "汇川区", "播州区", "桐梓县", "绥阳县", "正安县", "道真仡佬族苗族自治县", "务川仡佬族苗族自治县", "凤冈县", "湄潭县", "余庆县", "习水县", "赤水市",
            "仁怀市"
        ],
        "安顺市": ["西秀区", "平坝区", "普定县", "镇宁布依族苗族自治县", "关岭布依族苗族自治县", "紫云苗族布依族自治县"],
        "毕节市": ["七星关区", "大方县", "黔西县", "金沙县", "织金县", "纳雍县", "威宁彝族回族苗族自治县", "赫章县"],
        "铜仁市": ["碧江区", "万山区", "江口县", "玉屏侗族自治县", "石阡县", "思南县", "印江土家族苗族自治县", "德江县", "沿河土家族自治县", "松桃苗族自治县"],
        "黔西南布依族苗族自治州": ["兴义市", "兴仁市", "普安县", "晴隆县", "贞丰县", "望谟县", "册亨县", "安龙县"],
        "黔东南苗族侗族自治州": [
            "凯里市", "黄平县", "施秉县", "三穗县", "镇远县", "岑巩县", "天柱县", "锦屏县", "剑河县", "台江县", "黎平县", "榕江县", "从江县", "雷山县", "麻江县",
            "丹寨县"
        ],
        "黔南布依族苗族自治州": ["都匀市", "福泉市", "荔波县", "贵定县", "瓮安县", "独山县", "平塘县", "罗甸县", "长顺县", "龙里县", "惠水县", "三都水族自治县"]
    },
    "云南省": {
        "昆明市": [
            "五华区", "盘龙区", "官渡区", "西山区", "东川区", "呈贡区", "晋宁区", "富民县", "宜良县", "石林彝族自治县", "嵩明县", "禄劝彝族苗族自治县", "寻甸回族彝族自治县",
            "安宁市"
        ],
        "曲靖市": ["麒麟区", "沾益区", "马龙区", "陆良县", "师宗县", "罗平县", "富源县", "会泽县", "宣威市"],
        "玉溪市": ["红塔区", "江川区", "通海县", "华宁县", "易门县", "峨山彝族自治县", "新平彝族傣族自治县", "元江哈尼族彝族傣族自治县", "澄江市"],
        "保山市": ["隆阳区", "施甸县", "龙陵县", "昌宁县", "腾冲市"],
        "昭通市": ["昭阳区", "鲁甸县", "巧家县", "盐津县", "大关县", "永善县", "绥江县", "镇雄县", "彝良县", "威信县", "水富市"],
        "丽江市": ["古城区", "玉龙纳西族自治县", "永胜县", "华坪县", "宁蒗彝族自治县"],
        "普洱市": [
            "思茅区", "宁洱哈尼族彝族自治县", "墨江哈尼族自治县", "景东彝族自治县", "景谷傣族彝族自治县", "镇沅彝族哈尼族拉祜族自治县", "江城哈尼族彝族自治县", "孟连傣族拉祜族佤族自治县",
            "澜沧拉祜族自治县", "西盟佤族自治县"
        ],
        "临沧市": ["临翔区", "凤庆县", "云县", "永德县", "镇康县", "双江拉祜族佤族布朗族傣族自治县", "耿马傣族佤族自治县", "沧源佤族自治县"],
        "楚雄彝族自治州": ["楚雄市", "双柏县", "牟定县", "南华县", "姚安县", "大姚县", "永仁县", "元谋县", "武定县", "禄丰县"],
        "红河哈尼族彝族自治州":
            ["个旧市", "开远市", "蒙自市", "弥勒市", "屏边苗族自治县", "建水县", "石屏县", "泸西县", "元阳县", "红河县", "金平苗族瑶族傣族自治县", "绿春县", "河口瑶族自治县"],
        "文山壮族苗族自治州": ["文山市", "砚山县", "西畴县", "麻栗坡县", "马关县", "丘北县", "广南县", "富宁县"],
        "西双版纳傣族自治州": ["景洪市", "勐海县", "勐腊县"],
        "大理白族自治州": ["大理市", "漾濞彝族自治县", "祥云县", "宾川县", "弥渡县", "南涧彝族自治县", "巍山彝族回族自治县", "永平县", "云龙县", "洱源县", "剑川县", "鹤庆县"],
        "德宏傣族景颇族自治州": ["瑞丽市", "芒市", "梁河县", "盈江县", "陇川县"],
        "怒江傈僳族自治州": ["泸水市", "福贡县", "贡山独龙族怒族自治县", "兰坪白族普米族自治县"],
        "迪庆藏族自治州": ["香格里拉市", "德钦县", "维西傈僳族自治县"]
    },
    "西藏自治区": {
        "拉萨市":
            ["城关区", "堆龙德庆区", "达孜区", "林周县", "当雄县", "尼木县", "曲水县", "墨竹工卡县", "格尔木藏青工业园区", "拉萨经济技术开发区", "西藏文化旅游创意园区",
             "达孜工业园区"],
        "日喀则市": [
            "桑珠孜区", "南木林县", "江孜县", "定日县", "萨迦县", "拉孜县", "昂仁县", "谢通门县", "白朗县", "仁布县", "康马县", "定结县", "仲巴县", "亚东县", "吉隆县",
            "聂拉木县", "萨嘎县", "岗巴县"
        ],
        "昌都市": ["卡若区", "江达县", "贡觉县", "类乌齐县", "丁青县", "察雅县", "八宿县", "左贡县", "芒康县", "洛隆县", "边坝县"],
        "林芝市": ["巴宜区", "工布江达县", "米林县", "墨脱县", "波密县", "察隅县", "朗县"],
        "山南市": ["乃东区", "扎囊县", "贡嘎县", "桑日县", "琼结县", "曲松县", "措美县", "洛扎县", "加查县", "隆子县", "错那县", "浪卡子县"],
        "那曲市": ["色尼区", "嘉黎县", "比如县", "聂荣县", "安多县", "申扎县", "索县", "班戈县", "巴青县", "尼玛县", "双湖县"],
        "阿里地区": ["普兰县", "札达县", "噶尔县", "日土县", "革吉县", "改则县", "措勤县"]
    },
    "陕西省": {
        "西安市": ["新城区", "碑林区", "莲湖区", "灞桥区", "未央区", "雁塔区", "阎良区", "临潼区", "长安区", "高陵区", "鄠邑区", "蓝田县", "周至县"],
        "铜川市": ["王益区", "印台区", "耀州区", "宜君县"],
        "宝鸡市": ["渭滨区", "金台区", "陈仓区", "凤翔县", "岐山县", "扶风县", "眉县", "陇县", "千阳县", "麟游县", "凤县", "太白县"],
        "咸阳市": ["秦都区", "杨陵区", "渭城区", "三原县", "泾阳县", "乾县", "礼泉县", "永寿县", "长武县", "旬邑县", "淳化县", "武功县", "兴平市", "彬州市"],
        "渭南市": ["临渭区", "华州区", "潼关县", "大荔县", "合阳县", "澄城县", "蒲城县", "白水县", "富平县", "韩城市", "华阴市"],
        "延安市": ["宝塔区", "安塞区", "延长县", "延川县", "志丹县", "吴起县", "甘泉县", "富县", "洛川县", "宜川县", "黄龙县", "黄陵县", "子长市"],
        "汉中市": ["汉台区", "南郑区", "城固县", "洋县", "西乡县", "勉县", "宁强县", "略阳县", "镇巴县", "留坝县", "佛坪县"],
        "榆林市": ["榆阳区", "横山区", "府谷县", "靖边县", "定边县", "绥德县", "米脂县", "佳县", "吴堡县", "清涧县", "子洲县", "神木市"],
        "安康市": ["汉滨区", "汉阴县", "石泉县", "宁陕县", "紫阳县", "岚皋县", "平利县", "镇坪县", "旬阳县", "白河县"],
        "商洛市": ["商州区", "洛南县", "丹凤县", "商南县", "山阳县", "镇安县", "柞水县"]
    },
    "甘肃省": {
        "兰州市": ["城关区", "七里河区", "西固区", "安宁区", "红古区", "永登县", "皋兰县", "榆中县", "兰州新区"],
        "嘉峪关市": ["雄关街道", "钢城街道", "新城镇", "峪泉镇", "文殊镇"],
        "金昌市": ["金川区", "永昌县"],
        "白银市": ["白银区", "平川区", "靖远县", "会宁县", "景泰县"],
        "天水市": ["秦州区", "麦积区", "清水县", "秦安县", "甘谷县", "武山县", "张家川回族自治县"],
        "武威市": ["凉州区", "民勤县", "古浪县", "天祝藏族自治县"],
        "张掖市": ["甘州区", "肃南裕固族自治县", "民乐县", "临泽县", "高台县", "山丹县"],
        "平凉市": ["崆峒区", "泾川县", "灵台县", "崇信县", "庄浪县", "静宁县", "华亭市"],
        "酒泉市": ["肃州区", "金塔县", "瓜州县", "肃北蒙古族自治县", "阿克塞哈萨克族自治县", "玉门市", "敦煌市"],
        "庆阳市": ["西峰区", "庆城县", "环县", "华池县", "合水县", "正宁县", "宁县", "镇原县"],
        "定西市": ["安定区", "通渭县", "陇西县", "渭源县", "临洮县", "漳县", "岷县"],
        "陇南市": ["武都区", "成县", "文县", "宕昌县", "康县", "西和县", "礼县", "徽县", "两当县"],
        "临夏回族自治州": ["临夏市", "临夏县", "康乐县", "永靖县", "广河县", "和政县", "东乡族自治县", "积石山保安族东乡族撒拉族自治县"],
        "甘南藏族自治州": ["合作市", "临潭县", "卓尼县", "舟曲县", "迭部县", "玛曲县", "碌曲县", "夏河县"]
    },
    "青海省": {
        "西宁市": ["城东区", "城中区", "城西区", "城北区", "湟中区", "大通回族土族自治县", "湟源县"],
        "海东市": ["乐都区", "平安区", "民和回族土族自治县", "互助土族自治县", "化隆回族自治县", "循化撒拉族自治县"],
        "海北藏族自治州": ["门源回族自治县", "祁连县", "海晏县", "刚察县"],
        "黄南藏族自治州": ["同仁县", "尖扎县", "泽库县", "河南蒙古族自治县"],
        "海南藏族自治州": ["共和县", "同德县", "贵德县", "兴海县", "贵南县"],
        "果洛藏族自治州": ["玛沁县", "班玛县", "甘德县", "达日县", "久治县", "玛多县"],
        "玉树藏族自治州": ["玉树市", "杂多县", "称多县", "治多县", "囊谦县", "曲麻莱县"],
        "海西蒙古族藏族自治州": ["格尔木市", "德令哈市", "茫崖市", "乌兰县", "都兰县", "天峻县", "大柴旦行政委员会"]
    },
    "宁夏回族自治区": {
        "银川市": ["兴庆区", "西夏区", "金凤区", "永宁县", "贺兰县", "灵武市"],
        "石嘴山市": ["大武口区", "惠农区", "平罗县"],
        "吴忠市": ["利通区", "红寺堡区", "盐池县", "同心县", "青铜峡市"],
        "固原市": ["原州区", "西吉县", "隆德县", "泾源县", "彭阳县"],
        "中卫市": ["沙坡头区", "中宁县", "海原县"]
    },
    "新疆维吾尔自治区": {
        "乌鲁木齐市": ["天山区", "沙依巴克区", "新市区", "水磨沟区", "头屯河区", "达坂城区", "米东区", "乌鲁木齐县"],
        "克拉玛依市": ["独山子区", "克拉玛依区", "白碱滩区", "乌尔禾区"],
        "吐鲁番市": ["高昌区", "鄯善县", "托克逊县"],
        "哈密市": ["伊州区", "巴里坤哈萨克自治县", "伊吾县"],
        "昌吉回族自治州": ["昌吉市", "阜康市", "呼图壁县", "玛纳斯县", "奇台县", "吉木萨尔县", "木垒哈萨克自治县"],
        "博尔塔拉蒙古自治州": ["博乐市", "阿拉山口市", "精河县", "温泉县"],
        "巴音郭楞蒙古自治州": ["库尔勒市", "轮台县", "尉犁县", "若羌县", "且末县", "焉耆回族自治县", "和静县", "和硕县", "博湖县", "库尔勒经济技术开发区"],
        "阿克苏地区": ["阿克苏市", "库车市", "温宿县", "沙雅县", "新和县", "拜城县", "乌什县", "阿瓦提县", "柯坪县"],
        "克孜勒苏柯尔克孜自治州": ["阿图什市", "阿克陶县", "阿合奇县", "乌恰县"],
        "喀什地区": ["喀什市", "疏附县", "疏勒县", "英吉沙县", "泽普县", "莎车县", "叶城县", "麦盖提县", "岳普湖县", "伽师县", "巴楚县", "塔什库尔干塔吉克自治县"],
        "和田地区": ["和田市", "和田县", "墨玉县", "皮山县", "洛浦县", "策勒县", "于田县", "民丰县"],
        "伊犁哈萨克自治州": ["伊宁市", "奎屯市", "霍尔果斯市", "伊宁县", "察布查尔锡伯自治县", "霍城县", "巩留县", "新源县", "昭苏县", "特克斯县", "尼勒克县"],
        "塔城地区": ["塔城市", "乌苏市", "额敏县", "沙湾县", "托里县", "裕民县", "和布克赛尔蒙古自治县"],
        "阿勒泰地区": ["阿勒泰市", "布尔津县", "富蕴县", "福海县", "哈巴河县", "青河县", "吉木乃县"],
        "自治区直辖县级行政区划": ["石河子市", "阿拉尔市", "图木舒克市", "五家渠市", "北屯市", "铁门关市", "双河市", "可克达拉市", "昆玉市", "胡杨河市"]
    },
    "台湾省": {},
    "香港特别行政区": {},
    "澳门特别行政区": {}
}

CHINA_INDUSTRY_INFO: dict[str, typing.Any] = {
    "农、林、牧、渔业": {
        "code": "A",
        "name": "农、林、牧、渔业",
        "children": {
            "农业": {
                "code": "01",
                "name": "农业",
                "children": {
                    "谷物种植": {
                        "code": "011",
                        "name": "谷物种植",
                        "children": {
                            "稻谷种植": {
                                "code": "0111",
                                "name": "稻谷种植",
                                "children": {}
                            },
                            "小麦种植": {
                                "code": "0112",
                                "name": "小麦种植",
                                "children": {}
                            },
                            "玉米种植": {
                                "code": "0113",
                                "name": "玉米种植",
                                "children": {}
                            },
                            "其他谷物种植": {
                                "code": "0119",
                                "name": "其他谷物种植",
                                "children": {}
                            }
                        }
                    },
                    "豆类、油料和薯类种植": {
                        "code": "012",
                        "name": "豆类、油料和薯类种植",
                        "children": {
                            "豆类种植": {
                                "code": "0121",
                                "name": "豆类种植",
                                "children": {}
                            },
                            "油料种植": {
                                "code": "0122",
                                "name": "油料种植",
                                "children": {}
                            },
                            "薯类种植": {
                                "code": "0123",
                                "name": "薯类种植",
                                "children": {}
                            }
                        }
                    },
                    "棉、麻、糖、烟草种植": {
                        "code": "013",
                        "name": "棉、麻、糖、烟草种植",
                        "children": {
                            "棉花种植": {
                                "code": "0131",
                                "name": "棉花种植",
                                "children": {}
                            },
                            "麻类种植": {
                                "code": "0132",
                                "name": "麻类种植",
                                "children": {}
                            },
                            "糖料种植": {
                                "code": "0133",
                                "name": "糖料种植",
                                "children": {}
                            },
                            "烟草种植": {
                                "code": "0134",
                                "name": "烟草种植",
                                "children": {}
                            }
                        }
                    },
                    "蔬菜、食用菌及园艺作物种植": {
                        "code": "014",
                        "name": "蔬菜、食用菌及园艺作物种植",
                        "children": {
                            "蔬菜种植": {
                                "code": "0141",
                                "name": "蔬菜种植",
                                "children": {}
                            },
                            "食用菌种植": {
                                "code": "0142",
                                "name": "食用菌种植",
                                "children": {}
                            },
                            "花卉种植": {
                                "code": "0143",
                                "name": "花卉种植",
                                "children": {}
                            },
                            "其他园艺作物种植": {
                                "code": "0149",
                                "name": "其他园艺作物种植",
                                "children": {}
                            }
                        }
                    },
                    "水果种植": {
                        "code": "015",
                        "name": "水果种植",
                        "children": {
                            "仁果类和核果类水果种植": {
                                "code": "0151",
                                "name": "仁果类和核果类水果种植",
                                "children": {}
                            },
                            "葡萄种植": {
                                "code": "0152",
                                "name": "葡萄种植",
                                "children": {}
                            },
                            "柑橘类种植": {
                                "code": "0153",
                                "name": "柑橘类种植",
                                "children": {}
                            },
                            "香蕉等亚热带水果种植": {
                                "code": "0154",
                                "name": "香蕉等亚热带水果种植",
                                "children": {}
                            },
                            "其他水果种植": {
                                "code": "0159",
                                "name": "其他水果种植",
                                "children": {}
                            }
                        }
                    },
                    "坚果、含油果、香料和饮料作物种植": {
                        "code": "016",
                        "name": "坚果、含油果、香料和饮料作物种植",
                        "children": {
                            "坚果种植": {
                                "code": "0161",
                                "name": "坚果种植",
                                "children": {}
                            },
                            "含油果种植": {
                                "code": "0162",
                                "name": "含油果种植",
                                "children": {}
                            },
                            "香料作物种植": {
                                "code": "0163",
                                "name": "香料作物种植",
                                "children": {}
                            },
                            "茶叶种植": {
                                "code": "0164",
                                "name": "茶叶种植",
                                "children": {}
                            },
                            "其他饮料作物种植": {
                                "code": "0169",
                                "name": "其他饮料作物种植",
                                "children": {}
                            }
                        }
                    },
                    "中药材种植": {
                        "code": "017",
                        "name": "中药材种植",
                        "children": {
                            "中草药种植": {
                                "code": "0171",
                                "name": "中草药种植",
                                "children": {}
                            },
                            "其他中药材种植": {
                                "code": "0179",
                                "name": "其他中药材种植",
                                "children": {}
                            }
                        }
                    },
                    "草种植及割草": {
                        "code": "018",
                        "name": "草种植及割草",
                        "children": {
                            "草种植": {
                                "code": "0181",
                                "name": "草种植",
                                "children": {}
                            },
                            "天然草原割草": {
                                "code": "0182",
                                "name": "天然草原割草",
                                "children": {}
                            }
                        }
                    },
                    "其他农业": {
                        "code": "019",
                        "name": "其他农业",
                        "children": {
                            "其他农业": {
                                "code": "0190",
                                "name": "其他农业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "林业": {
                "code": "02",
                "name": "林业",
                "children": {
                    "林木育种和育苗": {
                        "code": "021",
                        "name": "林木育种和育苗",
                        "children": {
                            "林木育种": {
                                "code": "0211",
                                "name": "林木育种",
                                "children": {}
                            },
                            "林木育苗": {
                                "code": "0212",
                                "name": "林木育苗",
                                "children": {}
                            }
                        }
                    },
                    "造林和更新": {
                        "code": "022",
                        "name": "造林和更新",
                        "children": {
                            "造林和更新": {
                                "code": "0220",
                                "name": "造林和更新",
                                "children": {}
                            }
                        }
                    },
                    "森林经营、管护和改培": {
                        "code": "023",
                        "name": "森林经营、管护和改培",
                        "children": {
                            "森林经营和管护": {
                                "code": "0231",
                                "name": "森林经营和管护",
                                "children": {}
                            },
                            "森林改培": {
                                "code": "0232",
                                "name": "森林改培",
                                "children": {}
                            }
                        }
                    },
                    "木材和竹材采运": {
                        "code": "024",
                        "name": "木材和竹材采运",
                        "children": {
                            "木材采运": {
                                "code": "0241",
                                "name": "木材采运",
                                "children": {}
                            },
                            "竹材采运": {
                                "code": "0242",
                                "name": "竹材采运",
                                "children": {}
                            }
                        }
                    },
                    "林产品采集": {
                        "code": "025",
                        "name": "林产品采集",
                        "children": {
                            "木竹材林产品采集": {
                                "code": "0251",
                                "name": "木竹材林产品采集",
                                "children": {}
                            },
                            "非木竹材林产品采集": {
                                "code": "0252",
                                "name": "非木竹材林产品采集",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "畜牧业": {
                "code": "03",
                "name": "畜牧业",
                "children": {
                    "牲畜饲养": {
                        "code": "031",
                        "name": "牲畜饲养",
                        "children": {
                            "牛的饲养": {
                                "code": "0311",
                                "name": "牛的饲养",
                                "children": {}
                            },
                            "马的饲养": {
                                "code": "0312",
                                "name": "马的饲养",
                                "children": {}
                            },
                            "猪的饲养": {
                                "code": "0313",
                                "name": "猪的饲养",
                                "children": {}
                            },
                            "羊的饲养": {
                                "code": "0314",
                                "name": "羊的饲养",
                                "children": {}
                            },
                            "骆驼饲养": {
                                "code": "0315",
                                "name": "骆驼饲养",
                                "children": {}
                            },
                            "其他牲畜饲养": {
                                "code": "0319",
                                "name": "其他牲畜饲养",
                                "children": {}
                            }
                        }
                    },
                    "家禽饲养": {
                        "code": "032",
                        "name": "家禽饲养",
                        "children": {
                            "鸡的饲养": {
                                "code": "0321",
                                "name": "鸡的饲养",
                                "children": {}
                            },
                            "鸭的饲养": {
                                "code": "0322",
                                "name": "鸭的饲养",
                                "children": {}
                            },
                            "鹅的饲养": {
                                "code": "0323",
                                "name": "鹅的饲养",
                                "children": {}
                            },
                            "其他家禽饲养": {
                                "code": "0329",
                                "name": "其他家禽饲养",
                                "children": {}
                            }
                        }
                    },
                    "狩猎和捕捉动物": {
                        "code": "033",
                        "name": "狩猎和捕捉动物",
                        "children": {
                            "狩猎和捕捉动物": {
                                "code": "0330",
                                "name": "狩猎和捕捉动物",
                                "children": {}
                            }
                        }
                    },
                    "其他畜牧业": {
                        "code": "039",
                        "name": "其他畜牧业",
                        "children": {
                            "兔的饲养": {
                                "code": "0391",
                                "name": "兔的饲养",
                                "children": {}
                            },
                            "蜜蜂饲养": {
                                "code": "0392",
                                "name": "蜜蜂饲养",
                                "children": {}
                            },
                            "其他未列明畜牧业": {
                                "code": "0399",
                                "name": "其他未列明畜牧业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "渔业": {
                "code": "04",
                "name": "渔业",
                "children": {
                    "水产养殖": {
                        "code": "041",
                        "name": "水产养殖",
                        "children": {
                            "海水养殖": {
                                "code": "0411",
                                "name": "海水养殖",
                                "children": {}
                            },
                            "内陆养殖": {
                                "code": "0412",
                                "name": "内陆养殖",
                                "children": {}
                            }
                        }
                    },
                    "水产捕捞": {
                        "code": "042",
                        "name": "水产捕捞",
                        "children": {
                            "海水捕捞": {
                                "code": "0421",
                                "name": "海水捕捞",
                                "children": {}
                            },
                            "内陆捕捞": {
                                "code": "0422",
                                "name": "内陆捕捞",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "农、林、牧、渔专业及辅助性活动": {
                "code": "05",
                "name": "农、林、牧、渔专业及辅助性活动",
                "children": {
                    "农业专业及辅助性活动": {
                        "code": "051",
                        "name": "农业专业及辅助性活动",
                        "children": {
                            "种子种苗培育活动": {
                                "code": "0511",
                                "name": "种子种苗培育活动",
                                "children": {}
                            },
                            "农业机械活动": {
                                "code": "0512",
                                "name": "农业机械活动",
                                "children": {}
                            },
                            "灌溉活动": {
                                "code": "0513",
                                "name": "灌溉活动",
                                "children": {}
                            },
                            "农产品初加工活动": {
                                "code": "0514",
                                "name": "农产品初加工活动",
                                "children": {}
                            },
                            "农作物病虫害防治活动": {
                                "code": "0515",
                                "name": "农作物病虫害防治活动",
                                "children": {}
                            },
                            "其他农业专业及辅助性活动": {
                                "code": "0519",
                                "name": "其他农业专业及辅助性活动",
                                "children": {}
                            }
                        }
                    },
                    "林业专业及辅助性活动": {
                        "code": "052",
                        "name": "林业专业及辅助性活动",
                        "children": {
                            "林业有害生物防治活动": {
                                "code": "0521",
                                "name": "林业有害生物防治活动",
                                "children": {}
                            },
                            "森林防火活动": {
                                "code": "0522",
                                "name": "森林防火活动",
                                "children": {}
                            },
                            "林产品初级加工活动": {
                                "code": "0523",
                                "name": "林产品初级加工活动",
                                "children": {}
                            },
                            "其他林业专业及辅助性活动": {
                                "code": "0529",
                                "name": "其他林业专业及辅助性活动",
                                "children": {}
                            }
                        }
                    },
                    "畜牧专业及辅助性活动": {
                        "code": "053",
                        "name": "畜牧专业及辅助性活动",
                        "children": {
                            "畜牧良种繁殖活动": {
                                "code": "0531",
                                "name": "畜牧良种繁殖活动",
                                "children": {}
                            },
                            "畜禽粪污处理活动": {
                                "code": "0532",
                                "name": "畜禽粪污处理活动",
                                "children": {}
                            },
                            "其他畜牧专业及辅助性活动": {
                                "code": "0539",
                                "name": "其他畜牧专业及辅助性活动",
                                "children": {}
                            }
                        }
                    },
                    "渔业专业及辅助性活动": {
                        "code": "054",
                        "name": "渔业专业及辅助性活动",
                        "children": {
                            "鱼苗及鱼种场活动": {
                                "code": "0541",
                                "name": "鱼苗及鱼种场活动",
                                "children": {}
                            },
                            "其他渔业专业及辅助性活动": {
                                "code": "0549",
                                "name": "其他渔业专业及辅助性活动",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "采矿业": {
        "code": "B",
        "name": "采矿业",
        "children": {
            "煤炭开采和洗选业": {
                "code": "06",
                "name": "煤炭开采和洗选业",
                "children": {
                    "烟煤和无烟煤开采洗选": {
                        "code": "061",
                        "name": "烟煤和无烟煤开采洗选",
                        "children": {
                            "烟煤和无烟煤开采洗选": {
                                "code": "0610",
                                "name": "烟煤和无烟煤开采洗选",
                                "children": {}
                            }
                        }
                    },
                    "褐煤开采洗选": {
                        "code": "062",
                        "name": "褐煤开采洗选",
                        "children": {
                            "褐煤开采洗选": {
                                "code": "0620",
                                "name": "褐煤开采洗选",
                                "children": {}
                            }
                        }
                    },
                    "其他煤炭采选": {
                        "code": "069",
                        "name": "其他煤炭采选",
                        "children": {
                            "其他煤炭采选": {
                                "code": "0690",
                                "name": "其他煤炭采选",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "石油和天然气开采业": {
                "code": "07",
                "name": "石油和天然气开采业",
                "children": {
                    "石油开采": {
                        "code": "071",
                        "name": "石油开采",
                        "children": {
                            "陆地石油开采": {
                                "code": "0711",
                                "name": "陆地石油开采",
                                "children": {}
                            },
                            "海洋石油开采": {
                                "code": "0712",
                                "name": "海洋石油开采",
                                "children": {}
                            }
                        }
                    },
                    "天然气开采": {
                        "code": "072",
                        "name": "天然气开采",
                        "children": {
                            "陆地天然气开采": {
                                "code": "0721",
                                "name": "陆地天然气开采",
                                "children": {}
                            },
                            "海洋天然气及可燃冰开采": {
                                "code": "0722",
                                "name": "海洋天然气及可燃冰开采",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "黑色金属矿采选业": {
                "code": "08",
                "name": "黑色金属矿采选业",
                "children": {
                    "铁矿采选": {
                        "code": "081",
                        "name": "铁矿采选",
                        "children": {
                            "铁矿采选": {
                                "code": "0810",
                                "name": "铁矿采选",
                                "children": {}
                            }
                        }
                    },
                    "锰矿、铬矿采选": {
                        "code": "082",
                        "name": "锰矿、铬矿采选",
                        "children": {
                            "锰矿、铬矿采选": {
                                "code": "0820",
                                "name": "锰矿、铬矿采选",
                                "children": {}
                            }
                        }
                    },
                    "其他黑色金属矿采选": {
                        "code": "089",
                        "name": "其他黑色金属矿采选",
                        "children": {
                            "其他黑色金属矿采选": {
                                "code": "0890",
                                "name": "其他黑色金属矿采选",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "有色金属矿采选业": {
                "code": "09",
                "name": "有色金属矿采选业",
                "children": {
                    "常用有色金属矿采选": {
                        "code": "091",
                        "name": "常用有色金属矿采选",
                        "children": {
                            "铜矿采选": {
                                "code": "0911",
                                "name": "铜矿采选",
                                "children": {}
                            },
                            "铅锌矿采选": {
                                "code": "0912",
                                "name": "铅锌矿采选",
                                "children": {}
                            },
                            "镍钴矿采选": {
                                "code": "0913",
                                "name": "镍钴矿采选",
                                "children": {}
                            },
                            "锡矿采选": {
                                "code": "0914",
                                "name": "锡矿采选",
                                "children": {}
                            },
                            "锑矿采选": {
                                "code": "0915",
                                "name": "锑矿采选",
                                "children": {}
                            },
                            "铝矿采选": {
                                "code": "0916",
                                "name": "铝矿采选",
                                "children": {}
                            },
                            "镁矿采选": {
                                "code": "0917",
                                "name": "镁矿采选",
                                "children": {}
                            },
                            "其他常用有色金属矿采选": {
                                "code": "0919",
                                "name": "其他常用有色金属矿采选",
                                "children": {}
                            }
                        }
                    },
                    "贵金属矿采选": {
                        "code": "092",
                        "name": "贵金属矿采选",
                        "children": {
                            "金矿采选": {
                                "code": "0921",
                                "name": "金矿采选",
                                "children": {}
                            },
                            "银矿采选": {
                                "code": "0922",
                                "name": "银矿采选",
                                "children": {}
                            },
                            "其他贵金属矿采选": {
                                "code": "0929",
                                "name": "其他贵金属矿采选",
                                "children": {}
                            }
                        }
                    },
                    "稀有稀土金属矿采选": {
                        "code": "093",
                        "name": "稀有稀土金属矿采选",
                        "children": {
                            "钨钼矿采选": {
                                "code": "0931",
                                "name": "钨钼矿采选",
                                "children": {}
                            },
                            "稀土金属矿采选": {
                                "code": "0932",
                                "name": "稀土金属矿采选",
                                "children": {}
                            },
                            "放射性金属矿采选": {
                                "code": "0933",
                                "name": "放射性金属矿采选",
                                "children": {}
                            },
                            "其他稀有金属矿采选": {
                                "code": "0939",
                                "name": "其他稀有金属矿采选",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "非金属矿采选业": {
                "code": "10",
                "name": "非金属矿采选业",
                "children": {
                    "土砂石开采": {
                        "code": "101",
                        "name": "土砂石开采",
                        "children": {
                            "石灰石、石膏开采": {
                                "code": "1011",
                                "name": "石灰石、石膏开采",
                                "children": {}
                            },
                            "建筑装饰用石开采": {
                                "code": "1012",
                                "name": "建筑装饰用石开采",
                                "children": {}
                            },
                            "耐火土石开采": {
                                "code": "1013",
                                "name": "耐火土石开采",
                                "children": {}
                            },
                            "粘土及其他土砂石开采": {
                                "code": "1019",
                                "name": "粘土及其他土砂石开采",
                                "children": {}
                            }
                        }
                    },
                    "化学矿开采": {
                        "code": "102",
                        "name": "化学矿开采",
                        "children": {
                            "化学矿开采": {
                                "code": "1020",
                                "name": "化学矿开采",
                                "children": {}
                            }
                        }
                    },
                    "采盐": {
                        "code": "103",
                        "name": "采盐",
                        "children": {
                            "采盐": {
                                "code": "1030",
                                "name": "采盐",
                                "children": {}
                            }
                        }
                    },
                    "石棉及其他非金属矿采选": {
                        "code": "109",
                        "name": "石棉及其他非金属矿采选",
                        "children": {
                            "石棉、云母矿采选": {
                                "code": "1091",
                                "name": "石棉、云母矿采选",
                                "children": {}
                            },
                            "石墨、滑石采选": {
                                "code": "1092",
                                "name": "石墨、滑石采选",
                                "children": {}
                            },
                            "宝石、玉石采选": {
                                "code": "1093",
                                "name": "宝石、玉石采选",
                                "children": {}
                            },
                            "其他未列明非金属矿采选": {
                                "code": "1099",
                                "name": "其他未列明非金属矿采选",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "开采专业及辅助性活动": {
                "code": "11",
                "name": "开采专业及辅助性活动",
                "children": {
                    "煤炭开采和洗选专业及辅助性活动": {
                        "code": "111",
                        "name": "煤炭开采和洗选专业及辅助性活动",
                        "children": {
                            "煤炭开采和洗选专业及辅助性活动": {
                                "code": "1110",
                                "name": "煤炭开采和洗选专业及辅助性活动",
                                "children": {}
                            }
                        }
                    },
                    "石油和天然气开采专业及辅助性活动": {
                        "code": "112",
                        "name": "石油和天然气开采专业及辅助性活动",
                        "children": {
                            "石油和天然气开采专业及辅助性活动": {
                                "code": "1120",
                                "name": "石油和天然气开采专业及辅助性活动",
                                "children": {}
                            }
                        }
                    },
                    "其他开采专业及辅助性活动": {
                        "code": "119",
                        "name": "其他开采专业及辅助性活动",
                        "children": {
                            "其他开采专业及辅助性活动": {
                                "code": "1190",
                                "name": "其他开采专业及辅助性活动",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "其他采矿业": {
                "code": "12",
                "name": "其他采矿业",
                "children": {
                    "其他采矿业": {
                        "code": "120",
                        "name": "其他采矿业",
                        "children": {
                            "其他采矿业": {
                                "code": "1200",
                                "name": "其他采矿业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "制造业": {
        "code": "C",
        "name": "制造业",
        "children": {
            "农副食品加工业": {
                "code": "13",
                "name": "农副食品加工业",
                "children": {
                    "谷物磨制": {
                        "code": "131",
                        "name": "谷物磨制",
                        "children": {
                            "稻谷加工": {
                                "code": "1311",
                                "name": "稻谷加工",
                                "children": {}
                            },
                            "小麦加工": {
                                "code": "1312",
                                "name": "小麦加工",
                                "children": {}
                            },
                            "玉米加工": {
                                "code": "1313",
                                "name": "玉米加工",
                                "children": {}
                            },
                            "杂粮加工": {
                                "code": "1314",
                                "name": "杂粮加工",
                                "children": {}
                            },
                            "其他谷物磨制": {
                                "code": "1319",
                                "name": "其他谷物磨制",
                                "children": {}
                            }
                        }
                    },
                    "饲料加工": {
                        "code": "132",
                        "name": "饲料加工",
                        "children": {
                            "宠物饲料加工": {
                                "code": "1321",
                                "name": "宠物饲料加工",
                                "children": {}
                            },
                            "其他饲料加工": {
                                "code": "1329",
                                "name": "其他饲料加工",
                                "children": {}
                            }
                        }
                    },
                    "植物油加工": {
                        "code": "133",
                        "name": "植物油加工",
                        "children": {
                            "食用植物油加工": {
                                "code": "1331",
                                "name": "食用植物油加工",
                                "children": {}
                            },
                            "非食用植物油加工": {
                                "code": "1332",
                                "name": "非食用植物油加工",
                                "children": {}
                            }
                        }
                    },
                    "制糖业": {
                        "code": "134",
                        "name": "制糖业",
                        "children": {
                            "制糖业": {
                                "code": "1340",
                                "name": "制糖业",
                                "children": {}
                            }
                        }
                    },
                    "屠宰及肉类加工": {
                        "code": "135",
                        "name": "屠宰及肉类加工",
                        "children": {
                            "牲畜屠宰": {
                                "code": "1351",
                                "name": "牲畜屠宰",
                                "children": {}
                            },
                            "禽类屠宰": {
                                "code": "1352",
                                "name": "禽类屠宰",
                                "children": {}
                            },
                            "肉制品及副产品加工": {
                                "code": "1353",
                                "name": "肉制品及副产品加工",
                                "children": {}
                            }
                        }
                    },
                    "水产品加工": {
                        "code": "136",
                        "name": "水产品加工",
                        "children": {
                            "水产品冷冻加工": {
                                "code": "1361",
                                "name": "水产品冷冻加工",
                                "children": {}
                            },
                            "鱼糜制品及水产品干腌制加工": {
                                "code": "1362",
                                "name": "鱼糜制品及水产品干腌制加工",
                                "children": {}
                            },
                            "鱼油提取及制品制造": {
                                "code": "1363",
                                "name": "鱼油提取及制品制造",
                                "children": {}
                            },
                            "其他水产品加工": {
                                "code": "1369",
                                "name": "其他水产品加工",
                                "children": {}
                            }
                        }
                    },
                    "蔬菜、菌类、水果和坚果加工": {
                        "code": "137",
                        "name": "蔬菜、菌类、水果和坚果加工",
                        "children": {
                            "蔬菜加工": {
                                "code": "1371",
                                "name": "蔬菜加工",
                                "children": {}
                            },
                            "食用菌加工": {
                                "code": "1372",
                                "name": "食用菌加工",
                                "children": {}
                            },
                            "水果和坚果加工": {
                                "code": "1373",
                                "name": "水果和坚果加工",
                                "children": {}
                            }
                        }
                    },
                    "其他农副食品加工": {
                        "code": "139",
                        "name": "其他农副食品加工",
                        "children": {
                            "淀粉及淀粉制品制造": {
                                "code": "1391",
                                "name": "淀粉及淀粉制品制造",
                                "children": {}
                            },
                            "豆制品制造": {
                                "code": "1392",
                                "name": "豆制品制造",
                                "children": {}
                            },
                            "蛋品加工": {
                                "code": "1393",
                                "name": "蛋品加工",
                                "children": {}
                            },
                            "其他未列明农副食品加工": {
                                "code": "1399",
                                "name": "其他未列明农副食品加工",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "食品制造业": {
                "code": "14",
                "name": "食品制造业",
                "children": {
                    "焙烤食品制造": {
                        "code": "141",
                        "name": "焙烤食品制造",
                        "children": {
                            "糕点、面包制造": {
                                "code": "1411",
                                "name": "糕点、面包制造",
                                "children": {}
                            },
                            "饼干及其他焙烤食品制造": {
                                "code": "1419",
                                "name": "饼干及其他焙烤食品制造",
                                "children": {}
                            }
                        }
                    },
                    "糖果、巧克力及蜜饯制造": {
                        "code": "142",
                        "name": "糖果、巧克力及蜜饯制造",
                        "children": {
                            "糖果、巧克力制造": {
                                "code": "1421",
                                "name": "糖果、巧克力制造",
                                "children": {}
                            },
                            "蜜饯制作": {
                                "code": "1422",
                                "name": "蜜饯制作",
                                "children": {}
                            }
                        }
                    },
                    "方便食品制造": {
                        "code": "143",
                        "name": "方便食品制造",
                        "children": {
                            "米、面制品制造": {
                                "code": "1431",
                                "name": "米、面制品制造",
                                "children": {}
                            },
                            "速冻食品制造": {
                                "code": "1432",
                                "name": "速冻食品制造",
                                "children": {}
                            },
                            "方便面制造": {
                                "code": "1433",
                                "name": "方便面制造",
                                "children": {}
                            },
                            "其他方便食品制造": {
                                "code": "1439",
                                "name": "其他方便食品制造",
                                "children": {}
                            }
                        }
                    },
                    "乳制品制造": {
                        "code": "144",
                        "name": "乳制品制造",
                        "children": {
                            "液体乳制造": {
                                "code": "1441",
                                "name": "液体乳制造",
                                "children": {}
                            },
                            "乳粉制造": {
                                "code": "1442",
                                "name": "乳粉制造",
                                "children": {}
                            },
                            "其他乳制品制造": {
                                "code": "1449",
                                "name": "其他乳制品制造",
                                "children": {}
                            }
                        }
                    },
                    "罐头食品制造": {
                        "code": "145",
                        "name": "罐头食品制造",
                        "children": {
                            "肉、禽类罐头制造": {
                                "code": "1451",
                                "name": "肉、禽类罐头制造",
                                "children": {}
                            },
                            "水产品罐头制造": {
                                "code": "1452",
                                "name": "水产品罐头制造",
                                "children": {}
                            },
                            "蔬菜、水果罐头制造": {
                                "code": "1453",
                                "name": "蔬菜、水果罐头制造",
                                "children": {}
                            },
                            "其他罐头食品制造": {
                                "code": "1459",
                                "name": "其他罐头食品制造",
                                "children": {}
                            }
                        }
                    },
                    "调味品、发酵制品制造": {
                        "code": "146",
                        "name": "调味品、发酵制品制造",
                        "children": {
                            "味精制造": {
                                "code": "1461",
                                "name": "味精制造",
                                "children": {}
                            },
                            "酱油、食醋及类似制品制造": {
                                "code": "1462",
                                "name": "酱油、食醋及类似制品制造",
                                "children": {}
                            },
                            "其他调味品、发酵制品制造": {
                                "code": "1469",
                                "name": "其他调味品、发酵制品制造",
                                "children": {}
                            }
                        }
                    },
                    "其他食品制造": {
                        "code": "149",
                        "name": "其他食品制造",
                        "children": {
                            "营养食品制造": {
                                "code": "1491",
                                "name": "营养食品制造",
                                "children": {}
                            },
                            "保健食品制造": {
                                "code": "1492",
                                "name": "保健食品制造",
                                "children": {}
                            },
                            "冷冻饮品及食用冰制造": {
                                "code": "1493",
                                "name": "冷冻饮品及食用冰制造",
                                "children": {}
                            },
                            "盐加工": {
                                "code": "1494",
                                "name": "盐加工",
                                "children": {}
                            },
                            "食品及饲料添加剂制造": {
                                "code": "1495",
                                "name": "食品及饲料添加剂制造",
                                "children": {}
                            },
                            "其他未列明食品制造": {
                                "code": "1499",
                                "name": "其他未列明食品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "酒、饮料和精制茶制造业": {
                "code": "15",
                "name": "酒、饮料和精制茶制造业",
                "children": {
                    "酒的制造": {
                        "code": "151",
                        "name": "酒的制造",
                        "children": {
                            "酒精制造": {
                                "code": "1511",
                                "name": "酒精制造",
                                "children": {}
                            },
                            "白酒制造": {
                                "code": "1512",
                                "name": "白酒制造",
                                "children": {}
                            },
                            "啤酒制造": {
                                "code": "1513",
                                "name": "啤酒制造",
                                "children": {}
                            },
                            "黄酒制造": {
                                "code": "1514",
                                "name": "黄酒制造",
                                "children": {}
                            },
                            "葡萄酒制造": {
                                "code": "1515",
                                "name": "葡萄酒制造",
                                "children": {}
                            },
                            "其他酒制造": {
                                "code": "1519",
                                "name": "其他酒制造",
                                "children": {}
                            }
                        }
                    },
                    "饮料制造": {
                        "code": "152",
                        "name": "饮料制造",
                        "children": {
                            "碳酸饮料制造": {
                                "code": "1521",
                                "name": "碳酸饮料制造",
                                "children": {}
                            },
                            "瓶（罐）装饮用水制造": {
                                "code": "1522",
                                "name": "瓶（罐）装饮用水制造",
                                "children": {}
                            },
                            "果菜汁及果菜汁饮料制造": {
                                "code": "1523",
                                "name": "果菜汁及果菜汁饮料制造",
                                "children": {}
                            },
                            "含乳饮料和植物蛋白饮料制造": {
                                "code": "1524",
                                "name": "含乳饮料和植物蛋白饮料制造",
                                "children": {}
                            },
                            "固体饮料制造": {
                                "code": "1525",
                                "name": "固体饮料制造",
                                "children": {}
                            },
                            "茶饮料及其他饮料制造": {
                                "code": "1529",
                                "name": "茶饮料及其他饮料制造",
                                "children": {}
                            }
                        }
                    },
                    "精制茶加工": {
                        "code": "153",
                        "name": "精制茶加工",
                        "children": {
                            "精制茶加工": {
                                "code": "1530",
                                "name": "精制茶加工",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "烟草制品业": {
                "code": "16",
                "name": "烟草制品业",
                "children": {
                    "烟叶复烤": {
                        "code": "161",
                        "name": "烟叶复烤",
                        "children": {
                            "烟叶复烤": {
                                "code": "1610",
                                "name": "烟叶复烤",
                                "children": {}
                            }
                        }
                    },
                    "卷烟制造": {
                        "code": "162",
                        "name": "卷烟制造",
                        "children": {
                            "卷烟制造": {
                                "code": "1620",
                                "name": "卷烟制造",
                                "children": {}
                            }
                        }
                    },
                    "其他烟草制品制造": {
                        "code": "169",
                        "name": "其他烟草制品制造",
                        "children": {
                            "其他烟草制品制造": {
                                "code": "1690",
                                "name": "其他烟草制品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "纺织业": {
                "code": "17",
                "name": "纺织业",
                "children": {
                    "棉纺织及印染精加工": {
                        "code": "171",
                        "name": "棉纺织及印染精加工",
                        "children": {
                            "棉纺纱加工": {
                                "code": "1711",
                                "name": "棉纺纱加工",
                                "children": {}
                            },
                            "棉织造加工": {
                                "code": "1712",
                                "name": "棉织造加工",
                                "children": {}
                            },
                            "棉印染精加工": {
                                "code": "1713",
                                "name": "棉印染精加工",
                                "children": {}
                            }
                        }
                    },
                    "毛纺织及染整精加工": {
                        "code": "172",
                        "name": "毛纺织及染整精加工",
                        "children": {
                            "毛条和毛纱线加工": {
                                "code": "1721",
                                "name": "毛条和毛纱线加工",
                                "children": {}
                            },
                            "毛织造加工": {
                                "code": "1722",
                                "name": "毛织造加工",
                                "children": {}
                            },
                            "毛染整精加工": {
                                "code": "1723",
                                "name": "毛染整精加工",
                                "children": {}
                            }
                        }
                    },
                    "麻纺织及染整精加工": {
                        "code": "173",
                        "name": "麻纺织及染整精加工",
                        "children": {
                            "麻纤维纺前加工和纺纱": {
                                "code": "1731",
                                "name": "麻纤维纺前加工和纺纱",
                                "children": {}
                            },
                            "麻织造加工": {
                                "code": "1732",
                                "name": "麻织造加工",
                                "children": {}
                            },
                            "麻染整精加工": {
                                "code": "1733",
                                "name": "麻染整精加工",
                                "children": {}
                            }
                        }
                    },
                    "丝绢纺织及印染精加工": {
                        "code": "174",
                        "name": "丝绢纺织及印染精加工",
                        "children": {
                            "缫丝加工": {
                                "code": "1741",
                                "name": "缫丝加工",
                                "children": {}
                            },
                            "绢纺和丝织加工": {
                                "code": "1742",
                                "name": "绢纺和丝织加工",
                                "children": {}
                            },
                            "丝印染精加工": {
                                "code": "1743",
                                "name": "丝印染精加工",
                                "children": {}
                            }
                        }
                    },
                    "化纤织造及印染精加工": {
                        "code": "175",
                        "name": "化纤织造及印染精加工",
                        "children": {
                            "化纤织造加工": {
                                "code": "1751",
                                "name": "化纤织造加工",
                                "children": {}
                            },
                            "化纤织物染整精加工": {
                                "code": "1752",
                                "name": "化纤织物染整精加工",
                                "children": {}
                            }
                        }
                    },
                    "针织或钩针编织物及其制品制造": {
                        "code": "176",
                        "name": "针织或钩针编织物及其制品制造",
                        "children": {
                            "针织或钩针编织物织造": {
                                "code": "1761",
                                "name": "针织或钩针编织物织造",
                                "children": {}
                            },
                            "针织或钩针编织物印染精加工": {
                                "code": "1762",
                                "name": "针织或钩针编织物印染精加工",
                                "children": {}
                            },
                            "针织或钩针编织品制造": {
                                "code": "1763",
                                "name": "针织或钩针编织品制造",
                                "children": {}
                            }
                        }
                    },
                    "家用纺织制成品制造": {
                        "code": "177",
                        "name": "家用纺织制成品制造",
                        "children": {
                            "床上用品制造": {
                                "code": "1771",
                                "name": "床上用品制造",
                                "children": {}
                            },
                            "毛巾类制品制造": {
                                "code": "1772",
                                "name": "毛巾类制品制造",
                                "children": {}
                            },
                            "窗帘、布艺类产品制造": {
                                "code": "1773",
                                "name": "窗帘、布艺类产品制造",
                                "children": {}
                            },
                            "其他家用纺织制成品制造": {
                                "code": "1779",
                                "name": "其他家用纺织制成品制造",
                                "children": {}
                            }
                        }
                    },
                    "产业用纺织制成品制造": {
                        "code": "178",
                        "name": "产业用纺织制成品制造",
                        "children": {
                            "非织造布制造": {
                                "code": "1781",
                                "name": "非织造布制造",
                                "children": {}
                            },
                            "绳、索、缆制造": {
                                "code": "1782",
                                "name": "绳、索、缆制造",
                                "children": {}
                            },
                            "纺织带和帘子布制造": {
                                "code": "1783",
                                "name": "纺织带和帘子布制造",
                                "children": {}
                            },
                            "篷、帆布制造": {
                                "code": "1784",
                                "name": "篷、帆布制造",
                                "children": {}
                            },
                            "其他产业用纺织制成品制造": {
                                "code": "1789",
                                "name": "其他产业用纺织制成品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "纺织服装、服饰业": {
                "code": "18",
                "name": "纺织服装、服饰业",
                "children": {
                    "机织服装制造": {
                        "code": "181",
                        "name": "机织服装制造",
                        "children": {
                            "运动机织服装制造": {
                                "code": "1811",
                                "name": "运动机织服装制造",
                                "children": {}
                            },
                            "其他机织服装制造": {
                                "code": "1819",
                                "name": "其他机织服装制造",
                                "children": {}
                            }
                        }
                    },
                    "针织或钩针编织服装制造": {
                        "code": "182",
                        "name": "针织或钩针编织服装制造",
                        "children": {
                            "运动休闲针织服装制造": {
                                "code": "1821",
                                "name": "运动休闲针织服装制造",
                                "children": {}
                            },
                            "其他针织或钩针编织服装制造": {
                                "code": "1829",
                                "name": "其他针织或钩针编织服装制造",
                                "children": {}
                            }
                        }
                    },
                    "服饰制造": {
                        "code": "183",
                        "name": "服饰制造",
                        "children": {
                            "服饰制造": {
                                "code": "1830",
                                "name": "服饰制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "皮革、毛皮、羽毛及其制品和制鞋业": {
                "code": "19",
                "name": "皮革、毛皮、羽毛及其制品和制鞋业",
                "children": {
                    "皮革鞣制加工": {
                        "code": "191",
                        "name": "皮革鞣制加工",
                        "children": {
                            "皮革鞣制加工": {
                                "code": "1910",
                                "name": "皮革鞣制加工",
                                "children": {}
                            }
                        }
                    },
                    "皮革制品制造": {
                        "code": "192",
                        "name": "皮革制品制造",
                        "children": {
                            "皮革服装制造": {
                                "code": "1921",
                                "name": "皮革服装制造",
                                "children": {}
                            },
                            "皮箱、包（袋）制造": {
                                "code": "1922",
                                "name": "皮箱、包（袋）制造",
                                "children": {}
                            },
                            "皮手套及皮装饰制品制造": {
                                "code": "1923",
                                "name": "皮手套及皮装饰制品制造",
                                "children": {}
                            },
                            "其他皮革制品制造": {
                                "code": "1929",
                                "name": "其他皮革制品制造",
                                "children": {}
                            }
                        }
                    },
                    "毛皮鞣制及制品加工": {
                        "code": "193",
                        "name": "毛皮鞣制及制品加工",
                        "children": {
                            "毛皮鞣制加工": {
                                "code": "1931",
                                "name": "毛皮鞣制加工",
                                "children": {}
                            },
                            "毛皮服装加工": {
                                "code": "1932",
                                "name": "毛皮服装加工",
                                "children": {}
                            },
                            "其他毛皮制品加工": {
                                "code": "1939",
                                "name": "其他毛皮制品加工",
                                "children": {}
                            }
                        }
                    },
                    "羽毛(绒)加工及制品制造": {
                        "code": "194",
                        "name": "羽毛(绒)加工及制品制造",
                        "children": {
                            "羽毛（绒）加工": {
                                "code": "1941",
                                "name": "羽毛（绒）加工",
                                "children": {}
                            },
                            "羽毛（绒）制品加工": {
                                "code": "1942",
                                "name": "羽毛（绒）制品加工",
                                "children": {}
                            }
                        }
                    },
                    "制鞋业": {
                        "code": "195",
                        "name": "制鞋业",
                        "children": {
                            "纺织面料鞋制造": {
                                "code": "1951",
                                "name": "纺织面料鞋制造",
                                "children": {}
                            },
                            "皮鞋制造": {
                                "code": "1952",
                                "name": "皮鞋制造",
                                "children": {}
                            },
                            "塑料鞋制造": {
                                "code": "1953",
                                "name": "塑料鞋制造",
                                "children": {}
                            },
                            "橡胶鞋制造": {
                                "code": "1954",
                                "name": "橡胶鞋制造",
                                "children": {}
                            },
                            "其他制鞋业": {
                                "code": "1959",
                                "name": "其他制鞋业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "木材加工和木、竹、藤、棕、草制品业": {
                "code": "20",
                "name": "木材加工和木、竹、藤、棕、草制品业",
                "children": {
                    "木材加工": {
                        "code": "201",
                        "name": "木材加工",
                        "children": {
                            "锯材加工": {
                                "code": "2011",
                                "name": "锯材加工",
                                "children": {}
                            },
                            "木片加工": {
                                "code": "2012",
                                "name": "木片加工",
                                "children": {}
                            },
                            "单板加工": {
                                "code": "2013",
                                "name": "单板加工",
                                "children": {}
                            },
                            "其他木材加工": {
                                "code": "2019",
                                "name": "其他木材加工",
                                "children": {}
                            }
                        }
                    },
                    "人造板制造": {
                        "code": "202",
                        "name": "人造板制造",
                        "children": {
                            "胶合板制造": {
                                "code": "2021",
                                "name": "胶合板制造",
                                "children": {}
                            },
                            "纤维板制造": {
                                "code": "2022",
                                "name": "纤维板制造",
                                "children": {}
                            },
                            "刨花板制造": {
                                "code": "2023",
                                "name": "刨花板制造",
                                "children": {}
                            },
                            "其他人造板制造": {
                                "code": "2029",
                                "name": "其他人造板制造",
                                "children": {}
                            }
                        }
                    },
                    "木质制品制造": {
                        "code": "203",
                        "name": "木质制品制造",
                        "children": {
                            "建筑用木料及木材组件加工": {
                                "code": "2031",
                                "name": "建筑用木料及木材组件加工",
                                "children": {}
                            },
                            "木门窗制造": {
                                "code": "2032",
                                "name": "木门窗制造",
                                "children": {}
                            },
                            "木楼梯制造": {
                                "code": "2033",
                                "name": "木楼梯制造",
                                "children": {}
                            },
                            "木地板制造": {
                                "code": "2034",
                                "name": "木地板制造",
                                "children": {}
                            },
                            "木制容器制造": {
                                "code": "2035",
                                "name": "木制容器制造",
                                "children": {}
                            },
                            "软木制品及其他木制品制造": {
                                "code": "2039",
                                "name": "软木制品及其他木制品制造",
                                "children": {}
                            }
                        }
                    },
                    "竹、藤、棕、草等制品制造": {
                        "code": "204",
                        "name": "竹、藤、棕、草等制品制造",
                        "children": {
                            "竹制品制造": {
                                "code": "2041",
                                "name": "竹制品制造",
                                "children": {}
                            },
                            "藤制品制造": {
                                "code": "2042",
                                "name": "藤制品制造",
                                "children": {}
                            },
                            "棕制品制造": {
                                "code": "2043",
                                "name": "棕制品制造",
                                "children": {}
                            },
                            "草及其他制品制造": {
                                "code": "2049",
                                "name": "草及其他制品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "家具制造业": {
                "code": "21",
                "name": "家具制造业",
                "children": {
                    "木质家具制造": {
                        "code": "211",
                        "name": "木质家具制造",
                        "children": {
                            "木质家具制造": {
                                "code": "2110",
                                "name": "木质家具制造",
                                "children": {}
                            }
                        }
                    },
                    "竹、藤家具制造": {
                        "code": "212",
                        "name": "竹、藤家具制造",
                        "children": {
                            "竹、藤家具制造": {
                                "code": "2120",
                                "name": "竹、藤家具制造",
                                "children": {}
                            }
                        }
                    },
                    "金属家具制造": {
                        "code": "213",
                        "name": "金属家具制造",
                        "children": {
                            "金属家具制造": {
                                "code": "2130",
                                "name": "金属家具制造",
                                "children": {}
                            }
                        }
                    },
                    "塑料家具制造": {
                        "code": "214",
                        "name": "塑料家具制造",
                        "children": {
                            "塑料家具制造": {
                                "code": "2140",
                                "name": "塑料家具制造",
                                "children": {}
                            }
                        }
                    },
                    "其他家具制造": {
                        "code": "219",
                        "name": "其他家具制造",
                        "children": {
                            "其他家具制造": {
                                "code": "2190",
                                "name": "其他家具制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "造纸和纸制品业": {
                "code": "22",
                "name": "造纸和纸制品业",
                "children": {
                    "纸浆制造": {
                        "code": "221",
                        "name": "纸浆制造",
                        "children": {
                            "木竹浆制造": {
                                "code": "2211",
                                "name": "木竹浆制造",
                                "children": {}
                            },
                            "非木竹浆制造": {
                                "code": "2212",
                                "name": "非木竹浆制造",
                                "children": {}
                            }
                        }
                    },
                    "造纸": {
                        "code": "222",
                        "name": "造纸",
                        "children": {
                            "机制纸及纸板制造": {
                                "code": "2221",
                                "name": "机制纸及纸板制造",
                                "children": {}
                            },
                            "手工纸制造": {
                                "code": "2222",
                                "name": "手工纸制造",
                                "children": {}
                            },
                            "加工纸制造": {
                                "code": "2223",
                                "name": "加工纸制造",
                                "children": {}
                            }
                        }
                    },
                    "纸制品制造": {
                        "code": "223",
                        "name": "纸制品制造",
                        "children": {
                            "纸和纸板容器制造": {
                                "code": "2231",
                                "name": "纸和纸板容器制造",
                                "children": {}
                            },
                            "其他纸制品制造": {
                                "code": "2239",
                                "name": "其他纸制品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "印刷和记录媒介复制业": {
                "code": "23",
                "name": "印刷和记录媒介复制业",
                "children": {
                    "印刷": {
                        "code": "231",
                        "name": "印刷",
                        "children": {
                            "书、报刊印刷": {
                                "code": "2311",
                                "name": "书、报刊印刷",
                                "children": {}
                            },
                            "本册印制": {
                                "code": "2312",
                                "name": "本册印制",
                                "children": {}
                            },
                            "包装装潢及其他印刷": {
                                "code": "2319",
                                "name": "包装装潢及其他印刷",
                                "children": {}
                            }
                        }
                    },
                    "装订及印刷相关服务": {
                        "code": "232",
                        "name": "装订及印刷相关服务",
                        "children": {
                            "装订及印刷相关服务": {
                                "code": "2320",
                                "name": "装订及印刷相关服务",
                                "children": {}
                            }
                        }
                    },
                    "记录媒介复制": {
                        "code": "233",
                        "name": "记录媒介复制",
                        "children": {
                            "记录媒介复制": {
                                "code": "2330",
                                "name": "记录媒介复制",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "文教、工美、体育和娱乐用品制造业": {
                "code": "24",
                "name": "文教、工美、体育和娱乐用品制造业",
                "children": {
                    "文教办公用品制造": {
                        "code": "241",
                        "name": "文教办公用品制造",
                        "children": {
                            "文具制造": {
                                "code": "2411",
                                "name": "文具制造",
                                "children": {}
                            },
                            "笔的制造": {
                                "code": "2412",
                                "name": "笔的制造",
                                "children": {}
                            },
                            "教学用模型及教具制造": {
                                "code": "2413",
                                "name": "教学用模型及教具制造",
                                "children": {}
                            },
                            "墨水、墨汁制造": {
                                "code": "2414",
                                "name": "墨水、墨汁制造",
                                "children": {}
                            },
                            "其他文教办公用品制造": {
                                "code": "2419",
                                "name": "其他文教办公用品制造",
                                "children": {}
                            }
                        }
                    },
                    "乐器制造": {
                        "code": "242",
                        "name": "乐器制造",
                        "children": {
                            "中乐器制造": {
                                "code": "2421",
                                "name": "中乐器制造",
                                "children": {}
                            },
                            "西乐器制造": {
                                "code": "2422",
                                "name": "西乐器制造",
                                "children": {}
                            },
                            "电子乐器制造": {
                                "code": "2423",
                                "name": "电子乐器制造",
                                "children": {}
                            },
                            "其他乐器及零件制造": {
                                "code": "2429",
                                "name": "其他乐器及零件制造",
                                "children": {}
                            }
                        }
                    },
                    "工艺美术及礼仪用品制造": {
                        "code": "243",
                        "name": "工艺美术及礼仪用品制造",
                        "children": {
                            "雕塑工艺品制造": {
                                "code": "2431",
                                "name": "雕塑工艺品制造",
                                "children": {}
                            },
                            "金属工艺品制造": {
                                "code": "2432",
                                "name": "金属工艺品制造",
                                "children": {}
                            },
                            "漆器工艺品制造": {
                                "code": "2433",
                                "name": "漆器工艺品制造",
                                "children": {}
                            },
                            "花画工艺品制造": {
                                "code": "2434",
                                "name": "花画工艺品制造",
                                "children": {}
                            },
                            "天然植物纤维编织工艺品制造": {
                                "code": "2435",
                                "name": "天然植物纤维编织工艺品制造",
                                "children": {}
                            },
                            "抽纱刺绣工艺品制造": {
                                "code": "2436",
                                "name": "抽纱刺绣工艺品制造",
                                "children": {}
                            },
                            "地毯、挂毯制造": {
                                "code": "2437",
                                "name": "地毯、挂毯制造",
                                "children": {}
                            },
                            "珠宝首饰及有关物品制造": {
                                "code": "2438",
                                "name": "珠宝首饰及有关物品制造",
                                "children": {}
                            },
                            "其他工艺美术及礼仪用品制造": {
                                "code": "2439",
                                "name": "其他工艺美术及礼仪用品制造",
                                "children": {}
                            }
                        }
                    },
                    "体育用品制造": {
                        "code": "244",
                        "name": "体育用品制造",
                        "children": {
                            "球类制造": {
                                "code": "2441",
                                "name": "球类制造",
                                "children": {}
                            },
                            "专项运动器材及配件制造": {
                                "code": "2442",
                                "name": "专项运动器材及配件制造",
                                "children": {}
                            },
                            "健身器材制造": {
                                "code": "2443",
                                "name": "健身器材制造",
                                "children": {}
                            },
                            "运动防护用具制造": {
                                "code": "2444",
                                "name": "运动防护用具制造",
                                "children": {}
                            },
                            "其他体育用品制造": {
                                "code": "2449",
                                "name": "其他体育用品制造",
                                "children": {}
                            }
                        }
                    },
                    "玩具制造": {
                        "code": "245",
                        "name": "玩具制造",
                        "children": {
                            "电玩具制造": {
                                "code": "2451",
                                "name": "电玩具制造",
                                "children": {}
                            },
                            "塑胶玩具制造": {
                                "code": "2452",
                                "name": "塑胶玩具制造",
                                "children": {}
                            },
                            "金属玩具制造": {
                                "code": "2453",
                                "name": "金属玩具制造",
                                "children": {}
                            },
                            "弹射玩具制造": {
                                "code": "2454",
                                "name": "弹射玩具制造",
                                "children": {}
                            },
                            "娃娃玩具制造": {
                                "code": "2455",
                                "name": "娃娃玩具制造",
                                "children": {}
                            },
                            "儿童乘骑玩耍的童车类产品制造": {
                                "code": "2456",
                                "name": "儿童乘骑玩耍的童车类产品制造",
                                "children": {}
                            },
                            "其他玩具制造": {
                                "code": "2459",
                                "name": "其他玩具制造",
                                "children": {}
                            }
                        }
                    },
                    "游艺器材及娱乐用品制造": {
                        "code": "246",
                        "name": "游艺器材及娱乐用品制造",
                        "children": {
                            "露天游乐场所游乐设备制造": {
                                "code": "2461",
                                "name": "露天游乐场所游乐设备制造",
                                "children": {}
                            },
                            "游艺用品及室内游艺器材制造": {
                                "code": "2462",
                                "name": "游艺用品及室内游艺器材制造",
                                "children": {}
                            },
                            "其他娱乐用品制造": {
                                "code": "2469",
                                "name": "其他娱乐用品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "石油、煤炭及其他燃料加工业": {
                "code": "25",
                "name": "石油、煤炭及其他燃料加工业",
                "children": {
                    "精炼石油产品制造": {
                        "code": "251",
                        "name": "精炼石油产品制造",
                        "children": {
                            "原油加工及石油制品制造": {
                                "code": "2511",
                                "name": "原油加工及石油制品制造",
                                "children": {}
                            },
                            "其他原油制造": {
                                "code": "2519",
                                "name": "其他原油制造",
                                "children": {}
                            }
                        }
                    },
                    "煤炭加工": {
                        "code": "252",
                        "name": "煤炭加工",
                        "children": {
                            "炼焦": {
                                "code": "2521",
                                "name": "炼焦",
                                "children": {}
                            },
                            "煤制合成气生产": {
                                "code": "2522",
                                "name": "煤制合成气生产",
                                "children": {}
                            },
                            "煤制液体燃料生产": {
                                "code": "2523",
                                "name": "煤制液体燃料生产",
                                "children": {}
                            },
                            "煤制品制造": {
                                "code": "2524",
                                "name": "煤制品制造",
                                "children": {}
                            },
                            "其他煤炭加工": {
                                "code": "2529",
                                "name": "其他煤炭加工",
                                "children": {}
                            }
                        }
                    },
                    "核燃料加工": {
                        "code": "253",
                        "name": "核燃料加工",
                        "children": {
                            "核燃料加工": {
                                "code": "2530",
                                "name": "核燃料加工",
                                "children": {}
                            }
                        }
                    },
                    "生物质燃料加工": {
                        "code": "254",
                        "name": "生物质燃料加工",
                        "children": {
                            " 生物质液体燃料生产": {
                                "code": "2541",
                                "name": " 生物质液体燃料生产",
                                "children": {}
                            },
                            "生物质致密成型燃料加工": {
                                "code": "2542",
                                "name": "生物质致密成型燃料加工",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "化学原料和化学制品制造业": {
                "code": "26",
                "name": "化学原料和化学制品制造业",
                "children": {
                    "基础化学原料制造": {
                        "code": "261",
                        "name": "基础化学原料制造",
                        "children": {
                            "无机酸制造": {
                                "code": "2611",
                                "name": "无机酸制造",
                                "children": {}
                            },
                            "无机碱制造": {
                                "code": "2612",
                                "name": "无机碱制造",
                                "children": {}
                            },
                            "无机盐制造": {
                                "code": "2613",
                                "name": "无机盐制造",
                                "children": {}
                            },
                            "有机化学原料制造": {
                                "code": "2614",
                                "name": "有机化学原料制造",
                                "children": {}
                            },
                            "其他基础化学原料制造": {
                                "code": "2619",
                                "name": "其他基础化学原料制造",
                                "children": {}
                            }
                        }
                    },
                    "肥料制造": {
                        "code": "262",
                        "name": "肥料制造",
                        "children": {
                            "氮肥制造": {
                                "code": "2621",
                                "name": "氮肥制造",
                                "children": {}
                            },
                            "磷肥制造": {
                                "code": "2622",
                                "name": "磷肥制造",
                                "children": {}
                            },
                            "钾肥制造": {
                                "code": "2623",
                                "name": "钾肥制造",
                                "children": {}
                            },
                            "复混肥料制造": {
                                "code": "2624",
                                "name": "复混肥料制造",
                                "children": {}
                            },
                            "有机肥料及微生物肥料制造": {
                                "code": "2625",
                                "name": "有机肥料及微生物肥料制造",
                                "children": {}
                            },
                            "其他肥料制造": {
                                "code": "2629",
                                "name": "其他肥料制造",
                                "children": {}
                            }
                        }
                    },
                    "农药制造": {
                        "code": "263",
                        "name": "农药制造",
                        "children": {
                            "化学农药制造": {
                                "code": "2631",
                                "name": "化学农药制造",
                                "children": {}
                            },
                            "生物化学农药及微生物农药制造": {
                                "code": "2632",
                                "name": "生物化学农药及微生物农药制造",
                                "children": {}
                            }
                        }
                    },
                    "涂料、油墨、颜料及类似产品制造": {
                        "code": "264",
                        "name": "涂料、油墨、颜料及类似产品制造",
                        "children": {
                            "涂料制造": {
                                "code": "2641",
                                "name": "涂料制造",
                                "children": {}
                            },
                            "油墨及类似产品制造": {
                                "code": "2642",
                                "name": "油墨及类似产品制造",
                                "children": {}
                            },
                            "工业颜料制造": {
                                "code": "2643",
                                "name": "工业颜料制造",
                                "children": {}
                            },
                            "工艺美术颜料制造": {
                                "code": "2644",
                                "name": "工艺美术颜料制造",
                                "children": {}
                            },
                            "染料制造": {
                                "code": "2645",
                                "name": "染料制造",
                                "children": {}
                            },
                            "密封用填料及类似品制造": {
                                "code": "2646",
                                "name": "密封用填料及类似品制造",
                                "children": {}
                            }
                        }
                    },
                    "合成材料制造": {
                        "code": "265",
                        "name": "合成材料制造",
                        "children": {
                            "初级形态塑料及合成树脂制造": {
                                "code": "2651",
                                "name": "初级形态塑料及合成树脂制造",
                                "children": {}
                            },
                            "合成橡胶制造": {
                                "code": "2652",
                                "name": "合成橡胶制造",
                                "children": {}
                            },
                            "合成纤维单（聚合）体制造": {
                                "code": "2653",
                                "name": "合成纤维单（聚合）体制造",
                                "children": {}
                            },
                            "其他合成材料制造": {
                                "code": "2659",
                                "name": "其他合成材料制造",
                                "children": {}
                            }
                        }
                    },
                    "专用化学产品制造": {
                        "code": "266",
                        "name": "专用化学产品制造",
                        "children": {
                            "化学试剂和助剂制造": {
                                "code": "2661",
                                "name": "化学试剂和助剂制造",
                                "children": {}
                            },
                            "专项化学用品制造": {
                                "code": "2662",
                                "name": "专项化学用品制造",
                                "children": {}
                            },
                            "林产化学产品制造": {
                                "code": "2663",
                                "name": "林产化学产品制造",
                                "children": {}
                            },
                            "文化用信息化学品制造": {
                                "code": "2664",
                                "name": "文化用信息化学品制造",
                                "children": {}
                            },
                            "医学生产用信息化学品制造": {
                                "code": "2665",
                                "name": "医学生产用信息化学品制造",
                                "children": {}
                            },
                            "环境污染处理专用药剂材料制造": {
                                "code": "2666",
                                "name": "环境污染处理专用药剂材料制造",
                                "children": {}
                            },
                            "动物胶制造": {
                                "code": "2667",
                                "name": "动物胶制造",
                                "children": {}
                            },
                            "其他专用化学产品制造": {
                                "code": "2669",
                                "name": "其他专用化学产品制造",
                                "children": {}
                            }
                        }
                    },
                    "炸药、火工及焰火产品制造": {
                        "code": "267",
                        "name": "炸药、火工及焰火产品制造",
                        "children": {
                            "炸药及火工产品制造": {
                                "code": "2671",
                                "name": "炸药及火工产品制造",
                                "children": {}
                            },
                            "焰火、鞭炮产品制造": {
                                "code": "2672",
                                "name": "焰火、鞭炮产品制造",
                                "children": {}
                            }
                        }
                    },
                    "日用化学产品制造": {
                        "code": "268",
                        "name": "日用化学产品制造",
                        "children": {
                            "肥皂及洗涤剂制造": {
                                "code": "2681",
                                "name": "肥皂及洗涤剂制造",
                                "children": {}
                            },
                            "化妆品制造": {
                                "code": "2682",
                                "name": "化妆品制造",
                                "children": {}
                            },
                            "口腔清洁用品制造": {
                                "code": "2683",
                                "name": "口腔清洁用品制造",
                                "children": {}
                            },
                            "香料、香精制造": {
                                "code": "2684",
                                "name": "香料、香精制造",
                                "children": {}
                            },
                            "其他日用化学产品制造": {
                                "code": "2689",
                                "name": "其他日用化学产品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "医药制造业": {
                "code": "27",
                "name": "医药制造业",
                "children": {
                    "化学药品原料药制造": {
                        "code": "271",
                        "name": "化学药品原料药制造",
                        "children": {
                            "化学药品原料药制造": {
                                "code": "2710",
                                "name": "化学药品原料药制造",
                                "children": {}
                            }
                        }
                    },
                    "化学药品制剂制造": {
                        "code": "272",
                        "name": "化学药品制剂制造",
                        "children": {
                            "化学药品制剂制造": {
                                "code": "2720",
                                "name": "化学药品制剂制造",
                                "children": {}
                            }
                        }
                    },
                    "中药饮片加工": {
                        "code": "273",
                        "name": "中药饮片加工",
                        "children": {
                            "中药饮片加工": {
                                "code": "2730",
                                "name": "中药饮片加工",
                                "children": {}
                            }
                        }
                    },
                    "中成药生产": {
                        "code": "274",
                        "name": "中成药生产",
                        "children": {
                            "中成药生产": {
                                "code": "2740",
                                "name": "中成药生产",
                                "children": {}
                            }
                        }
                    },
                    "兽用药品制造": {
                        "code": "275",
                        "name": "兽用药品制造",
                        "children": {
                            "兽用药品制造": {
                                "code": "2750",
                                "name": "兽用药品制造",
                                "children": {}
                            }
                        }
                    },
                    "生物药品制品制造": {
                        "code": "276",
                        "name": "生物药品制品制造",
                        "children": {
                            "生物药品制造": {
                                "code": "2761",
                                "name": "生物药品制造",
                                "children": {}
                            },
                            "基因工程药物和疫苗制造": {
                                "code": "2762",
                                "name": "基因工程药物和疫苗制造",
                                "children": {}
                            }
                        }
                    },
                    "卫生材料及医药用品制造": {
                        "code": "277",
                        "name": "卫生材料及医药用品制造",
                        "children": {
                            "卫生材料及医药用品制造": {
                                "code": "2770",
                                "name": "卫生材料及医药用品制造",
                                "children": {}
                            }
                        }
                    },
                    "药用辅料及包装材料": {
                        "code": "278",
                        "name": "药用辅料及包装材料",
                        "children": {
                            "药用辅料及包装材料": {
                                "code": "2780",
                                "name": "药用辅料及包装材料",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "化学纤维制造业": {
                "code": "28",
                "name": "化学纤维制造业",
                "children": {
                    "纤维素纤维原料及纤维制造": {
                        "code": "281",
                        "name": "纤维素纤维原料及纤维制造",
                        "children": {
                            "化纤浆粕制造": {
                                "code": "2811",
                                "name": "化纤浆粕制造",
                                "children": {}
                            },
                            "人造纤维（纤维素纤维）制造": {
                                "code": "2812",
                                "name": "人造纤维（纤维素纤维）制造",
                                "children": {}
                            }
                        }
                    },
                    "合成纤维制造": {
                        "code": "282",
                        "name": "合成纤维制造",
                        "children": {
                            "锦纶纤维制造": {
                                "code": "2821",
                                "name": "锦纶纤维制造",
                                "children": {}
                            },
                            "涤纶纤维制造": {
                                "code": "2822",
                                "name": "涤纶纤维制造",
                                "children": {}
                            },
                            "腈纶纤维制造": {
                                "code": "2823",
                                "name": "腈纶纤维制造",
                                "children": {}
                            },
                            "维纶纤维制造": {
                                "code": "2824",
                                "name": "维纶纤维制造",
                                "children": {}
                            },
                            "丙纶纤维制造": {
                                "code": "2825",
                                "name": "丙纶纤维制造",
                                "children": {}
                            },
                            "氨纶纤维制造": {
                                "code": "2826",
                                "name": "氨纶纤维制造",
                                "children": {}
                            },
                            "其他合成纤维制造": {
                                "code": "2829",
                                "name": "其他合成纤维制造",
                                "children": {}
                            }
                        }
                    },
                    "生物基材料制造": {
                        "code": "283",
                        "name": "生物基材料制造",
                        "children": {
                            "生物基化学纤维制造": {
                                "code": "2831",
                                "name": "生物基化学纤维制造",
                                "children": {}
                            },
                            "生物基、淀粉基新材料制造": {
                                "code": "2832",
                                "name": "生物基、淀粉基新材料制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "橡胶和塑料制品业": {
                "code": "29",
                "name": "橡胶和塑料制品业",
                "children": {
                    "橡胶制品业": {
                        "code": "291",
                        "name": "橡胶制品业",
                        "children": {
                            "轮胎制造": {
                                "code": "2911",
                                "name": "轮胎制造",
                                "children": {}
                            },
                            "橡胶板、管、带制造": {
                                "code": "2912",
                                "name": "橡胶板、管、带制造",
                                "children": {}
                            },
                            "橡胶零件制造": {
                                "code": "2913",
                                "name": "橡胶零件制造",
                                "children": {}
                            },
                            "再生橡胶制造": {
                                "code": "2914",
                                "name": "再生橡胶制造",
                                "children": {}
                            },
                            "日用及医用橡胶制品制造": {
                                "code": "2915",
                                "name": "日用及医用橡胶制品制造",
                                "children": {}
                            },
                            "运动场地用塑胶制造": {
                                "code": "2916",
                                "name": "运动场地用塑胶制造",
                                "children": {}
                            },
                            "其他橡胶制品制造": {
                                "code": "2919",
                                "name": "其他橡胶制品制造",
                                "children": {}
                            }
                        }
                    },
                    "塑料制品业": {
                        "code": "292",
                        "name": "塑料制品业",
                        "children": {
                            "塑料薄膜制造": {
                                "code": "2921",
                                "name": "塑料薄膜制造",
                                "children": {}
                            },
                            "塑料板、管、型材制造": {
                                "code": "2922",
                                "name": "塑料板、管、型材制造",
                                "children": {}
                            },
                            "塑料丝、绳及编织品制造": {
                                "code": "2923",
                                "name": "塑料丝、绳及编织品制造",
                                "children": {}
                            },
                            "泡沫塑料制造": {
                                "code": "2924",
                                "name": "泡沫塑料制造",
                                "children": {}
                            },
                            "塑料人造革、合成革制造": {
                                "code": "2925",
                                "name": "塑料人造革、合成革制造",
                                "children": {}
                            },
                            "塑料包装箱及容器制造": {
                                "code": "2926",
                                "name": "塑料包装箱及容器制造",
                                "children": {}
                            },
                            "日用塑料制品制造": {
                                "code": "2927",
                                "name": "日用塑料制品制造",
                                "children": {}
                            },
                            "人造草坪制造": {
                                "code": "2928",
                                "name": "人造草坪制造",
                                "children": {}
                            },
                            "塑料零件及其他塑料制品制造": {
                                "code": "2929",
                                "name": "塑料零件及其他塑料制品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "非金属矿物制品业": {
                "code": "30",
                "name": "非金属矿物制品业",
                "children": {
                    "水泥、石灰和石膏制造": {
                        "code": "301",
                        "name": "水泥、石灰和石膏制造",
                        "children": {
                            "水泥制造": {
                                "code": "3011",
                                "name": "水泥制造",
                                "children": {}
                            },
                            "石灰和石膏制造": {
                                "code": "3012",
                                "name": "石灰和石膏制造",
                                "children": {}
                            }
                        }
                    },
                    "石膏、水泥制品及类似制品制造": {
                        "code": "302",
                        "name": "石膏、水泥制品及类似制品制造",
                        "children": {
                            "水泥制品制造": {
                                "code": "3021",
                                "name": "水泥制品制造",
                                "children": {}
                            },
                            "砼结构构件制造": {
                                "code": "3022",
                                "name": "砼结构构件制造",
                                "children": {}
                            },
                            "石棉水泥制品制造": {
                                "code": "3023",
                                "name": "石棉水泥制品制造",
                                "children": {}
                            },
                            "轻质建筑材料制造": {
                                "code": "3024",
                                "name": "轻质建筑材料制造",
                                "children": {}
                            },
                            "其他水泥类似制品制造": {
                                "code": "3029",
                                "name": "其他水泥类似制品制造",
                                "children": {}
                            }
                        }
                    },
                    "砖瓦、石材等建筑材料制造": {
                        "code": "303",
                        "name": "砖瓦、石材等建筑材料制造",
                        "children": {
                            "粘土砖瓦及建筑砌块制造": {
                                "code": "3031",
                                "name": "粘土砖瓦及建筑砌块制造",
                                "children": {}
                            },
                            "建筑用石加工": {
                                "code": "3032",
                                "name": "建筑用石加工",
                                "children": {}
                            },
                            "防水建筑材料制造": {
                                "code": "3033",
                                "name": "防水建筑材料制造",
                                "children": {}
                            },
                            "隔热和隔音材料制造": {
                                "code": "3034",
                                "name": "隔热和隔音材料制造",
                                "children": {}
                            },
                            "其他建筑材料制造": {
                                "code": "3039",
                                "name": "其他建筑材料制造",
                                "children": {}
                            }
                        }
                    },
                    "玻璃制造": {
                        "code": "304",
                        "name": "玻璃制造",
                        "children": {
                            "平板玻璃制造": {
                                "code": "3041",
                                "name": "平板玻璃制造",
                                "children": {}
                            },
                            "特种玻璃制造": {
                                "code": "3042",
                                "name": "特种玻璃制造",
                                "children": {}
                            },
                            "其他玻璃制造": {
                                "code": "3049",
                                "name": "其他玻璃制造",
                                "children": {}
                            }
                        }
                    },
                    "玻璃制品制造": {
                        "code": "305",
                        "name": "玻璃制品制造",
                        "children": {
                            "技术玻璃制品制造": {
                                "code": "3051",
                                "name": "技术玻璃制品制造",
                                "children": {}
                            },
                            "光学玻璃制造": {
                                "code": "3052",
                                "name": "光学玻璃制造",
                                "children": {}
                            },
                            "玻璃仪器制造": {
                                "code": "3053",
                                "name": "玻璃仪器制造",
                                "children": {}
                            },
                            "日用玻璃制品制造": {
                                "code": "3054",
                                "name": "日用玻璃制品制造",
                                "children": {}
                            },
                            "玻璃包装容器制造": {
                                "code": "3055",
                                "name": "玻璃包装容器制造",
                                "children": {}
                            },
                            "玻璃保温容器制造": {
                                "code": "3056",
                                "name": "玻璃保温容器制造",
                                "children": {}
                            },
                            "制镜及类似品加工": {
                                "code": "3057",
                                "name": "制镜及类似品加工",
                                "children": {}
                            },
                            "其他玻璃制品制造": {
                                "code": "3059",
                                "name": "其他玻璃制品制造",
                                "children": {}
                            }
                        }
                    },
                    "玻璃纤维和玻璃纤维增强塑料制品制": {
                        "code": "306",
                        "name": "玻璃纤维和玻璃纤维增强塑料制品制",
                        "children": {
                            "玻璃纤维及制品制造": {
                                "code": "3061",
                                "name": "玻璃纤维及制品制造",
                                "children": {}
                            },
                            "玻璃纤维增强塑料制品制造": {
                                "code": "3062",
                                "name": "玻璃纤维增强塑料制品制造",
                                "children": {}
                            }
                        }
                    },
                    "陶瓷制品制造": {
                        "code": "307",
                        "name": "陶瓷制品制造",
                        "children": {
                            "建筑陶瓷制品制造": {
                                "code": "3071",
                                "name": "建筑陶瓷制品制造",
                                "children": {}
                            },
                            "卫生陶瓷制品制造": {
                                "code": "3072",
                                "name": "卫生陶瓷制品制造",
                                "children": {}
                            },
                            "特种陶瓷制品制造": {
                                "code": "3073",
                                "name": "特种陶瓷制品制造",
                                "children": {}
                            },
                            "日用陶瓷制品制造": {
                                "code": "3074",
                                "name": "日用陶瓷制品制造",
                                "children": {}
                            },
                            "陈设艺术陶瓷制造": {
                                "code": "3075",
                                "name": "陈设艺术陶瓷制造",
                                "children": {}
                            },
                            "园艺陶瓷制造": {
                                "code": "3076",
                                "name": "园艺陶瓷制造",
                                "children": {}
                            },
                            "其他陶瓷制品制造": {
                                "code": "3079",
                                "name": "其他陶瓷制品制造",
                                "children": {}
                            }
                        }
                    },
                    "耐火材料制品制造": {
                        "code": "308",
                        "name": "耐火材料制品制造",
                        "children": {
                            "石棉制品制造": {
                                "code": "3081",
                                "name": "石棉制品制造",
                                "children": {}
                            },
                            "云母制品制造": {
                                "code": "3082",
                                "name": "云母制品制造",
                                "children": {}
                            },
                            "耐火陶瓷制品及其他耐火材料制造": {
                                "code": "3089",
                                "name": "耐火陶瓷制品及其他耐火材料制造",
                                "children": {}
                            }
                        }
                    },
                    "石墨及其他非金属矿物制品制造": {
                        "code": "309",
                        "name": "石墨及其他非金属矿物制品制造",
                        "children": {
                            "石墨及碳素制品制造": {
                                "code": "3091",
                                "name": "石墨及碳素制品制造",
                                "children": {}
                            },
                            "其他非金属矿物制品制造": {
                                "code": "3099",
                                "name": "其他非金属矿物制品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "黑色金属冶炼和压延加工业": {
                "code": "31",
                "name": "黑色金属冶炼和压延加工业",
                "children": {
                    "炼铁": {
                        "code": "311",
                        "name": "炼铁",
                        "children": {
                            "炼铁": {
                                "code": "3110",
                                "name": "炼铁",
                                "children": {}
                            }
                        }
                    },
                    "炼钢": {
                        "code": "312",
                        "name": "炼钢",
                        "children": {
                            "炼钢": {
                                "code": "3120",
                                "name": "炼钢",
                                "children": {}
                            }
                        }
                    },
                    "钢压延加工": {
                        "code": "313",
                        "name": "钢压延加工",
                        "children": {
                            "钢压延加工": {
                                "code": "3130",
                                "name": "钢压延加工",
                                "children": {}
                            }
                        }
                    },
                    "铁合金冶炼": {
                        "code": "314",
                        "name": "铁合金冶炼",
                        "children": {
                            "铁合金冶炼": {
                                "code": "3140",
                                "name": "铁合金冶炼",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "有色金属冶炼和压延加工业": {
                "code": "32",
                "name": "有色金属冶炼和压延加工业",
                "children": {
                    "常用有色金属冶炼": {
                        "code": "321",
                        "name": "常用有色金属冶炼",
                        "children": {
                            "铜冶炼": {
                                "code": "3211",
                                "name": "铜冶炼",
                                "children": {}
                            },
                            "铅锌冶炼": {
                                "code": "3212",
                                "name": "铅锌冶炼",
                                "children": {}
                            },
                            "镍钴冶炼": {
                                "code": "3213",
                                "name": "镍钴冶炼",
                                "children": {}
                            },
                            "锡冶炼": {
                                "code": "3214",
                                "name": "锡冶炼",
                                "children": {}
                            },
                            "锑冶炼": {
                                "code": "3215",
                                "name": "锑冶炼",
                                "children": {}
                            },
                            "铝冶炼": {
                                "code": "3216",
                                "name": "铝冶炼",
                                "children": {}
                            },
                            "镁冶炼": {
                                "code": "3217",
                                "name": "镁冶炼",
                                "children": {}
                            },
                            "硅冶炼": {
                                "code": "3218",
                                "name": "硅冶炼",
                                "children": {}
                            },
                            "其他常用有色金属冶炼": {
                                "code": "3219",
                                "name": "其他常用有色金属冶炼",
                                "children": {}
                            }
                        }
                    },
                    "贵金属冶炼": {
                        "code": "322",
                        "name": "贵金属冶炼",
                        "children": {
                            "金冶炼": {
                                "code": "3221",
                                "name": "金冶炼",
                                "children": {}
                            },
                            "银冶炼": {
                                "code": "3222",
                                "name": "银冶炼",
                                "children": {}
                            },
                            "其他贵金属冶炼": {
                                "code": "3229",
                                "name": "其他贵金属冶炼",
                                "children": {}
                            }
                        }
                    },
                    "稀有稀土金属冶炼": {
                        "code": "323",
                        "name": "稀有稀土金属冶炼",
                        "children": {
                            "钨钼冶炼": {
                                "code": "3231",
                                "name": "钨钼冶炼",
                                "children": {}
                            },
                            "稀土金属冶炼": {
                                "code": "3232",
                                "name": "稀土金属冶炼",
                                "children": {}
                            },
                            "其他稀有金属冶炼": {
                                "code": "3239",
                                "name": "其他稀有金属冶炼",
                                "children": {}
                            }
                        }
                    },
                    "有色金属合金制造": {
                        "code": "324",
                        "name": "有色金属合金制造",
                        "children": {
                            "有色金属合金制造": {
                                "code": "3240",
                                "name": "有色金属合金制造",
                                "children": {}
                            }
                        }
                    },
                    "有色金属压延加工": {
                        "code": "325",
                        "name": "有色金属压延加工",
                        "children": {
                            "铜压延加工": {
                                "code": "3251",
                                "name": "铜压延加工",
                                "children": {}
                            },
                            "铝压延加工": {
                                "code": "3252",
                                "name": "铝压延加工",
                                "children": {}
                            },
                            "贵金属压延加工": {
                                "code": "3253",
                                "name": "贵金属压延加工",
                                "children": {}
                            },
                            "稀有稀土金属压延加工": {
                                "code": "3254",
                                "name": "稀有稀土金属压延加工",
                                "children": {}
                            },
                            "其他有色金属压延加工": {
                                "code": "3259",
                                "name": "其他有色金属压延加工",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "金属制品业": {
                "code": "33",
                "name": "金属制品业",
                "children": {
                    "结构性金属制品制造": {
                        "code": "331",
                        "name": "结构性金属制品制造",
                        "children": {
                            "金属结构制造": {
                                "code": "3311",
                                "name": "金属结构制造",
                                "children": {}
                            },
                            "金属门窗制造": {
                                "code": "3312",
                                "name": "金属门窗制造",
                                "children": {}
                            }
                        }
                    },
                    "金属工具制造": {
                        "code": "332",
                        "name": "金属工具制造",
                        "children": {
                            "切削工具制造": {
                                "code": "3321",
                                "name": "切削工具制造",
                                "children": {}
                            },
                            "手工具制造": {
                                "code": "3322",
                                "name": "手工具制造",
                                "children": {}
                            },
                            "农用及园林用金属工具制造": {
                                "code": "3323",
                                "name": "农用及园林用金属工具制造",
                                "children": {}
                            },
                            "刀剪及类似日用金属工具制造": {
                                "code": "3324",
                                "name": "刀剪及类似日用金属工具制造",
                                "children": {}
                            },
                            "其他金属工具制造": {
                                "code": "3329",
                                "name": "其他金属工具制造",
                                "children": {}
                            }
                        }
                    },
                    "集装箱及金属包装容器制造": {
                        "code": "333",
                        "name": "集装箱及金属包装容器制造",
                        "children": {
                            "集装箱制造": {
                                "code": "3331",
                                "name": "集装箱制造",
                                "children": {}
                            },
                            "金属压力容器制造": {
                                "code": "3332",
                                "name": "金属压力容器制造",
                                "children": {}
                            },
                            "金属包装容器及材料制造": {
                                "code": "3333",
                                "name": "金属包装容器及材料制造",
                                "children": {}
                            }
                        }
                    },
                    "金属丝绳及其制品制造": {
                        "code": "334",
                        "name": "金属丝绳及其制品制造",
                        "children": {
                            "金属丝绳及其制品制造": {
                                "code": "3340",
                                "name": "金属丝绳及其制品制造",
                                "children": {}
                            }
                        }
                    },
                    "建筑、安全用金属制品制造": {
                        "code": "335",
                        "name": "建筑、安全用金属制品制造",
                        "children": {
                            "建筑、家具用金属配件制造": {
                                "code": "3351",
                                "name": "建筑、家具用金属配件制造",
                                "children": {}
                            },
                            "建筑装饰及水暖管道零件制造": {
                                "code": "3352",
                                "name": "建筑装饰及水暖管道零件制造",
                                "children": {}
                            },
                            "安全、消防用金属制品制造": {
                                "code": "3353",
                                "name": "安全、消防用金属制品制造",
                                "children": {}
                            },
                            "其他建筑、安全用金属制品制造": {
                                "code": "3359",
                                "name": "其他建筑、安全用金属制品制造",
                                "children": {}
                            }
                        }
                    },
                    "金属表面处理及热处理加工": {
                        "code": "336",
                        "name": "金属表面处理及热处理加工",
                        "children": {
                            "金属表面处理及热处理加工": {
                                "code": "3360",
                                "name": "金属表面处理及热处理加工",
                                "children": {}
                            }
                        }
                    },
                    "搪瓷制品制造": {
                        "code": "337",
                        "name": "搪瓷制品制造",
                        "children": {
                            "生产专用搪瓷制品制造": {
                                "code": "3371",
                                "name": "生产专用搪瓷制品制造",
                                "children": {}
                            },
                            "建筑装饰搪瓷制品制造": {
                                "code": "3372",
                                "name": "建筑装饰搪瓷制品制造",
                                "children": {}
                            },
                            "搪瓷卫生洁具制造": {
                                "code": "3373",
                                "name": "搪瓷卫生洁具制造",
                                "children": {}
                            },
                            "搪瓷日用品及其他搪瓷制品制造": {
                                "code": "3379",
                                "name": "搪瓷日用品及其他搪瓷制品制造",
                                "children": {}
                            }
                        }
                    },
                    "金属制日用品制造": {
                        "code": "338",
                        "name": "金属制日用品制造",
                        "children": {
                            "金属制厨房用器具制造": {
                                "code": "3381",
                                "name": "金属制厨房用器具制造",
                                "children": {}
                            },
                            "金属制餐具和器皿制造": {
                                "code": "3382",
                                "name": "金属制餐具和器皿制造",
                                "children": {}
                            },
                            "金属制卫生器具制造": {
                                "code": "3383",
                                "name": "金属制卫生器具制造",
                                "children": {}
                            },
                            "其他金属制日用品制造": {
                                "code": "3389",
                                "name": "其他金属制日用品制造",
                                "children": {}
                            }
                        }
                    },
                    "铸造及其他金属制品制造": {
                        "code": "339",
                        "name": "铸造及其他金属制品制造",
                        "children": {
                            "黑色金属铸造": {
                                "code": "3391",
                                "name": "黑色金属铸造",
                                "children": {}
                            },
                            "有色金属铸造": {
                                "code": "3392",
                                "name": "有色金属铸造",
                                "children": {}
                            },
                            "锻件及粉末冶金制品制造": {
                                "code": "3393",
                                "name": "锻件及粉末冶金制品制造",
                                "children": {}
                            },
                            "交通及公共管理用金属标牌制造": {
                                "code": "3394",
                                "name": "交通及公共管理用金属标牌制造",
                                "children": {}
                            },
                            "其他未列明金属制品制造": {
                                "code": "3399",
                                "name": "其他未列明金属制品制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "通用设备制造业": {
                "code": "34",
                "name": "通用设备制造业",
                "children": {
                    "锅炉及原动设备制造": {
                        "code": "341",
                        "name": "锅炉及原动设备制造",
                        "children": {
                            "锅炉及辅助设备制造": {
                                "code": "3411",
                                "name": "锅炉及辅助设备制造",
                                "children": {}
                            },
                            "内燃机及配件制造": {
                                "code": "3412",
                                "name": "内燃机及配件制造",
                                "children": {}
                            },
                            "汽轮机及辅机制造": {
                                "code": "3413",
                                "name": "汽轮机及辅机制造",
                                "children": {}
                            },
                            "水轮机及辅机制造": {
                                "code": "3414",
                                "name": "水轮机及辅机制造",
                                "children": {}
                            },
                            "风能原动设备制造": {
                                "code": "3415",
                                "name": "风能原动设备制造",
                                "children": {}
                            },
                            "其他原动设备制造": {
                                "code": "3419",
                                "name": "其他原动设备制造",
                                "children": {}
                            }
                        }
                    },
                    "金属加工机械制造": {
                        "code": "342",
                        "name": "金属加工机械制造",
                        "children": {
                            "金属切削机床制造": {
                                "code": "3421",
                                "name": "金属切削机床制造",
                                "children": {}
                            },
                            "金属成形机床制造": {
                                "code": "3422",
                                "name": "金属成形机床制造",
                                "children": {}
                            },
                            "铸造机械制造": {
                                "code": "3423",
                                "name": "铸造机械制造",
                                "children": {}
                            },
                            "金属切割及焊接设备制造": {
                                "code": "3424",
                                "name": "金属切割及焊接设备制造",
                                "children": {}
                            },
                            "机床功能部件及附件制造": {
                                "code": "3425",
                                "name": "机床功能部件及附件制造",
                                "children": {}
                            },
                            "其他金属加工机械制造": {
                                "code": "3429",
                                "name": "其他金属加工机械制造",
                                "children": {}
                            }
                        }
                    },
                    "物料搬运设备制造": {
                        "code": "343",
                        "name": "物料搬运设备制造",
                        "children": {
                            "轻小型起重设备制造": {
                                "code": "3431",
                                "name": "轻小型起重设备制造",
                                "children": {}
                            },
                            "生产专用起重机制造": {
                                "code": "3432",
                                "name": "生产专用起重机制造",
                                "children": {}
                            },
                            "生产专用车辆制造": {
                                "code": "3433",
                                "name": "生产专用车辆制造",
                                "children": {}
                            },
                            "连续搬运设备制造": {
                                "code": "3434",
                                "name": "连续搬运设备制造",
                                "children": {}
                            },
                            "电梯、自动扶梯及升降机制造": {
                                "code": "3435",
                                "name": "电梯、自动扶梯及升降机制造",
                                "children": {}
                            },
                            "客运索道制造": {
                                "code": "3436",
                                "name": "客运索道制造",
                                "children": {}
                            },
                            "机械式停车设备制造": {
                                "code": "3437",
                                "name": "机械式停车设备制造",
                                "children": {}
                            },
                            "其他物料搬运设备制造": {
                                "code": "3439",
                                "name": "其他物料搬运设备制造",
                                "children": {}
                            }
                        }
                    },
                    "泵、阀门、压缩机及类似机械制造": {
                        "code": "344",
                        "name": "泵、阀门、压缩机及类似机械制造",
                        "children": {
                            "泵及真空设备制造": {
                                "code": "3441",
                                "name": "泵及真空设备制造",
                                "children": {}
                            },
                            "气体压缩机械制造": {
                                "code": "3442",
                                "name": "气体压缩机械制造",
                                "children": {}
                            },
                            "阀门和旋塞制造": {
                                "code": "3443",
                                "name": "阀门和旋塞制造",
                                "children": {}
                            },
                            "液压动力机械及元件制造": {
                                "code": "3444",
                                "name": "液压动力机械及元件制造",
                                "children": {}
                            },
                            "液力动力机械元件制造": {
                                "code": "3445",
                                "name": "液力动力机械元件制造",
                                "children": {}
                            },
                            "气压动力机械及元件制造": {
                                "code": "3446",
                                "name": "气压动力机械及元件制造",
                                "children": {}
                            }
                        }
                    },
                    "轴承、齿轮和传动部件制造": {
                        "code": "345",
                        "name": "轴承、齿轮和传动部件制造",
                        "children": {
                            "滚动轴承制造": {
                                "code": "3451",
                                "name": "滚动轴承制造",
                                "children": {}
                            },
                            "滑动轴承制造": {
                                "code": "3452",
                                "name": "滑动轴承制造",
                                "children": {}
                            },
                            "齿轮及齿轮减、变速箱制造": {
                                "code": "3453",
                                "name": "齿轮及齿轮减、变速箱制造",
                                "children": {}
                            },
                            "其他传动部件制造": {
                                "code": "3459",
                                "name": "其他传动部件制造",
                                "children": {}
                            }
                        }
                    },
                    "烘炉、风机、包装等设备制造": {
                        "code": "346",
                        "name": "烘炉、风机、包装等设备制造",
                        "children": {
                            "烘炉、熔炉及电炉制造": {
                                "code": "3461",
                                "name": "烘炉、熔炉及电炉制造",
                                "children": {}
                            },
                            "风机、风扇制造": {
                                "code": "3462",
                                "name": "风机、风扇制造",
                                "children": {}
                            },
                            "气体、液体分离及纯净设备制造": {
                                "code": "3463",
                                "name": "气体、液体分离及纯净设备制造",
                                "children": {}
                            },
                            "制冷、空调设备制造": {
                                "code": "3464",
                                "name": "制冷、空调设备制造",
                                "children": {}
                            },
                            "风动和电动工具制造": {
                                "code": "3465",
                                "name": "风动和电动工具制造",
                                "children": {}
                            },
                            "喷枪及类似器具制造": {
                                "code": "3466",
                                "name": "喷枪及类似器具制造",
                                "children": {}
                            },
                            "包装专用设备制造": {
                                "code": "3467",
                                "name": "包装专用设备制造",
                                "children": {}
                            }
                        }
                    },
                    "文化、办公用机械制造": {
                        "code": "347",
                        "name": "文化、办公用机械制造",
                        "children": {
                            "电影机械制造": {
                                "code": "3471",
                                "name": "电影机械制造",
                                "children": {}
                            },
                            "幻灯及投影设备制造": {
                                "code": "3472",
                                "name": "幻灯及投影设备制造",
                                "children": {}
                            },
                            "照相机及器材制造": {
                                "code": "3473",
                                "name": "照相机及器材制造",
                                "children": {}
                            },
                            "复印和胶印设备制造": {
                                "code": "3474",
                                "name": "复印和胶印设备制造",
                                "children": {}
                            },
                            "计算器及货币专用设备制造": {
                                "code": "3475",
                                "name": "计算器及货币专用设备制造",
                                "children": {}
                            },
                            "其他文化、办公用机械制造": {
                                "code": "3479",
                                "name": "其他文化、办公用机械制造",
                                "children": {}
                            }
                        }
                    },
                    "通用零部件制造": {
                        "code": "348",
                        "name": "通用零部件制造",
                        "children": {
                            "金属密封件制造": {
                                "code": "3481",
                                "name": "金属密封件制造",
                                "children": {}
                            },
                            "紧固件制造": {
                                "code": "3482",
                                "name": "紧固件制造",
                                "children": {}
                            },
                            "弹簧制造": {
                                "code": "3483",
                                "name": "弹簧制造",
                                "children": {}
                            },
                            "机械零部件加工": {
                                "code": "3484",
                                "name": "机械零部件加工",
                                "children": {}
                            },
                            "其他通用零部件制造": {
                                "code": "3489",
                                "name": "其他通用零部件制造",
                                "children": {}
                            }
                        }
                    },
                    "其他通用设备制造业": {
                        "code": "349",
                        "name": "其他通用设备制造业",
                        "children": {
                            "工业机器人制造": {
                                "code": "3491",
                                "name": "工业机器人制造",
                                "children": {}
                            },
                            "特殊作业机器人制造": {
                                "code": "3492",
                                "name": "特殊作业机器人制造",
                                "children": {}
                            },
                            "增材制造装备制造": {
                                "code": "3493",
                                "name": "增材制造装备制造",
                                "children": {}
                            },
                            "其他未列明通用设备制造业": {
                                "code": "3499",
                                "name": "其他未列明通用设备制造业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "专用设备制造业": {
                "code": "35",
                "name": "专用设备制造业",
                "children": {
                    "采矿、冶金、建筑专用设备制造": {
                        "code": "351",
                        "name": "采矿、冶金、建筑专用设备制造",
                        "children": {
                            "矿山机械制造": {
                                "code": "3511",
                                "name": "矿山机械制造",
                                "children": {}
                            },
                            "石油钻采专用设备制造": {
                                "code": "3512",
                                "name": "石油钻采专用设备制造",
                                "children": {}
                            },
                            "深海石油钻探设备制造": {
                                "code": "3513",
                                "name": "深海石油钻探设备制造",
                                "children": {}
                            },
                            "建筑工程用机械制造": {
                                "code": "3514",
                                "name": "建筑工程用机械制造",
                                "children": {}
                            },
                            "建筑材料生产专用机械制造": {
                                "code": "3515",
                                "name": "建筑材料生产专用机械制造",
                                "children": {}
                            },
                            "冶金专用设备制造": {
                                "code": "3516",
                                "name": "冶金专用设备制造",
                                "children": {}
                            },
                            "隧道施工专用机械制造": {
                                "code": "3517",
                                "name": "隧道施工专用机械制造",
                                "children": {}
                            }
                        }
                    },
                    "化工、木材、非金属加工专用设备制造": {
                        "code": "352",
                        "name": "化工、木材、非金属加工专用设备制造",
                        "children": {
                            "炼油、化工生产专用设备制造": {
                                "code": "3521",
                                "name": "炼油、化工生产专用设备制造",
                                "children": {}
                            },
                            "橡胶加工专用设备制造": {
                                "code": "3522",
                                "name": "橡胶加工专用设备制造",
                                "children": {}
                            },
                            "塑料加工专用设备制造": {
                                "code": "3523",
                                "name": "塑料加工专用设备制造",
                                "children": {}
                            },
                            "木竹材加工机械制造": {
                                "code": "3524",
                                "name": "木竹材加工机械制造",
                                "children": {}
                            },
                            "模具制造": {
                                "code": "3525",
                                "name": "模具制造",
                                "children": {}
                            },
                            "其他非金属加工专用设备制造": {
                                "code": "3529",
                                "name": "其他非金属加工专用设备制造",
                                "children": {}
                            }
                        }
                    },
                    "食品、饮料、烟草及饲料生产专用设备制造": {
                        "code": "353",
                        "name": "食品、饮料、烟草及饲料生产专用设备制造",
                        "children": {
                            "食品、酒、饮料及茶生产专用设备制     指主要用于食品、酒、饮料生产及茶制品加": {
                                "code": "3531",
                                "name": "食品、酒、饮料及茶生产专用设备制     指主要用于食品、酒、饮料生产及茶制品加",
                                "children": {}
                            },
                            "农副食品加工专用设备制造": {
                                "code": "3532",
                                "name": "农副食品加工专用设备制造",
                                "children": {}
                            },
                            "烟草生产专用设备制造": {
                                "code": "3533",
                                "name": "烟草生产专用设备制造",
                                "children": {}
                            },
                            "饲料生产专用设备制造": {
                                "code": "3534",
                                "name": "饲料生产专用设备制造",
                                "children": {}
                            }
                        }
                    },
                    "印刷、制药、日化及日用品生产专用设": {
                        "code": "354",
                        "name": "印刷、制药、日化及日用品生产专用设",
                        "children": {
                            "制浆和造纸专用设备制造": {
                                "code": "3541",
                                "name": "制浆和造纸专用设备制造",
                                "children": {}
                            },
                            "印刷专用设备制造": {
                                "code": "3542",
                                "name": "印刷专用设备制造",
                                "children": {}
                            },
                            "日用化工专用设备制造": {
                                "code": "3543",
                                "name": "日用化工专用设备制造",
                                "children": {}
                            },
                            "制药专用设备制造": {
                                "code": "3544",
                                "name": "制药专用设备制造",
                                "children": {}
                            },
                            "照明器具生产专用设备制造": {
                                "code": "3545",
                                "name": "照明器具生产专用设备制造",
                                "children": {}
                            },
                            "玻璃、陶瓷和搪瓷制品生产专用设备": {
                                "code": "3546",
                                "name": "玻璃、陶瓷和搪瓷制品生产专用设备",
                                "children": {}
                            },
                            "其他日用品生产专用设备制造": {
                                "code": "3549",
                                "name": "其他日用品生产专用设备制造",
                                "children": {}
                            }
                        }
                    },
                    "纺织、服装和皮革加工专用设备制造": {
                        "code": "355",
                        "name": "纺织、服装和皮革加工专用设备制造",
                        "children": {
                            "纺织专用设备制造": {
                                "code": "3551",
                                "name": "纺织专用设备制造",
                                "children": {}
                            },
                            "皮革、毛皮及其制品加工专用设备制": {
                                "code": "3552",
                                "name": "皮革、毛皮及其制品加工专用设备制",
                                "children": {}
                            },
                            "缝制机械制造": {
                                "code": "3553",
                                "name": "缝制机械制造",
                                "children": {}
                            },
                            "洗涤机械制造": {
                                "code": "3554",
                                "name": "洗涤机械制造",
                                "children": {}
                            }
                        }
                    },
                    "电子和电工机械专用设备制造": {
                        "code": "356",
                        "name": "电子和电工机械专用设备制造",
                        "children": {
                            "电工机械专用设备制造": {
                                "code": "3561",
                                "name": "电工机械专用设备制造",
                                "children": {}
                            },
                            "半导体器件专用设备制造": {
                                "code": "3562",
                                "name": "半导体器件专用设备制造",
                                "children": {}
                            },
                            "电子元器件与机电组件设备制造": {
                                "code": "3563",
                                "name": "电子元器件与机电组件设备制造",
                                "children": {}
                            },
                            "其他电子专用设备制造": {
                                "code": "3569",
                                "name": "其他电子专用设备制造",
                                "children": {}
                            }
                        }
                    },
                    "农、林、牧、渔专用机械制造": {
                        "code": "357",
                        "name": "农、林、牧、渔专用机械制造",
                        "children": {
                            "拖拉机制造": {
                                "code": "3571",
                                "name": "拖拉机制造",
                                "children": {}
                            },
                            "机械化农业及园艺机具制造": {
                                "code": "3572",
                                "name": "机械化农业及园艺机具制造",
                                "children": {}
                            },
                            "营林及木竹采伐机械制造": {
                                "code": "3573",
                                "name": "营林及木竹采伐机械制造",
                                "children": {}
                            },
                            "畜牧机械制造": {
                                "code": "3574",
                                "name": "畜牧机械制造",
                                "children": {}
                            },
                            "渔业机械制造": {
                                "code": "3575",
                                "name": "渔业机械制造",
                                "children": {}
                            },
                            "农林牧渔机械配件制造": {
                                "code": "3576",
                                "name": "农林牧渔机械配件制造",
                                "children": {}
                            },
                            "棉花加工机械制造": {
                                "code": "3577",
                                "name": "棉花加工机械制造",
                                "children": {}
                            },
                            "其他农、林、牧、渔业机械制造": {
                                "code": "3579",
                                "name": "其他农、林、牧、渔业机械制造",
                                "children": {}
                            }
                        }
                    },
                    "医疗仪器设备及器械制造": {
                        "code": "358",
                        "name": "医疗仪器设备及器械制造",
                        "children": {
                            "医疗诊断、监护及治疗设备制造": {
                                "code": "3581",
                                "name": "医疗诊断、监护及治疗设备制造",
                                "children": {}
                            },
                            "口腔科用设备及器具制造": {
                                "code": "3582",
                                "name": "口腔科用设备及器具制造",
                                "children": {}
                            },
                            "医疗实验室及医用消毒设备和器具": {
                                "code": "3583",
                                "name": "医疗实验室及医用消毒设备和器具",
                                "children": {}
                            },
                            "医疗、外科及兽医用器械制造": {
                                "code": "3584",
                                "name": "医疗、外科及兽医用器械制造",
                                "children": {}
                            },
                            "机械治疗及病房护理设备制造": {
                                "code": "3585",
                                "name": "机械治疗及病房护理设备制造",
                                "children": {}
                            },
                            "康复辅具制造": {
                                "code": "3586",
                                "name": "康复辅具制造",
                                "children": {}
                            },
                            "眼镜制造": {
                                "code": "3587",
                                "name": "眼镜制造",
                                "children": {}
                            },
                            "其他医疗设备及器械制造": {
                                "code": "3589",
                                "name": "其他医疗设备及器械制造",
                                "children": {}
                            }
                        }
                    },
                    "环保、邮政、社会公共服务及其他专用": {
                        "code": "359",
                        "name": "环保、邮政、社会公共服务及其他专用",
                        "children": {
                            "环境保护专用设备制造": {
                                "code": "3591",
                                "name": "环境保护专用设备制造",
                                "children": {}
                            },
                            "地质勘查专用设备制造": {
                                "code": "3592",
                                "name": "地质勘查专用设备制造",
                                "children": {}
                            },
                            "邮政专用机械及器材制造": {
                                "code": "3593",
                                "name": "邮政专用机械及器材制造",
                                "children": {}
                            },
                            "商业、饮食、服务专用设备制造": {
                                "code": "3594",
                                "name": "商业、饮食、服务专用设备制造",
                                "children": {}
                            },
                            "社会公共安全设备及器材制造": {
                                "code": "3595",
                                "name": "社会公共安全设备及器材制造",
                                "children": {}
                            },
                            "交通安全、管制及类似专用设备制造": {
                                "code": "3596",
                                "name": "交通安全、管制及类似专用设备制造",
                                "children": {}
                            },
                            "水资源专用机械制造": {
                                "code": "3597",
                                "name": "水资源专用机械制造",
                                "children": {}
                            },
                            "其他专用设备制造": {
                                "code": "3599",
                                "name": "其他专用设备制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "汽车制造业": {
                "code": "36",
                "name": "汽车制造业",
                "children": {
                    "汽车整车制造": {
                        "code": "361",
                        "name": "汽车整车制造",
                        "children": {
                            "汽柴油车整车制造": {
                                "code": "3611",
                                "name": "汽柴油车整车制造",
                                "children": {}
                            },
                            "新能源车整车制造": {
                                "code": "3612",
                                "name": "新能源车整车制造",
                                "children": {}
                            }
                        }
                    },
                    "汽车用发动机制造": {
                        "code": "362",
                        "name": "汽车用发动机制造",
                        "children": {
                            "汽车用发动机制造": {
                                "code": "3620",
                                "name": "汽车用发动机制造",
                                "children": {}
                            }
                        }
                    },
                    "改装汽车制造": {
                        "code": "363",
                        "name": "改装汽车制造",
                        "children": {
                            "改装汽车制造": {
                                "code": "3630",
                                "name": "改装汽车制造",
                                "children": {}
                            }
                        }
                    },
                    "低速汽车制造": {
                        "code": "364",
                        "name": "低速汽车制造",
                        "children": {
                            "低速汽车制造": {
                                "code": "3640",
                                "name": "低速汽车制造",
                                "children": {}
                            }
                        }
                    },
                    "电车制造": {
                        "code": "365",
                        "name": "电车制造",
                        "children": {
                            "电车制造": {
                                "code": "3650",
                                "name": "电车制造",
                                "children": {}
                            }
                        }
                    },
                    "汽车车身、挂车制造": {
                        "code": "366",
                        "name": "汽车车身、挂车制造",
                        "children": {
                            "汽车车身、挂车制造": {
                                "code": "3660",
                                "name": "汽车车身、挂车制造",
                                "children": {}
                            }
                        }
                    },
                    "汽车零部件及配件制造": {
                        "code": "367",
                        "name": "汽车零部件及配件制造",
                        "children": {
                            "汽车零部件及配件制造": {
                                "code": "3670",
                                "name": "汽车零部件及配件制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "铁路、船舶、航空航天和其他运输设备制": {
                "code": "37",
                "name": "铁路、船舶、航空航天和其他运输设备制",
                "children": {
                    "铁路运输设备制造": {
                        "code": "371",
                        "name": "铁路运输设备制造",
                        "children": {
                            "高铁车组制造": {
                                "code": "3711",
                                "name": "高铁车组制造",
                                "children": {}
                            },
                            "铁路机车车辆制造": {
                                "code": "3712",
                                "name": "铁路机车车辆制造",
                                "children": {}
                            },
                            "窄轨机车车辆制造": {
                                "code": "3713",
                                "name": "窄轨机车车辆制造",
                                "children": {}
                            },
                            "高铁设备、配件制造": {
                                "code": "3714",
                                "name": "高铁设备、配件制造",
                                "children": {}
                            },
                            "铁路机车车辆配件制造": {
                                "code": "3715",
                                "name": "铁路机车车辆配件制造",
                                "children": {}
                            },
                            "铁路专用设备及器材、配件制造": {
                                "code": "3716",
                                "name": "铁路专用设备及器材、配件制造",
                                "children": {}
                            },
                            "其他铁路运输设备制造": {
                                "code": "3719",
                                "name": "其他铁路运输设备制造",
                                "children": {}
                            }
                        }
                    },
                    "城市轨道交通设备制造": {
                        "code": "372",
                        "name": "城市轨道交通设备制造",
                        "children": {
                            "城市轨道交通设备制造": {
                                "code": "3720",
                                "name": "城市轨道交通设备制造",
                                "children": {}
                            }
                        }
                    },
                    "船舶及相关装置制造": {
                        "code": "373",
                        "name": "船舶及相关装置制造",
                        "children": {
                            "金属船舶制造": {
                                "code": "3731",
                                "name": "金属船舶制造",
                                "children": {}
                            },
                            "非金属船舶制造": {
                                "code": "3732",
                                "name": "非金属船舶制造",
                                "children": {}
                            },
                            "娱乐船和运动船制造": {
                                "code": "3733",
                                "name": "娱乐船和运动船制造",
                                "children": {}
                            },
                            "船用配套设备制造": {
                                "code": "3734",
                                "name": "船用配套设备制造",
                                "children": {}
                            },
                            "船舶改装": {
                                "code": "3735",
                                "name": "船舶改装",
                                "children": {}
                            },
                            "船舶拆除": {
                                "code": "3736",
                                "name": "船舶拆除",
                                "children": {}
                            },
                            "海洋工程装备制造": {
                                "code": "3737",
                                "name": "海洋工程装备制造",
                                "children": {}
                            },
                            "航标器材及其他相关装置制造": {
                                "code": "3739",
                                "name": "航标器材及其他相关装置制造",
                                "children": {}
                            }
                        }
                    },
                    "航空、航天器及设备制造": {
                        "code": "374",
                        "name": "航空、航天器及设备制造",
                        "children": {
                            "飞机制造": {
                                "code": "3741",
                                "name": "飞机制造",
                                "children": {}
                            },
                            "航天器及运载火箭制造": {
                                "code": "3742",
                                "name": "航天器及运载火箭制造",
                                "children": {}
                            },
                            "航天相关设备制造": {
                                "code": "3743",
                                "name": "航天相关设备制造",
                                "children": {}
                            },
                            "航空相关设备制造": {
                                "code": "3744",
                                "name": "航空相关设备制造",
                                "children": {}
                            },
                            "其他航空航天器制造": {
                                "code": "3749",
                                "name": "其他航空航天器制造",
                                "children": {}
                            }
                        }
                    },
                    "摩托车制造": {
                        "code": "375",
                        "name": "摩托车制造",
                        "children": {
                            "摩托车整车制造": {
                                "code": "3751",
                                "name": "摩托车整车制造",
                                "children": {}
                            },
                            "摩托车零部件及配件制造": {
                                "code": "3752",
                                "name": "摩托车零部件及配件制造",
                                "children": {}
                            }
                        }
                    },
                    "自行车和残疾人座车制造": {
                        "code": "376",
                        "name": "自行车和残疾人座车制造",
                        "children": {
                            "自行车制造": {
                                "code": "3761",
                                "name": "自行车制造",
                                "children": {}
                            },
                            "残疾人座车制造": {
                                "code": "3762",
                                "name": "残疾人座车制造",
                                "children": {}
                            }
                        }
                    },
                    "助动车制造": {
                        "code": "377",
                        "name": "助动车制造",
                        "children": {
                            "助动车制造": {
                                "code": "3770",
                                "name": "助动车制造",
                                "children": {}
                            }
                        }
                    },
                    "非公路休闲车及零配件制造": {
                        "code": "378",
                        "name": "非公路休闲车及零配件制造",
                        "children": {
                            "非公路休闲车及零配件制造": {
                                "code": "3780",
                                "name": "非公路休闲车及零配件制造",
                                "children": {}
                            }
                        }
                    },
                    "潜水救捞及其他未列明运输设备制造": {
                        "code": "379",
                        "name": "潜水救捞及其他未列明运输设备制造",
                        "children": {
                            "潜水装备制造": {
                                "code": "3791",
                                "name": "潜水装备制造",
                                "children": {}
                            },
                            "水下救捞装备制造": {
                                "code": "3792",
                                "name": "水下救捞装备制造",
                                "children": {}
                            },
                            "其他未列明运输设备制造": {
                                "code": "3799",
                                "name": "其他未列明运输设备制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "电气机械和器材制造业": {
                "code": "38",
                "name": "电气机械和器材制造业",
                "children": {
                    "电机制造": {
                        "code": "381",
                        "name": "电机制造",
                        "children": {
                            "发电机及发电机组制造": {
                                "code": "3811",
                                "name": "发电机及发电机组制造",
                                "children": {}
                            },
                            "电动机制造": {
                                "code": "3812",
                                "name": "电动机制造",
                                "children": {}
                            },
                            "微特电机及组件制造": {
                                "code": "3813",
                                "name": "微特电机及组件制造",
                                "children": {}
                            },
                            "其他电机制造": {
                                "code": "3819",
                                "name": "其他电机制造",
                                "children": {}
                            }
                        }
                    },
                    "输配电及控制设备制造": {
                        "code": "382",
                        "name": "输配电及控制设备制造",
                        "children": {
                            "变压器、整流器和电感器制造": {
                                "code": "3821",
                                "name": "变压器、整流器和电感器制造",
                                "children": {}
                            },
                            "电容器及其配套设备制造": {
                                "code": "3822",
                                "name": "电容器及其配套设备制造",
                                "children": {}
                            },
                            "配电开关控制设备制造": {
                                "code": "3823",
                                "name": "配电开关控制设备制造",
                                "children": {}
                            },
                            "电力电子元器件制造": {
                                "code": "3824",
                                "name": "电力电子元器件制造",
                                "children": {}
                            },
                            "光伏设备及元器件制造": {
                                "code": "3825",
                                "name": "光伏设备及元器件制造",
                                "children": {}
                            },
                            "其他输配电及控制设备制造": {
                                "code": "3829",
                                "name": "其他输配电及控制设备制造",
                                "children": {}
                            }
                        }
                    },
                    "电线、电缆、光缆及电工器材制造": {
                        "code": "383",
                        "name": "电线、电缆、光缆及电工器材制造",
                        "children": {
                            "电线、电缆制造": {
                                "code": "3831",
                                "name": "电线、电缆制造",
                                "children": {}
                            },
                            "光纤制造": {
                                "code": "3832",
                                "name": "光纤制造",
                                "children": {}
                            },
                            "光缆制造": {
                                "code": "3833",
                                "name": "光缆制造",
                                "children": {}
                            },
                            "绝缘制品制造": {
                                "code": "3834",
                                "name": "绝缘制品制造",
                                "children": {}
                            },
                            "其他电工器材制造": {
                                "code": "3839",
                                "name": "其他电工器材制造",
                                "children": {}
                            }
                        }
                    },
                    "电池制造": {
                        "code": "384",
                        "name": "电池制造",
                        "children": {
                            "锂离子电池制造": {
                                "code": "3841",
                                "name": "锂离子电池制造",
                                "children": {}
                            },
                            "镍氢电池制造": {
                                "code": "3842",
                                "name": "镍氢电池制造",
                                "children": {}
                            },
                            "铅蓄电池制造": {
                                "code": "3843",
                                "name": "铅蓄电池制造",
                                "children": {}
                            },
                            "锌锰电池制造": {
                                "code": "3844",
                                "name": "锌锰电池制造",
                                "children": {}
                            },
                            "其他电池制造": {
                                "code": "3849",
                                "name": "其他电池制造",
                                "children": {}
                            }
                        }
                    },
                    "家用电力器具制造": {
                        "code": "385",
                        "name": "家用电力器具制造",
                        "children": {
                            "家用制冷电器具制造": {
                                "code": "3851",
                                "name": "家用制冷电器具制造",
                                "children": {}
                            },
                            "家用空气调节器制造": {
                                "code": "3852",
                                "name": "家用空气调节器制造",
                                "children": {}
                            },
                            "家用通风电器具制造": {
                                "code": "3853",
                                "name": "家用通风电器具制造",
                                "children": {}
                            },
                            "家用厨房电器具制造": {
                                "code": "3854",
                                "name": "家用厨房电器具制造",
                                "children": {}
                            },
                            "家用清洁卫生电器具制造": {
                                "code": "3855",
                                "name": "家用清洁卫生电器具制造",
                                "children": {}
                            },
                            "家用美容、保健护理电器具制造": {
                                "code": "3856",
                                "name": "家用美容、保健护理电器具制造",
                                "children": {}
                            },
                            "家用电力器具专用配件制造": {
                                "code": "3857",
                                "name": "家用电力器具专用配件制造",
                                "children": {}
                            },
                            "其他家用电力器具制造": {
                                "code": "3859",
                                "name": "其他家用电力器具制造",
                                "children": {}
                            }
                        }
                    },
                    "非电力家用器具制造": {
                        "code": "386",
                        "name": "非电力家用器具制造",
                        "children": {
                            "燃气及类似能源家用器具制造": {
                                "code": "3861",
                                "name": "燃气及类似能源家用器具制造",
                                "children": {}
                            },
                            "太阳能器具制造": {
                                "code": "3862",
                                "name": "太阳能器具制造",
                                "children": {}
                            },
                            "其他非电力家用器具制造": {
                                "code": "3869",
                                "name": "其他非电力家用器具制造",
                                "children": {}
                            }
                        }
                    },
                    "照明器具制造": {
                        "code": "387",
                        "name": "照明器具制造",
                        "children": {
                            "电光源制造": {
                                "code": "3871",
                                "name": "电光源制造",
                                "children": {}
                            },
                            "照明灯具制造": {
                                "code": "3872",
                                "name": "照明灯具制造",
                                "children": {}
                            },
                            "舞台及场地用灯制造": {
                                "code": "3873",
                                "name": "舞台及场地用灯制造",
                                "children": {}
                            },
                            "智能照明器具制造": {
                                "code": "3874",
                                "name": "智能照明器具制造",
                                "children": {}
                            },
                            "灯用电器附件及其他照明器具制造": {
                                "code": "3879",
                                "name": "灯用电器附件及其他照明器具制造",
                                "children": {}
                            }
                        }
                    },
                    "其他电气机械及器材制造": {
                        "code": "389",
                        "name": "其他电气机械及器材制造",
                        "children": {
                            "电气信号设备装置制造": {
                                "code": "3891",
                                "name": "电气信号设备装置制造",
                                "children": {}
                            },
                            "其他未列明电气机械及器材制造": {
                                "code": "3899",
                                "name": "其他未列明电气机械及器材制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "计算机、通信和其他电子设备制造业": {
                "code": "39",
                "name": "计算机、通信和其他电子设备制造业",
                "children": {
                    "计算机制造": {
                        "code": "391",
                        "name": "计算机制造",
                        "children": {
                            "计算机整机制造": {
                                "code": "3911",
                                "name": "计算机整机制造",
                                "children": {}
                            },
                            "计算机零部件制造": {
                                "code": "3912",
                                "name": "计算机零部件制造",
                                "children": {}
                            },
                            "计算机外围设备制造": {
                                "code": "3913",
                                "name": "计算机外围设备制造",
                                "children": {}
                            },
                            "工业控制计算机及系统制造": {
                                "code": "3914",
                                "name": "工业控制计算机及系统制造",
                                "children": {}
                            },
                            "信息安全设备制造": {
                                "code": "3915",
                                "name": "信息安全设备制造",
                                "children": {}
                            },
                            "其他计算机制造": {
                                "code": "3919",
                                "name": "其他计算机制造",
                                "children": {}
                            }
                        }
                    },
                    "通信设备制造": {
                        "code": "392",
                        "name": "通信设备制造",
                        "children": {
                            "通信系统设备制造": {
                                "code": "3921",
                                "name": "通信系统设备制造",
                                "children": {}
                            },
                            "通信终端设备制造": {
                                "code": "3922",
                                "name": "通信终端设备制造",
                                "children": {}
                            }
                        }
                    },
                    "广播电视设备制造": {
                        "code": "393",
                        "name": "广播电视设备制造",
                        "children": {
                            "广播电视节目制作及发射设备制造": {
                                "code": "3931",
                                "name": "广播电视节目制作及发射设备制造",
                                "children": {}
                            },
                            "广播电视接收设备制造": {
                                "code": "3932",
                                "name": "广播电视接收设备制造",
                                "children": {}
                            },
                            "广播电视专用配件制造": {
                                "code": "3933",
                                "name": "广播电视专用配件制造",
                                "children": {}
                            },
                            "专业音响设备制造": {
                                "code": "3934",
                                "name": "专业音响设备制造",
                                "children": {}
                            },
                            "应用电视设备及其他广播电视设备": {
                                "code": "3939",
                                "name": "应用电视设备及其他广播电视设备",
                                "children": {}
                            }
                        }
                    },
                    "雷达及配套设备制造": {
                        "code": "394",
                        "name": "雷达及配套设备制造",
                        "children": {
                            "雷达及配套设备制造": {
                                "code": "3940",
                                "name": "雷达及配套设备制造",
                                "children": {}
                            }
                        }
                    },
                    "非专业视听设备制造": {
                        "code": "395",
                        "name": "非专业视听设备制造",
                        "children": {
                            "电视机制造": {
                                "code": "3951",
                                "name": "电视机制造",
                                "children": {}
                            },
                            "音响设备制造": {
                                "code": "3952",
                                "name": "音响设备制造",
                                "children": {}
                            },
                            "影视录放设备制造": {
                                "code": "3953",
                                "name": "影视录放设备制造",
                                "children": {}
                            }
                        }
                    },
                    "智能消费设备制造": {
                        "code": "396",
                        "name": "智能消费设备制造",
                        "children": {
                            "可穿戴智能设备制造": {
                                "code": "3961",
                                "name": "可穿戴智能设备制造",
                                "children": {}
                            },
                            "智能车载设备制造": {
                                "code": "3962",
                                "name": "智能车载设备制造",
                                "children": {}
                            },
                            "智能无人飞行器制造": {
                                "code": "3963",
                                "name": "智能无人飞行器制造",
                                "children": {}
                            },
                            "服务消费机器人制造": {
                                "code": "3964",
                                "name": "服务消费机器人制造",
                                "children": {}
                            },
                            "其他智能消费设备制造": {
                                "code": "3969",
                                "name": "其他智能消费设备制造",
                                "children": {}
                            }
                        }
                    },
                    "电子器件制造": {
                        "code": "397",
                        "name": "电子器件制造",
                        "children": {
                            "电子真空器件制造": {
                                "code": "3971",
                                "name": "电子真空器件制造",
                                "children": {}
                            },
                            "半导体分立器件制造": {
                                "code": "3972",
                                "name": "半导体分立器件制造",
                                "children": {}
                            },
                            "集成电路制造": {
                                "code": "3973",
                                "name": "集成电路制造",
                                "children": {}
                            },
                            "显示器件制造": {
                                "code": "3974",
                                "name": "显示器件制造",
                                "children": {}
                            },
                            "半导体照明器件制造": {
                                "code": "3975",
                                "name": "半导体照明器件制造",
                                "children": {}
                            },
                            "光电子器件制造": {
                                "code": "3976",
                                "name": "光电子器件制造",
                                "children": {}
                            },
                            "其他电子器件制造": {
                                "code": "3979",
                                "name": "其他电子器件制造",
                                "children": {}
                            }
                        }
                    },
                    "电子元件及电子专用材料制造": {
                        "code": "398",
                        "name": "电子元件及电子专用材料制造",
                        "children": {
                            "电阻电容电感元件制造": {
                                "code": "3981",
                                "name": "电阻电容电感元件制造",
                                "children": {}
                            },
                            "电子电路制造": {
                                "code": "3982",
                                "name": "电子电路制造",
                                "children": {}
                            },
                            "敏感元件及传感器制造": {
                                "code": "3983",
                                "name": "敏感元件及传感器制造",
                                "children": {}
                            },
                            "电声器件及零件制造": {
                                "code": "3984",
                                "name": "电声器件及零件制造",
                                "children": {}
                            },
                            "电子专用材料制造": {
                                "code": "3985",
                                "name": "电子专用材料制造",
                                "children": {}
                            },
                            "其他电子元件制造": {
                                "code": "3989",
                                "name": "其他电子元件制造",
                                "children": {}
                            }
                        }
                    },
                    "其他电子设备制造": {
                        "code": "399",
                        "name": "其他电子设备制造",
                        "children": {
                            "其他电子设备制造": {
                                "code": "3990",
                                "name": "其他电子设备制造",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "仪器仪表制造业": {
                "code": "40",
                "name": "仪器仪表制造业",
                "children": {
                    "通用仪器仪表制造": {
                        "code": "401",
                        "name": "通用仪器仪表制造",
                        "children": {
                            "工业自动控制系统装置制造": {
                                "code": "4011",
                                "name": "工业自动控制系统装置制造",
                                "children": {}
                            },
                            "电工仪器仪表制造": {
                                "code": "4012",
                                "name": "电工仪器仪表制造",
                                "children": {}
                            },
                            "绘图、计算及测量仪器制造": {
                                "code": "4013",
                                "name": "绘图、计算及测量仪器制造",
                                "children": {}
                            },
                            "实验分析仪器制造": {
                                "code": "4014",
                                "name": "实验分析仪器制造",
                                "children": {}
                            },
                            "试验机制造": {
                                "code": "4015",
                                "name": "试验机制造",
                                "children": {}
                            },
                            "供应用仪器仪表制造": {
                                "code": "4016",
                                "name": "供应用仪器仪表制造",
                                "children": {}
                            },
                            "其他通用仪器制造": {
                                "code": "4019",
                                "name": "其他通用仪器制造",
                                "children": {}
                            }
                        }
                    },
                    "专用仪器仪表制造": {
                        "code": "402",
                        "name": "专用仪器仪表制造",
                        "children": {
                            "环境监测专用仪器仪表制造": {
                                "code": "4021",
                                "name": "环境监测专用仪器仪表制造",
                                "children": {}
                            },
                            "运输设备及生产用计数仪表制造": {
                                "code": "4022",
                                "name": "运输设备及生产用计数仪表制造",
                                "children": {}
                            },
                            "导航、测绘、气象及海洋专用仪器制": {
                                "code": "4023",
                                "name": "导航、测绘、气象及海洋专用仪器制",
                                "children": {}
                            },
                            "农林牧渔专用仪器仪表制造": {
                                "code": "4024",
                                "name": "农林牧渔专用仪器仪表制造",
                                "children": {}
                            },
                            "地质勘探和地震专用仪器制造": {
                                "code": "4025",
                                "name": "地质勘探和地震专用仪器制造",
                                "children": {}
                            },
                            "教学专用仪器制造": {
                                "code": "4026",
                                "name": "教学专用仪器制造",
                                "children": {}
                            },
                            "核子及核辐射测量仪器制造": {
                                "code": "4027",
                                "name": "核子及核辐射测量仪器制造",
                                "children": {}
                            },
                            "电子测量仪器制造": {
                                "code": "4028",
                                "name": "电子测量仪器制造",
                                "children": {}
                            },
                            "其他专用仪器制造": {
                                "code": "4029",
                                "name": "其他专用仪器制造",
                                "children": {}
                            }
                        }
                    },
                    "钟表与计时仪器制造": {
                        "code": "403",
                        "name": "钟表与计时仪器制造",
                        "children": {
                            "钟表与计时仪器制造": {
                                "code": "4030",
                                "name": "钟表与计时仪器制造",
                                "children": {}
                            }
                        }
                    },
                    "光学仪器制造": {
                        "code": "404",
                        "name": "光学仪器制造",
                        "children": {
                            "光学仪器制造": {
                                "code": "4040",
                                "name": "光学仪器制造",
                                "children": {}
                            }
                        }
                    },
                    "衡器制造": {
                        "code": "405",
                        "name": "衡器制造",
                        "children": {
                            "衡器制造": {
                                "code": "4050",
                                "name": "衡器制造",
                                "children": {}
                            }
                        }
                    },
                    "其他仪器仪表制造业": {
                        "code": "409",
                        "name": "其他仪器仪表制造业",
                        "children": {
                            "其他仪器仪表制造业": {
                                "code": "4090",
                                "name": "其他仪器仪表制造业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "其他制造业": {
                "code": "41",
                "name": "其他制造业",
                "children": {
                    "日用杂品制造": {
                        "code": "411",
                        "name": "日用杂品制造",
                        "children": {
                            "鬃毛加工、制刷及清扫工具制造": {
                                "code": "4111",
                                "name": "鬃毛加工、制刷及清扫工具制造",
                                "children": {}
                            },
                            "其他日用杂品制造": {
                                "code": "4119",
                                "name": "其他日用杂品制造",
                                "children": {}
                            }
                        }
                    },
                    "核辐射加工": {
                        "code": "412",
                        "name": "核辐射加工",
                        "children": {
                            "核辐射加工": {
                                "code": "4120",
                                "name": "核辐射加工",
                                "children": {}
                            }
                        }
                    },
                    "其他未列明制造业": {
                        "code": "419",
                        "name": "其他未列明制造业",
                        "children": {
                            "其他未列明制造业": {
                                "code": "4190",
                                "name": "其他未列明制造业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "废弃资源综合利用业": {
                "code": "42",
                "name": "废弃资源综合利用业",
                "children": {
                    "金属废料和碎屑加工处理": {
                        "code": "421",
                        "name": "金属废料和碎屑加工处理",
                        "children": {
                            "金属废料和碎屑加工处理": {
                                "code": "4210",
                                "name": "金属废料和碎屑加工处理",
                                "children": {}
                            }
                        }
                    },
                    "非金属废料和碎屑加工处理": {
                        "code": "422",
                        "name": "非金属废料和碎屑加工处理",
                        "children": {
                            "非金属废料和碎屑加工处理": {
                                "code": "4220",
                                "name": "非金属废料和碎屑加工处理",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "金属制品、机械和设备修理业": {
                "code": "43",
                "name": "金属制品、机械和设备修理业",
                "children": {
                    "金属制品修理": {
                        "code": "431",
                        "name": "金属制品修理",
                        "children": {
                            "金属制品修理": {
                                "code": "4310",
                                "name": "金属制品修理",
                                "children": {}
                            }
                        }
                    },
                    "通用设备修理": {
                        "code": "432",
                        "name": "通用设备修理",
                        "children": {
                            "通用设备修理": {
                                "code": "4320",
                                "name": "通用设备修理",
                                "children": {}
                            }
                        }
                    },
                    "专用设备修理": {
                        "code": "433",
                        "name": "专用设备修理",
                        "children": {
                            "专用设备修理": {
                                "code": "4330",
                                "name": "专用设备修理",
                                "children": {}
                            }
                        }
                    },
                    "铁路、船舶、航空航天等运输设备修理": {
                        "code": "434",
                        "name": "铁路、船舶、航空航天等运输设备修理",
                        "children": {
                            "铁路运输设备修理": {
                                "code": "4341",
                                "name": "铁路运输设备修理",
                                "children": {}
                            },
                            "船舶修理": {
                                "code": "4342",
                                "name": "船舶修理",
                                "children": {}
                            },
                            "航空航天器修理": {
                                "code": "4343",
                                "name": "航空航天器修理",
                                "children": {}
                            },
                            "其他运输设备修理": {
                                "code": "4349",
                                "name": "其他运输设备修理",
                                "children": {}
                            }
                        }
                    },
                    "电气设备修理": {
                        "code": "435",
                        "name": "电气设备修理",
                        "children": {
                            "电气设备修理": {
                                "code": "4350",
                                "name": "电气设备修理",
                                "children": {}
                            }
                        }
                    },
                    "仪器仪表修理": {
                        "code": "436",
                        "name": "仪器仪表修理",
                        "children": {
                            "仪器仪表修理": {
                                "code": "4360",
                                "name": "仪器仪表修理",
                                "children": {}
                            }
                        }
                    },
                    "其他机械和设备修理业": {
                        "code": "439",
                        "name": "其他机械和设备修理业",
                        "children": {
                            "其他机械和设备修理业": {
                                "code": "4390",
                                "name": "其他机械和设备修理业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "电力、热力、燃气及水生产和供应业": {
        "code": "D",
        "name": "电力、热力、燃气及水生产和供应业",
        "children": {
            "电力、热力生产和供应业": {
                "code": "44",
                "name": "电力、热力生产和供应业",
                "children": {
                    "电力生产": {
                        "code": "441",
                        "name": "电力生产",
                        "children": {
                            "火力发电": {
                                "code": "4411",
                                "name": "火力发电",
                                "children": {}
                            },
                            "热电联产": {
                                "code": "4412",
                                "name": "热电联产",
                                "children": {}
                            },
                            "水力发电": {
                                "code": "4413",
                                "name": "水力发电",
                                "children": {}
                            },
                            "核力发电": {
                                "code": "4414",
                                "name": "核力发电",
                                "children": {}
                            },
                            "风力发电": {
                                "code": "4415",
                                "name": "风力发电",
                                "children": {}
                            },
                            "太阳能发电": {
                                "code": "4416",
                                "name": "太阳能发电",
                                "children": {}
                            },
                            "生物质能发电": {
                                "code": "4417",
                                "name": "生物质能发电",
                                "children": {}
                            },
                            "其他电力生产": {
                                "code": "4419",
                                "name": "其他电力生产",
                                "children": {}
                            }
                        }
                    },
                    "电力供应": {
                        "code": "442",
                        "name": "电力供应",
                        "children": {
                            "电力供应": {
                                "code": "4420",
                                "name": "电力供应",
                                "children": {}
                            }
                        }
                    },
                    "热力生产和供应": {
                        "code": "443",
                        "name": "热力生产和供应",
                        "children": {
                            "热力生产和供应": {
                                "code": "4430",
                                "name": "热力生产和供应",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "燃气生产和供应业": {
                "code": "45",
                "name": "燃气生产和供应业",
                "children": {
                    "燃气生产和供应业": {
                        "code": "451",
                        "name": "燃气生产和供应业",
                        "children": {
                            "天然气生产和供应业": {
                                "code": "4511",
                                "name": "天然气生产和供应业",
                                "children": {}
                            },
                            "液化石油气生产和供应业": {
                                "code": "4512",
                                "name": "液化石油气生产和供应业",
                                "children": {}
                            },
                            "煤气生产和供应业": {
                                "code": "4513",
                                "name": "煤气生产和供应业",
                                "children": {}
                            }
                        }
                    },
                    "生物质燃气生产和供应业": {
                        "code": "452",
                        "name": "生物质燃气生产和供应业",
                        "children": {
                            "生物质燃气生产和供应业": {
                                "code": "4520",
                                "name": "生物质燃气生产和供应业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "水的生产和供应业": {
                "code": "46",
                "name": "水的生产和供应业",
                "children": {
                    "自来水生产和供应": {
                        "code": "461",
                        "name": "自来水生产和供应",
                        "children": {
                            "自来水生产和供应": {
                                "code": "4610",
                                "name": "自来水生产和供应",
                                "children": {}
                            }
                        }
                    },
                    "污水处理及其再生利用": {
                        "code": "462",
                        "name": "污水处理及其再生利用",
                        "children": {
                            "污水处理及其再生利用": {
                                "code": "4620",
                                "name": "污水处理及其再生利用",
                                "children": {}
                            }
                        }
                    },
                    "海水淡化处理": {
                        "code": "463",
                        "name": "海水淡化处理",
                        "children": {
                            "海水淡化处理": {
                                "code": "4630",
                                "name": "海水淡化处理",
                                "children": {}
                            }
                        }
                    },
                    "其他水的处理、利用与分配": {
                        "code": "469",
                        "name": "其他水的处理、利用与分配",
                        "children": {
                            "其他水的处理、利用与分配": {
                                "code": "4690",
                                "name": "其他水的处理、利用与分配",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "建筑业": {
        "code": "E",
        "name": "建筑业",
        "children": {
            "房屋建筑业": {
                "code": "47",
                "name": "房屋建筑业",
                "children": {
                    "住宅房屋建筑": {
                        "code": "471",
                        "name": "住宅房屋建筑",
                        "children": {
                            "住宅房屋建筑": {
                                "code": "4710",
                                "name": "住宅房屋建筑",
                                "children": {}
                            }
                        }
                    },
                    "体育场馆建筑": {
                        "code": "472",
                        "name": "体育场馆建筑",
                        "children": {
                            "体育场馆建筑": {
                                "code": "4720",
                                "name": "体育场馆建筑",
                                "children": {}
                            }
                        }
                    },
                    "其他房屋建筑业": {
                        "code": "479",
                        "name": "其他房屋建筑业",
                        "children": {
                            "其他房屋建筑业": {
                                "code": "4790",
                                "name": "其他房屋建筑业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "土木工程建筑业": {
                "code": "48",
                "name": "土木工程建筑业",
                "children": {
                    "铁路、道路、隧道和桥梁工程建筑": {
                        "code": "481",
                        "name": "铁路、道路、隧道和桥梁工程建筑",
                        "children": {
                            "铁路工程建筑": {
                                "code": "4811",
                                "name": "铁路工程建筑",
                                "children": {}
                            },
                            "公路工程建筑": {
                                "code": "4812",
                                "name": "公路工程建筑",
                                "children": {}
                            },
                            "市政道路工程建筑": {
                                "code": "4813",
                                "name": "市政道路工程建筑",
                                "children": {}
                            },
                            "城市轨道交通工程建筑": {
                                "code": "4814",
                                "name": "城市轨道交通工程建筑",
                                "children": {}
                            },
                            "其他道路、隧道和桥梁工程建筑": {
                                "code": "4819",
                                "name": "其他道路、隧道和桥梁工程建筑",
                                "children": {}
                            }
                        }
                    },
                    "水利和水运工程建筑": {
                        "code": "482",
                        "name": "水利和水运工程建筑",
                        "children": {
                            "水源及供水设施工程建筑": {
                                "code": "4821",
                                "name": "水源及供水设施工程建筑",
                                "children": {}
                            },
                            "河湖治理及防洪设施工程建筑": {
                                "code": "4822",
                                "name": "河湖治理及防洪设施工程建筑",
                                "children": {}
                            },
                            "港口及航运设施工程建筑": {
                                "code": "4823",
                                "name": "港口及航运设施工程建筑",
                                "children": {}
                            }
                        }
                    },
                    "海洋工程建筑": {
                        "code": "483",
                        "name": "海洋工程建筑",
                        "children": {
                            "海洋油气资源开发利用工程建筑": {
                                "code": "4831",
                                "name": "海洋油气资源开发利用工程建筑",
                                "children": {}
                            },
                            "海洋能源开发利用工程建筑": {
                                "code": "4832",
                                "name": "海洋能源开发利用工程建筑",
                                "children": {}
                            },
                            "海底隧道工程建筑": {
                                "code": "4833",
                                "name": "海底隧道工程建筑",
                                "children": {}
                            },
                            "海底设施铺设工程建筑": {
                                "code": "4834",
                                "name": "海底设施铺设工程建筑",
                                "children": {}
                            },
                            "其他海洋工程建筑": {
                                "code": "4839",
                                "name": "其他海洋工程建筑",
                                "children": {}
                            }
                        }
                    },
                    "工矿工程建筑": {
                        "code": "484",
                        "name": "工矿工程建筑",
                        "children": {
                            "工矿工程建筑": {
                                "code": "4840",
                                "name": "工矿工程建筑",
                                "children": {}
                            }
                        }
                    },
                    "架线和管道工程建筑": {
                        "code": "485",
                        "name": "架线和管道工程建筑",
                        "children": {
                            "架线及设备工程建筑": {
                                "code": "4851",
                                "name": "架线及设备工程建筑",
                                "children": {}
                            },
                            "管道工程建筑": {
                                "code": "4852",
                                "name": "管道工程建筑",
                                "children": {}
                            },
                            "地下综合管廊工程建筑": {
                                "code": "4853",
                                "name": "地下综合管廊工程建筑",
                                "children": {}
                            }
                        }
                    },
                    "节能环保工程施工": {
                        "code": "486",
                        "name": "节能环保工程施工",
                        "children": {
                            "节能工程施工": {
                                "code": "4861",
                                "name": "节能工程施工",
                                "children": {}
                            },
                            "环保工程施工": {
                                "code": "4862",
                                "name": "环保工程施工",
                                "children": {}
                            },
                            "生态保护工程施工": {
                                "code": "4863",
                                "name": "生态保护工程施工",
                                "children": {}
                            }
                        }
                    },
                    "电力工程施工": {
                        "code": "487",
                        "name": "电力工程施工",
                        "children": {
                            "火力发电工程施工": {
                                "code": "4871",
                                "name": "火力发电工程施工",
                                "children": {}
                            },
                            "水力发电工程施工": {
                                "code": "4872",
                                "name": "水力发电工程施工",
                                "children": {}
                            },
                            "核电工程施工": {
                                "code": "4873",
                                "name": "核电工程施工",
                                "children": {}
                            },
                            "风能发电工程施工": {
                                "code": "4874",
                                "name": "风能发电工程施工",
                                "children": {}
                            },
                            "太阳能发电工程施工": {
                                "code": "4875",
                                "name": "太阳能发电工程施工",
                                "children": {}
                            },
                            "其他电力工程施工": {
                                "code": "4879",
                                "name": "其他电力工程施工",
                                "children": {}
                            }
                        }
                    },
                    "其他土木工程建筑": {
                        "code": "489",
                        "name": "其他土木工程建筑",
                        "children": {
                            "园林绿化工程施工": {
                                "code": "4891",
                                "name": "园林绿化工程施工",
                                "children": {}
                            },
                            "体育场地设施工程施工": {
                                "code": "4892",
                                "name": "体育场地设施工程施工",
                                "children": {}
                            },
                            "游乐设施工程施工": {
                                "code": "4893",
                                "name": "游乐设施工程施工",
                                "children": {}
                            },
                            "其他土木工程建筑施工": {
                                "code": "4899",
                                "name": "其他土木工程建筑施工",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "建筑安装业": {
                "code": "49",
                "name": "建筑安装业",
                "children": {
                    "电气安装": {
                        "code": "491",
                        "name": "电气安装",
                        "children": {
                            "电气安装": {
                                "code": "4910",
                                "name": "电气安装",
                                "children": {}
                            }
                        }
                    },
                    "管道和设备安装": {
                        "code": "492",
                        "name": "管道和设备安装",
                        "children": {
                            "管道和设备安装": {
                                "code": "4920",
                                "name": "管道和设备安装",
                                "children": {}
                            }
                        }
                    },
                    "其他建筑安装业": {
                        "code": "499",
                        "name": "其他建筑安装业",
                        "children": {
                            "体育场地设施安装": {
                                "code": "4991",
                                "name": "体育场地设施安装",
                                "children": {}
                            },
                            "其他建筑安装": {
                                "code": "4999",
                                "name": "其他建筑安装",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "建筑装饰、装修和其他建筑业": {
                "code": "50",
                "name": "建筑装饰、装修和其他建筑业",
                "children": {
                    "建筑装饰和装修业": {
                        "code": "501",
                        "name": "建筑装饰和装修业",
                        "children": {
                            "公共建筑装饰和装修": {
                                "code": "5011",
                                "name": "公共建筑装饰和装修",
                                "children": {}
                            },
                            "住宅装饰和装修": {
                                "code": "5012",
                                "name": "住宅装饰和装修",
                                "children": {}
                            },
                            "建筑幕墙装饰和装修": {
                                "code": "5013",
                                "name": "建筑幕墙装饰和装修",
                                "children": {}
                            }
                        }
                    },
                    "建筑物拆除和场地准备活动": {
                        "code": "502",
                        "name": "建筑物拆除和场地准备活动",
                        "children": {
                            "建筑物拆除活动": {
                                "code": "5021",
                                "name": "建筑物拆除活动",
                                "children": {}
                            },
                            "场地准备活动": {
                                "code": "5022",
                                "name": "场地准备活动",
                                "children": {}
                            }
                        }
                    },
                    "提供施工设备服务": {
                        "code": "503",
                        "name": "提供施工设备服务",
                        "children": {
                            "提供施工设备服务": {
                                "code": "5030",
                                "name": "提供施工设备服务",
                                "children": {}
                            }
                        }
                    },
                    "其他未列明建筑业": {
                        "code": "509",
                        "name": "其他未列明建筑业",
                        "children": {
                            "其他未列明建筑业": {
                                "code": "5090",
                                "name": "其他未列明建筑业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "批发和零售业": {
        "code": "F",
        "name": "批发和零售业",
        "children": {
            "批发业": {
                "code": "51",
                "name": "批发业",
                "children": {
                    "农、林、牧、渔产品批发": {
                        "code": "511",
                        "name": "农、林、牧、渔产品批发",
                        "children": {
                            "谷物、豆及薯类批发": {
                                "code": "5111",
                                "name": "谷物、豆及薯类批发",
                                "children": {}
                            },
                            "种子批发": {
                                "code": "5112",
                                "name": "种子批发",
                                "children": {}
                            },
                            "畜牧渔业饲料批发": {
                                "code": "5113",
                                "name": "畜牧渔业饲料批发",
                                "children": {}
                            },
                            "棉、麻批发": {
                                "code": "5114",
                                "name": "棉、麻批发",
                                "children": {}
                            },
                            "林业产品批发": {
                                "code": "5115",
                                "name": "林业产品批发",
                                "children": {}
                            },
                            "牲畜批发": {
                                "code": "5116",
                                "name": "牲畜批发",
                                "children": {}
                            },
                            "渔业产品批发": {
                                "code": "5117",
                                "name": "渔业产品批发",
                                "children": {}
                            },
                            "其他农牧产品批发": {
                                "code": "5119",
                                "name": "其他农牧产品批发",
                                "children": {}
                            }
                        }
                    },
                    "食品、饮料及烟草制品批发": {
                        "code": "512",
                        "name": "食品、饮料及烟草制品批发",
                        "children": {
                            "米、面制品及食用油批发": {
                                "code": "5121",
                                "name": "米、面制品及食用油批发",
                                "children": {}
                            },
                            "糕点、糖果及糖批发": {
                                "code": "5122",
                                "name": "糕点、糖果及糖批发",
                                "children": {}
                            },
                            "果品、蔬菜批发": {
                                "code": "5123",
                                "name": "果品、蔬菜批发",
                                "children": {}
                            },
                            "肉、禽、蛋、奶及水产品批发": {
                                "code": "5124",
                                "name": "肉、禽、蛋、奶及水产品批发",
                                "children": {}
                            },
                            "盐及调味品批发": {
                                "code": "5125",
                                "name": "盐及调味品批发",
                                "children": {}
                            },
                            "营养和保健品批发": {
                                "code": "5126",
                                "name": "营养和保健品批发",
                                "children": {}
                            },
                            "酒、饮料及茶叶批发": {
                                "code": "5127",
                                "name": "酒、饮料及茶叶批发",
                                "children": {}
                            },
                            "烟草制品批发": {
                                "code": "5128",
                                "name": "烟草制品批发",
                                "children": {}
                            },
                            "其他食品批发": {
                                "code": "5129",
                                "name": "其他食品批发",
                                "children": {}
                            }
                        }
                    },
                    "纺织、服装及家庭用品批发": {
                        "code": "513",
                        "name": "纺织、服装及家庭用品批发",
                        "children": {
                            "纺织品、针织品及原料批发": {
                                "code": "5131",
                                "name": "纺织品、针织品及原料批发",
                                "children": {}
                            },
                            "服装批发": {
                                "code": "5132",
                                "name": "服装批发",
                                "children": {}
                            },
                            "鞋帽批发": {
                                "code": "5133",
                                "name": "鞋帽批发",
                                "children": {}
                            },
                            "化妆品及卫生用品批发": {
                                "code": "5134",
                                "name": "化妆品及卫生用品批发",
                                "children": {}
                            },
                            "厨具卫具及日用杂品批发": {
                                "code": "5135",
                                "name": "厨具卫具及日用杂品批发",
                                "children": {}
                            },
                            "灯具、装饰物品批发": {
                                "code": "5136",
                                "name": "灯具、装饰物品批发",
                                "children": {}
                            },
                            "家用视听设备批发": {
                                "code": "5137",
                                "name": "家用视听设备批发",
                                "children": {}
                            },
                            "日用家电批发": {
                                "code": "5138",
                                "name": "日用家电批发",
                                "children": {}
                            },
                            "其他家庭用品批发": {
                                "code": "5139",
                                "name": "其他家庭用品批发",
                                "children": {}
                            }
                        }
                    },
                    "文化、体育用品及器材批发": {
                        "code": "514",
                        "name": "文化、体育用品及器材批发",
                        "children": {
                            "文具用品批发": {
                                "code": "5141",
                                "name": "文具用品批发",
                                "children": {}
                            },
                            "体育用品及器材批发": {
                                "code": "5142",
                                "name": "体育用品及器材批发",
                                "children": {}
                            },
                            "图书批发": {
                                "code": "5143",
                                "name": "图书批发",
                                "children": {}
                            },
                            "报刊批发": {
                                "code": "5144",
                                "name": "报刊批发",
                                "children": {}
                            },
                            "音像制品、电子和数字出版物批发": {
                                "code": "5145",
                                "name": "音像制品、电子和数字出版物批发",
                                "children": {}
                            },
                            "首饰、工艺品及收藏品批发": {
                                "code": "5146",
                                "name": "首饰、工艺品及收藏品批发",
                                "children": {}
                            },
                            "乐器批发": {
                                "code": "5147",
                                "name": "乐器批发",
                                "children": {}
                            },
                            "其他文化用品批发": {
                                "code": "5149",
                                "name": "其他文化用品批发",
                                "children": {}
                            }
                        }
                    },
                    "医药及医疗器材批发": {
                        "code": "515",
                        "name": "医药及医疗器材批发",
                        "children": {
                            "西药批发": {
                                "code": "5151",
                                "name": "西药批发",
                                "children": {}
                            },
                            "中药批发": {
                                "code": "5152",
                                "name": "中药批发",
                                "children": {}
                            },
                            "动物用药品批发": {
                                "code": "5153",
                                "name": "动物用药品批发",
                                "children": {}
                            },
                            "医疗用品及器材批发": {
                                "code": "5154",
                                "name": "医疗用品及器材批发",
                                "children": {}
                            }
                        }
                    },
                    "矿产品、建材及化工产品批发": {
                        "code": "516",
                        "name": "矿产品、建材及化工产品批发",
                        "children": {
                            "煤炭及制品批发": {
                                "code": "5161",
                                "name": "煤炭及制品批发",
                                "children": {}
                            },
                            "石油及制品批发": {
                                "code": "5162",
                                "name": "石油及制品批发",
                                "children": {}
                            },
                            "非金属矿及制品批发": {
                                "code": "5163",
                                "name": "非金属矿及制品批发",
                                "children": {}
                            },
                            "金属及金属矿批发": {
                                "code": "5164",
                                "name": "金属及金属矿批发",
                                "children": {}
                            },
                            "建材批发": {
                                "code": "5165",
                                "name": "建材批发",
                                "children": {}
                            },
                            "化肥批发": {
                                "code": "5166",
                                "name": "化肥批发",
                                "children": {}
                            },
                            "农药批发": {
                                "code": "5167",
                                "name": "农药批发",
                                "children": {}
                            },
                            "农用薄膜批发": {
                                "code": "5168",
                                "name": "农用薄膜批发",
                                "children": {}
                            },
                            "其他化工产品批发": {
                                "code": "5169",
                                "name": "其他化工产品批发",
                                "children": {}
                            }
                        }
                    },
                    "机械设备、五金产品及电子产品批发": {
                        "code": "517",
                        "name": "机械设备、五金产品及电子产品批发",
                        "children": {
                            "农业机械批发": {
                                "code": "5171",
                                "name": "农业机械批发",
                                "children": {}
                            },
                            "汽车及零配件批发": {
                                "code": "5172",
                                "name": "汽车及零配件批发",
                                "children": {}
                            },
                            "摩托车及零配件批发": {
                                "code": "5173",
                                "name": "摩托车及零配件批发",
                                "children": {}
                            },
                            "五金产品批发": {
                                "code": "5174",
                                "name": "五金产品批发",
                                "children": {}
                            },
                            "电气设备批发": {
                                "code": "5175",
                                "name": "电气设备批发",
                                "children": {}
                            },
                            "计算机、软件及辅助设备批发": {
                                "code": "5176",
                                "name": "计算机、软件及辅助设备批发",
                                "children": {}
                            },
                            "通讯设备批发": {
                                "code": "5177",
                                "name": "通讯设备批发",
                                "children": {}
                            },
                            "广播影视设备批发": {
                                "code": "5178",
                                "name": "广播影视设备批发",
                                "children": {}
                            },
                            "其他机械设备及电子产品批发": {
                                "code": "5179",
                                "name": "其他机械设备及电子产品批发",
                                "children": {}
                            }
                        }
                    },
                    "贸易经纪与代理": {
                        "code": "518",
                        "name": "贸易经纪与代理",
                        "children": {
                            "贸易代理": {
                                "code": "5181",
                                "name": "贸易代理",
                                "children": {}
                            },
                            "一般物品拍卖": {
                                "code": "5182",
                                "name": "一般物品拍卖",
                                "children": {}
                            },
                            "艺术品、收藏品拍卖": {
                                "code": "5183",
                                "name": "艺术品、收藏品拍卖",
                                "children": {}
                            },
                            "艺术品代理": {
                                "code": "5184",
                                "name": "艺术品代理",
                                "children": {}
                            },
                            "其他贸易经纪与代理": {
                                "code": "5189",
                                "name": "其他贸易经纪与代理",
                                "children": {}
                            }
                        }
                    },
                    "其他批发业": {
                        "code": "519",
                        "name": "其他批发业",
                        "children": {
                            "再生物资回收与批发": {
                                "code": "5191",
                                "name": "再生物资回收与批发",
                                "children": {}
                            },
                            "宠物食品用品批发": {
                                "code": "5192",
                                "name": "宠物食品用品批发",
                                "children": {}
                            },
                            "互联网批发": {
                                "code": "5193",
                                "name": "互联网批发",
                                "children": {}
                            },
                            "其他未列明批发业": {
                                "code": "5199",
                                "name": "其他未列明批发业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "零售业": {
                "code": "52",
                "name": "零售业",
                "children": {
                    "综合零售": {
                        "code": "521",
                        "name": "综合零售",
                        "children": {
                            "百货零售": {
                                "code": "5211",
                                "name": "百货零售",
                                "children": {}
                            },
                            "超级市场零售": {
                                "code": "5212",
                                "name": "超级市场零售",
                                "children": {}
                            },
                            "便利店零售": {
                                "code": "5213",
                                "name": "便利店零售",
                                "children": {}
                            },
                            "其他综合零售": {
                                "code": "5219",
                                "name": "其他综合零售",
                                "children": {}
                            }
                        }
                    },
                    "食品、饮料及烟草制品专门零售": {
                        "code": "522",
                        "name": "食品、饮料及烟草制品专门零售",
                        "children": {
                            "粮油零售": {
                                "code": "5221",
                                "name": "粮油零售",
                                "children": {}
                            },
                            "糕点、面包零售": {
                                "code": "5222",
                                "name": "糕点、面包零售",
                                "children": {}
                            },
                            "果品、蔬菜零售": {
                                "code": "5223",
                                "name": "果品、蔬菜零售",
                                "children": {}
                            },
                            "肉、禽、蛋、奶及水产品零售": {
                                "code": "5224",
                                "name": "肉、禽、蛋、奶及水产品零售",
                                "children": {}
                            },
                            "营养和保健品零售": {
                                "code": "5225",
                                "name": "营养和保健品零售",
                                "children": {}
                            },
                            "酒、饮料及茶叶零售": {
                                "code": "5226",
                                "name": "酒、饮料及茶叶零售",
                                "children": {}
                            },
                            "烟草制品零售": {
                                "code": "5227",
                                "name": "烟草制品零售",
                                "children": {}
                            },
                            "其他食品零售": {
                                "code": "5229",
                                "name": "其他食品零售",
                                "children": {}
                            }
                        }
                    },
                    "纺织、服装及日用品专门零售": {
                        "code": "523",
                        "name": "纺织、服装及日用品专门零售",
                        "children": {
                            "纺织品及针织品零售": {
                                "code": "5231",
                                "name": "纺织品及针织品零售",
                                "children": {}
                            },
                            "服装零售": {
                                "code": "5232",
                                "name": "服装零售",
                                "children": {}
                            },
                            "鞋帽零售": {
                                "code": "5233",
                                "name": "鞋帽零售",
                                "children": {}
                            },
                            "化妆品及卫生用品零售": {
                                "code": "5234",
                                "name": "化妆品及卫生用品零售",
                                "children": {}
                            },
                            "厨具卫具及日用杂品零售": {
                                "code": "5235",
                                "name": "厨具卫具及日用杂品零售",
                                "children": {}
                            },
                            "钟表、眼镜零售": {
                                "code": "5236",
                                "name": "钟表、眼镜零售",
                                "children": {}
                            },
                            "箱包零售": {
                                "code": "5237",
                                "name": "箱包零售",
                                "children": {}
                            },
                            "自行车等代步设备零售": {
                                "code": "5238",
                                "name": "自行车等代步设备零售",
                                "children": {}
                            },
                            "其他日用品零售": {
                                "code": "5239",
                                "name": "其他日用品零售",
                                "children": {}
                            }
                        }
                    },
                    "文化、体育用品及器材专门零售": {
                        "code": "524",
                        "name": "文化、体育用品及器材专门零售",
                        "children": {
                            "文具用品零售": {
                                "code": "5241",
                                "name": "文具用品零售",
                                "children": {}
                            },
                            "体育用品及器材零售": {
                                "code": "5242",
                                "name": "体育用品及器材零售",
                                "children": {}
                            },
                            "图书、报刊零售": {
                                "code": "5243",
                                "name": "图书、报刊零售",
                                "children": {}
                            },
                            "音像制品、电子和数字出版物零售": {
                                "code": "5244",
                                "name": "音像制品、电子和数字出版物零售",
                                "children": {}
                            },
                            "珠宝首饰零售": {
                                "code": "5245",
                                "name": "珠宝首饰零售",
                                "children": {}
                            },
                            "工艺美术品及收藏品零售": {
                                "code": "5246",
                                "name": "工艺美术品及收藏品零售",
                                "children": {}
                            },
                            "乐器零售": {
                                "code": "5247",
                                "name": "乐器零售",
                                "children": {}
                            },
                            "照相器材零售": {
                                "code": "5248",
                                "name": "照相器材零售",
                                "children": {}
                            },
                            "其他文化用品零售": {
                                "code": "5249",
                                "name": "其他文化用品零售",
                                "children": {}
                            }
                        }
                    },
                    "医药及医疗器材专门零售": {
                        "code": "525",
                        "name": "医药及医疗器材专门零售",
                        "children": {
                            "西药零售": {
                                "code": "5251",
                                "name": "西药零售",
                                "children": {}
                            },
                            "中药零售": {
                                "code": "5252",
                                "name": "中药零售",
                                "children": {}
                            },
                            "动物用药品零售": {
                                "code": "5253",
                                "name": "动物用药品零售",
                                "children": {}
                            },
                            "医疗用品及器材零售": {
                                "code": "5254",
                                "name": "医疗用品及器材零售",
                                "children": {}
                            },
                            "保健辅助治疗器材零售": {
                                "code": "5255",
                                "name": "保健辅助治疗器材零售",
                                "children": {}
                            }
                        }
                    },
                    "汽车、摩托车、零配件和燃料及其他动力销售": {
                        "code": "526",
                        "name": "汽车、摩托车、零配件和燃料及其他动力销售",
                        "children": {
                            "汽车新车零售": {
                                "code": "5261",
                                "name": "汽车新车零售",
                                "children": {}
                            },
                            "汽车旧车零售": {
                                "code": "5262",
                                "name": "汽车旧车零售",
                                "children": {}
                            },
                            "汽车零配件零售": {
                                "code": "5263",
                                "name": "汽车零配件零售",
                                "children": {}
                            },
                            "摩托车及零配件零售": {
                                "code": "5264",
                                "name": "摩托车及零配件零售",
                                "children": {}
                            },
                            "机动车燃油零售": {
                                "code": "5265",
                                "name": "机动车燃油零售",
                                "children": {}
                            },
                            "机动车燃气零售": {
                                "code": "5266",
                                "name": "机动车燃气零售",
                                "children": {}
                            },
                            "机动车充电销售": {
                                "code": "5267",
                                "name": "机动车充电销售",
                                "children": {}
                            }
                        }
                    },
                    "家用电器及电子产品专门零售": {
                        "code": "527",
                        "name": "家用电器及电子产品专门零售",
                        "children": {
                            "家用视听设备零售": {
                                "code": "5271",
                                "name": "家用视听设备零售",
                                "children": {}
                            },
                            "日用家电零售": {
                                "code": "5272",
                                "name": "日用家电零售",
                                "children": {}
                            },
                            "计算机、软件及辅助设备零售": {
                                "code": "5273",
                                "name": "计算机、软件及辅助设备零售",
                                "children": {}
                            },
                            "通信设备零售": {
                                "code": "5274",
                                "name": "通信设备零售",
                                "children": {}
                            },
                            "其他电子产品零售": {
                                "code": "5279",
                                "name": "其他电子产品零售",
                                "children": {}
                            }
                        }
                    },
                    "五金、家具及室内装饰材料专门零售": {
                        "code": "528",
                        "name": "五金、家具及室内装饰材料专门零售",
                        "children": {
                            "五金零售": {
                                "code": "5281",
                                "name": "五金零售",
                                "children": {}
                            },
                            "灯具零售": {
                                "code": "5282",
                                "name": "灯具零售",
                                "children": {}
                            },
                            "家具零售": {
                                "code": "5283",
                                "name": "家具零售",
                                "children": {}
                            },
                            "涂料零售": {
                                "code": "5284",
                                "name": "涂料零售",
                                "children": {}
                            },
                            "卫生洁具零售": {
                                "code": "5285",
                                "name": "卫生洁具零售",
                                "children": {}
                            },
                            "木质装饰材料零售": {
                                "code": "5286",
                                "name": "木质装饰材料零售",
                                "children": {}
                            },
                            "陶瓷、石材装饰材料零售": {
                                "code": "5287",
                                "name": "陶瓷、石材装饰材料零售",
                                "children": {}
                            },
                            "其他室内装饰材料零售": {
                                "code": "5289",
                                "name": "其他室内装饰材料零售",
                                "children": {}
                            }
                        }
                    },
                    "货摊、无店铺及其他零售业": {
                        "code": "529",
                        "name": "货摊、无店铺及其他零售业",
                        "children": {
                            "流动货摊零售": {
                                "code": "5291",
                                "name": "流动货摊零售",
                                "children": {}
                            },
                            "互联网零售": {
                                "code": "5292",
                                "name": "互联网零售",
                                "children": {}
                            },
                            "邮购及电视、电话零售": {
                                "code": "5293",
                                "name": "邮购及电视、电话零售",
                                "children": {}
                            },
                            "自动售货机零售": {
                                "code": "5294",
                                "name": "自动售货机零售",
                                "children": {}
                            },
                            "旧货零售": {
                                "code": "5295",
                                "name": "旧货零售",
                                "children": {}
                            },
                            "生活用燃料零售": {
                                "code": "5296",
                                "name": "生活用燃料零售",
                                "children": {}
                            },
                            "宠物食品用品零售": {
                                "code": "5297",
                                "name": "宠物食品用品零售",
                                "children": {}
                            },
                            "其他未列明零售业": {
                                "code": "5299",
                                "name": "其他未列明零售业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "交通运输、仓储和邮政业": {
        "code": "G",
        "name": "交通运输、仓储和邮政业",
        "children": {
            "铁路运输业": {
                "code": "53",
                "name": "铁路运输业",
                "children": {
                    "铁路旅客运输": {
                        "code": "531",
                        "name": "铁路旅客运输",
                        "children": {
                            "高速铁路旅客运输": {
                                "code": "5311",
                                "name": "高速铁路旅客运输",
                                "children": {}
                            },
                            "城际铁路旅客运输": {
                                "code": "5312",
                                "name": "城际铁路旅客运输",
                                "children": {}
                            },
                            "普通铁路旅客运输": {
                                "code": "5313",
                                "name": "普通铁路旅客运输",
                                "children": {}
                            }
                        }
                    },
                    "铁路货物运输": {
                        "code": "532",
                        "name": "铁路货物运输",
                        "children": {
                            "铁路货物运输": {
                                "code": "5320",
                                "name": "铁路货物运输",
                                "children": {}
                            }
                        }
                    },
                    "铁路运输辅助活动": {
                        "code": "533",
                        "name": "铁路运输辅助活动",
                        "children": {
                            "客运火车站": {
                                "code": "5331",
                                "name": "客运火车站",
                                "children": {}
                            },
                            "货运火车站（场）": {
                                "code": "5332",
                                "name": "货运火车站（场）",
                                "children": {}
                            },
                            "铁路运输维护活动": {
                                "code": "5333",
                                "name": "铁路运输维护活动",
                                "children": {}
                            },
                            "其他铁路运输辅助活动": {
                                "code": "5339",
                                "name": "其他铁路运输辅助活动",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "道路运输业": {
                "code": "54",
                "name": "道路运输业",
                "children": {
                    "城市公共交通运输": {
                        "code": "541",
                        "name": "城市公共交通运输",
                        "children": {
                            "公共电汽车客运": {
                                "code": "5411",
                                "name": "公共电汽车客运",
                                "children": {}
                            },
                            "城市轨道交通": {
                                "code": "5412",
                                "name": "城市轨道交通",
                                "children": {}
                            },
                            "出租车客运": {
                                "code": "5413",
                                "name": "出租车客运",
                                "children": {}
                            },
                            "公共自行车服务": {
                                "code": "5414",
                                "name": "公共自行车服务",
                                "children": {}
                            },
                            "其他城市公共交通运输": {
                                "code": "5419",
                                "name": "其他城市公共交通运输",
                                "children": {}
                            }
                        }
                    },
                    "公路旅客运输": {
                        "code": "542",
                        "name": "公路旅客运输",
                        "children": {
                            "长途客运": {
                                "code": "5421",
                                "name": "长途客运",
                                "children": {}
                            },
                            "旅游客运": {
                                "code": "5422",
                                "name": "旅游客运",
                                "children": {}
                            },
                            "其他公路客运": {
                                "code": "5429",
                                "name": "其他公路客运",
                                "children": {}
                            }
                        }
                    },
                    "道路货物运输": {
                        "code": "543",
                        "name": "道路货物运输",
                        "children": {
                            "普通货物道路运输": {
                                "code": "5431",
                                "name": "普通货物道路运输",
                                "children": {}
                            },
                            "冷藏车道路运输": {
                                "code": "5432",
                                "name": "冷藏车道路运输",
                                "children": {}
                            },
                            "集装箱道路运输": {
                                "code": "5433",
                                "name": "集装箱道路运输",
                                "children": {}
                            },
                            "大型货物道路运输": {
                                "code": "5434",
                                "name": "大型货物道路运输",
                                "children": {}
                            },
                            "危险货物道路运输": {
                                "code": "5435",
                                "name": "危险货物道路运输",
                                "children": {}
                            },
                            "邮件包裹道路运输": {
                                "code": "5436",
                                "name": "邮件包裹道路运输",
                                "children": {}
                            },
                            "城市配送": {
                                "code": "5437",
                                "name": "城市配送",
                                "children": {}
                            },
                            "搬家运输": {
                                "code": "5438",
                                "name": "搬家运输",
                                "children": {}
                            },
                            "其他道路货物运输": {
                                "code": "5439",
                                "name": "其他道路货物运输",
                                "children": {}
                            }
                        }
                    },
                    "道路运输辅助活动": {
                        "code": "544",
                        "name": "道路运输辅助活动",
                        "children": {
                            "客运汽车站": {
                                "code": "5441",
                                "name": "客运汽车站",
                                "children": {}
                            },
                            "货运枢纽（站）": {
                                "code": "5442",
                                "name": "货运枢纽（站）",
                                "children": {}
                            },
                            "公路管理与养护": {
                                "code": "5443",
                                "name": "公路管理与养护",
                                "children": {}
                            },
                            "其他道路运输辅助活动": {
                                "code": "5449",
                                "name": "其他道路运输辅助活动",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "水上运输业": {
                "code": "55",
                "name": "水上运输业",
                "children": {
                    "水上旅客运输": {
                        "code": "551",
                        "name": "水上旅客运输",
                        "children": {
                            "海上旅客运输": {
                                "code": "5511",
                                "name": "海上旅客运输",
                                "children": {}
                            },
                            "内河旅客运输": {
                                "code": "5512",
                                "name": "内河旅客运输",
                                "children": {}
                            },
                            "客运轮渡运输": {
                                "code": "5513",
                                "name": "客运轮渡运输",
                                "children": {}
                            }
                        }
                    },
                    "水上货物运输": {
                        "code": "552",
                        "name": "水上货物运输",
                        "children": {
                            "远洋货物运输": {
                                "code": "5521",
                                "name": "远洋货物运输",
                                "children": {}
                            },
                            "沿海货物运输": {
                                "code": "5522",
                                "name": "沿海货物运输",
                                "children": {}
                            },
                            "内河货物运输": {
                                "code": "5523",
                                "name": "内河货物运输",
                                "children": {}
                            }
                        }
                    },
                    "水上运输辅助活动": {
                        "code": "553",
                        "name": "水上运输辅助活动",
                        "children": {
                            "客运港口": {
                                "code": "5531",
                                "name": "客运港口",
                                "children": {}
                            },
                            "货运港口": {
                                "code": "5532",
                                "name": "货运港口",
                                "children": {}
                            },
                            "其他水上运输辅助活动": {
                                "code": "5539",
                                "name": "其他水上运输辅助活动",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "航空运输业": {
                "code": "56",
                "name": "航空运输业",
                "children": {
                    "航空客货运输": {
                        "code": "561",
                        "name": "航空客货运输",
                        "children": {
                            "航空旅客运输": {
                                "code": "5611",
                                "name": "航空旅客运输",
                                "children": {}
                            },
                            "航空货物运输": {
                                "code": "5612",
                                "name": "航空货物运输",
                                "children": {}
                            }
                        }
                    },
                    "通用航空服务": {
                        "code": "562",
                        "name": "通用航空服务",
                        "children": {
                            "通用航空生产服务": {
                                "code": "5621",
                                "name": "通用航空生产服务",
                                "children": {}
                            },
                            "观光游览航空服务": {
                                "code": "5622",
                                "name": "观光游览航空服务",
                                "children": {}
                            },
                            "体育航空运动服务": {
                                "code": "5623",
                                "name": "体育航空运动服务",
                                "children": {}
                            },
                            "其他通用航空服务": {
                                "code": "5629",
                                "name": "其他通用航空服务",
                                "children": {}
                            }
                        }
                    },
                    "航空运输辅助活动": {
                        "code": "563",
                        "name": "航空运输辅助活动",
                        "children": {
                            "机场": {
                                "code": "5631",
                                "name": "机场",
                                "children": {}
                            },
                            "空中交通管理": {
                                "code": "5632",
                                "name": "空中交通管理",
                                "children": {}
                            },
                            "其他航空运输辅助活动": {
                                "code": "5639",
                                "name": "其他航空运输辅助活动",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "管道运输业": {
                "code": "57",
                "name": "管道运输业",
                "children": {
                    "海底管道运输": {
                        "code": "571",
                        "name": "海底管道运输",
                        "children": {
                            "海底管道运输": {
                                "code": "5710",
                                "name": "海底管道运输",
                                "children": {}
                            }
                        }
                    },
                    "陆地管道运输": {
                        "code": "572",
                        "name": "陆地管道运输",
                        "children": {
                            "陆地管道运输": {
                                "code": "5720",
                                "name": "陆地管道运输",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "多式联运和运输代理业": {
                "code": "58",
                "name": "多式联运和运输代理业",
                "children": {
                    "多式联运": {
                        "code": "581",
                        "name": "多式联运",
                        "children": {
                            "多式联运": {
                                "code": "5810",
                                "name": "多式联运",
                                "children": {}
                            }
                        }
                    },
                    "运输代理业": {
                        "code": "582",
                        "name": "运输代理业",
                        "children": {
                            "货物运输代理": {
                                "code": "5821",
                                "name": "货物运输代理",
                                "children": {}
                            },
                            "旅客票务代理": {
                                "code": "5822",
                                "name": "旅客票务代理",
                                "children": {}
                            },
                            "其他运输代理业": {
                                "code": "5829",
                                "name": "其他运输代理业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "装卸搬运和仓储业": {
                "code": "59",
                "name": "装卸搬运和仓储业",
                "children": {
                    "装卸搬运": {
                        "code": "591",
                        "name": "装卸搬运",
                        "children": {
                            "装卸搬运": {
                                "code": "5910",
                                "name": "装卸搬运",
                                "children": {}
                            }
                        }
                    },
                    "通用仓储": {
                        "code": "592",
                        "name": "通用仓储",
                        "children": {
                            "通用仓储": {
                                "code": "5920",
                                "name": "通用仓储",
                                "children": {}
                            }
                        }
                    },
                    "低温仓储": {
                        "code": "593",
                        "name": "低温仓储",
                        "children": {
                            "低温仓储": {
                                "code": "5930",
                                "name": "低温仓储",
                                "children": {}
                            }
                        }
                    },
                    "危险品仓储": {
                        "code": "594",
                        "name": "危险品仓储",
                        "children": {
                            "油气仓储": {
                                "code": "5941",
                                "name": "油气仓储",
                                "children": {}
                            },
                            "危险化学品仓储": {
                                "code": "5942",
                                "name": "危险化学品仓储",
                                "children": {}
                            },
                            "其他危险品仓储": {
                                "code": "5949",
                                "name": "其他危险品仓储",
                                "children": {}
                            }
                        }
                    },
                    "谷物、棉花等农产品仓储": {
                        "code": "595",
                        "name": "谷物、棉花等农产品仓储",
                        "children": {
                            "谷物仓储": {
                                "code": "5951",
                                "name": "谷物仓储",
                                "children": {}
                            },
                            "棉花仓储": {
                                "code": "5952",
                                "name": "棉花仓储",
                                "children": {}
                            },
                            "其他农产品仓储": {
                                "code": "5959",
                                "name": "其他农产品仓储",
                                "children": {}
                            }
                        }
                    },
                    "中药材仓储": {
                        "code": "596",
                        "name": "中药材仓储",
                        "children": {
                            "中药材仓储": {
                                "code": "5960",
                                "name": "中药材仓储",
                                "children": {}
                            }
                        }
                    },
                    "其他仓储业": {
                        "code": "599",
                        "name": "其他仓储业",
                        "children": {
                            "其他仓储业": {
                                "code": "5990",
                                "name": "其他仓储业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "邮政业": {
                "code": "60",
                "name": "邮政业",
                "children": {
                    "邮政基本服务": {
                        "code": "601",
                        "name": "邮政基本服务",
                        "children": {
                            "邮政基本服务": {
                                "code": "6010",
                                "name": "邮政基本服务",
                                "children": {}
                            }
                        }
                    },
                    "快递服务": {
                        "code": "602",
                        "name": "快递服务",
                        "children": {
                            "快递服务": {
                                "code": "6020",
                                "name": "快递服务",
                                "children": {}
                            }
                        }
                    },
                    "其他寄递服务": {
                        "code": "609",
                        "name": "其他寄递服务",
                        "children": {
                            "其他寄递服务": {
                                "code": "6090",
                                "name": "其他寄递服务",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "住宿和餐饮业": {
        "code": "H",
        "name": "住宿和餐饮业",
        "children": {
            "住宿业": {
                "code": "61",
                "name": "住宿业",
                "children": {
                    "旅游饭店": {
                        "code": "611",
                        "name": "旅游饭店",
                        "children": {
                            "旅游饭店": {
                                "code": "6110",
                                "name": "旅游饭店",
                                "children": {}
                            }
                        }
                    },
                    "一般旅馆": {
                        "code": "612",
                        "name": "一般旅馆",
                        "children": {
                            "经济型连锁酒店": {
                                "code": "6121",
                                "name": "经济型连锁酒店",
                                "children": {}
                            },
                            "其他一般旅馆": {
                                "code": "6129",
                                "name": "其他一般旅馆",
                                "children": {}
                            }
                        }
                    },
                    "民宿服务": {
                        "code": "613",
                        "name": "民宿服务",
                        "children": {
                            "民宿服务": {
                                "code": "6130",
                                "name": "民宿服务",
                                "children": {}
                            }
                        }
                    },
                    "露营地服务": {
                        "code": "614",
                        "name": "露营地服务",
                        "children": {
                            "露营地服务": {
                                "code": "6140",
                                "name": "露营地服务",
                                "children": {}
                            }
                        }
                    },
                    "其他住宿业": {
                        "code": "619",
                        "name": "其他住宿业",
                        "children": {
                            "其他住宿业": {
                                "code": "6190",
                                "name": "其他住宿业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "餐饮业": {
                "code": "62",
                "name": "餐饮业",
                "children": {
                    "正餐服务": {
                        "code": "621",
                        "name": "正餐服务",
                        "children": {
                            "正餐服务": {
                                "code": "6210",
                                "name": "正餐服务",
                                "children": {}
                            }
                        }
                    },
                    "快餐服务": {
                        "code": "622",
                        "name": "快餐服务",
                        "children": {
                            "快餐服务": {
                                "code": "6220",
                                "name": "快餐服务",
                                "children": {}
                            }
                        }
                    },
                    "饮料及冷饮服务": {
                        "code": "623",
                        "name": "饮料及冷饮服务",
                        "children": {
                            "茶馆服务": {
                                "code": "6231",
                                "name": "茶馆服务",
                                "children": {}
                            },
                            "咖啡馆服务": {
                                "code": "6232",
                                "name": "咖啡馆服务",
                                "children": {}
                            },
                            "酒吧服务": {
                                "code": "6233",
                                "name": "酒吧服务",
                                "children": {}
                            },
                            "其他饮料及冷饮服务": {
                                "code": "6239",
                                "name": "其他饮料及冷饮服务",
                                "children": {}
                            }
                        }
                    },
                    "餐饮配送及外卖送餐服务": {
                        "code": "624",
                        "name": "餐饮配送及外卖送餐服务",
                        "children": {
                            "餐饮配送服务": {
                                "code": "6241",
                                "name": "餐饮配送服务",
                                "children": {}
                            },
                            "外卖送餐服务": {
                                "code": "6242",
                                "name": "外卖送餐服务",
                                "children": {}
                            }
                        }
                    },
                    "其他餐饮业": {
                        "code": "629",
                        "name": "其他餐饮业",
                        "children": {
                            "小吃服务": {
                                "code": "6291",
                                "name": "小吃服务",
                                "children": {}
                            },
                            "其他未列明餐饮业": {
                                "code": "6299",
                                "name": "其他未列明餐饮业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "信息传输、软件和信息技术服务业": {
        "code": "I",
        "name": "信息传输、软件和信息技术服务业",
        "children": {
            "电信、广播电视和卫星传输服务": {
                "code": "63",
                "name": "电信、广播电视和卫星传输服务",
                "children": {
                    "电信": {
                        "code": "631",
                        "name": "电信",
                        "children": {
                            "固定电信服务": {
                                "code": "6311",
                                "name": "固定电信服务",
                                "children": {}
                            },
                            "移动电信服务": {
                                "code": "6312",
                                "name": "移动电信服务",
                                "children": {}
                            },
                            "其他电信服务": {
                                "code": "6319",
                                "name": "其他电信服务",
                                "children": {}
                            }
                        }
                    },
                    "广播电视传输服务": {
                        "code": "632",
                        "name": "广播电视传输服务",
                        "children": {
                            "有线广播电视传输服务": {
                                "code": "6321",
                                "name": "有线广播电视传输服务",
                                "children": {}
                            },
                            "无线广播电视传输服务": {
                                "code": "6322",
                                "name": "无线广播电视传输服务",
                                "children": {}
                            }
                        }
                    },
                    "卫星传输服务": {
                        "code": "633",
                        "name": "卫星传输服务",
                        "children": {
                            "广播电视卫星传输服务": {
                                "code": "6331",
                                "name": "广播电视卫星传输服务",
                                "children": {}
                            },
                            "其他卫星传输服务": {
                                "code": "6339",
                                "name": "其他卫星传输服务",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "互联网和相关服务": {
                "code": "64",
                "name": "互联网和相关服务",
                "children": {
                    "互联网接入及相关服务": {
                        "code": "641",
                        "name": "互联网接入及相关服务",
                        "children": {
                            "互联网接入及相关服务": {
                                "code": "6410",
                                "name": "互联网接入及相关服务",
                                "children": {}
                            }
                        }
                    },
                    "互联网信息服务": {
                        "code": "642",
                        "name": "互联网信息服务",
                        "children": {
                            "互联网搜索服务": {
                                "code": "6421",
                                "name": "互联网搜索服务",
                                "children": {}
                            },
                            "互联网游戏服务": {
                                "code": "6422",
                                "name": "互联网游戏服务",
                                "children": {}
                            },
                            "互联网其他信息服务": {
                                "code": "6429",
                                "name": "互联网其他信息服务",
                                "children": {}
                            }
                        }
                    },
                    "互联网平台": {
                        "code": "643",
                        "name": "互联网平台",
                        "children": {
                            "互联网生产服务平台": {
                                "code": "6431",
                                "name": "互联网生产服务平台",
                                "children": {}
                            },
                            "互联网生活服务平台": {
                                "code": "6432",
                                "name": "互联网生活服务平台",
                                "children": {}
                            },
                            "互联网科技创新平台": {
                                "code": "6433",
                                "name": "互联网科技创新平台",
                                "children": {}
                            },
                            "互联网公共服务平台": {
                                "code": "6434",
                                "name": "互联网公共服务平台",
                                "children": {}
                            },
                            "其他互联网平台": {
                                "code": "6439",
                                "name": "其他互联网平台",
                                "children": {}
                            }
                        }
                    },
                    "互联网安全服务": {
                        "code": "644",
                        "name": "互联网安全服务",
                        "children": {
                            "互联网安全服务": {
                                "code": "6440",
                                "name": "互联网安全服务",
                                "children": {}
                            }
                        }
                    },
                    "互联网数据服务": {
                        "code": "645",
                        "name": "互联网数据服务",
                        "children": {
                            "互联网数据服务": {
                                "code": "6450",
                                "name": "互联网数据服务",
                                "children": {}
                            }
                        }
                    },
                    "其他互联网服务": {
                        "code": "649",
                        "name": "其他互联网服务",
                        "children": {
                            "其他互联网服务": {
                                "code": "6490",
                                "name": "其他互联网服务",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "软件和信息技术服务业": {
                "code": "65",
                "name": "软件和信息技术服务业",
                "children": {
                    "软件开发": {
                        "code": "651",
                        "name": "软件开发",
                        "children": {
                            "基础软件开发": {
                                "code": "6511",
                                "name": "基础软件开发",
                                "children": {}
                            },
                            "支撑软件开发": {
                                "code": "6512",
                                "name": "支撑软件开发",
                                "children": {}
                            },
                            "应用软件开发": {
                                "code": "6513",
                                "name": "应用软件开发",
                                "children": {}
                            },
                            "其他软件开发": {
                                "code": "6519",
                                "name": "其他软件开发",
                                "children": {}
                            }
                        }
                    },
                    "集成电路设计": {
                        "code": "652",
                        "name": "集成电路设计",
                        "children": {
                            "集成电路设计": {
                                "code": "6520",
                                "name": "集成电路设计",
                                "children": {}
                            }
                        }
                    },
                    "信息系统集成和物联网技术服务": {
                        "code": "653",
                        "name": "信息系统集成和物联网技术服务",
                        "children": {
                            "信息系统集成服务": {
                                "code": "6531",
                                "name": "信息系统集成服务",
                                "children": {}
                            },
                            "物联网技术服务": {
                                "code": "6532",
                                "name": "物联网技术服务",
                                "children": {}
                            }
                        }
                    },
                    "运行维护服务": {
                        "code": "654",
                        "name": "运行维护服务",
                        "children": {
                            "运行维护服务": {
                                "code": "6540",
                                "name": "运行维护服务",
                                "children": {}
                            }
                        }
                    },
                    "信息处理和存储支持服务": {
                        "code": "655",
                        "name": "信息处理和存储支持服务",
                        "children": {
                            "信息处理和存储支持服务": {
                                "code": "6550",
                                "name": "信息处理和存储支持服务",
                                "children": {}
                            }
                        }
                    },
                    "信息技术咨询服务": {
                        "code": "656",
                        "name": "信息技术咨询服务",
                        "children": {
                            "信息技术咨询服务": {
                                "code": "6560",
                                "name": "信息技术咨询服务",
                                "children": {}
                            }
                        }
                    },
                    "数字内容服务": {
                        "code": "657",
                        "name": "数字内容服务",
                        "children": {
                            "地理遥感信息服务": {
                                "code": "6571",
                                "name": "地理遥感信息服务",
                                "children": {}
                            },
                            "动漫、游戏数字内容服务": {
                                "code": "6572",
                                "name": "动漫、游戏数字内容服务",
                                "children": {}
                            },
                            "其他数字内容服务": {
                                "code": "6579",
                                "name": "其他数字内容服务",
                                "children": {}
                            }
                        }
                    },
                    "其他信息技术服务业": {
                        "code": "659",
                        "name": "其他信息技术服务业",
                        "children": {
                            "呼叫中心": {
                                "code": "6591",
                                "name": "呼叫中心",
                                "children": {}
                            },
                            "其他未列明信息技术服务业": {
                                "code": "6599",
                                "name": "其他未列明信息技术服务业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "金融业": {
        "code": "J",
        "name": "金融业",
        "children": {
            "货币金融服务": {
                "code": "66",
                "name": "货币金融服务",
                "children": {
                    "中央银行服务": {
                        "code": "661",
                        "name": "中央银行服务",
                        "children": {
                            "中央银行服务": {
                                "code": "6610",
                                "name": "中央银行服务",
                                "children": {}
                            }
                        }
                    },
                    "货币银行服务": {
                        "code": "662",
                        "name": "货币银行服务",
                        "children": {
                            "商业银行服务": {
                                "code": "6621",
                                "name": "商业银行服务",
                                "children": {}
                            },
                            "政策性银行服务": {
                                "code": "6622",
                                "name": "政策性银行服务",
                                "children": {}
                            },
                            "信用合作社服务": {
                                "code": "6623",
                                "name": "信用合作社服务",
                                "children": {}
                            },
                            "农村资金互助社服务": {
                                "code": "6624",
                                "name": "农村资金互助社服务",
                                "children": {}
                            },
                            "其他货币银行服务": {
                                "code": "6629",
                                "name": "其他货币银行服务",
                                "children": {}
                            }
                        }
                    },
                    "非货币银行服务": {
                        "code": "663",
                        "name": "非货币银行服务",
                        "children": {
                            "融资租赁服务": {
                                "code": "6631",
                                "name": "融资租赁服务",
                                "children": {}
                            },
                            "财务公司服务": {
                                "code": "6632",
                                "name": "财务公司服务",
                                "children": {}
                            },
                            "典当": {
                                "code": "6633",
                                "name": "典当",
                                "children": {}
                            },
                            "汽车金融公司服务": {
                                "code": "6634",
                                "name": "汽车金融公司服务",
                                "children": {}
                            },
                            "小额贷款公司服务": {
                                "code": "6635",
                                "name": "小额贷款公司服务",
                                "children": {}
                            },
                            "消费金融公司服务": {
                                "code": "6636",
                                "name": "消费金融公司服务",
                                "children": {}
                            },
                            "网络借贷服务": {
                                "code": "6637",
                                "name": "网络借贷服务",
                                "children": {}
                            },
                            "其他非货币银行服务": {
                                "code": "6639",
                                "name": "其他非货币银行服务",
                                "children": {}
                            }
                        }
                    },
                    "银行理财服务": {
                        "code": "664",
                        "name": "银行理财服务",
                        "children": {
                            "银行理财服务": {
                                "code": "6640",
                                "name": "银行理财服务",
                                "children": {}
                            }
                        }
                    },
                    "银行监管服务": {
                        "code": "665",
                        "name": "银行监管服务",
                        "children": {
                            "银行监管服务": {
                                "code": "6650",
                                "name": "银行监管服务",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "资本市场服务": {
                "code": "67",
                "name": "资本市场服务",
                "children": {
                    "证券市场服务": {
                        "code": "671",
                        "name": "证券市场服务",
                        "children": {
                            "证券市场管理服务": {
                                "code": "6711",
                                "name": "证券市场管理服务",
                                "children": {}
                            },
                            "证券经纪交易服务": {
                                "code": "6712",
                                "name": "证券经纪交易服务",
                                "children": {}
                            }
                        }
                    },
                    "公开募集证券投资基金": {
                        "code": "672",
                        "name": "公开募集证券投资基金",
                        "children": {
                            "公开募集证券投资基金": {
                                "code": "6720",
                                "name": "公开募集证券投资基金",
                                "children": {}
                            }
                        }
                    },
                    "非公开募集证券投资基金": {
                        "code": "673",
                        "name": "非公开募集证券投资基金",
                        "children": {
                            "创业投资基金": {
                                "code": "6731",
                                "name": "创业投资基金",
                                "children": {}
                            },
                            "天使投资": {
                                "code": "6732",
                                "name": "天使投资",
                                "children": {}
                            },
                            "其他非公开募集证券投资基金": {
                                "code": "6739",
                                "name": "其他非公开募集证券投资基金",
                                "children": {}
                            }
                        }
                    },
                    "期货市场服务": {
                        "code": "674",
                        "name": "期货市场服务",
                        "children": {
                            "期货市场管理服务": {
                                "code": "6741",
                                "name": "期货市场管理服务",
                                "children": {}
                            },
                            "其他期货市场服务": {
                                "code": "6749",
                                "name": "其他期货市场服务",
                                "children": {}
                            }
                        }
                    },
                    "证券期货监管服务": {
                        "code": "675",
                        "name": "证券期货监管服务",
                        "children": {
                            "证券期货监管服务": {
                                "code": "6750",
                                "name": "证券期货监管服务",
                                "children": {}
                            }
                        }
                    },
                    "资本投资服务": {
                        "code": "676",
                        "name": "资本投资服务",
                        "children": {
                            "资本投资服务": {
                                "code": "6760",
                                "name": "资本投资服务",
                                "children": {}
                            }
                        }
                    },
                    "其他资本市场服务": {
                        "code": "679",
                        "name": "其他资本市场服务",
                        "children": {
                            "其他资本市场服务": {
                                "code": "6790",
                                "name": "其他资本市场服务",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "保险业": {
                "code": "68",
                "name": "保险业",
                "children": {
                    "人身保险": {
                        "code": "681",
                        "name": "人身保险",
                        "children": {
                            "人寿保险": {
                                "code": "6811",
                                "name": "人寿保险",
                                "children": {}
                            },
                            "年金保险": {
                                "code": "6812",
                                "name": "年金保险",
                                "children": {}
                            },
                            "健康保险": {
                                "code": "6813",
                                "name": "健康保险",
                                "children": {}
                            },
                            "意外伤害保险": {
                                "code": "6814",
                                "name": "意外伤害保险",
                                "children": {}
                            }
                        }
                    },
                    "财产保险": {
                        "code": "682",
                        "name": "财产保险",
                        "children": {
                            "财产保险": {
                                "code": "6820",
                                "name": "财产保险",
                                "children": {}
                            }
                        }
                    },
                    "再保险": {
                        "code": "683",
                        "name": "再保险",
                        "children": {
                            "再保险": {
                                "code": "6830",
                                "name": "再保险",
                                "children": {}
                            }
                        }
                    },
                    "商业养老金": {
                        "code": "684",
                        "name": "商业养老金",
                        "children": {
                            "商业养老金": {
                                "code": "6840",
                                "name": "商业养老金",
                                "children": {}
                            }
                        }
                    },
                    "保险中介服务": {
                        "code": "685",
                        "name": "保险中介服务",
                        "children": {
                            "保险经纪服务": {
                                "code": "6851",
                                "name": "保险经纪服务",
                                "children": {}
                            },
                            "保险代理服务": {
                                "code": "6852",
                                "name": "保险代理服务",
                                "children": {}
                            },
                            "保险公估服务": {
                                "code": "6853",
                                "name": "保险公估服务",
                                "children": {}
                            }
                        }
                    },
                    "保险资产管理": {
                        "code": "686",
                        "name": "保险资产管理",
                        "children": {
                            "保险资产管理": {
                                "code": "6860",
                                "name": "保险资产管理",
                                "children": {}
                            }
                        }
                    },
                    "保险监管服务": {
                        "code": "687",
                        "name": "保险监管服务",
                        "children": {
                            "保险监管服务": {
                                "code": "6870",
                                "name": "保险监管服务",
                                "children": {}
                            }
                        }
                    },
                    "其他保险活动": {
                        "code": "689",
                        "name": "其他保险活动",
                        "children": {
                            "其他保险活动": {
                                "code": "6890",
                                "name": "其他保险活动",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "其他金融业": {
                "code": "69",
                "name": "其他金融业",
                "children": {
                    "金融信托与管理服务": {
                        "code": "691",
                        "name": "金融信托与管理服务",
                        "children": {
                            "信托公司": {
                                "code": "6911",
                                "name": "信托公司",
                                "children": {}
                            },
                            "其他金融信托与管理服务": {
                                "code": "6919",
                                "name": "其他金融信托与管理服务",
                                "children": {}
                            }
                        }
                    },
                    "控股公司服务": {
                        "code": "692",
                        "name": "控股公司服务",
                        "children": {
                            "控股公司服务": {
                                "code": "6920",
                                "name": "控股公司服务",
                                "children": {}
                            }
                        }
                    },
                    "非金融机构支付服务": {
                        "code": "693",
                        "name": "非金融机构支付服务",
                        "children": {
                            "非金融机构支付服务": {
                                "code": "6930",
                                "name": "非金融机构支付服务",
                                "children": {}
                            }
                        }
                    },
                    "金融信息服务": {
                        "code": "694",
                        "name": "金融信息服务",
                        "children": {
                            "金融信息服务": {
                                "code": "6940",
                                "name": "金融信息服务",
                                "children": {}
                            }
                        }
                    },
                    "金融资产管理公司": {
                        "code": "695",
                        "name": "金融资产管理公司",
                        "children": {
                            "金融资产管理公司": {
                                "code": "6950",
                                "name": "金融资产管理公司",
                                "children": {}
                            }
                        }
                    },
                    "其他未列明金融业": {
                        "code": "699",
                        "name": "其他未列明金融业",
                        "children": {
                            "货币经纪公司服务": {
                                "code": "6991",
                                "name": "货币经纪公司服务",
                                "children": {}
                            },
                            "其他未包括金融业": {
                                "code": "6999",
                                "name": "其他未包括金融业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "房地产业": {
        "code": "K",
        "name": "房地产业",
        "children": {
            "房地产业": {
                "code": "70",
                "name": "房地产业",
                "children": {
                    "房地产开发经营": {
                        "code": "701",
                        "name": "房地产开发经营",
                        "children": {
                            "房地产开发经营": {
                                "code": "7010",
                                "name": "房地产开发经营",
                                "children": {}
                            }
                        }
                    },
                    "物业管理": {
                        "code": "702",
                        "name": "物业管理",
                        "children": {
                            "物业管理": {
                                "code": "7020",
                                "name": "物业管理",
                                "children": {}
                            }
                        }
                    },
                    "房地产中介服务": {
                        "code": "703",
                        "name": "房地产中介服务",
                        "children": {
                            "房地产中介服务": {
                                "code": "7030",
                                "name": "房地产中介服务",
                                "children": {}
                            }
                        }
                    },
                    "房地产租赁经营": {
                        "code": "704",
                        "name": "房地产租赁经营",
                        "children": {
                            "房地产租赁经营": {
                                "code": "7040",
                                "name": "房地产租赁经营",
                                "children": {}
                            }
                        }
                    },
                    "其他房地产业": {
                        "code": "709",
                        "name": "其他房地产业",
                        "children": {
                            "其他房地产业": {
                                "code": "7090",
                                "name": "其他房地产业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "租赁和商务服务业": {
        "code": "L",
        "name": "租赁和商务服务业",
        "children": {
            "租赁业": {
                "code": "71",
                "name": "租赁业",
                "children": {
                    "机械设备经营租赁": {
                        "code": "711",
                        "name": "机械设备经营租赁",
                        "children": {
                            "汽车租赁": {
                                "code": "7111",
                                "name": "汽车租赁",
                                "children": {}
                            },
                            "农业机械经营租赁": {
                                "code": "7112",
                                "name": "农业机械经营租赁",
                                "children": {}
                            },
                            "建筑工程机械与设备经营租赁": {
                                "code": "7113",
                                "name": "建筑工程机械与设备经营租赁",
                                "children": {}
                            },
                            "计算机及通讯设备经营租赁": {
                                "code": "7114",
                                "name": "计算机及通讯设备经营租赁",
                                "children": {}
                            },
                            "医疗设备经营租赁": {
                                "code": "7115",
                                "name": "医疗设备经营租赁",
                                "children": {}
                            },
                            "其他机械与设备经营租赁": {
                                "code": "7119",
                                "name": "其他机械与设备经营租赁",
                                "children": {}
                            }
                        }
                    },
                    "文体设备和用品出租": {
                        "code": "712",
                        "name": "文体设备和用品出租",
                        "children": {
                            "休闲娱乐用品设备出租": {
                                "code": "7121",
                                "name": "休闲娱乐用品设备出租",
                                "children": {}
                            },
                            "体育用品设备出租": {
                                "code": "7122",
                                "name": "体育用品设备出租",
                                "children": {}
                            },
                            "文化用品设备出租": {
                                "code": "7123",
                                "name": "文化用品设备出租",
                                "children": {}
                            },
                            "图书出租": {
                                "code": "7124",
                                "name": "图书出租",
                                "children": {}
                            },
                            "音像制品出租": {
                                "code": "7125",
                                "name": "音像制品出租",
                                "children": {}
                            },
                            "其他文体设备和用品出租": {
                                "code": "7129",
                                "name": "其他文体设备和用品出租",
                                "children": {}
                            }
                        }
                    },
                    "日用品出租": {
                        "code": "713",
                        "name": "日用品出租",
                        "children": {
                            "日用品出租": {
                                "code": "7130",
                                "name": "日用品出租",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "商务服务业": {
                "code": "72",
                "name": "商务服务业",
                "children": {
                    "组织管理服务": {
                        "code": "721",
                        "name": "组织管理服务",
                        "children": {
                            "企业总部管理": {
                                "code": "7211",
                                "name": "企业总部管理",
                                "children": {}
                            },
                            "投资与资产管理": {
                                "code": "7212",
                                "name": "投资与资产管理",
                                "children": {}
                            },
                            "资源与产权交易服务": {
                                "code": "7213",
                                "name": "资源与产权交易服务",
                                "children": {}
                            },
                            "单位后勤管理服务": {
                                "code": "7214",
                                "name": "单位后勤管理服务",
                                "children": {}
                            },
                            "农村集体经济组织管理": {
                                "code": "7215",
                                "name": "农村集体经济组织管理",
                                "children": {}
                            },
                            "其他组织管理服务": {
                                "code": "7219",
                                "name": "其他组织管理服务",
                                "children": {}
                            }
                        }
                    },
                    "综合管理服务": {
                        "code": "722",
                        "name": "综合管理服务",
                        "children": {
                            "园区管理服务": {
                                "code": "7221",
                                "name": "园区管理服务",
                                "children": {}
                            },
                            "商业综合体管理服务": {
                                "code": "7222",
                                "name": "商业综合体管理服务",
                                "children": {}
                            },
                            "市场管理服务": {
                                "code": "7223",
                                "name": "市场管理服务",
                                "children": {}
                            },
                            "供应链管理服务": {
                                "code": "7224",
                                "name": "供应链管理服务",
                                "children": {}
                            },
                            "其他综合管理服务": {
                                "code": "7229",
                                "name": "其他综合管理服务",
                                "children": {}
                            }
                        }
                    },
                    "法律服务": {
                        "code": "723",
                        "name": "法律服务",
                        "children": {
                            "律师及相关法律服务": {
                                "code": "7231",
                                "name": "律师及相关法律服务",
                                "children": {}
                            },
                            "公证服务": {
                                "code": "7232",
                                "name": "公证服务",
                                "children": {}
                            },
                            "其他法律服务": {
                                "code": "7239",
                                "name": "其他法律服务",
                                "children": {}
                            }
                        }
                    },
                    "咨询与调查": {
                        "code": "724",
                        "name": "咨询与调查",
                        "children": {
                            "会计、审计及税务服务": {
                                "code": "7241",
                                "name": "会计、审计及税务服务",
                                "children": {}
                            },
                            "市场调查": {
                                "code": "7242",
                                "name": "市场调查",
                                "children": {}
                            },
                            "社会经济咨询": {
                                "code": "7243",
                                "name": "社会经济咨询",
                                "children": {}
                            },
                            "健康咨询": {
                                "code": "7244",
                                "name": "健康咨询",
                                "children": {}
                            },
                            "环保咨询": {
                                "code": "7245",
                                "name": "环保咨询",
                                "children": {}
                            },
                            "体育咨询": {
                                "code": "7246",
                                "name": "体育咨询",
                                "children": {}
                            },
                            "其他专业咨询与调查": {
                                "code": "7249",
                                "name": "其他专业咨询与调查",
                                "children": {}
                            }
                        }
                    },
                    "广告业": {
                        "code": "725",
                        "name": "广告业",
                        "children": {
                            "互联网广告服务": {
                                "code": "7251",
                                "name": "互联网广告服务",
                                "children": {}
                            },
                            "其他广告服务": {
                                "code": "7259",
                                "name": "其他广告服务",
                                "children": {}
                            }
                        }
                    },
                    "人力资源服务": {
                        "code": "726",
                        "name": "人力资源服务",
                        "children": {
                            "公共就业服务": {
                                "code": "7261",
                                "name": "公共就业服务",
                                "children": {}
                            },
                            "职业中介服务": {
                                "code": "7262",
                                "name": "职业中介服务",
                                "children": {}
                            },
                            "劳务派遣服务": {
                                "code": "7263",
                                "name": "劳务派遣服务",
                                "children": {}
                            },
                            "创业指导服务": {
                                "code": "7264",
                                "name": "创业指导服务",
                                "children": {}
                            },
                            "其他人力资源服务": {
                                "code": "7269",
                                "name": "其他人力资源服务",
                                "children": {}
                            }
                        }
                    },
                    "安全保护服务": {
                        "code": "727",
                        "name": "安全保护服务",
                        "children": {
                            "安全服务": {
                                "code": "7271",
                                "name": "安全服务",
                                "children": {}
                            },
                            "安全系统监控服务": {
                                "code": "7272",
                                "name": "安全系统监控服务",
                                "children": {}
                            },
                            "其他安全保护服务": {
                                "code": "7279",
                                "name": "其他安全保护服务",
                                "children": {}
                            }
                        }
                    },
                    "会议、展览及相关服务": {
                        "code": "728",
                        "name": "会议、展览及相关服务",
                        "children": {
                            "科技会展服务": {
                                "code": "7281",
                                "name": "科技会展服务",
                                "children": {}
                            },
                            "旅游会展服务": {
                                "code": "7282",
                                "name": "旅游会展服务",
                                "children": {}
                            },
                            "体育会展服务": {
                                "code": "7283",
                                "name": "体育会展服务",
                                "children": {}
                            },
                            "文化会展服务": {
                                "code": "7284",
                                "name": "文化会展服务",
                                "children": {}
                            },
                            "其他会议、会展及相关服务": {
                                "code": "7289",
                                "name": "其他会议、会展及相关服务",
                                "children": {}
                            }
                        }
                    },
                    "其他商务服务业": {
                        "code": "729",
                        "name": "其他商务服务业",
                        "children": {
                            "旅行社及相关服务": {
                                "code": "7291",
                                "name": "旅行社及相关服务",
                                "children": {}
                            },
                            "包装服务": {
                                "code": "7292",
                                "name": "包装服务",
                                "children": {}
                            },
                            "办公服务": {
                                "code": "7293",
                                "name": "办公服务",
                                "children": {}
                            },
                            "翻译服务": {
                                "code": "7294",
                                "name": "翻译服务",
                                "children": {}
                            },
                            "信用服务": {
                                "code": "7295",
                                "name": "信用服务",
                                "children": {}
                            },
                            "非融资担保服务": {
                                "code": "7296",
                                "name": "非融资担保服务",
                                "children": {}
                            },
                            "商务代理代办服务": {
                                "code": "7297",
                                "name": "商务代理代办服务",
                                "children": {}
                            },
                            "票务代理服务": {
                                "code": "7298",
                                "name": "票务代理服务",
                                "children": {}
                            },
                            "其他未列明商务服务业": {
                                "code": "7299",
                                "name": "其他未列明商务服务业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "科学研究和技术服务业": {
        "code": "M",
        "name": "科学研究和技术服务业",
        "children": {
            "研究和试验发展": {
                "code": "73",
                "name": "研究和试验发展",
                "children": {
                    "自然科学研究和试验发展": {
                        "code": "731",
                        "name": "自然科学研究和试验发展",
                        "children": {
                            "自然科学研究和试验发展": {
                                "code": "7310",
                                "name": "自然科学研究和试验发展",
                                "children": {}
                            }
                        }
                    },
                    "工程和技术研究和试验发展": {
                        "code": "732",
                        "name": "工程和技术研究和试验发展",
                        "children": {
                            "工程和技术研究和试验发展": {
                                "code": "7320",
                                "name": "工程和技术研究和试验发展",
                                "children": {}
                            }
                        }
                    },
                    "农业科学研究和试验发展": {
                        "code": "733",
                        "name": "农业科学研究和试验发展",
                        "children": {
                            "农业科学研究和试验发展": {
                                "code": "7330",
                                "name": "农业科学研究和试验发展",
                                "children": {}
                            }
                        }
                    },
                    "医学研究和试验发展": {
                        "code": "734",
                        "name": "医学研究和试验发展",
                        "children": {
                            "医学研究和试验发展": {
                                "code": "7340",
                                "name": "医学研究和试验发展",
                                "children": {}
                            }
                        }
                    },
                    "社会人文科学研究": {
                        "code": "735",
                        "name": "社会人文科学研究",
                        "children": {
                            "社会人文科学研究": {
                                "code": "7350",
                                "name": "社会人文科学研究",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "专业技术服务业": {
                "code": "74",
                "name": "专业技术服务业",
                "children": {
                    "气象服务": {
                        "code": "741",
                        "name": "气象服务",
                        "children": {
                            "气象服务": {
                                "code": "7410",
                                "name": "气象服务",
                                "children": {}
                            }
                        }
                    },
                    "地震服务": {
                        "code": "742",
                        "name": "地震服务",
                        "children": {
                            "地震服务": {
                                "code": "7420",
                                "name": "地震服务",
                                "children": {}
                            }
                        }
                    },
                    "海洋服务": {
                        "code": "743",
                        "name": "海洋服务",
                        "children": {
                            "海洋气象服务": {
                                "code": "7431",
                                "name": "海洋气象服务",
                                "children": {}
                            },
                            "海洋环境服务": {
                                "code": "7432",
                                "name": "海洋环境服务",
                                "children": {}
                            },
                            "其他海洋服务": {
                                "code": "7439",
                                "name": "其他海洋服务",
                                "children": {}
                            }
                        }
                    },
                    "测绘地理信息服务": {
                        "code": "744",
                        "name": "测绘地理信息服务",
                        "children": {
                            "遥感测绘服务": {
                                "code": "7441",
                                "name": "遥感测绘服务",
                                "children": {}
                            },
                            "其他测绘地理信息服务": {
                                "code": "7449",
                                "name": "其他测绘地理信息服务",
                                "children": {}
                            }
                        }
                    },
                    "质检技术服务": {
                        "code": "745",
                        "name": "质检技术服务",
                        "children": {
                            "检验检疫服务": {
                                "code": "7451",
                                "name": "检验检疫服务",
                                "children": {}
                            },
                            "检测服务": {
                                "code": "7452",
                                "name": "检测服务",
                                "children": {}
                            },
                            "计量服务": {
                                "code": "7453",
                                "name": "计量服务",
                                "children": {}
                            },
                            "标准化服务": {
                                "code": "7454",
                                "name": "标准化服务",
                                "children": {}
                            },
                            "认证认可服务": {
                                "code": "7455",
                                "name": "认证认可服务",
                                "children": {}
                            },
                            "其他质检技术服务": {
                                "code": "7459",
                                "name": "其他质检技术服务",
                                "children": {}
                            }
                        }
                    },
                    "环境与生态监测检测服务": {
                        "code": "746",
                        "name": "环境与生态监测检测服务",
                        "children": {
                            "环境保护监测": {
                                "code": "7461",
                                "name": "环境保护监测",
                                "children": {}
                            },
                            "生态资源监测": {
                                "code": "7462",
                                "name": "生态资源监测",
                                "children": {}
                            },
                            "野生动物疫源疫病防控监测": {
                                "code": "7463",
                                "name": "野生动物疫源疫病防控监测",
                                "children": {}
                            }
                        }
                    },
                    "地质勘查": {
                        "code": "747",
                        "name": "地质勘查",
                        "children": {
                            "能源矿产地质勘查": {
                                "code": "7471",
                                "name": "能源矿产地质勘查",
                                "children": {}
                            },
                            "固体矿产地质勘查": {
                                "code": "7472",
                                "name": "固体矿产地质勘查",
                                "children": {}
                            },
                            "水、二氧化碳等矿产地质勘查": {
                                "code": "7473",
                                "name": "水、二氧化碳等矿产地质勘查",
                                "children": {}
                            },
                            "基础地质勘查": {
                                "code": "7474",
                                "name": "基础地质勘查",
                                "children": {}
                            },
                            "地质勘查技术服务": {
                                "code": "7475",
                                "name": "地质勘查技术服务",
                                "children": {}
                            }
                        }
                    },
                    "工程技术与设计服务": {
                        "code": "748",
                        "name": "工程技术与设计服务",
                        "children": {
                            "工程管理服务": {
                                "code": "7481",
                                "name": "工程管理服务",
                                "children": {}
                            },
                            "工程监理服务": {
                                "code": "7482",
                                "name": "工程监理服务",
                                "children": {}
                            },
                            "工程勘察活动": {
                                "code": "7483",
                                "name": "工程勘察活动",
                                "children": {}
                            },
                            "工程设计活动": {
                                "code": "7484",
                                "name": "工程设计活动",
                                "children": {}
                            },
                            "规划设计管理": {
                                "code": "7485",
                                "name": "规划设计管理",
                                "children": {}
                            },
                            "土地规划服务": {
                                "code": "7486",
                                "name": "土地规划服务",
                                "children": {}
                            }
                        }
                    },
                    "工业与专业设计及其他专业技术服务": {
                        "code": "749",
                        "name": "工业与专业设计及其他专业技术服务",
                        "children": {
                            "工业设计服务": {
                                "code": "7491",
                                "name": "工业设计服务",
                                "children": {}
                            },
                            "专业设计服务": {
                                "code": "7492",
                                "name": "专业设计服务",
                                "children": {}
                            },
                            "兽医服务": {
                                "code": "7493",
                                "name": "兽医服务",
                                "children": {}
                            },
                            "其他未列明专业技术服务业": {
                                "code": "7499",
                                "name": "其他未列明专业技术服务业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "科技推广和应用服务业": {
                "code": "75",
                "name": "科技推广和应用服务业",
                "children": {
                    "技术推广服务": {
                        "code": "751",
                        "name": "技术推广服务",
                        "children": {
                            "农林牧渔技术推广服务": {
                                "code": "7511",
                                "name": "农林牧渔技术推广服务",
                                "children": {}
                            },
                            "生物技术推广服务": {
                                "code": "7512",
                                "name": "生物技术推广服务",
                                "children": {}
                            },
                            "新材料技术推广服务": {
                                "code": "7513",
                                "name": "新材料技术推广服务",
                                "children": {}
                            },
                            "节能技术推广服务": {
                                "code": "7514",
                                "name": "节能技术推广服务",
                                "children": {}
                            },
                            "新能源技术推广服务": {
                                "code": "7515",
                                "name": "新能源技术推广服务",
                                "children": {}
                            },
                            "环保技术推广服务": {
                                "code": "7516",
                                "name": "环保技术推广服务",
                                "children": {}
                            },
                            "三维（3D)打印技术推广服务": {
                                "code": "7517",
                                "name": "三维（3D)打印技术推广服务",
                                "children": {}
                            },
                            "其他技术推广服务": {
                                "code": "7519",
                                "name": "其他技术推广服务",
                                "children": {}
                            }
                        }
                    },
                    "知识产权服务": {
                        "code": "752",
                        "name": "知识产权服务",
                        "children": {
                            "知识产权服务": {
                                "code": "7520",
                                "name": "知识产权服务",
                                "children": {}
                            }
                        }
                    },
                    "科技中介服务": {
                        "code": "753",
                        "name": "科技中介服务",
                        "children": {
                            "科技中介服务": {
                                "code": "7530",
                                "name": "科技中介服务",
                                "children": {}
                            }
                        }
                    },
                    "创业空间服务": {
                        "code": "754",
                        "name": "创业空间服务",
                        "children": {
                            "创业空间服务": {
                                "code": "7540",
                                "name": "创业空间服务",
                                "children": {}
                            }
                        }
                    },
                    "其他科技推广服务业": {
                        "code": "759",
                        "name": "其他科技推广服务业",
                        "children": {
                            "其他科技推广服务业": {
                                "code": "7590",
                                "name": "其他科技推广服务业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "水利、环境和公共设施管理业": {
        "code": "N",
        "name": "水利、环境和公共设施管理业",
        "children": {
            "水利管理业": {
                "code": "76",
                "name": "水利管理业",
                "children": {
                    "防洪除涝设施管理": {
                        "code": "761",
                        "name": "防洪除涝设施管理",
                        "children": {
                            "防洪除涝设施管理": {
                                "code": "7610",
                                "name": "防洪除涝设施管理",
                                "children": {}
                            }
                        }
                    },
                    "水资源管理": {
                        "code": "762",
                        "name": "水资源管理",
                        "children": {
                            "水资源管理": {
                                "code": "7620",
                                "name": "水资源管理",
                                "children": {}
                            }
                        }
                    },
                    "天然水收集与分配": {
                        "code": "763",
                        "name": "天然水收集与分配",
                        "children": {
                            "天然水收集与分配": {
                                "code": "7630",
                                "name": "天然水收集与分配",
                                "children": {}
                            }
                        }
                    },
                    "水文服务": {
                        "code": "764",
                        "name": "水文服务",
                        "children": {
                            "水文服务": {
                                "code": "7640",
                                "name": "水文服务",
                                "children": {}
                            }
                        }
                    },
                    "其他水利管理业": {
                        "code": "769",
                        "name": "其他水利管理业",
                        "children": {
                            "其他水利管理业": {
                                "code": "7690",
                                "name": "其他水利管理业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "生态保护和环境治理业": {
                "code": "77",
                "name": "生态保护和环境治理业",
                "children": {
                    "生态保护": {
                        "code": "771",
                        "name": "生态保护",
                        "children": {
                            "自然生态系统保护管理": {
                                "code": "7711",
                                "name": "自然生态系统保护管理",
                                "children": {}
                            },
                            "自然遗迹保护管理": {
                                "code": "7712",
                                "name": "自然遗迹保护管理",
                                "children": {}
                            },
                            "野生动物保护": {
                                "code": "7713",
                                "name": "野生动物保护",
                                "children": {}
                            },
                            "野生植物保护": {
                                "code": "7714",
                                "name": "野生植物保护",
                                "children": {}
                            },
                            "动物园、水族馆管理服务": {
                                "code": "7715",
                                "name": "动物园、水族馆管理服务",
                                "children": {}
                            },
                            "植物园管理服务": {
                                "code": "7716",
                                "name": "植物园管理服务",
                                "children": {}
                            },
                            "其他自然保护": {
                                "code": "7719",
                                "name": "其他自然保护",
                                "children": {}
                            }
                        }
                    },
                    "环境治理业": {
                        "code": "772",
                        "name": "环境治理业",
                        "children": {
                            "水污染治理": {
                                "code": "7721",
                                "name": "水污染治理",
                                "children": {}
                            },
                            "大气污染治理": {
                                "code": "7722",
                                "name": "大气污染治理",
                                "children": {}
                            },
                            "固体废物治理": {
                                "code": "7723",
                                "name": "固体废物治理",
                                "children": {}
                            },
                            "危险废物治理": {
                                "code": "7724",
                                "name": "危险废物治理",
                                "children": {}
                            },
                            "放射性废物治理": {
                                "code": "7725",
                                "name": "放射性废物治理",
                                "children": {}
                            },
                            "土壤污染治理与修复服务": {
                                "code": "7726",
                                "name": "土壤污染治理与修复服务",
                                "children": {}
                            },
                            "噪声与振动控制服务": {
                                "code": "7727",
                                "name": "噪声与振动控制服务",
                                "children": {}
                            },
                            "其他污染治理": {
                                "code": "7729",
                                "name": "其他污染治理",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "公共设施管理业": {
                "code": "78",
                "name": "公共设施管理业",
                "children": {
                    "市政设施管理": {
                        "code": "781",
                        "name": "市政设施管理",
                        "children": {
                            "市政设施管理": {
                                "code": "7810",
                                "name": "市政设施管理",
                                "children": {}
                            }
                        }
                    },
                    "环境卫生管理": {
                        "code": "782",
                        "name": "环境卫生管理",
                        "children": {
                            "环境卫生管理": {
                                "code": "7820",
                                "name": "环境卫生管理",
                                "children": {}
                            }
                        }
                    },
                    "城乡市容管理": {
                        "code": "783",
                        "name": "城乡市容管理",
                        "children": {
                            "城乡市容管理": {
                                "code": "7830",
                                "name": "城乡市容管理",
                                "children": {}
                            }
                        }
                    },
                    "绿化管理": {
                        "code": "784",
                        "name": "绿化管理",
                        "children": {
                            "绿化管理": {
                                "code": "7840",
                                "name": "绿化管理",
                                "children": {}
                            }
                        }
                    },
                    "城市公园管理": {
                        "code": "785",
                        "name": "城市公园管理",
                        "children": {
                            "城市公园管理": {
                                "code": "7850",
                                "name": "城市公园管理",
                                "children": {}
                            }
                        }
                    },
                    "游览景区管理": {
                        "code": "786",
                        "name": "游览景区管理",
                        "children": {
                            "名胜风景区管理": {
                                "code": "7861",
                                "name": "名胜风景区管理",
                                "children": {}
                            },
                            "森林公园管理": {
                                "code": "7862",
                                "name": "森林公园管理",
                                "children": {}
                            },
                            "其他游览景区管理": {
                                "code": "7869",
                                "name": "其他游览景区管理",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "土地管理业": {
                "code": "79",
                "name": "土地管理业",
                "children": {
                    "土地整治服务": {
                        "code": "791",
                        "name": "土地整治服务",
                        "children": {
                            "土地整治服务": {
                                "code": "7910",
                                "name": "土地整治服务",
                                "children": {}
                            }
                        }
                    },
                    "土地调查评估服务": {
                        "code": "792",
                        "name": "土地调查评估服务",
                        "children": {
                            "土地调查评估服务": {
                                "code": "7920",
                                "name": "土地调查评估服务",
                                "children": {}
                            }
                        }
                    },
                    "土地登记服务": {
                        "code": "793",
                        "name": "土地登记服务",
                        "children": {
                            "土地登记服务": {
                                "code": "7930",
                                "name": "土地登记服务",
                                "children": {}
                            }
                        }
                    },
                    "土地登记代理服务": {
                        "code": "794",
                        "name": "土地登记代理服务",
                        "children": {
                            "土地登记代理服务": {
                                "code": "7940",
                                "name": "土地登记代理服务",
                                "children": {}
                            }
                        }
                    },
                    "其他土地管理服务": {
                        "code": "799",
                        "name": "其他土地管理服务",
                        "children": {
                            "其他土地管理服务": {
                                "code": "7990",
                                "name": "其他土地管理服务",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "居民服务、修理和其他服务业": {
        "code": "O",
        "name": "居民服务、修理和其他服务业",
        "children": {
            "居民服务业": {
                "code": "80",
                "name": "居民服务业",
                "children": {
                    "家庭服务": {
                        "code": "801",
                        "name": "家庭服务",
                        "children": {
                            "家庭服务": {
                                "code": "8010",
                                "name": "家庭服务",
                                "children": {}
                            }
                        }
                    },
                    "托儿所服务": {
                        "code": "802",
                        "name": "托儿所服务",
                        "children": {
                            "托儿所服务": {
                                "code": "8020",
                                "name": "托儿所服务",
                                "children": {}
                            }
                        }
                    },
                    "洗染服务": {
                        "code": "803",
                        "name": "洗染服务",
                        "children": {
                            "洗染服务": {
                                "code": "8030",
                                "name": "洗染服务",
                                "children": {}
                            }
                        }
                    },
                    "理发及美容服务": {
                        "code": "804",
                        "name": "理发及美容服务",
                        "children": {
                            "理发及美容服务": {
                                "code": "8040",
                                "name": "理发及美容服务",
                                "children": {}
                            }
                        }
                    },
                    "洗浴和保健养生服务": {
                        "code": "805",
                        "name": "洗浴和保健养生服务",
                        "children": {
                            "洗浴服务": {
                                "code": "8051",
                                "name": "洗浴服务",
                                "children": {}
                            },
                            "足浴服务": {
                                "code": "8052",
                                "name": "足浴服务",
                                "children": {}
                            },
                            "养生保健服务": {
                                "code": "8053",
                                "name": "养生保健服务",
                                "children": {}
                            }
                        }
                    },
                    "摄影扩印服务": {
                        "code": "806",
                        "name": "摄影扩印服务",
                        "children": {
                            "摄影扩印服务": {
                                "code": "8060",
                                "name": "摄影扩印服务",
                                "children": {}
                            }
                        }
                    },
                    "婚姻服务": {
                        "code": "807",
                        "name": "婚姻服务",
                        "children": {
                            "婚姻服务": {
                                "code": "8070",
                                "name": "婚姻服务",
                                "children": {}
                            }
                        }
                    },
                    "殡葬服务": {
                        "code": "808",
                        "name": "殡葬服务",
                        "children": {
                            "殡葬服务": {
                                "code": "8080",
                                "name": "殡葬服务",
                                "children": {}
                            }
                        }
                    },
                    "其他居民服务业": {
                        "code": "809",
                        "name": "其他居民服务业",
                        "children": {
                            "其他居民服务业": {
                                "code": "8090",
                                "name": "其他居民服务业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "机动车、电子产品和日用产品修理业": {
                "code": "81",
                "name": "机动车、电子产品和日用产品修理业",
                "children": {
                    "汽车、摩托车等修理与维护": {
                        "code": "811",
                        "name": "汽车、摩托车等修理与维护",
                        "children": {
                            "汽车修理与维护": {
                                "code": "8111",
                                "name": "汽车修理与维护",
                                "children": {}
                            },
                            "大型车辆装备修理与维护": {
                                "code": "8112",
                                "name": "大型车辆装备修理与维护",
                                "children": {}
                            },
                            "摩托车修理与维护": {
                                "code": "8113",
                                "name": "摩托车修理与维护",
                                "children": {}
                            },
                            "助动车等修理与维护": {
                                "code": "8114",
                                "name": "助动车等修理与维护",
                                "children": {}
                            }
                        }
                    },
                    "计算机和办公设备维修": {
                        "code": "812",
                        "name": "计算机和办公设备维修",
                        "children": {
                            "计算机和辅助设备修理": {
                                "code": "8121",
                                "name": "计算机和辅助设备修理",
                                "children": {}
                            },
                            "通讯设备修理": {
                                "code": "8122",
                                "name": "通讯设备修理",
                                "children": {}
                            },
                            "其他办公设备维修": {
                                "code": "8129",
                                "name": "其他办公设备维修",
                                "children": {}
                            }
                        }
                    },
                    "家用电器修理": {
                        "code": "813",
                        "name": "家用电器修理",
                        "children": {
                            "家用电子产品修理": {
                                "code": "8131",
                                "name": "家用电子产品修理",
                                "children": {}
                            },
                            "日用电器修理": {
                                "code": "8132",
                                "name": "日用电器修理",
                                "children": {}
                            }
                        }
                    },
                    "其他日用产品修理业": {
                        "code": "819",
                        "name": "其他日用产品修理业",
                        "children": {
                            "自行车修理": {
                                "code": "8191",
                                "name": "自行车修理",
                                "children": {}
                            },
                            "鞋和皮革修理": {
                                "code": "8192",
                                "name": "鞋和皮革修理",
                                "children": {}
                            },
                            "家具和相关物品修理": {
                                "code": "8193",
                                "name": "家具和相关物品修理",
                                "children": {}
                            },
                            "其他未列明日用产品修理业": {
                                "code": "8199",
                                "name": "其他未列明日用产品修理业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "其他服务业": {
                "code": "82",
                "name": "其他服务业",
                "children": {
                    "清洁服务": {
                        "code": "821",
                        "name": "清洁服务",
                        "children": {
                            "建筑物清洁服务": {
                                "code": "8211",
                                "name": "建筑物清洁服务",
                                "children": {}
                            },
                            "其他清洁服务": {
                                "code": "8219",
                                "name": "其他清洁服务",
                                "children": {}
                            }
                        }
                    },
                    "宠物服务": {
                        "code": "822",
                        "name": "宠物服务",
                        "children": {
                            "宠物饲养": {
                                "code": "8221",
                                "name": "宠物饲养",
                                "children": {}
                            },
                            "宠物医院服务": {
                                "code": "8222",
                                "name": "宠物医院服务",
                                "children": {}
                            },
                            "宠物美容服务": {
                                "code": "8223",
                                "name": "宠物美容服务",
                                "children": {}
                            },
                            "宠物寄托收养服务": {
                                "code": "8224",
                                "name": "宠物寄托收养服务",
                                "children": {}
                            },
                            "其他宠物服务": {
                                "code": "8229",
                                "name": "其他宠物服务",
                                "children": {}
                            }
                        }
                    },
                    "其他未列明服务业": {
                        "code": "829",
                        "name": "其他未列明服务业",
                        "children": {
                            "其他未列明服务业": {
                                "code": "8290",
                                "name": "其他未列明服务业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "教育": {
        "code": "P",
        "name": "教育",
        "children": {
            "教育": {
                "code": "83",
                "name": "教育",
                "children": {
                    "学前教育": {
                        "code": "831",
                        "name": "学前教育",
                        "children": {
                            "学前教育": {
                                "code": "8310",
                                "name": "学前教育",
                                "children": {}
                            }
                        }
                    },
                    "初等教育": {
                        "code": "832",
                        "name": "初等教育",
                        "children": {
                            "普通小学教育": {
                                "code": "8321",
                                "name": "普通小学教育",
                                "children": {}
                            },
                            "成人小学教育": {
                                "code": "8322",
                                "name": "成人小学教育",
                                "children": {}
                            }
                        }
                    },
                    "中等教育": {
                        "code": "833",
                        "name": "中等教育",
                        "children": {
                            "普通初中教育": {
                                "code": "8331",
                                "name": "普通初中教育",
                                "children": {}
                            },
                            "职业初中教育": {
                                "code": "8332",
                                "name": "职业初中教育",
                                "children": {}
                            },
                            "成人初中教育": {
                                "code": "8333",
                                "name": "成人初中教育",
                                "children": {}
                            },
                            "普通高中教育": {
                                "code": "8334",
                                "name": "普通高中教育",
                                "children": {}
                            },
                            "成人高中教育": {
                                "code": "8335",
                                "name": "成人高中教育",
                                "children": {}
                            },
                            "中等职业学校教育": {
                                "code": "8336",
                                "name": "中等职业学校教育",
                                "children": {}
                            }
                        }
                    },
                    "高等教育": {
                        "code": "834",
                        "name": "高等教育",
                        "children": {
                            "普通高等教育": {
                                "code": "8341",
                                "name": "普通高等教育",
                                "children": {}
                            },
                            "成人高等教育": {
                                "code": "8342",
                                "name": "成人高等教育",
                                "children": {}
                            }
                        }
                    },
                    "特殊教育": {
                        "code": "835",
                        "name": "特殊教育",
                        "children": {
                            "特殊教育": {
                                "code": "8350",
                                "name": "特殊教育",
                                "children": {}
                            }
                        }
                    },
                    "技能培训、教育辅助及其他教育": {
                        "code": "839",
                        "name": "技能培训、教育辅助及其他教育",
                        "children": {
                            "职业技能培训": {
                                "code": "8391",
                                "name": "职业技能培训",
                                "children": {}
                            },
                            "体校及体育培训": {
                                "code": "8392",
                                "name": "体校及体育培训",
                                "children": {}
                            },
                            "文化艺术培训": {
                                "code": "8393",
                                "name": "文化艺术培训",
                                "children": {}
                            },
                            "教育辅助服务": {
                                "code": "8394",
                                "name": "教育辅助服务",
                                "children": {}
                            },
                            "其他未列明教育": {
                                "code": "8399",
                                "name": "其他未列明教育",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "卫生和社会工作": {
        "code": "Q",
        "name": "卫生和社会工作",
        "children": {
            "卫生": {
                "code": "84",
                "name": "卫生",
                "children": {
                    "医院": {
                        "code": "841",
                        "name": "医院",
                        "children": {
                            "综合医院": {
                                "code": "8411",
                                "name": "综合医院",
                                "children": {}
                            },
                            "中医医院": {
                                "code": "8412",
                                "name": "中医医院",
                                "children": {}
                            },
                            "中西医结合医院": {
                                "code": "8413",
                                "name": "中西医结合医院",
                                "children": {}
                            },
                            "民族医院": {
                                "code": "8414",
                                "name": "民族医院",
                                "children": {}
                            },
                            "专科医院": {
                                "code": "8415",
                                "name": "专科医院",
                                "children": {}
                            },
                            "疗养院": {
                                "code": "8416",
                                "name": "疗养院",
                                "children": {}
                            }
                        }
                    },
                    "基层医疗卫生服务": {
                        "code": "842",
                        "name": "基层医疗卫生服务",
                        "children": {
                            "社区卫生服务中心（站）": {
                                "code": "8421",
                                "name": "社区卫生服务中心（站）",
                                "children": {}
                            },
                            "街道卫生院": {
                                "code": "8422",
                                "name": "街道卫生院",
                                "children": {}
                            },
                            "乡镇卫生院": {
                                "code": "8423",
                                "name": "乡镇卫生院",
                                "children": {}
                            },
                            "村卫生室": {
                                "code": "8424",
                                "name": "村卫生室",
                                "children": {}
                            },
                            "门诊部（所）": {
                                "code": "8425",
                                "name": "门诊部（所）",
                                "children": {}
                            }
                        }
                    },
                    "专业公共卫生服务": {
                        "code": "843",
                        "name": "专业公共卫生服务",
                        "children": {
                            "疾病预防控制中心": {
                                "code": "8431",
                                "name": "疾病预防控制中心",
                                "children": {}
                            },
                            "专科疾病防治院（所、站）": {
                                "code": "8432",
                                "name": "专科疾病防治院（所、站）",
                                "children": {}
                            },
                            "妇幼保健院（所、站）": {
                                "code": "8433",
                                "name": "妇幼保健院（所、站）",
                                "children": {}
                            },
                            "急救中心（站）服务": {
                                "code": "8434",
                                "name": "急救中心（站）服务",
                                "children": {}
                            },
                            "采供血机构服务": {
                                "code": "8435",
                                "name": "采供血机构服务",
                                "children": {}
                            },
                            "计划生育技术服务活动": {
                                "code": "8436",
                                "name": "计划生育技术服务活动",
                                "children": {}
                            }
                        }
                    },
                    "其他卫生活动": {
                        "code": "849",
                        "name": "其他卫生活动",
                        "children": {
                            "健康体检服务": {
                                "code": "8491",
                                "name": "健康体检服务",
                                "children": {}
                            },
                            "临床检验服务": {
                                "code": "8492",
                                "name": "临床检验服务",
                                "children": {}
                            },
                            "其他未列明卫生服务": {
                                "code": "8499",
                                "name": "其他未列明卫生服务",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "社会工作": {
                "code": "85",
                "name": "社会工作",
                "children": {
                    "提供住宿社会工作": {
                        "code": "851",
                        "name": "提供住宿社会工作",
                        "children": {
                            "干部休养所": {
                                "code": "8511",
                                "name": "干部休养所",
                                "children": {}
                            },
                            "护理机构服务": {
                                "code": "8512",
                                "name": "护理机构服务",
                                "children": {}
                            },
                            "精神康复服务": {
                                "code": "8513",
                                "name": "精神康复服务",
                                "children": {}
                            },
                            "老年人、残疾人养护服务": {
                                "code": "8514",
                                "name": "老年人、残疾人养护服务",
                                "children": {}
                            },
                            "临终关怀服务": {
                                "code": "8515",
                                "name": "临终关怀服务",
                                "children": {}
                            },
                            "孤残儿童收养和庇护服务": {
                                "code": "8516",
                                "name": "孤残儿童收养和庇护服务",
                                "children": {}
                            },
                            "其他提供住宿社会救助": {
                                "code": "8519",
                                "name": "其他提供住宿社会救助",
                                "children": {}
                            }
                        }
                    },
                    "不提供住宿社会工作": {
                        "code": "852",
                        "name": "不提供住宿社会工作",
                        "children": {
                            "社会看护与帮助服务": {
                                "code": "8521",
                                "name": "社会看护与帮助服务",
                                "children": {}
                            },
                            "康复辅具适配服务": {
                                "code": "8522",
                                "name": "康复辅具适配服务",
                                "children": {}
                            },
                            "其他不提供住宿社会工作": {
                                "code": "8529",
                                "name": "其他不提供住宿社会工作",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "文化、体育和娱乐业": {
        "code": "R",
        "name": "文化、体育和娱乐业",
        "children": {
            "新闻和出版业": {
                "code": "86",
                "name": "新闻和出版业",
                "children": {
                    "新闻业": {
                        "code": "861",
                        "name": "新闻业",
                        "children": {
                            "新闻业": {
                                "code": "8610",
                                "name": "新闻业",
                                "children": {}
                            }
                        }
                    },
                    "出版业": {
                        "code": "862",
                        "name": "出版业",
                        "children": {
                            "图书出版": {
                                "code": "8621",
                                "name": "图书出版",
                                "children": {}
                            },
                            "报纸出版": {
                                "code": "8622",
                                "name": "报纸出版",
                                "children": {}
                            },
                            "期刊出版": {
                                "code": "8623",
                                "name": "期刊出版",
                                "children": {}
                            },
                            "音像制品出版": {
                                "code": "8624",
                                "name": "音像制品出版",
                                "children": {}
                            },
                            "电子出版物出版": {
                                "code": "8625",
                                "name": "电子出版物出版",
                                "children": {}
                            },
                            "数字出版": {
                                "code": "8626",
                                "name": "数字出版",
                                "children": {}
                            },
                            "其他出版业": {
                                "code": "8629",
                                "name": "其他出版业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "广播、电视、电影和录音制作业": {
                "code": "87",
                "name": "广播、电视、电影和录音制作业",
                "children": {
                    "广播": {
                        "code": "871",
                        "name": "广播",
                        "children": {
                            "广播": {
                                "code": "8710",
                                "name": "广播",
                                "children": {}
                            }
                        }
                    },
                    "电视": {
                        "code": "872",
                        "name": "电视",
                        "children": {
                            "电视": {
                                "code": "8720",
                                "name": "电视",
                                "children": {}
                            }
                        }
                    },
                    "影视节目制作": {
                        "code": "873",
                        "name": "影视节目制作",
                        "children": {
                            "影视节目制作": {
                                "code": "8730",
                                "name": "影视节目制作",
                                "children": {}
                            }
                        }
                    },
                    "广播电视集成播控": {
                        "code": "874",
                        "name": "广播电视集成播控",
                        "children": {
                            "广播电视集成播控": {
                                "code": "8740",
                                "name": "广播电视集成播控",
                                "children": {}
                            }
                        }
                    },
                    "电影和广播电视节目发行": {
                        "code": "875",
                        "name": "电影和广播电视节目发行",
                        "children": {
                            "电影和广播电视节目发行": {
                                "code": "8750",
                                "name": "电影和广播电视节目发行",
                                "children": {}
                            }
                        }
                    },
                    "电影放映": {
                        "code": "876",
                        "name": "电影放映",
                        "children": {
                            "电影放映": {
                                "code": "8760",
                                "name": "电影放映",
                                "children": {}
                            }
                        }
                    },
                    "录音制作": {
                        "code": "877",
                        "name": "录音制作",
                        "children": {
                            "录音制作": {
                                "code": "8770",
                                "name": "录音制作",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "文化艺术业": {
                "code": "88",
                "name": "文化艺术业",
                "children": {
                    "文艺创作与表演": {
                        "code": "881",
                        "name": "文艺创作与表演",
                        "children": {
                            "文艺创作与表演": {
                                "code": "8810",
                                "name": "文艺创作与表演",
                                "children": {}
                            }
                        }
                    },
                    "艺术表演场馆": {
                        "code": "882",
                        "name": "艺术表演场馆",
                        "children": {
                            "艺术表演场馆": {
                                "code": "8820",
                                "name": "艺术表演场馆",
                                "children": {}
                            }
                        }
                    },
                    "图书馆与档案馆": {
                        "code": "883",
                        "name": "图书馆与档案馆",
                        "children": {
                            "图书馆": {
                                "code": "8831",
                                "name": "图书馆",
                                "children": {}
                            },
                            "档案馆": {
                                "code": "8832",
                                "name": "档案馆",
                                "children": {}
                            }
                        }
                    },
                    "文物及非物质文化遗产保护": {
                        "code": "884",
                        "name": "文物及非物质文化遗产保护",
                        "children": {
                            "文物及非物质文化遗产保护": {
                                "code": "8840",
                                "name": "文物及非物质文化遗产保护",
                                "children": {}
                            }
                        }
                    },
                    "博物馆": {
                        "code": "885",
                        "name": "博物馆",
                        "children": {
                            "博物馆": {
                                "code": "8850",
                                "name": "博物馆",
                                "children": {}
                            }
                        }
                    },
                    "烈士陵园、纪念馆": {
                        "code": "886",
                        "name": "烈士陵园、纪念馆",
                        "children": {
                            "烈士陵园、纪念馆": {
                                "code": "8860",
                                "name": "烈士陵园、纪念馆",
                                "children": {}
                            }
                        }
                    },
                    "群众文体活动": {
                        "code": "887",
                        "name": "群众文体活动",
                        "children": {
                            "群众文体活动": {
                                "code": "8870",
                                "name": "群众文体活动",
                                "children": {}
                            }
                        }
                    },
                    "其他文化艺术业": {
                        "code": "889",
                        "name": "其他文化艺术业",
                        "children": {
                            "其他文化艺术业": {
                                "code": "8890",
                                "name": "其他文化艺术业",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "体育": {
                "code": "89",
                "name": "体育",
                "children": {
                    "体育组织": {
                        "code": "891",
                        "name": "体育组织",
                        "children": {
                            "体育竞赛组织": {
                                "code": "8911",
                                "name": "体育竞赛组织",
                                "children": {}
                            },
                            "体育保障组织": {
                                "code": "8912",
                                "name": "体育保障组织",
                                "children": {}
                            },
                            "其他体育组织": {
                                "code": "8919",
                                "name": "其他体育组织",
                                "children": {}
                            }
                        }
                    },
                    "体育场地设施管理": {
                        "code": "892",
                        "name": "体育场地设施管理",
                        "children": {
                            "体育场馆管理": {
                                "code": "8921",
                                "name": "体育场馆管理",
                                "children": {}
                            },
                            "其他体育场地设施管理": {
                                "code": "8929",
                                "name": "其他体育场地设施管理",
                                "children": {}
                            }
                        }
                    },
                    "健身休闲活动": {
                        "code": "893",
                        "name": "健身休闲活动",
                        "children": {
                            "健身休闲活动": {
                                "code": "8930",
                                "name": "健身休闲活动",
                                "children": {}
                            }
                        }
                    },
                    "其他体育": {
                        "code": "899",
                        "name": "其他体育",
                        "children": {
                            "体育中介代理服务": {
                                "code": "8991",
                                "name": "体育中介代理服务",
                                "children": {}
                            },
                            "体育健康服务": {
                                "code": "8992",
                                "name": "体育健康服务",
                                "children": {}
                            },
                            "其他未列明体育": {
                                "code": "8999",
                                "name": "其他未列明体育",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "娱乐业": {
                "code": "90",
                "name": "娱乐业",
                "children": {
                    "室内娱乐活动": {
                        "code": "901",
                        "name": "室内娱乐活动",
                        "children": {
                            "歌舞厅娱乐活动": {
                                "code": "9011",
                                "name": "歌舞厅娱乐活动",
                                "children": {}
                            },
                            "电子游艺厅娱乐活动": {
                                "code": "9012",
                                "name": "电子游艺厅娱乐活动",
                                "children": {}
                            },
                            "网吧活动": {
                                "code": "9013",
                                "name": "网吧活动",
                                "children": {}
                            },
                            "其他室内娱乐活动": {
                                "code": "9019",
                                "name": "其他室内娱乐活动",
                                "children": {}
                            }
                        }
                    },
                    "游乐园": {
                        "code": "902",
                        "name": "游乐园",
                        "children": {
                            "游乐园": {
                                "code": "9020",
                                "name": "游乐园",
                                "children": {}
                            }
                        }
                    },
                    "休闲观光活动": {
                        "code": "903",
                        "name": "休闲观光活动",
                        "children": {
                            "休闲观光活动": {
                                "code": "9030",
                                "name": "休闲观光活动",
                                "children": {}
                            }
                        }
                    },
                    "彩票活动": {
                        "code": "904",
                        "name": "彩票活动",
                        "children": {
                            "体育彩票服务": {
                                "code": "9041",
                                "name": "体育彩票服务",
                                "children": {}
                            },
                            "福利彩票服务": {
                                "code": "9042",
                                "name": "福利彩票服务",
                                "children": {}
                            },
                            "其他彩票服务": {
                                "code": "9049",
                                "name": "其他彩票服务",
                                "children": {}
                            }
                        }
                    },
                    "文化体育娱乐活动与经纪代理服务": {
                        "code": "905",
                        "name": "文化体育娱乐活动与经纪代理服务",
                        "children": {
                            "文化活动服务": {
                                "code": "9051",
                                "name": "文化活动服务",
                                "children": {}
                            },
                            "体育表演服务": {
                                "code": "9052",
                                "name": "体育表演服务",
                                "children": {}
                            },
                            "文化娱乐经纪人": {
                                "code": "9053",
                                "name": "文化娱乐经纪人",
                                "children": {}
                            },
                            "体育经纪人": {
                                "code": "9054",
                                "name": "体育经纪人",
                                "children": {}
                            },
                            "其他文化艺术经纪代理": {
                                "code": "9059",
                                "name": "其他文化艺术经纪代理",
                                "children": {}
                            }
                        }
                    },
                    "其他娱乐业": {
                        "code": "909",
                        "name": "其他娱乐业",
                        "children": {
                            "其他娱乐业": {
                                "code": "9090",
                                "name": "其他娱乐业",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "公共管理、社会保障和社会组织": {
        "code": "S",
        "name": "公共管理、社会保障和社会组织",
        "children": {
            "中国共产党机关": {
                "code": "91",
                "name": "中国共产党机关",
                "children": {
                    "中国共产党机关": {
                        "code": "910",
                        "name": "中国共产党机关",
                        "children": {
                            "中国共产党机关": {
                                "code": "9100",
                                "name": "中国共产党机关",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "国家机构": {
                "code": "92",
                "name": "国家机构",
                "children": {
                    "国家权力机构": {
                        "code": "921",
                        "name": "国家权力机构",
                        "children": {
                            "国家权力机构": {
                                "code": "9210",
                                "name": "国家权力机构",
                                "children": {}
                            }
                        }
                    },
                    "国家行政机构": {
                        "code": "922",
                        "name": "国家行政机构",
                        "children": {
                            "综合事务管理机构": {
                                "code": "9221",
                                "name": "综合事务管理机构",
                                "children": {}
                            },
                            "对外事务管理机构": {
                                "code": "9222",
                                "name": "对外事务管理机构",
                                "children": {}
                            },
                            "公共安全管理机构": {
                                "code": "9223",
                                "name": "公共安全管理机构",
                                "children": {}
                            },
                            "社会事务管理机构": {
                                "code": "9224",
                                "name": "社会事务管理机构",
                                "children": {}
                            },
                            "经济事务管理机构": {
                                "code": "9225",
                                "name": "经济事务管理机构",
                                "children": {}
                            },
                            "行政监督检查机构": {
                                "code": "9226",
                                "name": "行政监督检查机构",
                                "children": {}
                            }
                        }
                    },
                    "人民法院和人民检察院": {
                        "code": "923",
                        "name": "人民法院和人民检察院",
                        "children": {
                            "人民法院": {
                                "code": "9231",
                                "name": "人民法院",
                                "children": {}
                            },
                            "人民检察院": {
                                "code": "9232",
                                "name": "人民检察院",
                                "children": {}
                            }
                        }
                    },
                    "其他国家机构": {
                        "code": "929",
                        "name": "其他国家机构",
                        "children": {
                            "消防管理机构": {
                                "code": "9291",
                                "name": "消防管理机构",
                                "children": {}
                            },
                            "其他未列明国家机构": {
                                "code": "9299",
                                "name": "其他未列明国家机构",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "人民政协、民主党派": {
                "code": "93",
                "name": "人民政协、民主党派",
                "children": {
                    "人民政协": {
                        "code": "931",
                        "name": "人民政协",
                        "children": {
                            "人民政协": {
                                "code": "9310",
                                "name": "人民政协",
                                "children": {}
                            }
                        }
                    },
                    "民主党派": {
                        "code": "932",
                        "name": "民主党派",
                        "children": {
                            "民主党派": {
                                "code": "9320",
                                "name": "民主党派",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "社会保障": {
                "code": "94",
                "name": "社会保障",
                "children": {
                    "基本保险": {
                        "code": "941",
                        "name": "基本保险",
                        "children": {
                            "基本养老保险": {
                                "code": "9411",
                                "name": "基本养老保险",
                                "children": {}
                            },
                            "基本医疗保险": {
                                "code": "9412",
                                "name": "基本医疗保险",
                                "children": {}
                            },
                            "失业保险": {
                                "code": "9413",
                                "name": "失业保险",
                                "children": {}
                            },
                            "工伤保险": {
                                "code": "9414",
                                "name": "工伤保险",
                                "children": {}
                            },
                            "生育保险": {
                                "code": "9415",
                                "name": "生育保险",
                                "children": {}
                            },
                            "其他基本保险": {
                                "code": "9419",
                                "name": "其他基本保险",
                                "children": {}
                            }
                        }
                    },
                    "补充保险": {
                        "code": "942",
                        "name": "补充保险",
                        "children": {
                            "补充保险": {
                                "code": "9420",
                                "name": "补充保险",
                                "children": {}
                            }
                        }
                    },
                    "其他社会保障": {
                        "code": "949",
                        "name": "其他社会保障",
                        "children": {
                            "其他社会保障": {
                                "code": "9490",
                                "name": "其他社会保障",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "群众团体、社会团体和其他成员组织": {
                "code": "95",
                "name": "群众团体、社会团体和其他成员组织",
                "children": {
                    "群众团体": {
                        "code": "951",
                        "name": "群众团体",
                        "children": {
                            "工会": {
                                "code": "9511",
                                "name": "工会",
                                "children": {}
                            },
                            "妇联": {
                                "code": "9512",
                                "name": "妇联",
                                "children": {}
                            },
                            "共青团": {
                                "code": "9513",
                                "name": "共青团",
                                "children": {}
                            },
                            "其他群众团体": {
                                "code": "9519",
                                "name": "其他群众团体",
                                "children": {}
                            }
                        }
                    },
                    "社会团体": {
                        "code": "952",
                        "name": "社会团体",
                        "children": {
                            "专业性团体": {
                                "code": "9521",
                                "name": "专业性团体",
                                "children": {}
                            },
                            "行业性团体": {
                                "code": "9522",
                                "name": "行业性团体",
                                "children": {}
                            },
                            "其他社会团体": {
                                "code": "9529",
                                "name": "其他社会团体",
                                "children": {}
                            }
                        }
                    },
                    "基金会": {
                        "code": "953",
                        "name": "基金会",
                        "children": {
                            "基金会": {
                                "code": "9530",
                                "name": "基金会",
                                "children": {}
                            }
                        }
                    },
                    "宗教组织": {
                        "code": "954",
                        "name": "宗教组织",
                        "children": {
                            "宗教团体服务": {
                                "code": "9541",
                                "name": "宗教团体服务",
                                "children": {}
                            },
                            "宗教活动场所服务": {
                                "code": "9542",
                                "name": "宗教活动场所服务",
                                "children": {}
                            }
                        }
                    }
                }
            },
            "基层群众自治组织及其他组织": {
                "code": "96",
                "name": "基层群众自治组织及其他组织",
                "children": {
                    "社区居民自治组织": {
                        "code": "961",
                        "name": "社区居民自治组织",
                        "children": {
                            "社区居民自治组织": {
                                "code": "9610",
                                "name": "社区居民自治组织",
                                "children": {}
                            }
                        }
                    },
                    "村民自治组织": {
                        "code": "962",
                        "name": "村民自治组织",
                        "children": {
                            "村民自治组织": {
                                "code": "9620",
                                "name": "村民自治组织",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    },
    "国际组织": {
        "code": "T",
        "name": "国际组织",
        "children": {
            "国际组织": {
                "code": "97",
                "name": "国际组织",
                "children": {
                    "国际组织": {
                        "code": "970",
                        "name": "国际组织",
                        "children": {
                            "国际组织": {
                                "code": "9700",
                                "name": "国际组织",
                                "children": {}
                            }
                        }
                    }
                }
            }
        }
    }
}
