CREATE OR REPLACE VIEW covid_symptom__define_symptom AS
SELECT
    t.cui,
    t.tui,
    t.code,
    t.code_system,
    t.text,
    t.pref
FROM (
    VALUES
    (
        'C0027424',
        'T184',
        '68235000',
        'SNOMEDCT_US',
        'nasal congestion',
        'Congestion or runny nose'
    ),
    (
        'C0027424',
        'T184',
        '68235000',
        'SNOMEDCT_US',
        'stuffed-up nose',
        'Congestion or runny nose'
    ),
    (
        'C0027424',
        'T184',
        '68235000',
        'SNOMEDCT_US',
        'stuffy nose',
        'Congestion or runny nose'
    ),
    (
        'C0027424',
        'T184',
        '68235000',
        'SNOMEDCT_US',
        'congested nose',
        'Congestion or runny nose'
    ),
    (
        'C1260880',
        'T184',
        '64531003',
        'SNOMEDCT_US',
        'rhinorrhea',
        'Congestion or runny nose'
    ),
    (
        'C1260880',
        'T184',
        '64531003',
        'SNOMEDCT_US',
        'Nasal discharge',
        'Congestion or runny nose'
    ),
    (
        'C1260880',
        'T184',
        '64531003',
        'SNOMEDCT_US',
        'discharge from nose',
        'Congestion or runny nose'
    ),
    (
        'C1260880',
        'T184',
        '267101005',
        'SNOMEDCT_US',
        'nose dripping',
        'Congestion or runny nose'
    ),
    (
        'C1260880',
        'T184',
        '267101005',
        'SNOMEDCT_US',
        'nose running',
        'Congestion or runny nose'
    ),
    (
        'C1260880',
        'T184',
        '267101005',
        'SNOMEDCT_US',
        'running nose',
        'Congestion or runny nose'
    ),
    ('C1260880', 'T184', 'HP:0031417', 'HPO', 'runny nose', 'Congestion or runny nose'),
    ('C0027424', 'T184', 'R09.81', 'ICD10CM', 'R09.81', 'Congestion or runny nose'),
    ('C0010200', 'T184', '49727002', 'SNOMEDCT_US', 'cough', 'Cough'),
    ('C0010200', 'T184', '49727002', 'SNOMEDCT_US', 'coughing', 'Cough'),
    ('C0010200', 'T184', '49727002', 'SNOMEDCT_US', 'tussive', 'Cough'),
    ('C0010200', 'T184', '49727002', 'SNOMEDCT_US', 'posttussive', 'Cough'),
    ('C0010200', 'T184', '49727002', 'SNOMEDCT_US', 'post-tussive', 'Cough'),
    ('C0010200', 'T184', 'R05', 'ICD10CM', 'R05', 'Cough'),
    ('C0010200', 'T184', 'R05.9', 'ICD10CM', 'R05.9', 'Cough'),
    ('C0850149', 'T184', '11833005', 'SNOMEDCT_US', 'dry cough', 'Cough'),
    ('C0850149', 'T184', '11833005', 'SNOMEDCT_US', 'dry coughs', 'Cough'),
    ('C0850149', 'T184', '11833005', 'SNOMEDCT_US', 'coughs dry', 'Cough'),
    ('C0850149', 'T184', '11833005', 'SNOMEDCT_US', 'unproductive cough', 'Cough'),
    ('C0850149', 'T184', '11833005', 'SNOMEDCT_US', 'non-productive cough', 'Cough'),
    ('C0239134', 'T033', '28743005', 'SNOMEDCT_US', 'productive cough', 'Cough'),
    ('C0239134', 'T033', '28743005', 'SNOMEDCT_US', 'loose cough', 'Cough'),
    ('C0239134', 'T033', '28743005', 'SNOMEDCT_US', 'moist cough', 'Cough'),
    ('C0239134', 'T033', '28743005', 'SNOMEDCT_US', 'Producing sputum', 'Cough'),
    ('C0239134', 'T033', '28743005', 'SNOMEDCT_US', 'Bronchial cough', 'Cough'),
    ('C0239134', 'T033', '28743005', 'SNOMEDCT_US', 'Chest cough', 'Cough'),
    ('C0239134', 'T033', '28743005', 'SNOMEDCT_US', 'Chesty cough', 'Cough'),
    ('C0011991', 'T184', '62315008', 'SNOMEDCT_US', 'diarrhea', 'Diarrhea'),
    ('C0011991', 'T184', 'R19.7', 'ICD10CM', 'R19.7', 'Diarrhea'),
    ('C0011991', 'T184', 'HP:0002014', 'HPO', 'Watery stool', 'Diarrhea'),
    ('C0011991', 'T184', 'HP:0002014', 'HPO', 'Watery stools', 'Diarrhea'),
    ('C0015672', 'T184', '84229001', 'SNOMEDCT_US', 'fatigue', 'Fatigue'),
    ('C0015672', 'T184', '0000004914', 'CHV', 'fatigues', 'Fatigue'),
    ('C0015672', 'T184', '0000004914', 'CHV', 'fatigued', 'Fatigue'),
    ('C0015672', 'T184', '0000004914', 'CHV', 'tiredness', 'Fatigue'),
    ('C0015672', 'T184', '0000004914', 'CHV', 'lack of energy', 'Fatigue'),
    ('C0015672', 'T184', '0000004914', 'CHV', 'energy loss', 'Fatigue'),
    ('C0015672', 'T184', '0000004914', 'CHV', 'weariness', 'Fatigue'),
    ('C0015672', 'T184', 'R53.83', 'ICD10CM', 'R53.83', 'Fatigue'),
    ('C0231218', 'T184', '367391008', 'SNOMEDCT_US', 'Malaise', 'Fatigue'),
    ('C0231218', 'T184', '213257006', 'SNOMEDCT_US', 'Generally unwell', 'Fatigue'),
    ('C0231218', 'T184', 'R53.81', 'ICD10CM', 'R53.81', 'Fatigue'),
    ('C0085593', 'T184', '43724002', 'SNOMEDCT_US', 'Chill', 'Fever or chills'),
    ('C0085593', 'T184', '43724002', 'SNOMEDCT_US', 'Chills', 'Fever or chills'),
    ('C0085593', 'T184', 'R68.83', 'ICD10CM', 'R68.83', 'Fever or chills'),
    ('C0015967', 'T184', '386661006', 'SNOMEDCT_US', 'Fever', 'Fever or chills'),
    ('C0015967', 'T184', '386661006', 'SNOMEDCT_US', 'Fevers', 'Fever or chills'),
    ('C0015967', 'T184', '386661006', 'SNOMEDCT_US', 'Pyrexia', 'Fever or chills'),
    (
        'C0085594',
        'T184',
        '274640006',
        'SNOMEDCT_US',
        'Fever with chills',
        'Fever or chills'
    ),
    (
        'C0085594',
        'T184',
        '274640006',
        'SNOMEDCT_US',
        'Fever and chills',
        'Fever or chills'
    ),
    (
        'C0085594',
        'T184',
        '274640006',
        'SNOMEDCT_US',
        'Pyrexia with chills',
        'Fever or chills'
    ),
    ('C0085594', 'T184', '274640006', 'SNOMEDCT_US', 'Fever Chills', 'Fever or chills'),
    ('C0085594', 'T184', 'R50', 'ICD10CM', 'R50', 'Fever or chills'),
    ('C0085594', 'T184', 'R50.0', 'ICD10CM', 'R50.0', 'Fever or chills'),
    ('C0085594', 'T184', 'R50.9', 'ICD10CM', 'R50.9', 'Fever or chills'),
    ('C0018681', 'T184', '25064002', 'SNOMEDCT_US', 'Headache', 'Headache'),
    ('C0018681', 'T184', '25064002', 'SNOMEDCT_US', 'HA', 'Headache'),
    ('C0018681', 'T184', '25064002', 'SNOMEDCT_US', 'Cephalgia', 'Headache'),
    ('C0018681', 'T184', '25064002', 'SNOMEDCT_US', 'Cephalalgia', 'Headache'),
    ('C0018681', 'T184', '25064002', 'SNOMEDCT_US', 'Cephalodynia', 'Headache'),
    ('C0018681', 'T184', '0000005820', 'CHV', 'Headaches', 'Headache'),
    ('C0018681', 'T184', '0000005820', 'CHV', 'ache head', 'Headache'),
    ('C0018681', 'T184', '0000005820', 'CHV', 'cephalgias', 'Headache'),
    ('C0018681', 'T184', '0000005820', 'CHV', 'head pain', 'Headache'),
    ('C0018681', 'T184', 'R51', 'ICD10CM', 'R51', 'Headache'),
    ('C0018681', 'T184', 'R51.9', 'ICD10CM', 'R51.9', 'Headache'),
    ('C0231528', 'T184', '68962001', 'SNOMEDCT_US', 'myalgia', 'Muscle or body aches'),
    ('C0231528', 'T184', '68962001', 'SNOMEDCT_US', 'myalgias', 'Muscle or body aches'),
    ('C0231528', 'T184', '68962001', 'SNOMEDCT_US', 'myodynia', 'Muscle or body aches'),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'Myoneuralgia',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'Myosalgia',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'muscle pain',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'muscle pains',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'muscle soreness',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'aching muscles',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'muscle ache',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'muscle aches',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'muscles aching',
        'Muscle or body aches'
    ),
    (
        'C0231528',
        'T184',
        '68962001',
        'SNOMEDCT_US',
        'aching muscles',
        'Muscle or body aches'
    ),
    ('C0231528', 'T184', 'M79.1', 'ICD10CM', 'M79.1', 'Muscle or body aches'),
    (
        'C0281856',
        'T184',
        '82991003',
        'SNOMEDCT_US',
        'generalized aches and pains',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '82991003',
        'SNOMEDCT_US',
        'generalized body aches',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '82991003',
        'SNOMEDCT_US',
        'body aches',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '82991003',
        'SNOMEDCT_US',
        'aching body',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '0000027418',
        'CHV',
        'generalized pain',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '0000027418',
        'CHV',
        'generalized ache',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '0000027418',
        'CHV',
        'generalized aches',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '0000027418',
        'CHV',
        'generalized aching',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '0000027418',
        'CHV',
        'generalized body pain',
        'Muscle or body aches'
    ),
    (
        'C0281856',
        'T184',
        '0000027418',
        'CHV',
        'pain generalized',
        'Muscle or body aches'
    ),
    ('C0281856', 'T184', '0000027418', 'CHV', 'body pain', 'Muscle or body aches'),
    ('C0027497', 'T184', '422587007', 'SNOMEDCT_US', 'Nausea', 'Nausea or vomiting'),
    ('C0027497', 'T184', '0000008525', 'CHV', 'nauseated', 'Nausea or vomiting'),
    ('C0027497', 'T184', '0000008525', 'CHV', 'nauseating', 'Nausea or vomiting'),
    ('C0027497', 'T184', '0000008525', 'CHV', 'nauseous', 'Nausea or vomiting'),
    ('C0027497', 'T184', '0000008525', 'CHV', 'queasy', 'Nausea or vomiting'),
    ('C0027497', 'T184', 'R11.0', 'ICD10CM', 'R11.0', 'Nausea or vomiting'),
    ('C0042963', 'T184', '422400008', 'SNOMEDCT_US', 'Vomiting', 'Nausea or vomiting'),
    ('C0042963', 'T184', '0000013085', 'CHV', 'vomit', 'Nausea or vomiting'),
    ('C0042963', 'T184', '0000013085', 'CHV', 'vomited', 'Nausea or vomiting'),
    ('C0042963', 'T184', '0000013085', 'CHV', 'throwing up', 'Nausea or vomiting'),
    ('C0042963', 'T184', '0000013085', 'CHV', 'throw up', 'Nausea or vomiting'),
    ('C0042963', 'T184', '0000013085', 'CHV', 'threw up', 'Nausea or vomiting'),
    ('C0042963', 'T184', '0000013085', 'CHV', 'regurgitated', 'Nausea or vomiting'),
    ('C0042963', 'T184', 'R11', 'ICD10CM', 'R11', 'Nausea or vomiting'),
    ('C0042963', 'T184', 'R11.1', 'ICD10CM', 'R11.1', 'Nausea or vomiting'),
    ('C0042963', 'T184', 'R11.10', 'ICD10CM', 'R11.10', 'Nausea or vomiting'),
    (
        'C0027498',
        'T184',
        '16932000',
        'SNOMEDCT_US',
        'Nausea and vomiting',
        'Nausea or vomiting'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'Anosmia',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'Loss of smell',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'Loss of sense of smell',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'Lost sense of smell',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'Lost the sense of smell',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'Lost smell',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'No sense of smell',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'SNOMEDCT_US',
        'could not smell',
        'Loss of taste or smell'
    ),
    ('C0003126', 'T033', 'R43', 'ICD10CM', 'R43', 'Loss of taste or smell'),
    ('C0003126', 'T033', 'R43.0', 'ICD10CM', 'R43.0', 'Loss of taste or smell'),
    (
        'C0003126',
        'T033',
        'HP:0000458',
        'HPO',
        'Loss of smell',
        'Loss of taste or smell'
    ),
    (
        'C0003126',
        'T033',
        '44169009',
        'HPO',
        'Loss of the sense of smell',
        'Loss of taste or smell'
    ),
    (
        'C1332239',
        'T184',
        'C5038',
        'NCI',
        'Alterations in Smell or Taste',
        'Loss of taste or smell'
    ),
    ('C1332239', 'T184', 'C5038', 'NCI', 'Loss of taste', 'Loss of taste or smell'),
    (
        'C1332239',
        'T184',
        'C5038',
        'NCI',
        'Loss of the sense of taste',
        'Loss of taste or smell'
    ),
    (
        'C1332239',
        'T184',
        'C5038',
        'NCI',
        'Lost the sense of taste',
        'Loss of taste or smell'
    ),
    (
        'C1332239',
        'T184',
        'C5038',
        'NCI',
        'Lost sense of taste',
        'Loss of taste or smell'
    ),
    ('C1332239', 'T184', 'C5038', 'NCI', 'Lost taste', 'Loss of taste or smell'),
    ('C1332239', 'T184', 'C5038', 'NCI', 'Taste lost', 'Loss of taste or smell'),
    ('C0013404', 'T184', '267036007', 'SNOMEDCT_US', 'Dyspnea', 'Dyspnea'),
    ('C0013404', 'T184', '267036007', 'SNOMEDCT_US', 'difficult breathing', 'Dyspnea'),
    ('C0013404', 'T184', '267036007', 'SNOMEDCT_US', 'difficulty breathing', 'Dyspnea'),
    (
        'C0013404',
        'T184',
        '267036007',
        'SNOMEDCT_US',
        'difficulty with breathing',
        'Dyspnea'
    ),
    ('C0013404', 'T184', '267036007', 'SNOMEDCT_US', 'breathing difficulty', 'Dyspnea'),
    ('C0013404', 'T184', '0000032132', 'CHV', 'breathlessness', 'Dyspnea'),
    ('C0013404', 'T184', '0000032132', 'CHV', 'SOB', 'Dyspnea'),
    ('C0013404', 'T184', '0000032132', 'CHV', 'shortness of breath', 'Dyspnea'),
    ('C0013404', 'T184', '0000032132', 'CHV', 'short of breath', 'Dyspnea'),
    ('C0013404', 'T184', 'R06', 'ICD10CM', 'R06', 'Dyspnea'),
    ('C0013404', 'T184', 'R06.0', 'ICD10CM', 'R06.0', 'Dyspnea'),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'Sore throat', 'Sore throat'),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'throat pain', 'Sore throat'),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'painful throat', 'Sore throat'),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'pain in throat', 'Sore throat'),
    (
        'C0242429',
        'T184',
        '162397003',
        'SNOMEDCT_US',
        'pain in the throat',
        'Sore throat'
    ),
    (
        'C0242429',
        'T184',
        '162397003',
        'SNOMEDCT_US',
        'Pain in the pharynx',
        'Sore throat'
    ),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'Pharyngeal pain', 'Sore throat'),
    (
        'C0242429',
        'T184',
        '162397003',
        'SNOMEDCT_US',
        'Throat discomfort',
        'Sore throat'
    ),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'Throat soreness', 'Sore throat'),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'Throat soreness', 'Sore throat'),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'Pharyngitis', 'Sore throat'),
    ('C0242429', 'T184', '162397003', 'SNOMEDCT_US', 'dynophagia', 'Sore throat'),
    ('C0242429', 'T184', 'R07.0', 'ICD10CM', 'R07.0', 'Sore throat')
)
AS t (cui, tui, code, code_system, text, pref);
