
# Copyright (c) [2025] [OpenAI]
# Copyright (c) [2025] [ByteDance Ltd. and/or its affiliates.]
# SPDX-License-Identifier: Apache-2.0
#
# This file has been modified by [ByteDance Ltd. and/or its affiliates.] on 2025.7
#
# Original file was released under Apache License Version 2.0, with the full license text
# available at https://github.com/openai/openai-python/blob/main/LICENSE.
#
# This modified file is released under the same license.

from __future__ import annotations

from typing import List, Union, Iterable, Optional
from typing_extensions import Literal, Required, TypeAlias, TypedDict

from .easy_input_message_param import EasyInputMessageParam
from .response_reasoning_item_param import ResponseReasoningItemParam
from .response_function_tool_call_param import ResponseFunctionToolCallParam
from .mcp_input_item_param import McpApprovalRequest, McpApprovalResponse, McpListTools, McpCall

__all__ = [
    "ResponseInputParam",
    "ResponseInputItemParam",
    "FunctionCallOutput",
]


class FunctionCallOutput(TypedDict, total=False):
    call_id: Required[str]
    """The unique ID of the function tool call generated by the model."""

    output: Required[str]
    """A JSON string of the output of the function tool call."""

    type: Required[Literal["function_call_output"]]
    """The type of the function tool call output. Always `function_call_output`."""


ResponseInputItemParam: TypeAlias = Union[
    EasyInputMessageParam,
    ResponseFunctionToolCallParam,
    FunctionCallOutput,
    McpApprovalRequest,
    McpApprovalResponse,
    McpListTools,
    McpCall
]

ResponseInputParam: TypeAlias = List[ResponseInputItemParam]
