from shared.abstractions.base import AsyncSyncMeta, R2RSerializable, syncable
from shared.abstractions.completion import CompletionRecord, MessageType
from shared.abstractions.document import (
    DataType,
    Document,
    DocumentExtraction,
    DocumentFragment,
    DocumentInfo,
    DocumentType,
    IngestionStatus,
    RestructureStatus,
)
from shared.abstractions.embedding import (
    EmbeddingPurpose,
    default_embedding_prefixes,
)
from shared.abstractions.exception import (
    R2RDocumentProcessingError,
    R2RException,
)
from shared.abstractions.graph import (
    Community,
    CommunityReport,
    Entity,
    EntityType,
    KGExtraction,
    RelationshipType,
    Triple,
)
from shared.abstractions.llm import (
    GenerationConfig,
    LLMChatCompletion,
    LLMChatCompletionChunk,
    Message,
    RAGCompletion,
)
from shared.abstractions.prompt import Prompt
from shared.abstractions.restructure import (
    KGCreationSettings,
    KGEnrichmentSettings,
)
from shared.abstractions.search import (
    AggregateSearchResult,
    HybridSearchSettings,
    KGCommunityResult,
    KGEntityResult,
    KGGlobalResult,
    KGRelationshipResult,
    KGSearchMethod,
    KGSearchResult,
    KGSearchResultType,
    KGSearchSettings,
    VectorSearchResult,
    VectorSearchSettings,
)
from shared.abstractions.user import Token, TokenData, UserStats
from shared.abstractions.vector import (
    StorageResult,
    Vector,
    VectorEntry,
    VectorType,
)

__all__ = [
    # Base abstractions
    "R2RSerializable",
    "AsyncSyncMeta",
    "syncable",
    # Completion abstractions
    "CompletionRecord",
    "MessageType",
    # Document abstractions
    "DataType",
    "Document",
    "DocumentExtraction",
    "DocumentFragment",
    "DocumentInfo",
    "IngestionStatus",
    "RestructureStatus",
    "DocumentType",
    # Embedding abstractions
    "EmbeddingPurpose",
    "default_embedding_prefixes",
    # Exception abstractions
    "R2RDocumentProcessingError",
    "R2RException",
    # Graph abstractions
    "Entity",
    "EntityType",
    "RelationshipType",
    "Community",
    "CommunityReport",
    "KGExtraction",
    "Triple",
    # LLM abstractions
    "GenerationConfig",
    "LLMChatCompletion",
    "LLMChatCompletionChunk",
    "Message",
    "RAGCompletion",
    # Prompt abstractions
    "Prompt",
    # Search abstractions
    "AggregateSearchResult",
    "KGSearchResult",
    "KGSearchMethod",
    "KGSearchResultType",
    "KGEntityResult",
    "KGRelationshipResult",
    "KGCommunityResult",
    "KGGlobalResult",
    "KGSearchSettings",
    "VectorSearchResult",
    "VectorSearchSettings",
    "HybridSearchSettings",
    # Restructure abstractions
    "KGCreationSettings",
    "KGEnrichmentSettings",
    # User abstractions
    "Token",
    "TokenData",
    "UserStats",
    # Vector abstractions
    "Vector",
    "VectorEntry",
    "VectorType",
    "StorageResult",
]
