from __future__ import annotations
import numpy as numpy
from rdkit.Chem import ChemicalFeatures
from rdkit import Geometry
import rdkit.RDLogger
import typing
__all__ = ['ChemicalFeatures', 'ExplicitPharmacophore', 'Geometry', 'Pharmacophore', 'logger', 'numpy']
class ExplicitPharmacophore:
    """
    this is a pharmacophore with explicit point locations and radii
      
    """
    __firstlineno__: typing.ClassVar[int] = 133
    __static_attributes__: typing.ClassVar[tuple] = ('_feats', '_radii')
    def __init__(self, feats = None, radii = None):
        ...
    def __str__(self):
        ...
    def _initializeFeats(self, feats, radii):
        ...
    def getFeature(self, i):
        ...
    def getFeatures(self):
        ...
    def getRadii(self):
        ...
    def getRadius(self, i):
        ...
    def initFromFile(self, inF):
        ...
    def initFromLines(self, lines):
        ...
    def initFromString(self, text):
        ...
    def setRadius(self, i, rad):
        ...
class Pharmacophore:
    __firstlineno__: typing.ClassVar[int] = 19
    __static_attributes__: typing.ClassVar[tuple] = ('_boundsMat', '_boundsMat2D', '_feats')
    def __init__(self, feats, initMats = True):
        ...
    def __str__(self):
        ...
    def _checkBounds(self, i, j):
        """
        raises ValueError on failure 
        """
    def _initializeFeats(self, feats):
        ...
    def _initializeMatrices(self):
        ...
    def getFeature(self, i):
        ...
    def getFeatures(self):
        ...
    def getLowerBound(self, i, j):
        ...
    def getLowerBound2D(self, i, j):
        ...
    def getUpperBound(self, i, j):
        ...
    def getUpperBound2D(self, i, j):
        ...
    def setLowerBound(self, i, j, val, checkBounds = False):
        ...
    def setLowerBound2D(self, i, j, val, checkBounds = False):
        ...
    def setUpperBound(self, i, j, val, checkBounds = False):
        ...
    def setUpperBound2D(self, i, j, val, checkBounds = False):
        ...
logger: rdkit.RDLogger.logger  # value = <rdkit.RDLogger.logger object>
