# Generated by Django 5.2.3 on 2025-06-19 07:13

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('indicators_lib', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='GeoFeature',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.TextField(help_text='attention le nom doit être exactement le même que celui en base.', verbose_name='Nom de la table en base')),
                ('title', models.TextField(default='à compléter', verbose_name='Titre à afficher')),
                ('unite', models.TextField(verbose_name='Unité au pluriel')),
                ('geo_type', models.TextField(choices=[('point', 'Point'), ('line', 'Line'), ('polygon', 'Polygon')], default='point', verbose_name='Type de géométrie')),
                ('point_icon_svg', models.TextField(blank=True, help_text="Icone SVG a utilisé pour les points.<br/>Laisser vide pour les autres types de géométrie.<br/>Veuillez charger un fichier provenant des <a href='/'>Material Icons</a> de Google.", null=True, verbose_name='Icone des points')),
                ('color', models.TextField(default='#000000', help_text="Couleur des données sur la date, à renseigner au format hexadécimal, par exemple: '#05B2F9'", verbose_name='Couleur')),
                ('show_on_fr_level', models.BooleanField(default=True, help_text='Décochez si la quantité de données est trop importante pour le niveau France entière.', verbose_name='Afficher au niveau France entière')),
                ('indicator', models.ForeignKey(help_text="Cette donnée géographique sera ajoutée à la carte de l'indicateur.", on_delete=django.db.models.deletion.CASCADE, related_name='geo_features', to='indicators_lib.indicator')),
            ],
            options={
                'verbose_name': 'Données de la carte',
                'ordering': ('indicator', 'name'),
            },
        ),
        migrations.CreateModel(
            name='GeoElement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.TextField(verbose_name='Nom de la colonne en DB')),
                ('label', models.TextField()),
                ('filterable', models.BooleanField(default=True, verbose_name='Filtrable')),
                ('geo_feature', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='geo_lib.geofeature')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
