# Generated by Django 5.2.3 on 2025-06-18 13:09

import martor.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='GlossaryItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('word', models.TextField(verbose_name='Mot')),
                ('definition', models.TextField(verbose_name='Définition')),
            ],
            options={
                'verbose_name': 'Définition',
                'verbose_name_plural': 'Page Lexique',
                'ordering': ['word'],
            },
        ),
        migrations.CreateModel(
            name='LandingPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.TextField(verbose_name='Titre')),
                ('body', martor.models.MartorField(verbose_name='Contenu')),
                ('button_link', models.TextField(help_text='Au format markdown, par exemple : <br/><br/>[découvrir les indicateurs](/indicateurs/)', verbose_name='Lien du bouton')),
            ],
            options={
                'verbose_name': "Page d'accueil",
                'verbose_name_plural': "Page d'accueil",
            },
        ),
        migrations.CreateModel(
            name='MainConf',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.TextField(default='Tableau de bord', verbose_name='Titre principal du site')),
                ('entity', models.TextField(default='', help_text="Renseigner le nom de l'entité au même format que le logo officiel en respectant les mises à la ligne.", verbose_name='Entité qui possède le site')),
                ('header_navigation', models.TextField(default='', help_text='Navigation du header, mettre les liens au format markdown avec un slash à la fin du lien, mettre une ligne vide entre chaque rubrique. <br/><br/>\n        \n        Une rubrique peut contenir un seul lien, ou bien plusiers, dans ce cas la rubrique sera sous forme de dropdown et il faut mettre un titre en premier. <br/><br/>Par exemple : <br/>\n        <br/><br/>\n        [Accueil](/accueil/)\n        <br/><br/>\n        [Indicateurs territoriaux](/indicateurs/)\n        <br/><br/>\n        À propos\n        [Présentation](/presentation/)\n        [Journal des versions](/journal/)\n        ', verbose_name='Navigation')),
                ('footer_navigation', models.TextField(default='', help_text='Navigation du footer, mettre les liens au format markdown, un par ligne. <br/><br/>\n    Si le lien est interne, commencer et terminer le lien par un slash comme "/accueil/"<br/><br/>\n    Par exemple : <br/><br/>\n    [Plan du site](/plan-site/)<br/>\n    [Accessibilité](/accessibilite/)<br/>\n    [Mentions légales](/mentions-legales/) <br/>\n    ', verbose_name='Navigation')),
            ],
            options={
                'verbose_name': 'Configuration principale',
                'verbose_name_plural': 'Configurations principales',
            },
        ),
        migrations.CreateModel(
            name='NoticeBanner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=64, verbose_name='Titre')),
                ('description', models.CharField(max_length=255, verbose_name='Description')),
                ('link_href', models.CharField(blank=True, help_text="Le lien doit être un lien interne et commencer et terminer par '/', par exemple '/journal/", max_length=255, null=True, verbose_name='Lien')),
                ('link_text', models.CharField(blank=True, help_text='à remplir seulement si un lien est spécifié', max_length=64, null=True, verbose_name='Intitulé du lien')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='StaticPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.TextField(verbose_name='Nom de la page')),
                ('url', models.TextField(help_text="En minuscule avec des espaces remplacés par des traits '-'.<br/>Par exemple : <br/><br/> indicateurs <br/> mentions-legales", verbose_name='Url de la page')),
                ('body', martor.models.MartorField(verbose_name='Contenu')),
            ],
            options={
                'verbose_name': 'Page Statique',
                'verbose_name_plural': 'Pages Statiques',
            },
        ),
    ]
