# Generated by Django 5.2.3 on 2025-06-19 07:13

import django.db.models.deletion
import martor.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='SubTheme',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=64, unique=True)),
                ('index_in_theme', models.IntegerField(default=0)),
                ('title', models.CharField(max_length=128)),
                ('description', models.TextField(blank=True, default='')),
            ],
            options={
                'verbose_name': '2 - Sous-thème',
                'ordering': ('theme', 'index_in_theme'),
            },
        ),
        migrations.CreateModel(
            name='Indicator',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('index_in_theme', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=32, unique=True)),
                ('title', models.CharField(max_length=128)),
                ('db_table_prefix', models.CharField(max_length=128)),
                ('is_composite', models.BooleanField(default=False)),
                ('show_alternative', models.BooleanField(default=True, help_text='Pour certains indicateurs composites (par exemple les moyennes) on ne veut pas afficher la valeur alternative.', verbose_name='Afficher la valeur alternative')),
                ('aggregation_constant', models.DecimalField(decimal_places=5, default=1, max_digits=10)),
                ('aggregation_function', models.CharField(choices=[('discrete', 'Discrete Component 2'), ('repeated', 'Repeated Component 2')], default='repeated', max_length=8)),
                ('unite', models.CharField(max_length=32)),
                ('unite_nom_accessible', models.CharField(blank=True, default='', help_text="Nom accessible de l'unité qui sera lu par le lecteur d'écran.", max_length=64)),
                ('unite_alternative', models.CharField(blank=True, default=None, max_length=32, null=True)),
                ('unite_alternative_nom_accessible', models.CharField(blank=True, default='', help_text="Nom accessible de l'unité alternative qui sera lu par le lecteur d'écran.", max_length=64)),
                ('flows_db_table_prefix', models.CharField(blank=True, help_text='Les données des flux seront affichés sur la carte et le graphique de Sankey.', max_length=128, null=True, verbose_name='Table des flux (prefix)')),
                ('flows_dimension', models.CharField(blank=True, help_text='Nom de la colonne des dimensions de la table des flux', max_length=32, null=True, verbose_name='Dimension des flux')),
                ('show_evolution', models.BooleanField(default=False)),
                ('source', models.TextField(blank=True, default='')),
                ('description', models.TextField(blank=True, default='')),
                ('methodo', martor.models.MartorField(blank=True, default='')),
                ('methodo_file', models.BinaryField(blank=True, null=True)),
                ('secondary_indicator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='indicators_lib.indicator', verbose_name='Second indicateur à afficher sur la carte')),
                ('sub_theme', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='indicators', to='indicators_lib.subtheme')),
            ],
            options={
                'verbose_name': '3 - Indicateur',
                'ordering': ('sub_theme', 'index_in_theme'),
            },
        ),
        migrations.CreateModel(
            name='Dimension',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('db_name', models.TextField()),
                ('title', models.TextField()),
                ('is_breakdown', models.BooleanField(default=False, help_text="Dans le cas de plusieurs dimensions pour un indicateur, l'une d'entre elles doit être la dimension de réparition pour les graphiques.", verbose_name='Répartir selon cette dimension')),
                ('indicator', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dimensions', to='indicators_lib.indicator')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Theme',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('ordering', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=64, unique=True)),
                ('title', models.CharField(max_length=128)),
                ('objectif_theme', models.TextField(blank=True)),
                ('action_theme', models.TextField(blank=True)),
            ],
            options={
                'verbose_name': '1 - Thème',
                'ordering': ('ordering',),
                'indexes': [models.Index(fields=['name'], name='indicators__name_fea408_idx')],
            },
        ),
        migrations.AddField(
            model_name='subtheme',
            name='theme',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sub_themes', to='indicators_lib.theme'),
        ),
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('db_name', models.CharField(max_length=128)),
                ('order', models.IntegerField(default=0)),
                ('default', models.BooleanField(default=True)),
                ('dimension', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='filters', to='indicators_lib.dimension')),
            ],
            options={
                'verbose_name': 'Filtre',
                'ordering': ('dimension', 'order', 'db_name'),
                'indexes': [models.Index(fields=['db_name'], name='indicators__db_name_d32459_idx'), models.Index(fields=['dimension', 'order'], name='indicators__dimensi_aa3fdf_idx')],
                'unique_together': {('dimension', 'db_name')},
            },
        ),
        migrations.AddIndex(
            model_name='indicator',
            index=models.Index(fields=['sub_theme'], name='indicators__sub_the_b49caf_idx'),
        ),
        migrations.AddIndex(
            model_name='indicator',
            index=models.Index(fields=['name'], name='indicators__name_c5606a_idx'),
        ),
        migrations.AddIndex(
            model_name='subtheme',
            index=models.Index(fields=['theme', 'index_in_theme'], name='indicators__theme_i_0cbbc1_idx'),
        ),
        migrations.AddIndex(
            model_name='subtheme',
            index=models.Index(fields=['name'], name='indicators__name_79c542_idx'),
        ),
    ]
