# Generated by Django 5.2.3 on 2025-06-18 13:03

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Dashboard',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('superset_id', models.TextField(help_text="Un utilisateur administrateur de l'instance Superset doit accéder aux paramètres du dashboard et cliquer sur 'embed dashboard' pour récupérer cet ID nécessaire à la connexion avec l'instance Superset.", unique=True, verbose_name='Embed ID de Superset')),
                ('short_name', models.TextField(help_text="Pour l'URL, ne mettre que des lettres minuscules sans accents et des tirets", unique=True, verbose_name='Nom court')),
                ('label', models.TextField(help_text='Nom du dashboard à afficher dans la liste.', unique=True, verbose_name='Label')),
                ('order', models.IntegerField(default=1, help_text="Numéro d'ordre dans la dropdown de sélection, les dashboards sont triés du plus petit numéro au plus grand.", verbose_name="Numéro d'ordre")),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('superset_id', models.TextField(blank=True, help_text="ID du native filter du territoire, qui permettra d'initialiser les filtres du dasbhoard au territoire sélectionné dans l'application. Pour le récupérer c'est un petit parcours du combattant : aller sur le dashboard dans superset, cliquer sur modifier le dashboard, cliquer sur les trois petits points, puis sur modifier les propriétés. Cliquer sur avancé, copier le json et le coller dans un site comme : https://jsonformatter.curiousconcept.com/ pour mieux le voir. Chercher 'global_chart_configuration' puis 'native_filter_configuration'. Chercher le native filter lié au choix du territoire. Copier l'id qui dans son nom, le nom est de la forme NATIVE_FILTER-ID. Promis, c'est le plus simple que j'ai trouvé !", null=True)),
                ('superset_col', models.TextField(blank=True, help_text="Nom de la colonne en base de données liée au filtre sur le territoire. Pour trouver le nom faire les mêmes étapes que pour geo_filter_id et chercher 'column' dans les paramètres json du native filter.", null=True)),
                ('mesh', models.TextField(blank=True, choices=[('fr', 'National'), ('reg', 'Region'), ('dep', 'Department'), ('epci', 'Epci'), ('com', 'Town')], help_text="Maille du territoire sur lequel s'effectue le filtre.", null=True)),
                ('dashboard', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='filters', to='superset_lib.dashboard')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
