#!/usr/bin/env python
# coding: utf-8
from gitlab_api.version import __version__, __author__, __credits__
from gitlab_api.gitlab_api import Api
from gitlab_api.gitlab_models import (
    BranchModel,
    CommitModel,
    DeployTokenModel,
    GroupModel,
    JobModel,
    MembersModel,
    PackageModel,
    PipelineModel,
    ProjectModel,
    ProtectedBranchModel,
    MergeRequestModel,
    MergeRequestRuleModel,
    ReleaseModel,
    RunnerModel,
    UserModel,
    WikiModel,
    DeployToken,
    Rule,
    AccessControl,
    Source,
    Link,
    Assets,
    Evidence,
    Evidences,
    ReleaseLinks,
    Token,
    ToDo,
    WikiPage,
    WikiPages,
    WikiAttachmentLink,
    WikiAttachment,
    Agent,
    Agents,
    Release,
    Releases,
    Branch,
    Branches,
    ApprovalRule,
    ApprovalRules,
    MergeRequest,
    MergeRequests,
    GroupAccess,
    GroupAccesses,
    DefaultBranchProtectionDefaults,
    Group,
    Groups,
    Webhook,
    AccessLevel,
    AccessLevels,
    Project,
    Projects,
    Runner,
    Runners,
    Job,
    Jobs,
    Label,
    Labels,
    Tag,
    Tags,
    Topic,
    Topics,
    Pipeline,
    Pipelines,
    PackageLink,
    PackageVersion,
    Package,
    Packages,
    Contributor,
    Contributors,
    CommitStats,
    CommitSignature,
    Comment,
    Comments,
    Commit,
    Commits,
    Membership,
    Memberships,
    IssueStats,
    Milestone,
    Milestones,
    TimeStats,
    TaskCompletionStatus,
    References,
    Artifact,
    Artifacts,
    ArtifactsFile,
    RunnerManager,
    Configuration,
    Iteration,
    Identity,
    Identities,
    GroupSamlIdentity,
    User,
    Users,
    Namespace,
    Namespaces,
    ContainerExpirationPolicy,
    Permissions,
    Statistics,
    Links,
    Diff,
    Diffs,
    DetailedStatus,
)
from gitlab_api.gitlab_db_models import (
    BaseDBModel,
    DeployTokenDBModel,
    RuleDBModel,
    AccessControlDBModel,
    AccessControlsDBModel,
    SourcesDBModel,
    LinkDBModel,
    AssetsDBModel,
    EvidenceDBModel,
    EvidencesDBModel,
    ReleaseLinksDBModel,
    TokenDBModel,
    ToDoDBModel,
    WikiPageDBModel,
    WikiPagesDBModel,
    WikiAttachmentLinkDBModel,
    WikiAttachmentDBModel,
    AgentDBModel,
    AgentsDBModel,
    ReleaseDBModel,
    ReleasesDBModel,
    BranchDBModel,
    BranchesDBModel,
    ApprovalRuleDBModel,
    ApprovalRulesDBModel,
    MergeRequestDBModel,
    MergeRequestsDBModel,
    MergeApprovalsDBModel,
    TestCaseDBModel,
    TestCasesDBModel,
    TestSuiteDBModel,
    TestSuitesDBModel,
    TestReportDBModel,
    TestReportTotalDBModel,
    GroupAccessDBModel,
    DefaultBranchProtectionDefaultsDBModel,
    GroupDBModel,
    GroupsDBModel,
    WebhookDBModel,
    AccessLevelDBModel,
    TagDBModel,
    TagsDBModel,
    TopicDBModel,
    TopicsDBModel,
    LabelDBModel,
    LabelsDBModel,
    ProjectDBModel,
    ProjectsDBModel,
    RunnerDBModel,
    RunnersDBModel,
    EpicDBModel,
    IssueDBModel,
    JobDBModel,
    JobsDBModel,
    ParentIDDBModel,
    ParentIDsDBModel,
    PipelineDBModel,
    PipelinesDBModel,
    PipelineVariableDBModel,
    PackageLinkDBModel,
    PackageVersionDBModel,
    PackageDBModel,
    PackagesDBModel,
    ProjectConfigDBModel,
    ContributorDBModel,
    CommitStatsDBModel,
    CommitSignatureDBModel,
    CommentDBModel,
    CommentsDBModel,
    CommitDBModel,
    CommitsDBModel,
    MembershipDBModel,
    MembershipsDBModel,
    IssueStatsDBModel,
    MilestoneDBModel,
    MilestonesDBModel,
    TimeStatsDBModel,
    TaskCompletionStatusDBModel,
    ReferencesDBModel,
    ArtifactDBModel,
    ArtifactsDBModel,
    ArtifactsFileDBModel,
    RunnerManagerDBModel,
    ConfigurationDBModel,
    IterationDBModel,
    IdentityDBModel,
    GroupSamlIdentityDBModel,
    UserDBModel,
    UsersDBModel,
    NamespaceDBModel,
    NamespacesDBModel,
    ContainerExpirationPolicyDBModel,
    PermissionsDBModel,
    StatisticsDBModel,
    LinksDBModel,
    DiffDBModel,
    DiffsDBModel,
    DetailedStatusDBModel,
)
from gitlab_api.utils import (
    upsert,
    create_table,
    pydantic_to_sqlalchemy,
)

"""
GitLab API

A Python Wrapper for GitLab API
"""

__version__ = __version__
__author__ = __author__
__credits__ = __credits__

__all__ = [
    "upsert",
    "create_table",
    "pydantic_to_sqlalchemy",
    "Api",
    "BranchModel",
    "CommitModel",
    "DeployTokenModel",
    "GroupModel",
    "JobModel",
    "MembersModel",
    "PackageModel",
    "PipelineModel",
    "ProjectModel",
    "ProtectedBranchModel",
    "MergeRequestModel",
    "MergeRequestRuleModel",
    "ReleaseModel",
    "RunnerModel",
    "UserModel",
    "WikiModel",
    "DeployToken",
    "Branch",
    "Branches",
    "Rule",
    "AccessControl",
    "Source",
    "Link",
    "Links",
    "Tag",
    "Tags",
    "Topic",
    "Topics",
    "Label",
    "Labels",
    "Assets",
    "Evidence",
    "Evidences",
    "ReleaseLinks",
    "Token",
    "ToDo",
    "WikiPage",
    "WikiPages",
    "WikiAttachmentLink",
    "WikiAttachment",
    "Agent",
    "Agents",
    "Release",
    "Releases",
    "Branches",
    "ApprovalRule",
    "ApprovalRules",
    "MergeRequest",
    "MergeRequests",
    "GroupAccess",
    "GroupAccesses",
    "DefaultBranchProtectionDefaults",
    "Group",
    "Groups",
    "Webhook",
    "AccessLevel",
    "AccessLevels",
    "Project",
    "Projects",
    "Runner",
    "Runners",
    "Job",
    "Jobs",
    "Pipeline",
    "Pipelines",
    "PackageLink",
    "PackageVersion",
    "Package",
    "Packages",
    "Contributor",
    "Contributors",
    "CommitStats",
    "CommitSignature",
    "Comment",
    "Comments",
    "Commit",
    "Commits",
    "Membership",
    "Memberships",
    "IssueStats",
    "Milestone",
    "Milestones",
    "TimeStats",
    "TaskCompletionStatus",
    "References",
    "Artifact",
    "Artifacts",
    "ArtifactsFile",
    "RunnerManager",
    "Configuration",
    "Iteration",
    "Identity",
    "Identities",
    "GroupSamlIdentity",
    "User",
    "Users",
    "Namespace",
    "Namespaces",
    "ContainerExpirationPolicy",
    "Permissions",
    "Statistics",
    "Links",
    "Diff",
    "Diffs",
    "DetailedStatus",
    "BaseDBModel",
    "DeployTokenDBModel",
    "RuleDBModel",
    "AccessControlDBModel",
    "AccessControlsDBModel",
    "SourcesDBModel",
    "LinkDBModel",
    "AssetsDBModel",
    "EvidenceDBModel",
    "EvidencesDBModel",
    "ReleaseLinksDBModel",
    "TokenDBModel",
    "ToDoDBModel",
    "WikiPageDBModel",
    "WikiPagesDBModel",
    "WikiAttachmentLinkDBModel",
    "WikiAttachmentDBModel",
    "AgentDBModel",
    "AgentsDBModel",
    "ReleaseDBModel",
    "ReleasesDBModel",
    "BranchDBModel",
    "BranchesDBModel",
    "ApprovalRuleDBModel",
    "ApprovalRulesDBModel",
    "MergeRequestDBModel",
    "MergeRequestsDBModel",
    "MergeApprovalsDBModel",
    "GroupAccessDBModel",
    "DefaultBranchProtectionDefaultsDBModel",
    "GroupDBModel",
    "GroupsDBModel",
    "WebhookDBModel",
    "AccessLevelDBModel",
    "ProjectDBModel",
    "ProjectsDBModel",
    "RunnerDBModel",
    "RunnersDBModel",
    "EpicDBModel",
    "IssueDBModel",
    "JobDBModel",
    "JobsDBModel",
    "PipelineDBModel",
    "PipelinesDBModel",
    "PipelineVariableDBModel",
    "PackageLinkDBModel",
    "PackageVersionDBModel",
    "PackageDBModel",
    "PackagesDBModel",
    "LabelDBModel",
    "LabelsDBModel",
    "ProjectConfigDBModel",
    "ContributorDBModel",
    "CommitStatsDBModel",
    "CommitSignatureDBModel",
    "CommentDBModel",
    "CommentsDBModel",
    "CommitDBModel",
    "CommitsDBModel",
    "MembershipDBModel",
    "MembershipsDBModel",
    "IssueStatsDBModel",
    "MilestoneDBModel",
    "MilestonesDBModel",
    "TimeStatsDBModel",
    "TaskCompletionStatusDBModel",
    "ReferencesDBModel",
    "ArtifactDBModel",
    "ArtifactsDBModel",
    "ArtifactsFileDBModel",
    "RunnerManagerDBModel",
    "ConfigurationDBModel",
    "IterationDBModel",
    "IdentityDBModel",
    "ParentIDDBModel",
    "ParentIDsDBModel",
    "GroupSamlIdentityDBModel",
    "UserDBModel",
    "UsersDBModel",
    "TagDBModel",
    "TagsDBModel",
    "TopicDBModel",
    "TopicsDBModel",
    "TestCaseDBModel",
    "TestCasesDBModel",
    "TestSuiteDBModel",
    "TestSuitesDBModel",
    "TestReportDBModel",
    "TestReportTotalDBModel",
    "NamespaceDBModel",
    "NamespacesDBModel",
    "ContainerExpirationPolicyDBModel",
    "PermissionsDBModel",
    "StatisticsDBModel",
    "LinksDBModel",
    "DiffDBModel",
    "DiffsDBModel",
    "DetailedStatusDBModel",
]
