"""
Dominus Orchestrator Endpoints

Single backend URL for all services. The SDK now targets dominus-orchestrator
which consolidates all service functionality.

Configuration:
    Set DOMINUS_BASE_URL environment variable to override the default URL.
    Example: export DOMINUS_BASE_URL=http://localhost:5000

Usage:
    from dominus.config.endpoints import BASE_URL, get_base_url
"""
import os

# Default Dominus Orchestrator Production URL
_DEFAULT_BASE_URL = "https://dominus-orchestrator-production-775398158805.us-east4.run.app"

# Base URL (can be overridden via DOMINUS_BASE_URL environment variable)
BASE_URL = os.environ.get("DOMINUS_BASE_URL", _DEFAULT_BASE_URL)

# Legacy aliases (all point to orchestrator now) - DEPRECATED
SOVEREIGN_URL = BASE_URL
ARCHITECT_URL = BASE_URL
ORCHESTRATOR_URL = BASE_URL
WARDEN_URL = BASE_URL


def get_base_url() -> str:
    """
    Get the dominus-orchestrator base URL.

    Returns the value of DOMINUS_BASE_URL environment variable if set,
    otherwise returns the default production URL.
    """
    return os.environ.get("DOMINUS_BASE_URL", _DEFAULT_BASE_URL)


# DEPRECATED - use get_base_url()
def get_sovereign_url(environment: str = None) -> str:
    """Deprecated: Use get_base_url() instead."""
    return BASE_URL


def get_architect_url(environment: str = None) -> str:
    """Deprecated: Use get_base_url() instead."""
    return BASE_URL


def get_service_url(service: str, environment: str = None) -> str:
    """Deprecated: Use get_base_url() instead. All services are now consolidated."""
    return BASE_URL
