"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk_1 = require("@aws-cdk/cdk");
const s3_generated_1 = require("./s3.generated");
/**
 * Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
 */
class BucketPolicy extends cdk_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * A policy document containing permissions to add to the specified bucket.
         * For more information, see Access Policy Language Overview in the Amazon
         * Simple Storage Service Developer Guide.
         */
        this.document = new aws_iam_1.PolicyDocument();
        if (!props.bucket.bucketName) {
            throw new Error('Bucket doesn\'t have a bucketName defined');
        }
        new s3_generated_1.CfnBucketPolicy(this, 'Resource', {
            bucket: props.bucket.bucketName,
            policyDocument: this.document,
        });
    }
}
exports.BucketPolicy = BucketPolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVja2V0LXBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImJ1Y2tldC1wb2xpY3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSw4Q0FBa0Q7QUFDbEQsc0NBQXlDO0FBRXpDLGlEQUFpRDtBQVNqRDs7R0FFRztBQUNILE1BQWEsWUFBYSxTQUFRLGVBQVM7SUFTekMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QjtRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBUm5COzs7O1dBSUc7UUFDYSxhQUFRLEdBQUcsSUFBSSx3QkFBYyxFQUFFLENBQUM7UUFLOUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsVUFBVSxFQUFFO1lBQzVCLE1BQU0sSUFBSSxLQUFLLENBQUMsMkNBQTJDLENBQUMsQ0FBQztTQUM5RDtRQUVELElBQUksOEJBQWUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BDLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLFVBQVU7WUFDL0IsY0FBYyxFQUFFLElBQUksQ0FBQyxRQUFRO1NBQzlCLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQXJCRCxvQ0FxQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQb2xpY3lEb2N1bWVudCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IElCdWNrZXQgfSBmcm9tICcuL2J1Y2tldCc7XG5pbXBvcnQgeyBDZm5CdWNrZXRQb2xpY3kgfSBmcm9tICcuL3MzLmdlbmVyYXRlZCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQnVja2V0UG9saWN5UHJvcHMge1xuICAvKipcbiAgICogVGhlIEFtYXpvbiBTMyBidWNrZXQgdGhhdCB0aGUgcG9saWN5IGFwcGxpZXMgdG8uXG4gICAqL1xuICByZWFkb25seSBidWNrZXQ6IElCdWNrZXQ7XG59XG5cbi8qKlxuICogQXBwbGllcyBhbiBBbWF6b24gUzMgYnVja2V0IHBvbGljeSB0byBhbiBBbWF6b24gUzMgYnVja2V0LlxuICovXG5leHBvcnQgY2xhc3MgQnVja2V0UG9saWN5IGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICAvKipcbiAgICogQSBwb2xpY3kgZG9jdW1lbnQgY29udGFpbmluZyBwZXJtaXNzaW9ucyB0byBhZGQgdG8gdGhlIHNwZWNpZmllZCBidWNrZXQuXG4gICAqIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgQWNjZXNzIFBvbGljeSBMYW5ndWFnZSBPdmVydmlldyBpbiB0aGUgQW1hem9uXG4gICAqIFNpbXBsZSBTdG9yYWdlIFNlcnZpY2UgRGV2ZWxvcGVyIEd1aWRlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGRvY3VtZW50ID0gbmV3IFBvbGljeURvY3VtZW50KCk7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEJ1Y2tldFBvbGljeVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGlmICghcHJvcHMuYnVja2V0LmJ1Y2tldE5hbWUpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQnVja2V0IGRvZXNuXFwndCBoYXZlIGEgYnVja2V0TmFtZSBkZWZpbmVkJyk7XG4gICAgfVxuXG4gICAgbmV3IENmbkJ1Y2tldFBvbGljeSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBidWNrZXQ6IHByb3BzLmJ1Y2tldC5idWNrZXROYW1lLFxuICAgICAgcG9saWN5RG9jdW1lbnQ6IHRoaXMuZG9jdW1lbnQsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==