import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::S3::Bucket`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export interface CfnBucketProps {
    /**
     * `AWS::S3::Bucket.AccelerateConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accelerateconfiguration
     */
    readonly accelerateConfiguration?: CfnBucket.AccelerateConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.AccessControl`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-accesscontrol
     */
    readonly accessControl?: string;
    /**
     * `AWS::S3::Bucket.AnalyticsConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-analyticsconfigurations
     */
    readonly analyticsConfigurations?: Array<CfnBucket.AnalyticsConfigurationProperty | cdk.Token> | cdk.Token;
    /**
     * `AWS::S3::Bucket.BucketEncryption`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-bucketencryption
     */
    readonly bucketEncryption?: CfnBucket.BucketEncryptionProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.BucketName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-name
     */
    readonly bucketName?: string;
    /**
     * `AWS::S3::Bucket.CorsConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-crossoriginconfig
     */
    readonly corsConfiguration?: CfnBucket.CorsConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.InventoryConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-inventoryconfigurations
     */
    readonly inventoryConfigurations?: Array<CfnBucket.InventoryConfigurationProperty | cdk.Token> | cdk.Token;
    /**
     * `AWS::S3::Bucket.LifecycleConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-lifecycleconfig
     */
    readonly lifecycleConfiguration?: CfnBucket.LifecycleConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.LoggingConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-loggingconfig
     */
    readonly loggingConfiguration?: CfnBucket.LoggingConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.MetricsConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-metricsconfigurations
     */
    readonly metricsConfigurations?: Array<CfnBucket.MetricsConfigurationProperty | cdk.Token> | cdk.Token;
    /**
     * `AWS::S3::Bucket.NotificationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-notification
     */
    readonly notificationConfiguration?: CfnBucket.NotificationConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.PublicAccessBlockConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-publicaccessblockconfiguration
     */
    readonly publicAccessBlockConfiguration?: CfnBucket.PublicAccessBlockConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.ReplicationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-replicationconfiguration
     */
    readonly replicationConfiguration?: CfnBucket.ReplicationConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::S3::Bucket.VersioningConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-versioning
     */
    readonly versioningConfiguration?: CfnBucket.VersioningConfigurationProperty | cdk.Token;
    /**
     * `AWS::S3::Bucket.WebsiteConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html#cfn-s3-bucket-websiteconfiguration
     */
    readonly websiteConfiguration?: CfnBucket.WebsiteConfigurationProperty | cdk.Token;
}
/**
 * A CloudFormation `AWS::S3::Bucket`
 *
 * @cloudformationResource AWS::S3::Bucket
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket.html
 */
export declare class CfnBucket extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::S3::Bucket";
    /**
     * @cloudformationAttribute Arn
     */
    readonly bucketArn: string;
    /**
     * @cloudformationAttribute DomainName
     */
    readonly bucketDomainName: string;
    /**
     * @cloudformationAttribute DualStackDomainName
     */
    readonly bucketDualStackDomainName: string;
    /**
     * @cloudformationAttribute RegionalDomainName
     */
    readonly bucketRegionalDomainName: string;
    /**
     * @cloudformationAttribute WebsiteURL
     */
    readonly bucketWebsiteUrl: string;
    readonly bucketName: string;
    /**
     * The `TagManager` handles setting, removing and formatting tags
     *
     * Tags should be managed either passing them as properties during
     * initiation or by calling methods on this object. If both techniques are
     * used only the tags from the TagManager will be used. `Tag` (aspect)
     * will use the manager.
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::S3::Bucket`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnBucketProps);
    readonly propertyOverrides: CfnBucketProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html
     */
    interface AbortIncompleteMultipartUploadProperty {
        /**
         * `CfnBucket.AbortIncompleteMultipartUploadProperty.DaysAfterInitiation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-abortincompletemultipartupload.html#cfn-s3-bucket-abortincompletemultipartupload-daysafterinitiation
         */
        readonly daysAfterInitiation: number | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html
     */
    interface AccelerateConfigurationProperty {
        /**
         * `CfnBucket.AccelerateConfigurationProperty.AccelerationStatus`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accelerateconfiguration.html#cfn-s3-bucket-accelerateconfiguration-accelerationstatus
         */
        readonly accelerationStatus: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html
     */
    interface AccessControlTranslationProperty {
        /**
         * `CfnBucket.AccessControlTranslationProperty.Owner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-accesscontroltranslation.html#cfn-s3-bucket-accesscontroltranslation-owner
         */
        readonly owner: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html
     */
    interface AnalyticsConfigurationProperty {
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.StorageClassAnalysis`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-storageclassanalysis
         */
        readonly storageClassAnalysis: CfnBucket.StorageClassAnalysisProperty | cdk.Token;
        /**
         * `CfnBucket.AnalyticsConfigurationProperty.TagFilters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-analyticsconfiguration.html#cfn-s3-bucket-analyticsconfiguration-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html
     */
    interface BucketEncryptionProperty {
        /**
         * `CfnBucket.BucketEncryptionProperty.ServerSideEncryptionConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-bucketencryption.html#cfn-s3-bucket-bucketencryption-serversideencryptionconfiguration
         */
        readonly serverSideEncryptionConfiguration: Array<CfnBucket.ServerSideEncryptionRuleProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html
     */
    interface CorsConfigurationProperty {
        /**
         * `CfnBucket.CorsConfigurationProperty.CorsRules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors.html#cfn-s3-bucket-cors-corsrule
         */
        readonly corsRules: Array<CfnBucket.CorsRuleProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html
     */
    interface CorsRuleProperty {
        /**
         * `CfnBucket.CorsRuleProperty.AllowedHeaders`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedheaders
         */
        readonly allowedHeaders?: string[];
        /**
         * `CfnBucket.CorsRuleProperty.AllowedMethods`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedmethods
         */
        readonly allowedMethods: string[];
        /**
         * `CfnBucket.CorsRuleProperty.AllowedOrigins`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-allowedorigins
         */
        readonly allowedOrigins: string[];
        /**
         * `CfnBucket.CorsRuleProperty.ExposedHeaders`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-exposedheaders
         */
        readonly exposedHeaders?: string[];
        /**
         * `CfnBucket.CorsRuleProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-id
         */
        readonly id?: string;
        /**
         * `CfnBucket.CorsRuleProperty.MaxAge`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-cors-corsrule.html#cfn-s3-bucket-cors-corsrule-maxage
         */
        readonly maxAge?: number | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html
     */
    interface DataExportProperty {
        /**
         * `CfnBucket.DataExportProperty.Destination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-destination
         */
        readonly destination: CfnBucket.DestinationProperty | cdk.Token;
        /**
         * `CfnBucket.DataExportProperty.OutputSchemaVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-dataexport.html#cfn-s3-bucket-dataexport-outputschemaversion
         */
        readonly outputSchemaVersion: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html
     */
    interface DestinationProperty {
        /**
         * `CfnBucket.DestinationProperty.BucketAccountId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketaccountid
         */
        readonly bucketAccountId?: string;
        /**
         * `CfnBucket.DestinationProperty.BucketArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-bucketarn
         */
        readonly bucketArn: string;
        /**
         * `CfnBucket.DestinationProperty.Format`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-format
         */
        readonly format: string;
        /**
         * `CfnBucket.DestinationProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-destination.html#cfn-s3-bucket-destination-prefix
         */
        readonly prefix?: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnBucket.EncryptionConfigurationProperty.ReplicaKmsKeyID`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-encryptionconfiguration.html#cfn-s3-bucket-encryptionconfiguration-replicakmskeyid
         */
        readonly replicaKmsKeyId: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html
     */
    interface FilterRuleProperty {
        /**
         * `CfnBucket.FilterRuleProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-name
         */
        readonly name: string;
        /**
         * `CfnBucket.FilterRuleProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key-rules.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules-value
         */
        readonly value: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html
     */
    interface InventoryConfigurationProperty {
        /**
         * `CfnBucket.InventoryConfigurationProperty.Destination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-destination
         */
        readonly destination: CfnBucket.DestinationProperty | cdk.Token;
        /**
         * `CfnBucket.InventoryConfigurationProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-enabled
         */
        readonly enabled: boolean | cdk.Token;
        /**
         * `CfnBucket.InventoryConfigurationProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.IncludedObjectVersions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-includedobjectversions
         */
        readonly includedObjectVersions: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.OptionalFields`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-optionalfields
         */
        readonly optionalFields?: string[];
        /**
         * `CfnBucket.InventoryConfigurationProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.InventoryConfigurationProperty.ScheduleFrequency`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-inventoryconfiguration.html#cfn-s3-bucket-inventoryconfiguration-schedulefrequency
         */
        readonly scheduleFrequency: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html
     */
    interface LambdaConfigurationProperty {
        /**
         * `CfnBucket.LambdaConfigurationProperty.Event`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-event
         */
        readonly event: string;
        /**
         * `CfnBucket.LambdaConfigurationProperty.Filter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-filter
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.Token;
        /**
         * `CfnBucket.LambdaConfigurationProperty.Function`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-lambdaconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig-function
         */
        readonly function: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html
     */
    interface LifecycleConfigurationProperty {
        /**
         * `CfnBucket.LifecycleConfigurationProperty.Rules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig.html#cfn-s3-bucket-lifecycleconfig-rules
         */
        readonly rules: Array<CfnBucket.RuleProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html
     */
    interface LoggingConfigurationProperty {
        /**
         * `CfnBucket.LoggingConfigurationProperty.DestinationBucketName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-destinationbucketname
         */
        readonly destinationBucketName?: string;
        /**
         * `CfnBucket.LoggingConfigurationProperty.LogFilePrefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-loggingconfig.html#cfn-s3-bucket-loggingconfig-logfileprefix
         */
        readonly logFilePrefix?: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html
     */
    interface MetricsConfigurationProperty {
        /**
         * `CfnBucket.MetricsConfigurationProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-id
         */
        readonly id: string;
        /**
         * `CfnBucket.MetricsConfigurationProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.MetricsConfigurationProperty.TagFilters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-metricsconfiguration.html#cfn-s3-bucket-metricsconfiguration-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html
     */
    interface NoncurrentVersionTransitionProperty {
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.StorageClass`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-storageclass
         */
        readonly storageClass: string;
        /**
         * `CfnBucket.NoncurrentVersionTransitionProperty.TransitionInDays`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition-transitionindays
         */
        readonly transitionInDays: number | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnBucket.NotificationConfigurationProperty.LambdaConfigurations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-lambdaconfig
         */
        readonly lambdaConfigurations?: Array<CfnBucket.LambdaConfigurationProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnBucket.NotificationConfigurationProperty.QueueConfigurations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-queueconfig
         */
        readonly queueConfigurations?: Array<CfnBucket.QueueConfigurationProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnBucket.NotificationConfigurationProperty.TopicConfigurations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig.html#cfn-s3-bucket-notificationconfig-topicconfig
         */
        readonly topicConfigurations?: Array<CfnBucket.TopicConfigurationProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html
     */
    interface NotificationFilterProperty {
        /**
         * `CfnBucket.NotificationFilterProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key
         */
        readonly s3Key: CfnBucket.S3KeyFilterProperty | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
     */
    interface PublicAccessBlockConfigurationProperty {
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicAcls`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicacls
         */
        readonly blockPublicAcls?: boolean | cdk.Token;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.BlockPublicPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-blockpublicpolicy
         */
        readonly blockPublicPolicy?: boolean | cdk.Token;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.IgnorePublicAcls`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-ignorepublicacls
         */
        readonly ignorePublicAcls?: boolean | cdk.Token;
        /**
         * `CfnBucket.PublicAccessBlockConfigurationProperty.RestrictPublicBuckets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html#cfn-s3-bucket-publicaccessblockconfiguration-restrictpublicbuckets
         */
        readonly restrictPublicBuckets?: boolean | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html
     */
    interface QueueConfigurationProperty {
        /**
         * `CfnBucket.QueueConfigurationProperty.Event`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-event
         */
        readonly event: string;
        /**
         * `CfnBucket.QueueConfigurationProperty.Filter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-filter
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.Token;
        /**
         * `CfnBucket.QueueConfigurationProperty.Queue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-queueconfig.html#cfn-s3-bucket-notificationconfig-queueconfig-queue
         */
        readonly queue: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html
     */
    interface RedirectAllRequestsToProperty {
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.HostName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-hostname
         */
        readonly hostName: string;
        /**
         * `CfnBucket.RedirectAllRequestsToProperty.Protocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-redirectallrequeststo.html#cfn-s3-websiteconfiguration-redirectallrequeststo-protocol
         */
        readonly protocol?: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html
     */
    interface RedirectRuleProperty {
        /**
         * `CfnBucket.RedirectRuleProperty.HostName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-hostname
         */
        readonly hostName?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.HttpRedirectCode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-httpredirectcode
         */
        readonly httpRedirectCode?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.Protocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-protocol
         */
        readonly protocol?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyPrefixWith`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeyprefixwith
         */
        readonly replaceKeyPrefixWith?: string;
        /**
         * `CfnBucket.RedirectRuleProperty.ReplaceKeyWith`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-redirectrule.html#cfn-s3-websiteconfiguration-redirectrule-replacekeywith
         */
        readonly replaceKeyWith?: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html
     */
    interface ReplicationConfigurationProperty {
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Role`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-role
         */
        readonly role: string;
        /**
         * `CfnBucket.ReplicationConfigurationProperty.Rules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration.html#cfn-s3-bucket-replicationconfiguration-rules
         */
        readonly rules: Array<CfnBucket.ReplicationRuleProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html
     */
    interface ReplicationDestinationProperty {
        /**
         * `CfnBucket.ReplicationDestinationProperty.AccessControlTranslation`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-accesscontroltranslation
         */
        readonly accessControlTranslation?: CfnBucket.AccessControlTranslationProperty | cdk.Token;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Account`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-account
         */
        readonly account?: string;
        /**
         * `CfnBucket.ReplicationDestinationProperty.Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-bucket
         */
        readonly bucket: string;
        /**
         * `CfnBucket.ReplicationDestinationProperty.EncryptionConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationdestination-encryptionconfiguration
         */
        readonly encryptionConfiguration?: CfnBucket.EncryptionConfigurationProperty | cdk.Token;
        /**
         * `CfnBucket.ReplicationDestinationProperty.StorageClass`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules-destination.html#cfn-s3-bucket-replicationconfiguration-rules-destination-storageclass
         */
        readonly storageClass?: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html
     */
    interface ReplicationRuleProperty {
        /**
         * `CfnBucket.ReplicationRuleProperty.Destination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-destination
         */
        readonly destination: CfnBucket.ReplicationDestinationProperty | cdk.Token;
        /**
         * `CfnBucket.ReplicationRuleProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-id
         */
        readonly id?: string;
        /**
         * `CfnBucket.ReplicationRuleProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-prefix
         */
        readonly prefix: string;
        /**
         * `CfnBucket.ReplicationRuleProperty.SourceSelectionCriteria`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationrule-sourceselectioncriteria
         */
        readonly sourceSelectionCriteria?: CfnBucket.SourceSelectionCriteriaProperty | cdk.Token;
        /**
         * `CfnBucket.ReplicationRuleProperty.Status`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-replicationconfiguration-rules.html#cfn-s3-bucket-replicationconfiguration-rules-status
         */
        readonly status: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html
     */
    interface RoutingRuleProperty {
        /**
         * `CfnBucket.RoutingRuleProperty.RedirectRule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-redirectrule
         */
        readonly redirectRule: CfnBucket.RedirectRuleProperty | cdk.Token;
        /**
         * `CfnBucket.RoutingRuleProperty.RoutingRuleCondition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition
         */
        readonly routingRuleCondition?: CfnBucket.RoutingRuleConditionProperty | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html
     */
    interface RoutingRuleConditionProperty {
        /**
         * `CfnBucket.RoutingRuleConditionProperty.HttpErrorCodeReturnedEquals`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-httperrorcodereturnedequals
         */
        readonly httpErrorCodeReturnedEquals?: string;
        /**
         * `CfnBucket.RoutingRuleConditionProperty.KeyPrefixEquals`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules-routingrulecondition.html#cfn-s3-websiteconfiguration-routingrules-routingrulecondition-keyprefixequals
         */
        readonly keyPrefixEquals?: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html
     */
    interface RuleProperty {
        /**
         * `CfnBucket.RuleProperty.AbortIncompleteMultipartUpload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-abortincompletemultipartupload
         */
        readonly abortIncompleteMultipartUpload?: CfnBucket.AbortIncompleteMultipartUploadProperty | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.ExpirationDate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationdate
         */
        readonly expirationDate?: Date | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.ExpirationInDays`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-expirationindays
         */
        readonly expirationInDays?: number | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-id
         */
        readonly id?: string;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionExpirationInDays`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversionexpirationindays
         */
        readonly noncurrentVersionExpirationInDays?: number | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransition
         */
        readonly noncurrentVersionTransition?: CfnBucket.NoncurrentVersionTransitionProperty | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.NoncurrentVersionTransitions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-noncurrentversiontransitions
         */
        readonly noncurrentVersionTransitions?: Array<CfnBucket.NoncurrentVersionTransitionProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnBucket.RuleProperty.Status`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-status
         */
        readonly status: string;
        /**
         * `CfnBucket.RuleProperty.TagFilters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-rule-tagfilters
         */
        readonly tagFilters?: Array<CfnBucket.TagFilterProperty | cdk.Token> | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.Transition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transition
         */
        readonly transition?: CfnBucket.TransitionProperty | cdk.Token;
        /**
         * `CfnBucket.RuleProperty.Transitions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule.html#cfn-s3-bucket-lifecycleconfig-rule-transitions
         */
        readonly transitions?: Array<CfnBucket.TransitionProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html
     */
    interface S3KeyFilterProperty {
        /**
         * `CfnBucket.S3KeyFilterProperty.Rules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfiguration-config-filter-s3key.html#cfn-s3-bucket-notificationconfiguraiton-config-filter-s3key-rules
         */
        readonly rules: Array<CfnBucket.FilterRuleProperty | cdk.Token> | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html
     */
    interface ServerSideEncryptionByDefaultProperty {
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.KMSMasterKeyID`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-kmsmasterkeyid
         */
        readonly kmsMasterKeyId?: string;
        /**
         * `CfnBucket.ServerSideEncryptionByDefaultProperty.SSEAlgorithm`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionbydefault.html#cfn-s3-bucket-serversideencryptionbydefault-ssealgorithm
         */
        readonly sseAlgorithm: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html
     */
    interface ServerSideEncryptionRuleProperty {
        /**
         * `CfnBucket.ServerSideEncryptionRuleProperty.ServerSideEncryptionByDefault`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-serversideencryptionrule.html#cfn-s3-bucket-serversideencryptionrule-serversideencryptionbydefault
         */
        readonly serverSideEncryptionByDefault?: CfnBucket.ServerSideEncryptionByDefaultProperty | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html
     */
    interface SourceSelectionCriteriaProperty {
        /**
         * `CfnBucket.SourceSelectionCriteriaProperty.SseKmsEncryptedObjects`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-sourceselectioncriteria.html#cfn-s3-bucket-sourceselectioncriteria-ssekmsencryptedobjects
         */
        readonly sseKmsEncryptedObjects: CfnBucket.SseKmsEncryptedObjectsProperty | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html
     */
    interface SseKmsEncryptedObjectsProperty {
        /**
         * `CfnBucket.SseKmsEncryptedObjectsProperty.Status`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-ssekmsencryptedobjects.html#cfn-s3-bucket-ssekmsencryptedobjects-status
         */
        readonly status: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html
     */
    interface StorageClassAnalysisProperty {
        /**
         * `CfnBucket.StorageClassAnalysisProperty.DataExport`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-storageclassanalysis.html#cfn-s3-bucket-storageclassanalysis-dataexport
         */
        readonly dataExport?: CfnBucket.DataExportProperty | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html
     */
    interface TagFilterProperty {
        /**
         * `CfnBucket.TagFilterProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-key
         */
        readonly key: string;
        /**
         * `CfnBucket.TagFilterProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-tagfilter.html#cfn-s3-bucket-tagfilter-value
         */
        readonly value: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html
     */
    interface TopicConfigurationProperty {
        /**
         * `CfnBucket.TopicConfigurationProperty.Event`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-event
         */
        readonly event: string;
        /**
         * `CfnBucket.TopicConfigurationProperty.Filter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-filter
         */
        readonly filter?: CfnBucket.NotificationFilterProperty | cdk.Token;
        /**
         * `CfnBucket.TopicConfigurationProperty.Topic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-notificationconfig-topicconfig.html#cfn-s3-bucket-notificationconfig-topicconfig-topic
         */
        readonly topic: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html
     */
    interface TransitionProperty {
        /**
         * `CfnBucket.TransitionProperty.StorageClass`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-storageclass
         */
        readonly storageClass: string;
        /**
         * `CfnBucket.TransitionProperty.TransitionDate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitiondate
         */
        readonly transitionDate?: Date | cdk.Token;
        /**
         * `CfnBucket.TransitionProperty.TransitionInDays`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-lifecycleconfig-rule-transition.html#cfn-s3-bucket-lifecycleconfig-rule-transition-transitionindays
         */
        readonly transitionInDays?: number | cdk.Token;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html
     */
    interface VersioningConfigurationProperty {
        /**
         * `CfnBucket.VersioningConfigurationProperty.Status`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-versioningconfig.html#cfn-s3-bucket-versioningconfig-status
         */
        readonly status: string;
    }
}
export declare namespace CfnBucket {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html
     */
    interface WebsiteConfigurationProperty {
        /**
         * `CfnBucket.WebsiteConfigurationProperty.ErrorDocument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-errordocument
         */
        readonly errorDocument?: string;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.IndexDocument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-indexdocument
         */
        readonly indexDocument?: string;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RedirectAllRequestsTo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-redirectallrequeststo
         */
        readonly redirectAllRequestsTo?: CfnBucket.RedirectAllRequestsToProperty | cdk.Token;
        /**
         * `CfnBucket.WebsiteConfigurationProperty.RoutingRules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration.html#cfn-s3-websiteconfiguration-routingrules
         */
        readonly routingRules?: Array<CfnBucket.RoutingRuleProperty | cdk.Token> | cdk.Token;
    }
}
/**
 * Properties for defining a `AWS::S3::BucketPolicy`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 */
export interface CfnBucketPolicyProps {
    /**
     * `AWS::S3::BucketPolicy.Bucket`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-bucket
     */
    readonly bucket: string;
    /**
     * `AWS::S3::BucketPolicy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html#aws-properties-s3-policy-policydocument
     */
    readonly policyDocument: object | cdk.Token;
}
/**
 * A CloudFormation `AWS::S3::BucketPolicy`
 *
 * @cloudformationResource AWS::S3::BucketPolicy
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html
 */
export declare class CfnBucketPolicy extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::S3::BucketPolicy";
    /**
     * Create a new `AWS::S3::BucketPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBucketPolicyProps);
    readonly propertyOverrides: CfnBucketPolicyProps;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
