# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replication_factor: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the cluster.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input[str] size: The size of the managed cluster.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if idle_arrangement_merge_effort is not None:
            pulumi.set(__self__, "idle_arrangement_merge_effort", idle_arrangement_merge_effort)
        if introspection_debugging is not None:
            pulumi.set(__self__, "introspection_debugging", introspection_debugging)
        if introspection_interval is not None:
            pulumi.set(__self__, "introspection_interval", introspection_interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[bool]]:
        """
        **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter(name="idleArrangementMergeEffort")
    def idle_arrangement_merge_effort(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        """
        return pulumi.get(self, "idle_arrangement_merge_effort")

    @idle_arrangement_merge_effort.setter
    def idle_arrangement_merge_effort(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_arrangement_merge_effort", value)

    @property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @introspection_debugging.setter
    def introspection_debugging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "introspection_debugging", value)

    @property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @introspection_interval.setter
    def introspection_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "introspection_interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of each dataflow-powered object to maintain.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the managed cluster.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replication_factor: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the cluster.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input[str] size: The size of the managed cluster.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if idle_arrangement_merge_effort is not None:
            pulumi.set(__self__, "idle_arrangement_merge_effort", idle_arrangement_merge_effort)
        if introspection_debugging is not None:
            pulumi.set(__self__, "introspection_debugging", introspection_debugging)
        if introspection_interval is not None:
            pulumi.set(__self__, "introspection_interval", introspection_interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[bool]]:
        """
        **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter(name="idleArrangementMergeEffort")
    def idle_arrangement_merge_effort(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        """
        return pulumi.get(self, "idle_arrangement_merge_effort")

    @idle_arrangement_merge_effort.setter
    def idle_arrangement_merge_effort(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_arrangement_merge_effort", value)

    @property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @introspection_debugging.setter
    def introspection_debugging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "introspection_debugging", value)

    @property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @introspection_interval.setter
    def introspection_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "introspection_interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of each dataflow-powered object to maintain.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the managed cluster.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replication_factor: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Clusters describe logical compute resources that can be used by sources, sinks, indexes, and materialized views. Managed clusters are created by setting the `size` attribute

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_cluster = materialize.Cluster("exampleCluster")
        ```

        ## Import

        Clusters can be imported using the cluster id

        ```sh
         $ pulumi import materialize:index/cluster:Cluster example_cluster <region>:<cluster_id>
        ```

         Cluster id and information be found in the `mz_catalog.mz_clusters` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the cluster.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input[str] size: The size of the managed cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Clusters describe logical compute resources that can be used by sources, sinks, indexes, and materialized views. Managed clusters are created by setting the `size` attribute

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_cluster = materialize.Cluster("exampleCluster")
        ```

        ## Import

        Clusters can be imported using the cluster id

        ```sh
         $ pulumi import materialize:index/cluster:Cluster example_cluster <region>:<cluster_id>
        ```

         Cluster id and information be found in the `mz_catalog.mz_clusters` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replication_factor: Optional[pulumi.Input[int]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["disk"] = disk
            __props__.__dict__["idle_arrangement_merge_effort"] = idle_arrangement_merge_effort
            __props__.__dict__["introspection_debugging"] = introspection_debugging
            __props__.__dict__["introspection_interval"] = introspection_interval
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["region"] = region
            __props__.__dict__["replication_factor"] = replication_factor
            __props__.__dict__["size"] = size
        super(Cluster, __self__).__init__(
            'materialize:index/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[str]] = None,
            disk: Optional[pulumi.Input[bool]] = None,
            idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
            introspection_debugging: Optional[pulumi.Input[bool]] = None,
            introspection_interval: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ownership_role: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replication_factor: Optional[pulumi.Input[int]] = None,
            size: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the cluster.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[int] replication_factor: The number of replicas of each dataflow-powered object to maintain.
        :param pulumi.Input[str] size: The size of the managed cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["disk"] = disk
        __props__.__dict__["idle_arrangement_merge_effort"] = idle_arrangement_merge_effort
        __props__.__dict__["introspection_debugging"] = introspection_debugging
        __props__.__dict__["introspection_interval"] = introspection_interval
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["size"] = size
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[Optional[bool]]:
        """
        **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter(name="idleArrangementMergeEffort")
    def idle_arrangement_merge_effort(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        """
        return pulumi.get(self, "idle_arrangement_merge_effort")

    @property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> pulumi.Output[Optional[str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier for the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[int]:
        """
        The number of replicas of each dataflow-powered object to maintain.
        """
        return pulumi.get(self, "replication_factor")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[Optional[str]]:
        """
        The size of the managed cluster.
        """
        return pulumi.get(self, "size")

