# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ClusterReplicaArgs', 'ClusterReplica']

@pulumi.input_type
class ClusterReplicaArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 size: pulumi.Input[str],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ClusterReplica resource.
        :param pulumi.Input[str] cluster_name: The cluster whose resources you want to create an additional computation of.
        :param pulumi.Input[str] size: The size of the replica.
        :param pulumi.Input[str] availability_zone: The specific availability zone of the replica.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the replica.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "size", size)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if idle_arrangement_merge_effort is not None:
            pulumi.set(__self__, "idle_arrangement_merge_effort", idle_arrangement_merge_effort)
        if introspection_debugging is not None:
            pulumi.set(__self__, "introspection_debugging", introspection_debugging)
        if introspection_interval is not None:
            pulumi.set(__self__, "introspection_interval", introspection_interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        The cluster whose resources you want to create an additional computation of.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[str]:
        """
        The size of the replica.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[str]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The specific availability zone of the replica.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[bool]]:
        """
        **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter(name="idleArrangementMergeEffort")
    def idle_arrangement_merge_effort(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        """
        return pulumi.get(self, "idle_arrangement_merge_effort")

    @idle_arrangement_merge_effort.setter
    def idle_arrangement_merge_effort(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_arrangement_merge_effort", value)

    @property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @introspection_debugging.setter
    def introspection_debugging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "introspection_debugging", value)

    @property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @introspection_interval.setter
    def introspection_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "introspection_interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the replica.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ClusterReplicaState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ClusterReplica resources.
        :param pulumi.Input[str] availability_zone: The specific availability zone of the replica.
        :param pulumi.Input[str] cluster_name: The cluster whose resources you want to create an additional computation of.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the replica.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] size: The size of the replica.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if idle_arrangement_merge_effort is not None:
            pulumi.set(__self__, "idle_arrangement_merge_effort", idle_arrangement_merge_effort)
        if introspection_debugging is not None:
            pulumi.set(__self__, "introspection_debugging", introspection_debugging)
        if introspection_interval is not None:
            pulumi.set(__self__, "introspection_interval", introspection_interval)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The specific availability zone of the replica.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster whose resources you want to create an additional computation of.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[bool]]:
        """
        **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter(name="idleArrangementMergeEffort")
    def idle_arrangement_merge_effort(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        """
        return pulumi.get(self, "idle_arrangement_merge_effort")

    @idle_arrangement_merge_effort.setter
    def idle_arrangement_merge_effort(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_arrangement_merge_effort", value)

    @property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @introspection_debugging.setter
    def introspection_debugging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "introspection_debugging", value)

    @property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @introspection_interval.setter
    def introspection_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "introspection_interval", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the replica.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the replica.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)


class ClusterReplica(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Cluster replicas allocate physical compute resources for a cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_cluster_replica = materialize.ClusterReplica("exampleClusterReplica",
            cluster_name="cluster",
            size="2xsmall")
        ```

        ## Import

        Cluster replicas can be imported using the cluster replica id

        ```sh
         $ pulumi import materialize:index/clusterReplica:ClusterReplica example_1_cluster_replica <region>:<cluster_replica_id>
        ```

         Cluster replica id and information be found in the `mz_catalog.mz_cluster_replicas` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The specific availability zone of the replica.
        :param pulumi.Input[str] cluster_name: The cluster whose resources you want to create an additional computation of.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the replica.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] size: The size of the replica.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterReplicaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Cluster replicas allocate physical compute resources for a cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        example_cluster_replica = materialize.ClusterReplica("exampleClusterReplica",
            cluster_name="cluster",
            size="2xsmall")
        ```

        ## Import

        Cluster replicas can be imported using the cluster replica id

        ```sh
         $ pulumi import materialize:index/clusterReplica:ClusterReplica example_1_cluster_replica <region>:<cluster_replica_id>
        ```

         Cluster replica id and information be found in the `mz_catalog.mz_cluster_replicas` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ClusterReplicaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterReplicaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[bool]] = None,
                 idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
                 introspection_debugging: Optional[pulumi.Input[bool]] = None,
                 introspection_interval: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterReplicaArgs.__new__(ClusterReplicaArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["comment"] = comment
            __props__.__dict__["disk"] = disk
            __props__.__dict__["idle_arrangement_merge_effort"] = idle_arrangement_merge_effort
            __props__.__dict__["introspection_debugging"] = introspection_debugging
            __props__.__dict__["introspection_interval"] = introspection_interval
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
        super(ClusterReplica, __self__).__init__(
            'materialize:index/clusterReplica:ClusterReplica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            disk: Optional[pulumi.Input[bool]] = None,
            idle_arrangement_merge_effort: Optional[pulumi.Input[int]] = None,
            introspection_debugging: Optional[pulumi.Input[bool]] = None,
            introspection_interval: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[str]] = None) -> 'ClusterReplica':
        """
        Get an existing ClusterReplica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The specific availability zone of the replica.
        :param pulumi.Input[str] cluster_name: The cluster whose resources you want to create an additional computation of.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[bool] disk: **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        :param pulumi.Input[int] idle_arrangement_merge_effort: The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        :param pulumi.Input[bool] introspection_debugging: Whether to introspect the gathering of the introspection data.
        :param pulumi.Input[str] introspection_interval: The interval at which to collect introspection data.
        :param pulumi.Input[str] name: The identifier for the replica.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] size: The size of the replica.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterReplicaState.__new__(_ClusterReplicaState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["comment"] = comment
        __props__.__dict__["disk"] = disk
        __props__.__dict__["idle_arrangement_merge_effort"] = idle_arrangement_merge_effort
        __props__.__dict__["introspection_debugging"] = introspection_debugging
        __props__.__dict__["introspection_interval"] = introspection_interval
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        return ClusterReplica(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The specific availability zone of the replica.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The cluster whose resources you want to create an additional computation of.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[Optional[bool]]:
        """
        **Private Preview**. Whether or not the replica is a *disk-backed replica*.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter(name="idleArrangementMergeEffort")
    def idle_arrangement_merge_effort(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of effort to exert compacting arrangements during idle periods. This is an unstable option! It may be changed or removed at any time.
        """
        return pulumi.get(self, "idle_arrangement_merge_effort")

    @property
    @pulumi.getter(name="introspectionDebugging")
    def introspection_debugging(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to introspect the gathering of the introspection data.
        """
        return pulumi.get(self, "introspection_debugging")

    @property
    @pulumi.getter(name="introspectionInterval")
    def introspection_interval(self) -> pulumi.Output[Optional[str]]:
        """
        The interval at which to collect introspection data.
        """
        return pulumi.get(self, "introspection_interval")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier for the replica.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The size of the replica.
        """
        return pulumi.get(self, "size")

