# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionKafkaArgs', 'ConnectionKafka']

@pulumi.input_type
class ConnectionKafkaArgs:
    def __init__(__self__, *,
                 kafka_brokers: pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]],
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 progress_topic: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[str]] = None,
                 sasl_password: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']] = None,
                 sasl_username: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']] = None,
                 validate: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ConnectionKafka resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]] kafka_brokers: The Kafka brokers configuration.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the connection database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[str] name: The identifier for the connection.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslPasswordArgs'] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslUsernameArgs'] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[str] schema_name: The identifier for the connection schema. Defaults to `public`.
        :param pulumi.Input[str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input['ConnectionKafkaSshTunnelArgs'] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input['ConnectionKafkaSslCertificateArgs'] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslKeyArgs'] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[bool] validate: **Private Preview** If the connection should wait for validation.
        """
        pulumi.set(__self__, "kafka_brokers", kafka_brokers)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if progress_topic is not None:
            pulumi.set(__self__, "progress_topic", progress_topic)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sasl_mechanisms is not None:
            pulumi.set(__self__, "sasl_mechanisms", sasl_mechanisms)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter(name="kafkaBrokers")
    def kafka_brokers(self) -> pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]:
        """
        The Kafka brokers configuration.
        """
        return pulumi.get(self, "kafka_brokers")

    @kafka_brokers.setter
    def kafka_brokers(self, value: pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]):
        pulumi.set(self, "kafka_brokers", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the connection database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter(name="progressTopic")
    def progress_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a topic that Kafka sinks can use to track internal consistency metadata.
        """
        return pulumi.get(self, "progress_topic")

    @progress_topic.setter
    def progress_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "progress_topic", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="saslMechanisms")
    def sasl_mechanisms(self) -> Optional[pulumi.Input[str]]:
        """
        The SASL mechanism for the Kafka broker.
        """
        return pulumi.get(self, "sasl_mechanisms")

    @sasl_mechanisms.setter
    def sasl_mechanisms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sasl_mechanisms", value)

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]:
        """
        The SASL password for the Kafka broker.
        """
        return pulumi.get(self, "sasl_password")

    @sasl_password.setter
    def sasl_password(self, value: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]):
        pulumi.set(self, "sasl_password", value)

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]:
        """
        The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "sasl_username")

    @sasl_username.setter
    def sasl_username(self, value: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]):
        pulumi.set(self, "sasl_username", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the connection schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_protocol", value)

    @property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]:
        """
        The default SSH tunnel configuration for the Kafka brokers.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]:
        """
        The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]:
        """
        The client key for the Kafka broker.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        **Private Preview** If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)


@pulumi.input_type
class _ConnectionKafkaState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 progress_topic: Optional[pulumi.Input[str]] = None,
                 qualified_sql_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[str]] = None,
                 sasl_password: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']] = None,
                 sasl_username: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 ssh_tunnel: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']] = None,
                 ssl_certificate: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']] = None,
                 ssl_certificate_authority: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']] = None,
                 ssl_key: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']] = None,
                 validate: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ConnectionKafka resources.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the connection database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]] kafka_brokers: The Kafka brokers configuration.
        :param pulumi.Input[str] name: The identifier for the connection.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslPasswordArgs'] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input['ConnectionKafkaSaslUsernameArgs'] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[str] schema_name: The identifier for the connection schema. Defaults to `public`.
        :param pulumi.Input[str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input['ConnectionKafkaSshTunnelArgs'] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input['ConnectionKafkaSslCertificateArgs'] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs'] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input['ConnectionKafkaSslKeyArgs'] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[bool] validate: **Private Preview** If the connection should wait for validation.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if kafka_brokers is not None:
            pulumi.set(__self__, "kafka_brokers", kafka_brokers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_role is not None:
            pulumi.set(__self__, "ownership_role", ownership_role)
        if progress_topic is not None:
            pulumi.set(__self__, "progress_topic", progress_topic)
        if qualified_sql_name is not None:
            pulumi.set(__self__, "qualified_sql_name", qualified_sql_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sasl_mechanisms is not None:
            pulumi.set(__self__, "sasl_mechanisms", sasl_mechanisms)
        if sasl_password is not None:
            pulumi.set(__self__, "sasl_password", sasl_password)
        if sasl_username is not None:
            pulumi.set(__self__, "sasl_username", sasl_username)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssh_tunnel is not None:
            pulumi.set(__self__, "ssh_tunnel", ssh_tunnel)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if ssl_certificate_authority is not None:
            pulumi.set(__self__, "ssl_certificate_authority", ssl_certificate_authority)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the connection database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="kafkaBrokers")
    def kafka_brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]]:
        """
        The Kafka brokers configuration.
        """
        return pulumi.get(self, "kafka_brokers")

    @kafka_brokers.setter
    def kafka_brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionKafkaKafkaBrokerArgs']]]]):
        pulumi.set(self, "kafka_brokers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> Optional[pulumi.Input[str]]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @ownership_role.setter
    def ownership_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_role", value)

    @property
    @pulumi.getter(name="progressTopic")
    def progress_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a topic that Kafka sinks can use to track internal consistency metadata.
        """
        return pulumi.get(self, "progress_topic")

    @progress_topic.setter
    def progress_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "progress_topic", value)

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @qualified_sql_name.setter
    def qualified_sql_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualified_sql_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="saslMechanisms")
    def sasl_mechanisms(self) -> Optional[pulumi.Input[str]]:
        """
        The SASL mechanism for the Kafka broker.
        """
        return pulumi.get(self, "sasl_mechanisms")

    @sasl_mechanisms.setter
    def sasl_mechanisms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sasl_mechanisms", value)

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]:
        """
        The SASL password for the Kafka broker.
        """
        return pulumi.get(self, "sasl_password")

    @sasl_password.setter
    def sasl_password(self, value: Optional[pulumi.Input['ConnectionKafkaSaslPasswordArgs']]):
        pulumi.set(self, "sasl_password", value)

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]:
        """
        The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "sasl_username")

    @sasl_username.setter
    def sasl_username(self, value: Optional[pulumi.Input['ConnectionKafkaSaslUsernameArgs']]):
        pulumi.set(self, "sasl_username", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the connection schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_protocol", value)

    @property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]:
        """
        The default SSH tunnel configuration for the Kafka brokers.
        """
        return pulumi.get(self, "ssh_tunnel")

    @ssh_tunnel.setter
    def ssh_tunnel(self, value: Optional[pulumi.Input['ConnectionKafkaSshTunnelArgs']]):
        pulumi.set(self, "ssh_tunnel", value)

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]:
        """
        The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateArgs']]):
        pulumi.set(self, "ssl_certificate", value)

    @property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]:
        """
        The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @ssl_certificate_authority.setter
    def ssl_certificate_authority(self, value: Optional[pulumi.Input['ConnectionKafkaSslCertificateAuthorityArgs']]):
        pulumi.set(self, "ssl_certificate_authority", value)

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]:
        """
        The client key for the Kafka broker.
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input['ConnectionKafkaSslKeyArgs']]):
        pulumi.set(self, "ssl_key", value)

    @property
    @pulumi.getter
    def validate(self) -> Optional[pulumi.Input[bool]]:
        """
        **Private Preview** If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

    @validate.setter
    def validate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate", value)


class ConnectionKafka(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionKafkaKafkaBrokerArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 progress_topic: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[str]] = None,
                 sasl_password: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSaslPasswordArgs']]] = None,
                 sasl_username: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSaslUsernameArgs']]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSshTunnelArgs']]] = None,
                 ssl_certificate: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateArgs']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateAuthorityArgs']]] = None,
                 ssl_key: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslKeyArgs']]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        A Kafka connection establishes a link to a Kafka cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a Kafka Connection
        example_kafka_connection = materialize.ConnectionKafka("exampleKafkaConnection",
            kafka_brokers=[materialize.ConnectionKafkaKafkaBrokerArgs(
                broker="b-1.hostname-1:9096",
            )],
            progress_topic="example",
            sasl_mechanisms="SCRAM-SHA-256",
            sasl_password=materialize.ConnectionKafkaSaslPasswordArgs(
                database_name="materialize",
                name="kafka_password",
                schema_name="public",
            ),
            sasl_username=materialize.ConnectionKafkaSaslUsernameArgs(
                text="user",
            ))
        example_kafka_connection_multiple_brokers = materialize.ConnectionKafka("exampleKafkaConnectionMultipleBrokers", kafka_brokers=[
            materialize.ConnectionKafkaKafkaBrokerArgs(
                availability_zone="use1-az1",
                broker="b-1.hostname-1:9096",
                privatelink_connection=materialize.ConnectionKafkaKafkaBrokerPrivatelinkConnectionArgs(
                    database_name="materialize",
                    name="example_aws_privatelink_conn",
                    schema_name="public",
                ),
                target_group_port=9001,
            ),
            materialize.ConnectionKafkaKafkaBrokerArgs(
                availability_zone="use1-az2",
                broker="b-2.hostname-2:9096",
                privatelink_connection=materialize.ConnectionKafkaKafkaBrokerPrivatelinkConnectionArgs(
                    database_name="materialize",
                    name="example_aws_privatelink_conn",
                    schema_name="public",
                ),
                target_group_port=9002,
            ),
        ])
        ```

        ## Import

        Connections can be imported using the connection id

        ```sh
         $ pulumi import materialize:index/connectionKafka:ConnectionKafka example <region>:<connection_id>
        ```

         Connection id and information be found in the `mz_catalog.mz_connections` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the connection database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionKafkaKafkaBrokerArgs']]]] kafka_brokers: The Kafka brokers configuration.
        :param pulumi.Input[str] name: The identifier for the connection.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSaslPasswordArgs']] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSaslUsernameArgs']] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[str] schema_name: The identifier for the connection schema. Defaults to `public`.
        :param pulumi.Input[str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSshTunnelArgs']] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateArgs']] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateAuthorityArgs']] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSslKeyArgs']] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[bool] validate: **Private Preview** If the connection should wait for validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionKafkaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Kafka connection establishes a link to a Kafka cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_materialize as materialize

        # Create a Kafka Connection
        example_kafka_connection = materialize.ConnectionKafka("exampleKafkaConnection",
            kafka_brokers=[materialize.ConnectionKafkaKafkaBrokerArgs(
                broker="b-1.hostname-1:9096",
            )],
            progress_topic="example",
            sasl_mechanisms="SCRAM-SHA-256",
            sasl_password=materialize.ConnectionKafkaSaslPasswordArgs(
                database_name="materialize",
                name="kafka_password",
                schema_name="public",
            ),
            sasl_username=materialize.ConnectionKafkaSaslUsernameArgs(
                text="user",
            ))
        example_kafka_connection_multiple_brokers = materialize.ConnectionKafka("exampleKafkaConnectionMultipleBrokers", kafka_brokers=[
            materialize.ConnectionKafkaKafkaBrokerArgs(
                availability_zone="use1-az1",
                broker="b-1.hostname-1:9096",
                privatelink_connection=materialize.ConnectionKafkaKafkaBrokerPrivatelinkConnectionArgs(
                    database_name="materialize",
                    name="example_aws_privatelink_conn",
                    schema_name="public",
                ),
                target_group_port=9001,
            ),
            materialize.ConnectionKafkaKafkaBrokerArgs(
                availability_zone="use1-az2",
                broker="b-2.hostname-2:9096",
                privatelink_connection=materialize.ConnectionKafkaKafkaBrokerPrivatelinkConnectionArgs(
                    database_name="materialize",
                    name="example_aws_privatelink_conn",
                    schema_name="public",
                ),
                target_group_port=9002,
            ),
        ])
        ```

        ## Import

        Connections can be imported using the connection id

        ```sh
         $ pulumi import materialize:index/connectionKafka:ConnectionKafka example <region>:<connection_id>
        ```

         Connection id and information be found in the `mz_catalog.mz_connections` table The region is the region where the database is located (e.g. aws/us-east-1)

        :param str resource_name: The name of the resource.
        :param ConnectionKafkaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionKafkaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionKafkaKafkaBrokerArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ownership_role: Optional[pulumi.Input[str]] = None,
                 progress_topic: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 sasl_mechanisms: Optional[pulumi.Input[str]] = None,
                 sasl_password: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSaslPasswordArgs']]] = None,
                 sasl_username: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSaslUsernameArgs']]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 ssh_tunnel: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSshTunnelArgs']]] = None,
                 ssl_certificate: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateArgs']]] = None,
                 ssl_certificate_authority: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateAuthorityArgs']]] = None,
                 ssl_key: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslKeyArgs']]] = None,
                 validate: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionKafkaArgs.__new__(ConnectionKafkaArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["database_name"] = database_name
            if kafka_brokers is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_brokers'")
            __props__.__dict__["kafka_brokers"] = kafka_brokers
            __props__.__dict__["name"] = name
            __props__.__dict__["ownership_role"] = ownership_role
            __props__.__dict__["progress_topic"] = progress_topic
            __props__.__dict__["region"] = region
            __props__.__dict__["sasl_mechanisms"] = sasl_mechanisms
            __props__.__dict__["sasl_password"] = sasl_password
            __props__.__dict__["sasl_username"] = sasl_username
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["security_protocol"] = security_protocol
            __props__.__dict__["ssh_tunnel"] = ssh_tunnel
            __props__.__dict__["ssl_certificate"] = ssl_certificate
            __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
            __props__.__dict__["ssl_key"] = ssl_key
            __props__.__dict__["validate"] = validate
            __props__.__dict__["qualified_sql_name"] = None
        super(ConnectionKafka, __self__).__init__(
            'materialize:index/connectionKafka:ConnectionKafka',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            kafka_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionKafkaKafkaBrokerArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ownership_role: Optional[pulumi.Input[str]] = None,
            progress_topic: Optional[pulumi.Input[str]] = None,
            qualified_sql_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            sasl_mechanisms: Optional[pulumi.Input[str]] = None,
            sasl_password: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSaslPasswordArgs']]] = None,
            sasl_username: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSaslUsernameArgs']]] = None,
            schema_name: Optional[pulumi.Input[str]] = None,
            security_protocol: Optional[pulumi.Input[str]] = None,
            ssh_tunnel: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSshTunnelArgs']]] = None,
            ssl_certificate: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateArgs']]] = None,
            ssl_certificate_authority: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateAuthorityArgs']]] = None,
            ssl_key: Optional[pulumi.Input[pulumi.InputType['ConnectionKafkaSslKeyArgs']]] = None,
            validate: Optional[pulumi.Input[bool]] = None) -> 'ConnectionKafka':
        """
        Get an existing ConnectionKafka resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: **Public Preview** Comment on an object in the database.
        :param pulumi.Input[str] database_name: The identifier for the connection database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionKafkaKafkaBrokerArgs']]]] kafka_brokers: The Kafka brokers configuration.
        :param pulumi.Input[str] name: The identifier for the connection.
        :param pulumi.Input[str] ownership_role: The owernship role of the object.
        :param pulumi.Input[str] progress_topic: The name of a topic that Kafka sinks can use to track internal consistency metadata.
        :param pulumi.Input[str] qualified_sql_name: The fully qualified name of the connection.
        :param pulumi.Input[str] region: The region to use for the resource connection. If not set, the default region is used.
        :param pulumi.Input[str] sasl_mechanisms: The SASL mechanism for the Kafka broker.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSaslPasswordArgs']] sasl_password: The SASL password for the Kafka broker.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSaslUsernameArgs']] sasl_username: The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[str] schema_name: The identifier for the connection schema. Defaults to `public`.
        :param pulumi.Input[str] security_protocol: The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSshTunnelArgs']] ssh_tunnel: The default SSH tunnel configuration for the Kafka brokers.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateArgs']] ssl_certificate: The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSslCertificateAuthorityArgs']] ssl_certificate_authority: The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        :param pulumi.Input[pulumi.InputType['ConnectionKafkaSslKeyArgs']] ssl_key: The client key for the Kafka broker.
        :param pulumi.Input[bool] validate: **Private Preview** If the connection should wait for validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionKafkaState.__new__(_ConnectionKafkaState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["kafka_brokers"] = kafka_brokers
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_role"] = ownership_role
        __props__.__dict__["progress_topic"] = progress_topic
        __props__.__dict__["qualified_sql_name"] = qualified_sql_name
        __props__.__dict__["region"] = region
        __props__.__dict__["sasl_mechanisms"] = sasl_mechanisms
        __props__.__dict__["sasl_password"] = sasl_password
        __props__.__dict__["sasl_username"] = sasl_username
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["security_protocol"] = security_protocol
        __props__.__dict__["ssh_tunnel"] = ssh_tunnel
        __props__.__dict__["ssl_certificate"] = ssl_certificate
        __props__.__dict__["ssl_certificate_authority"] = ssl_certificate_authority
        __props__.__dict__["ssl_key"] = ssl_key
        __props__.__dict__["validate"] = validate
        return ConnectionKafka(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        **Public Preview** Comment on an object in the database.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the connection database. Defaults to `MZ_DATABASE` environment variable if set or `materialize` if environment variable is not set.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="kafkaBrokers")
    def kafka_brokers(self) -> pulumi.Output[Sequence['outputs.ConnectionKafkaKafkaBroker']]:
        """
        The Kafka brokers configuration.
        """
        return pulumi.get(self, "kafka_brokers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The identifier for the connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownershipRole")
    def ownership_role(self) -> pulumi.Output[str]:
        """
        The owernship role of the object.
        """
        return pulumi.get(self, "ownership_role")

    @property
    @pulumi.getter(name="progressTopic")
    def progress_topic(self) -> pulumi.Output[Optional[str]]:
        """
        The name of a topic that Kafka sinks can use to track internal consistency metadata.
        """
        return pulumi.get(self, "progress_topic")

    @property
    @pulumi.getter(name="qualifiedSqlName")
    def qualified_sql_name(self) -> pulumi.Output[str]:
        """
        The fully qualified name of the connection.
        """
        return pulumi.get(self, "qualified_sql_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region to use for the resource connection. If not set, the default region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="saslMechanisms")
    def sasl_mechanisms(self) -> pulumi.Output[Optional[str]]:
        """
        The SASL mechanism for the Kafka broker.
        """
        return pulumi.get(self, "sasl_mechanisms")

    @property
    @pulumi.getter(name="saslPassword")
    def sasl_password(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSaslPassword']]:
        """
        The SASL password for the Kafka broker.
        """
        return pulumi.get(self, "sasl_password")

    @property
    @pulumi.getter(name="saslUsername")
    def sasl_username(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSaslUsername']]:
        """
        The SASL username for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "sasl_username")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier for the connection schema. Defaults to `public`.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        The security protocol to use: `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.
        """
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter(name="sshTunnel")
    def ssh_tunnel(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSshTunnel']]:
        """
        The default SSH tunnel configuration for the Kafka brokers.
        """
        return pulumi.get(self, "ssh_tunnel")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSslCertificate']]:
        """
        The client certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate")

    @property
    @pulumi.getter(name="sslCertificateAuthority")
    def ssl_certificate_authority(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSslCertificateAuthority']]:
        """
        The CA certificate for the Kafka broker.. Can be supplied as either free text using `text` or reference to a secret object using `secret`.
        """
        return pulumi.get(self, "ssl_certificate_authority")

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> pulumi.Output[Optional['outputs.ConnectionKafkaSslKey']]:
        """
        The client key for the Kafka broker.
        """
        return pulumi.get(self, "ssl_key")

    @property
    @pulumi.getter
    def validate(self) -> pulumi.Output[Optional[bool]]:
        """
        **Private Preview** If the connection should wait for validation.
        """
        return pulumi.get(self, "validate")

