# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetSchemasResult',
    'AwaitableGetSchemasResult',
    'get_schemas',
    'get_schemas_output',
]

@pulumi.output_type
class GetSchemasResult:
    """
    A collection of values returned by GetSchemas.
    """
    def __init__(__self__, database_name=None, id=None, region=None, schemas=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schemas and not isinstance(schemas, list):
            raise TypeError("Expected argument 'schemas' to be a list")
        pulumi.set(__self__, "schemas", schemas)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Limit schemas to a specific database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which the resource is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.GetSchemasSchemaResult']:
        """
        The schemas in the account
        """
        return pulumi.get(self, "schemas")


class AwaitableGetSchemasResult(GetSchemasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchemasResult(
            database_name=self.database_name,
            id=self.id,
            region=self.region,
            schemas=self.schemas)


def get_schemas(database_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchemasResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_schemas()
    materialize = materialize.get_schemas(database_name="materialize")
    ```


    :param str database_name: Limit schemas to a specific database
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('materialize:index/getSchemas:GetSchemas', __args__, opts=opts, typ=GetSchemasResult).value

    return AwaitableGetSchemasResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        schemas=pulumi.get(__ret__, 'schemas'))


@_utilities.lift_output_func(get_schemas)
def get_schemas_output(database_name: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSchemasResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_materialize as materialize

    all = materialize.get_schemas()
    materialize = materialize.get_schemas(database_name="materialize")
    ```


    :param str database_name: Limit schemas to a specific database
    """
    ...
